@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Review Rating Details')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.review_rating.index') }}">Review Rating</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pub.review_rating.show', $store->id) }}">Review Rating Details</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Review Rating Details</h3>
    </div>
    <div class="card-body">

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Rating :</label>

            <div class="col-md-9">
                {{ $store->rating }}
            </div>
            <!--col-->
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Review :</label>

            <div class="col-md-9">
                {{  $store->review }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Created date :</label>

            <div class="col-md-9">
                {{ date('M-d-Y H:i:s', strtotime($store->created_at)) }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">User name :</label>

            <div class="col-md-9">
                {{ $store->user->name }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">User email :</label>

            <div class="col-md-9">
                {{ $store->user->email }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Status :</label>

            <div class="col-md-9">
                {{ $store->status  == 2? 'Pending' : 'Approveed'}}
            </div>
        </div>

    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
