@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')

@section('header', 'Profile Edit')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.profile.edit') }}">Profile edit</a></li>
@endsection

<link rel="stylesheet" href="{{ asset('public/intelinput/build/css/intlTelInput.css') }}">
  {{-- <link rel="stylesheet" href="{{ asset('public/intelinput/build/css/demo.css') }}"> --}}

<div class="row">
    <div class="col-md-4">

        <!-- Profile Image -->
        <div class="card card-primary card-outline">
            <div class="card-body box-profile">
                <div class="text-center">
                    <img class="profile-user-img img-fluid img-circle" src="{{ $user->profile->profile_photo }}">
                </div>

                <h3 class="profile-username text-center">{{ $user->business_name }}</h3>

                {{-- <p class="text-muted text-center">Software Engineer</p> --}}

                <ul class="list-group list-group-unbordered mb-3">
                    <li class="list-group-item">
                        <b class="d-block">Contact / Manager</b> <a class="d-block" data-toggle="tooltip" title="{{ $user->name }}"
                            >{{ $user->name }}</a>
                    </li>
                    <li class="list-group-item">
                        <b class="d-block">Email</b> <a class="d-block" data-toggle="tooltip" title="{{ $user->email }}"
                            href="mailto:{{ $user->email }}">{{ $user->email }}</a>
                    </li>

                    <li class="list-group-item">
                        <b>Telephone</b> <a href="tel:{{ $user->mobile }}"
                            class="float-right">{{ $user->mobile }}</a>
                    </li>

                    {{-- <li class="list-group-item">
                    <b>DOB</b> <a class="float-right">{{$user->profile->dob}}</a>
                  </li> --}}

                </ul>

            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
        @if ($user->role == 2)
            <!-- About Me Box -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">About Me</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    <strong><i class="fas fa-map-marker-alt mr-1"></i> Address</strong>
                    <p>
                        <a href="https://www.google.com/maps/place/{{ $user->profile->address }}/@{{ $user->profile->add_lat }},{{ $user->profile->add_lng }}" target="_blank"
                            class="text-muted">{{ $user->profile->address }}</a>
                             {{-- <a href="https://www.google.com/maps/search/?api=1&query={{ $user->profile->add_lat }},{{ $user->profile->add_lng }}" target="_blank"
                            class="text-muted">{{ $user->profile->address }}</a> --}}
                            {{-- https://www.google.com/maps/search/?api=1&query=28.6139,77.2090 --}}
                    </p>
                    <hr>

                    {{-- <strong><i class="far fa-file-alt mr-1"></i> About me</strong>
                        <p class="text-muted">{{$user->profile->about}}</p> --}}
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        @endif

    </div>

    <!-- /.col -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header p-2">
                <ul class="nav nav-pills">
                    <li class="nav-item"><a class="nav-link active" href="#general" data-toggle="tab">General</a>
                    </li>
                    <li class="nav-item"><a class="nav-link" href="#profile-image" data-toggle="tab">Profile Update</a></li>
                    @if ($user->role == 2)
                        <li class="nav-item"><a class="nav-link" href="#profile-doc" data-toggle="tab">Document Image</a></li>
                    @endif
                    <li class="nav-item"><a class="nav-link" href="#about" data-toggle="tab">About Vendor</a></li>

                    {{-- <li class="nav-item"><a class="nav-link" href="#change-email" data-toggle="tab">Change
                            Email</a></li> --}}
                    {{-- <li class="nav-item"><a class="nav-link" href="#change-password" data-toggle="tab">Change Password</a></li> --}}
                </ul>
            </div><!-- /.card-header -->
            <div class="card-body">
                <div class="tab-content">

                    {{-- general tab start --}}
                    <div class="active tab-pane" id="general">

                        <form class="form-horizontal" action="{{ route('pub.profile.edit') }}" method="POST">

                            {{-- <input type="hidden" name="user_id" value="{{ $user->id }}"> --}}
                            @csrf
                            @if ($user->role == 2)
                            @php
                                $b_type = explode(',',$user->profile->business_type);
                                @endphp
                                {{-- @dd($user->business_types) --}}
                                @php
                                    $array_business_type = [];
                                    // dd($array_business_type);
                                    foreach ($user->business_types as $business_types){
                                        // dump($business_types);

                                        $array_business_type[] = $business_types->pivot->business_category_id;
                                    }
                                @endphp
                                {{-- @dd($array_business_type) --}}
                                {{-- @dump($b_type) --}}
                                <div class="form-group row">
                                    <label
                                        class="col-sm-2 col-form-label">Business Category</label>
                                    <div class="col-sm-10">
                                        {{-- <input type="text" name="business_name"
                                            class="form-control @error('business_name') is-invalid @enderror" placeholder="Business Name"
                                            value="{{ $user->business_name }}"> --}}
                                        <select name="business_type[]" id="" class="form-control @error('business_name') is-invalid @enderror" size="3" multiple required>
                                            {{-- <option value="">Select Business Category</option> --}}
                                            @foreach ($buisnessCategoryList as $buisnessCategory)

                                            <option value="{{ $buisnessCategory->id }}" {{ in_array($buisnessCategory->id, $array_business_type) ? "selected" : "" }}>{{ $buisnessCategory->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('business_type')
                                            <span class="error invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label
                                        class="col-sm-2 col-form-label">Business Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="business_name"
                                            class="form-control @error('business_name') is-invalid @enderror" placeholder="Business Name"
                                            value="{{ $user->business_name }}">
                                        @error('business_name')
                                            <span class="error invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                            @endif

                            <div class="form-group row">
                                <label
                                    class="col-sm-2 col-form-label">{{ $user->role == 2 ? 'Contacts' : 'Name' }}</label>
                                <div class="col-sm-10">
                                    <input type="text" name="name"
                                        class="form-control @error('name') is-invalid @enderror" placeholder="name"
                                        value="{{ $user->name }}">
                                    @error('name')
                                        <span class="error invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>




                            {{-- <div class="form-group row">
                                <label class="col-sm-2 col-form-label">DOB</label>
                                <div class="col-sm-10">
                                    <div class="input-group date datepicker @error('dob') is-invalid @enderror" id="dob"
                                        data-target-input="nearest">
                                        <input type="text" name="dob" class="form-control datetimepicker-input"
                                            data-target="#dob" value="{{ $user->profile->dob }}" />


                                        <div class="input-group-append" data-target="#dob" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                    @error('dob')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div> --}}

                            {{-- <div class="form-group row">
                                <label class="col-sm-2 col-form-label">Sex</label>
                                <div class="col-sm-10">
                                    <div class="form-group clearfix">
                                        <div class="icheck-success d-inline">
                                            <input type="radio" name="gender" value="male" id="male"
                                                {{ $user->profile->gender == 'male' ? 'checked' : '' }}>
                                            <label for="male">Male</label>
                                        </div>

                                        <div class="icheck-success d-inline">
                                            <input type="radio" name="gender" value="female" id="female"
                                                {{ $user->profile->gender == 'female' ? 'checked' : '' }}>
                                            <label for="female">Female</label>
                                        </div>

                                        <div class="icheck-success d-inline">
                                            <input type="radio" name="gender" value="other" id="other"
                                                {{ $user->profile->gender == 'other' ? 'checked' : '' }}>
                                            <label for="other">Other</label>
                                        </div>
                                    </div>

                                </div>
                            </div> --}}
                            {{-- <div class="form-group row">
                                <label class="col-sm-2 col-form-label">Email</label>
                                <div class="col-sm-10">
                                    <input type="email" name="email"
                                        class="form-control @error('email') is-invalid @enderror" placeholder="Email"
                                        value="{{ $user->email }}">
                                    @error('email')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div> --}}
                            <input type="hidden" name="dial_code" id="dial_code">
                            <input type="hidden" name="add_lat" id="add_lat" value="{{ $user->profile->add_lat }}">
                            <input type="hidden" name="add_lng" id="add_lng" value="{{ $user->profile->add_lng }}">
                            <input type="hidden" name="country_name" id="country_name">
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label">Telephone</label>
                                <div class="col-sm-10">
                                    <input type="text" name="mobile" id="mobile"
                                        class="form-control @error('mobile') is-invalid @enderror" placeholder="mobile"
                                        value="{{ $user->mobile }}">
                                    @error('mobile')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            @if ($user->role == 2)
                                <div class="form-group row">
                                    <label class="col-sm-2 col-form-label">Address</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="address" id="address"
                                            class="form-control @error('address') is-invalid @enderror"
                                            placeholder="address" value="{{ $user->profile->address }}" autocomplete="off">
                                        @error('address')
                                            <span class="error invalid-feedback"
                                                id="error_description">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-2 col-form-label">Website</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="website" id="website"
                                            class="form-control @error('website') is-invalid @enderror"
                                            placeholder="website" value="{{ $user->profile->website }}" autocomplete="off" maxlength="255">
                                        @error('website')
                                            <span class="error invalid-feedback"
                                                id="error_description">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            @endif


                            {{-- <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">About me</label>
                        <div class="col-sm-10">
                          <textarea name="about" class="form-control @error('about') is-invalid @enderror" placeholder="about me">{{$user->profile->about}}</textarea>
                          @error('about')
                           <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                          @enderror
                        </div>
                      </div> --}}

                            <div class="form-group row">
                                <div class="offset-sm-2 col-sm-10">
                                    <button type="submit" class="btn btn-outline-primary">Submit</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    {{-- general tab end --}}

                    {{-- profile document tab end --}}
                    <div class="tab-pane" id="profile-doc">

                        <form class="form-horizontal" action="{{ route('pub.profile.edit') }}" method="POST"
                            enctype="multipart/form-data">
                            {{-- <input type="hidden" name="user_id" value="{{ $user->id }}"> --}}
                            @csrf

                            @if ($user->profile->document)

                                <div class="from-group row">
                                    {{-- public/uploads/users/document --}}
                                    <img src="{{ asset('public/uploads/users/document/' . $user->profile->document) }}"
                                        width="100px" height="100px">
                                </div>
                            @endif

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label">Document</label>
                                <div class="col-sm-10">
                                    <input type="file" name="document"
                                        class="form-control @error('document') is-invalid @enderror">
                                    @error('document')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="offset-sm-10 col-sm-2">
                                    <button type="submit" class="btn btn-outline-primary">Submit</button>
                                </div>
                            </div>

                        </form>

                    </div>
                    {{-- profile document tab end --}}

                    {{-- profile image tab end --}}
                    <div class="tab-pane" id="profile-image">

                        <form class="form-horizontal" action="{{ route('pub.profile.edit') }}" method="POST"
                            enctype="multipart/form-data">
                            {{-- <input type="hidden" name="user_id" value="{{ $user->id }}"> --}}
                            @csrf
                            @if ($user->profile->profile_photo)
                            <div class="form-group row">
                                <img class="profile-user-img img-fluid img-circle" src="{{ $user->profile->profile_photo }}">
                            </div>
                            @endif
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Profile Image</label>
                                <div class="col-sm-9">
                                    <input type="file" name="profile_photo"
                                        class="form-control @error('profile_photo') is-invalid @enderror">
                                    @error('profile_photo')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            {{-- @if ($user->profile->document)

                            <div class="from-group row">
                                <img src="{{ asset('public/uploads/users/document'.$user->profile->document) }}" width="100px" height="100px">
                            </div>
                            @endif --}}

                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Language</label>
                                <div class="col-sm-9">
                                    <select name="language" class="form-control">
                                        <option value="">Select Language</option>
                                        <option value="EN" {{ ($user->profile->language == 'EN')? "selected":"" }}>English</option>
                                        <option value="IT" {{ ($user->profile->language == 'IT')? "selected":"" }}>Italian</option>
                                        <option value="de" {{ ($user->profile->language == 'de')? "selected":"" }}>German</option>
                                        <option value="FR" {{ ($user->profile->language == 'FR')? "selected":"" }}>French</option>
                                        <option value="ES" {{ ($user->profile->language == 'ES')? "selected":"" }}>Spanish</option>
                                    </select>
                                    @error('language')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Currency</label>
                                <div class="col-sm-9">
                                    <select name="currency" class="form-control">
                                        <option value="">Select Currency</option>
                                        <option value="usd" {{ ($user->profile->currency == 'usd')? "selected":"" }}>USD</option>
                                        <option value="eur" {{ ($user->profile->currency == 'eur')? "selected":"" }}>EUR</option>
                                        <option value="chf" {{ ($user->profile->currency == 'chf')? "selected":"" }}>CHF</option>
                                        <option value="gbp" {{ ($user->profile->currency == 'gbp')? "selected":"" }}>GBP</option>
                                        {{-- <option value="FR">French</option> --}}

                                    </select>
                                    @error('currency')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="offset-sm-10 col-sm-2">
                                    <button type="submit" class="btn btn-outline-primary">Submit</button>
                                </div>
                            </div>

                        </form>

                    </div>
                    {{-- profile image tab end --}}


                    <!-- /.change email start -->
                    {{-- <div class="tab-pane" id="change-email">
                        <form class="form-horizontal" action="{{ route('admin.user.update') }}" method="POST">
                            <input type="hidden" name="user_id" value="{{ $user->id }}">
                            @csrf
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Email</label>
                                <div class="col-sm-9">
                                    <input type="email" name="email"
                                        class="form-control @error('email') is-invalid @enderror" placeholder="Email"
                                        value="{{ $user->email }}">
                                    @error('email')
                                        <span class="error invalid-feedback"
                                            id="error_description">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>



                            <div class="form-group row">
                                <div class="offset-sm-10 col-sm-2">
                                    <button type="submit" class="btn btn-outline-primary">Submit</button>
                                </div>
                            </div>

                        </form>
                    </div> --}}
                    <!-- /.change email end -->

                    <!-- /.change-password start -->
                    <div class="tab-pane" id="about">
                    <form class="form-horizontal" action="{{ route('pub.profile.edit') }}" method="POST">
                      @csrf
                      <div class="form-group row">
                        <label class="col-sm-2 col-form-label">About</label>
                        <div class="col-sm-10">
                          <textarea name="about" class="form-control @error('about') is-invalid @enderror">{{ $user->profile->about }}</textarea>
                          @error('about')
                           <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                          @enderror
                        </div>
                      </div>
{{--
                      <div class="form-group row">
                        <label class="col-sm-3 col-form-label">New Password</label>
                        <div class="col-sm-9">
                          <input type="password" name="new_password" class="form-control @error('new_password') is-invalid @enderror" placeholder="new password">
                          @error('new_password')
                           <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                          @enderror
                        </div>
                      </div>

                       <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Confirm Password</label>
                        <div class="col-sm-9">
                          <input type="password" name="confirm_password" class="form-control @error('confirm_password') is-invalid @enderror" placeholder="confirm password">
                          @error('confirm_password')
                           <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                          @enderror
                        </div>
                      </div> --}}

                      <div class="form-group row">
                        <div class="offset-sm-10 col-sm-2">
                          <button type="submit" class="btn btn-outline-primary">Submit</button>
                        </div>
                      </div>

                    </form>
                  </div>
                    <!-- /.change-password end -->



                </div>
                <!-- /.tab-content -->
            </div><!-- /.card-body -->
        </div>
        <!-- /.nav-tabs-custom -->
    </div>
    <!-- /.col -->
</div>

@endsection

@push('scripts')
<script src="{{ asset('public/intelinput/build/js/intlTelInput.js') }}"></script>
{{-- <script async
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCrB_h3JV4QV_aVNHPCrx0GMq4yWvI8PVg&libraries=places&callback=initialize">
</script> --}}
@include('common.map')
  <script>
    var input = document.querySelector("#mobile");
    var iti = window.intlTelInput(input, {
      // allowDropdown: false,
      // autoHideDialCode: false,
      // autoPlaceholder: "off",
      // dropdownContainer: document.body,
      // excludeCountries: ["us"],
      // formatOnDisplay: false,
      // geoIpLookup: function(callback) {
      //   $.get("http://ipinfo.io", function() {}, "jsonp").always(function(resp) {
      //     var countryCode = (resp && resp.country) ? resp.country : "";
      //     callback(countryCode);
      //   });
      // },
      // hiddenInput: "full_number",
      // initialCountry: "auto",
      <?php
        if($user->country_code) {
        ?>
        initialCountry: "{{ $user->country_code }}",
        <?php
        }
        ?>
      // localizedCountries: { 'de': 'Deutschland' },
      // nationalMode: false,
      // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
      // placeholderNumberType: "MOBILE",
      // preferredCountries: ['cn', 'jp'],
      separateDialCode: true,
      utilsScript: "{{ asset('public/intelinput/build/js/utils.js') }}",
    });
    input.addEventListener("countrychange", function() {
    // do something with iti.getSelectedCountryData()
    console.log(iti.getSelectedCountryData());
    var countryName = document.querySelector('input[name="country_name"]');
    // console.log(Myelement.value);
    countryName.value = iti.getSelectedCountryData().name;
    var dialCode = document.querySelector('input[name="dial_code"]');
    // console.log(Myelement.value);
    dialCode.value = iti.getSelectedCountryData().dialCode;
    $('#country_name').val(iti.getSelectedCountryData().iso2);
        $('#dial_code').val(iti.getSelectedCountryData().dialCode);
    // alert('hi');
    });

    function initialize() {
        // const center = { lat: 50.064192, lng: -130.605469 };
        // // Create a bounding box with sides ~10km away from the center point
        // const defaultBounds = {
        // north: center.lat + 0.1,
        // south: center.lat - 0.1,
        // east: center.lng + 0.1,
        // west: center.lng - 0.1,
        // };
        const input_add = document.getElementById("address");
        const options = {
        // bounds: defaultBounds,
        // componentRestrictions: { country: "us" },
        fields: ["address_components", "geometry", "icon", "name"],
        strictBounds: false,
        types: ["establishment"],
        };
        const autocomplete = new google.maps.places.Autocomplete(input_add);

        autocomplete.addListener("place_changed", () => {
            // infowindow.close();
            // marker.setVisible(false);

            const place = autocomplete.getPlace();
            // console.log(place, place.geometry.location.lat(),place.geometry.location.lng());
            const input_lat = document.getElementById("add_lat").value = place.geometry.location.lat();
            const input_lng = document.getElementById("add_lng").value = place.geometry.location.lng();


            // if (!place.geometry || !place.geometry.location) {
            //     // User entered the name of a Place that was not suggested and
            //     // pressed the Enter key, or the Place Details request failed.
            //     window.alert("No details available for input: '" + place.name + "'");
            //     return;
            // }

            // // If the place has a geometry, then present it on a map.
            // if (place.geometry.viewport) {
            //     map.fitBounds(place.geometry.viewport);
            // } else {
            //     map.setCenter(place.geometry.location);
            //     map.setZoom(17);
            // }

            // marker.setPosition(place.geometry.location);
            // marker.setVisible(true);
            // infowindowContent.children["place-name"].textContent = place.name;
            // infowindowContent.children["place-address"].textContent =
            // place.formatted_address;
            // infowindow.open(map, marker);
        });
    }




  </script>

@endpush
