@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')

@section('header', 'Add Photo Gallery')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.gallery.index') }}">Photo Gallery</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pub.gallery.create') }}">Add Photo Gallery </a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Photo Gallery Add</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('pub.gallery.store') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image </label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image[]"
                            id="image" multiple>
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
