@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
          @section('header', 'Food & Drinks')
          @section('badge')
           <li class="breadcrumb-item"><a href="{{ route('pub.food.index') }}">Food & Drinks</a></li>
          @endsection

    <!-- /.col -->

          <div class="card card-primary card-outline">
            <div class="card-header">
              <h3 class="card-title">Food & Drinks List</h3>

              <div class="card-tools">
                <form action="" method="GET">
                <div class="input-group input-group-sm">
                  <input type="text" name="search" class="form-control" placeholder="Search">
                  <div class="input-group-append">
                    <button class="btn btn-primary"><i class="fas fa-search"></i></button>

                  </div>
                </div>
                </form>

              </div>
              <!-- /.card-tools -->
            </div>
            <!-- /.card-header -->
            <div class="card-body p-0">
                <form action="{{ route('admin.news.delete') }}" method="post">
                          @csrf

              <div class="mailbox-controls">
                <!-- Check all button -->
                {{-- <button type="button" data-toggle="tooltip" title="Select All" class="btn btn-default btn-sm checkbox-toggle"><i class="far fa-square"></i>
                </button> --}}
                <div class="btn-group">
                  {{-- <button type="submit" onclick="return confirm('Are you sure want to delete?');" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button> --}}
               {{--    <a href="" class="btn btn-default btn-sm"><i class="fas fa-eye"></i></a>
                  <a href="" class="btn btn-default btn-sm"><i class="fas fa-edit"></i></a> --}}
                  <a href="" data-toggle="tooltip" title="Refresh" class="btn btn-default btn-sm"><i class="fas fa-sync-alt"></i></a>
                </div>
                  <a href="{{ route('pub.food.create') }}" data-toggle="tooltip" title="Add New Food & Drinks" class="btn btn-primary btn-sm"><i class="fas fa-plus-square"></i> New</a>
                <!-- /.btn-group -->


                <!-- /.float-right -->
              </div>
              <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                  <thead>
                  <tr>
                    <th># No</th>
                    <th>Name</th>
                    <th>Category</th>
                    <th>Image</th>
                    <th>Price</th>
                    <th width="240px">Action</th>
                  </tr>
                  </thead>

                  <tbody id="search_result">
                    @forelse ($foods as $food)
                      <tr>
                         <tr>

                        <td>
                      <div class="icheck-primary">
                        {{-- <input type="checkbox" name="category_id[]" value="{{ $category->id }}" id="check{{ $loop->iteration }}"> --}}
                        <label for="check{{ $loop->iteration }}">#{{ $loop->iteration }}</label>
                      </div>
                    </td>
                        <td>{{ $food->name }}</td>
                        <td>{{ $food->category->name }}</td>
                        <td>
                            @if ($food->image)
                                <img width="100px" height="100px" src="{{ asset('public/uploads/food/'.$food->image) }}" alt="">
                            @endif
                        </td>
                        <td>{{ $food->price }}</td>

                        <td>
                        <a class="btn btn-sm btn-info" href="{{ route('pub.food.show', $food->id) }}"> <i class="fas fa-eye"></i> View</a>
                        {{-- <a class="btn btn-sm btn-outline-warning" href="{{ route('admin.news.edit', $news->id) }}"> <i class="fas fa-edit"></i> Edit</a>
                        <a class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure want to delete?');" href="{{ route('admin.news.delete', $news->id) }}"> <i class="fas fa-trash-alt"></i> Delete</a> --}}
                        <a href="{{ route('pub.food.edit', $food->id) }}" class="btn btn-sm btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>

                        @if ($food->status == 1)
                        <a href="{{route('pub.food.inactive',$food->id)}}" class="btn btn-sm btn-danger">
                            <i class="fas fa-toggle-off"></i> Inactive
                        </a>
                        @else
                        <a href="{{route('pub.food.active',$food->id)}}" class="btn btn-sm btn-success">
                            <i class="fas fa-toggle-on"></i> Active
                        </a>
                        @endif

                        </td>
                      </tr>
                    @empty
                      <tr>
                        <td colspan="6" class="text-center">No data found.</td>
                      </tr>
                    @endforelse

                  </tbody>


                </table>
                <!-- /.table -->
              </div>
              <!-- /.mail-box-messages -->
            </div>
            <!-- /.card-body -->
            <div class="card-footer p-0">
              <div class="mailbox-controls">

                <div class="float-right">

                  <div class="btn-group">
                    {{-- {{ $users->onEachSide(1)->links() }} --}}
                    {{ $foods->links() }}
                  </div>
                  <!-- /.btn-group -->
                </div>
                <!-- /.float-right -->
              </div>
            </div>
          </form>
          </div>
          <!-- /.card -->

        <!-- /.col -->


@endsection
@push('scripts')

  @endpush
