@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Food & Drinks Doc')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.food_media.index') }}">Food & Drinks Doc</a></li>
@endsection

<!-- /.col -->

<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">Food & Drinks Doc List</h3>

        {{-- <div class="card-tools">
            <form action="" method="GET">
                <div class="input-group input-group-sm">
                    <input type="text" name="search" class="form-control" placeholder="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary"><i class="fas fa-search"></i></button>

                    </div>
                </div>
            </form>

        </div> --}}
        <!-- /.card-tools -->
    </div>
    <!-- /.card-header -->
    <div class="card-body p-0">
        <form action="{{ route('pub.food_media.delete') }}" method="post">
            @csrf

            <div class="mailbox-controls">
                <!-- Check all button -->
                {{-- <button type="button" data-toggle="tooltip" title="Select All" class="btn btn-default btn-sm checkbox-toggle"><i class="far fa-square"></i>
                </button> --}}
                <div class="btn-group">
                    {{-- <button type="submit" onclick="return confirm('Are you sure want to delete?');" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button> --}}
                    {{-- <a href="" class="btn btn-default btn-sm"><i class="fas fa-eye"></i></a>
                  <a href="" class="btn btn-default btn-sm"><i class="fas fa-edit"></i></a> --}}
                    <a href="" data-toggle="tooltip" title="Refresh" class="btn btn-default btn-sm"><i
                            class="fas fa-sync-alt"></i></a>
                </div>
                <a href="{{ route('pub.food_media.create') }}" data-toggle="tooltip" title="Add New Food & Drinks Info"
                    class="btn btn-primary btn-sm"><i class="fas fa-plus-square"></i> New</a>
                <!-- /.btn-group -->


                <!-- /.float-right -->
            </div>
            <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                    <thead>
                        <tr>
                            <th># No</th>
                            <th>Image</th>
                            {{-- <th>Category</th> --}}
                            {{-- <th>Pub</th> --}}
                            {{-- <th>Price</th> --}}
                            <th width="240px">Action</th>
                        </tr>
                    </thead>

                    <tbody id="search_result">
                        @forelse ($foods as $food)
                            <tr>
                            <tr>

                                <td>
                                    <div class="icheck-primary">
                                        <input type="checkbox" name="food_id[]" value="{{ $food->id }}" id="check{{ $loop->iteration }}">
                                        <label for="check{{ $loop->iteration }}">#{{ $loop->iteration }}</label>
                                    </div>
                                </td>
                                <td>
                                    @if (explode('/',$food->media_type)[0] == 'image')

                                    <img width="100px" height="100px" src="{{ asset('public/uploads/food-media/' . $food->image) }}">
                                    @elseif (explode('/',$food->media_type)[1] == 'vnd.open')
                                    <iframe src="{{ 'https://docs.google.com/gview?url='.asset('public/uploads/food-media/' . $food->image).'&embedded=true' }}" style="width: 100px;height: 100px;border: none;"></iframe>
                                    @else
                                    <iframe src="{{ asset('public/uploads/food-media/' . $food->image) }}" style="width: 100px;height: 100px;border: none;"></iframe>
                                    @endif
                                    {{-- {{ asset('public/uploads/food-media/' . $food->image) }} --}}
                                    {{-- https://docs.google.com/gview?url=http://remote.url.tld/path/to/document.doc&embedded=true --}}


                                </td>


                                <td>
                                    <a class="btn btn-sm btn-info"
                                        href="{{ route('pub.food_media.show', $food->id) }}"> <i
                                            class="fas fa-eye"></i> View</a>
                                    {{-- <a class="btn btn-sm btn-outline-warning" href="{{ route('admin.news.edit', $news->id) }}"> <i class="fas fa-edit"></i> Edit</a> --}}
                                    <a class="btn btn-sm btn-outline-danger"
                                        onclick="return confirm('Are you sure want to delete?');"
                                        href="{{ route('pub.food_media.delete', $food->id) }}"> <i
                                            class="fas fa-trash-alt"></i> Delete</a>
                                    <a href="{{ route('pub.food_media.edit', $food->id) }}"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No data found.</td>
                            </tr>
                        @endforelse

                    </tbody>


                </table>
                <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
    </div>
    <!-- /.card-body -->
    <div class="card-footer p-0">
        <div class="mailbox-controls">

            <div class="float-right">

                <div class="btn-group">
                    {{-- {{ $users->onEachSide(1)->links() }} --}}
                    {{ $foods->links() }}
                </div>
                <!-- /.btn-group -->
            </div>
            <!-- /.float-right -->
        </div>
    </div>
    </form>
</div>
<!-- /.card -->

<!-- /.col -->


@endsection
@push('scripts')

@endpush
