@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Edit Home page Banner')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.feature-banner.index') }}">Home page Banner</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pub.feature-banner.edit', $page->id) }}">Edit Home page Banner</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Home page Banner edit</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('pub.feature-banner.edit', $page->id) }}" method="POST"
            enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="description">Title<span
                            class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" placeholder="Title" value="{{ old('title')? old('title'):$page->title }}" required>
                        {{-- <textarea class="form-control @error('content') is-invalid @enderror" type="text" name="content"
                            id="content" placeholder="content"
                            style="width: 100%; height: 300px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $page->content }}</textarea> --}}

                        @error('title')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="description">Details<span
                            class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" name="details" class="form-control @error('details') is-invalid @enderror" placeholder="Details" value="{{ old('details')? old('details'):$page->details }}" required>
                        {{-- <textarea class="form-control @error('content') is-invalid @enderror" type="text" name="content"
                            id="content" placeholder="content"
                            style="width: 100%; height: 300px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $page->content }}</textarea> --}}

                        @error('details')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                @if($page->image != '')
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name"></label>

                    <div class="col-md-10">
                       <img src="{{ asset('public/uploads/banner/'.$page->image) }}" alt="">
                    </div>
                </div>
                @endif

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image<span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>




            </div>

            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-outline-primary"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
{{-- @push('scripts')
<script type="text/javascript">
    CKEDITOR.replace('content');
</script>
@endpush --}}
