@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')

@section('header', 'Add Home page Banner')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.feature-banner.index') }}">Home page Banner</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pub.feature-banner.create') }}">Add Home page Banner</a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Home page Banner add</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('pub.feature-banner.create') }}" method="POST"
            enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Title <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('Title') is-invalid @enderror" type="text"
                            name="title" id="Title" placeholder="Please enter Title"
                            value="{{ old('Title') }}">
                        @error('Title')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Content <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('content') is-invalid @enderror" type="text"
                            name="content" id="content" placeholder="Please enter page name"
                            value="{{ old('content') }}">
                        @error('content')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image<span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image" required>
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>


                {{-- <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="description">Content<span
                            class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <textarea class="form-control @error('content') is-invalid @enderror" type="text" name="content"
                            id="content" placeholder="content"
                            style="width: 100%; height: 300px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ old('content') }}</textarea>
                        @error('content')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div> --}}

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection

{{-- @push('scripts')
<script type="text/javascript">
    CKEDITOR.replace('content');
</script>
@endpush --}}
