@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Coupon Lists')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.coupon.index') }}">Coupon</a></li>
@endsection

<!-- /.col -->

<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">Coupon List</h3>

        {{-- <div class="card-tools">
            <form action="" method="GET">
                <div class="input-group input-group-sm">
                    <input type="text" name="search" class="form-control" placeholder="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary"><i class="fas fa-search"></i></button>

                    </div>
                </div>
            </form>

        </div> --}}
        <!-- /.card-tools -->
    </div>
    <!-- /.card-header -->
    <div class="card-body p-0">

            <div class="mailbox-controls">
                <div class="btn-group">
                    <a href="" data-toggle="tooltip" title="Refresh" class="btn btn-default btn-sm">
                        <i class="fas fa-sync-alt"></i>
                    </a>
                </div>
                <!-- /.float-right -->
            </div>
            <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                    <thead>
                        <tr>
                            <th># No</th>
                            <th>Coupon expire Date</th>
                            <th>Coupon Code</th>

                            <th>Discount Amount</th>
                            <th>Used Status</th>
                        </tr>
                    </thead>

                    <tbody id="search_result">
                        @forelse ($coupons as $coupon)
                            {{-- <tr> --}}
                            <tr>

                                <td>
                                    <div class="icheck-primary">
                                        <input type="checkbox" name="food_id[]" value="{{ $coupon->id }}" id="check{{ $loop->iteration }}">
                                        <label for="check{{ $loop->iteration }}">#{{ $loop->iteration }}</label>
                                    </div>
                                </td>
                                <td>{{ $coupon->end_date }}</td>
                                <td class="notranslate">{{ $coupon->code }}</td>
                                <td>{{ $coupon->discount_type ==1 ? "Flat":''}} {{ $coupon->discount }}  {!! $coupon->discount_type ==2 ? "%":'' !!}</td>
                                <td>{{ $coupon->coupon_uses_count? 'Used' : 'Not Use' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No data found.</td>
                            </tr>
                        @endforelse

                    </tbody>


                </table>
                <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
    </div>
    <!-- /.card-body -->
    <div class="card-footer p-0">
        <div class="mailbox-controls">

            <div class="float-right">

                <div class="btn-group">
                    {{-- {{ $users->onEachSide(1)->links() }} --}}
                    {{ $coupons->links() }}
                </div>
                <!-- /.btn-group -->
            </div>
            <!-- /.float-right -->
        </div>
    </div>
    </form>
</div>
<!-- /.card -->

<!-- /.col -->


@endsection
@push('scripts')

@endpush
