@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Manage Profile')
          @section('badge')
           {{-- <li class="breadcrumb-item"><a href="{{ route('admin.cms') }}">cms</a></li> --}}
           <li class="breadcrumb-item"><a href="{{ route('admin.manageProfile') }}">Manage Profile</a></li>
          @endsection
<section class="content">
    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
          <div class="card-header">
            <h3 class="card-title">Manage Profile</h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
              <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
            </div>
          </div>
          <!-- /.card-header -->
            <div class="card-body">
                <form role="form" method="POST" action="{{ route('admin.manageProfile') }}" enctype="multipart/form-data">
                        {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label>Email</label>
                                <input id="email" type="email" class="form-control" name="email"  value="{{ request()->user()->email}}" required>
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <div class="text-danger">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </div>
                                    </span>
                                @endif
                            </div>

                            {{-- @if(request()->user()->logo) --}}
                                {{-- @php
                                    $asd = url('public/Images/memberUsers/');
                                    $asd_len = strlen($asd)+1;
                                    $profile_photo = substr($memberDetailsById->profile_photo, $asd_len)
                                    @endphp --}}
                                {{-- <img  src="{{ asset('public/images/logo/'.request()->user()->logo) }}" height="128px" width="128px"   alt="" class="img-circle img-fluid"> --}}
                                {{-- @else
                                <img src="{{ asset('public/dist/img/user1-128x128.jpg')}}" alt="" class="img-circle img-fluid"> --}}
                            {{-- @endif --}}

                            @if(getSetting('logo'))
                                <img src="{{ asset('public/Images/logo/'.getSetting('logo')) }}" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                                @endif

                            <div class="form-group{{ $errors->has('logo') ? ' has-error' : '' }}">
                                <label>Logo</label>


                                <input id="logo" type="file" class="form-control-file" name="logo">
                                @if ($errors->has('logo'))
                                    <span class="help-block">
                                        <div class="text-danger">
                                            <strong>{{ $errors->first('logo') }}</strong>
                                        </div>
                                    </span>
                                @endif
                            </div>

                            {{-- @if(request()->user()->profile->profile_photo)
                                <img  src="{{ asset(request()->user()->profile->profile_photo) }}" height="128px" width="128px"   alt="" class="img-circle img-fluid">
                            @endif

                            <div class="form-group{{ $errors->has('profile_image') ? ' has-error' : '' }}">
                                <label>Profile Image</label>

                                <input id="profile_image" type="file" class="form-control-file" name="profile_image">
                                @if ($errors->has('profile_image'))
                                    <span class="help-block">
                                        <div class="text-danger">
                                            <strong>{{ $errors->first('profile_image') }}</strong>
                                        </div>
                                    </span>
                                @endif
                            </div> --}}
                            <!-- /.form-group -->

                            <button type="submit" class="btn btn-primary">
                                Save
                            </button>
                        </div>
                      <!-- /.col -->
                      <!-- <div class="col-md-6">
                        <div class="form-group">
                          <label>Multiple</label>

                        </div>
                      </div> -->
                      <!-- /.col -->
                    </div>
                </form>
            </div>
          <!-- /.card-body -->
         <!--  <div class="card-footer">
            Visit <a href="https://select2.github.io/">Select2 documentation</a> for more examples and information about
            the plugin.
          </div> -->
        </div>
        <!-- /.card -->
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
@endsection
