@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Change Password')
          @section('badge')
           {{-- <li class="breadcrumb-item"><a href="{{ route('admin.cms') }}">cms</a></li> --}}
           <li class="breadcrumb-item"><a href="{{ route('pub.change-password') }}">Change Password</a></li>
          @endsection
<section class="content">
    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
          <div class="card-header">
            <h3 class="card-title">Password Change</h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
              <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
            </div>
          </div>
          <!-- /.card-header -->
            <div class="card-body">
                <form role="form" method="POST" action="{{ route('pub.change-password') }}">
                        {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group{{ $errors->has('current-password') ? ' has-error' : '' }}">
                                <label>Current Password</label>
                                <input id="current-password" type="password" class="form-control" name="current-password" required>
                                @if ($errors->has('current-password'))
                                    <span class="help-block">
                                        <div class="text-danger">
                                            <strong>{{ $errors->first('current-password') }}</strong>
                                        </div>
                                    </span>
                                @endif
                            </div>
                            <!-- /.form-group -->
                            <div class="form-group{{ $errors->has('current-password') ? ' has-error' : '' }}">
                                <label>New Password</label>
                              <input id="new-password" type="password" class="form-control" name="new-password" required>

                                @if ($errors->has('new-password'))
                                    <span class="help-block">
                                       <div class="text-danger"> <strong>{{ $errors->first('new-password') }}</strong></div>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label>Confirm New Password</label>
                               <input id="new-password-confirm" type="password" class="form-control" name="new-password_confirmation" required>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                Change Password
                            </button>
                        </div>
                      <!-- /.col -->
                      <!-- <div class="col-md-6">
                        <div class="form-group">
                          <label>Multiple</label>

                        </div>
                      </div> -->
                      <!-- /.col -->
                    </div>
                </form>
            </div>
          <!-- /.card-body -->
         <!--  <div class="card-footer">
            Visit <a href="https://select2.github.io/">Select2 documentation</a> for more examples and information about
            the plugin.
          </div> -->
        </div>
        <!-- /.card -->
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
@endsection
