@extends('layout.admin_layout')

@section('title', 'Chief Complaint')

@section('body')
@section('header', '
Chief Complaint')
@section('badge')
<li class="breadcrumb-item"><a href="">
Chief Complaint</a></li>
@endsection



<div class="card card-primary card-outline">
   
    @if(Session::has('message'))
        <div class="alert alert-success">
            {{ Session::get('message') }}
        </div>
        @endif

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px;">
        
        <a href="{{ route('admin.problems_import') }}" data-toggle="tooltip" title="Import Chief Complaint" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a>
        <a href="{{ route('admin.p_cat_add') }}" data-toggle="tooltip" title="Add Chief Complaint" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>



        </div>
       



        <div class="card-body p-3">

            <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Chief Complaint</th>
                            <th>Age Limit</th>
                            <th>Status</th>
                            <th>Under Top 10</th>
                            <th>Img</th>

                            <th data-orderable="false">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($data as $key=>$value)
                        <tr>


                            <td>

                                {{$key+1}}

                            </td>
                            <td>{{$value->problem}}</td>
                            <td>{{$value->age_b}}</td>
                            @if($value->status == 1)
                            <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/chief_complaint/status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                            @else
                            <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/chief_complaint/status') }}/{{$value->id}}/1">Inactive</td>
                            @endif
                            @if($value->top == 1)
                            <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to remove from top 10" href="{{ URL::to('admin/chief_complaint/top') }}/{{$value->id}}/0">Yes</td>
                            @else
                            <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to add into top 10" href="{{ URL::to('admin/chief_complaint/top') }}/{{$value->id}}/1">No</td>
                            @endif

                            <td><img src="{{$value->img}}" style="height:50px;width:50px"/></td>

                            <td>
                                <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/chief_complaint/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                                <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/chief_complaint/delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>
                            </td>

                        </tr>
                        @endforeach


                    </tbody>



                </table>

            </div>
        </div>



    </div>



    @endsection
    @push('scripts')

    @endpush