@extends('layout.admin_layout')

@section('title', 'Chief Complaint Edit')

@section('body')

@section('header', 'Chief Complaint Edit')
@section('badge')
<li class="breadcrumb-item"><a href="#">Update Chief Complaint</a></li>

@endsection


<div class="card">
 
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.p_cat_update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Chief Complaint <span class="text-danger">*</span></label>
                    <input type="hidden" name="id" id="id" value="{{$data->id}}" class="form-control" required>
                    <div class="col-md-8">

                        <input type="text" name="problem" id="cat" maxlength="50" value="{{$data->problem}}" class="form-control" required>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Age Limit <span class="text-danger">*</span></label>

                    <div class="col-md-8">


                        <select class="form-control" name="age_b" required>

                            <option value="">Select
                            </option>

                            <option value="Adult" @if($data->age_b == 'Adult') selected @endif>Adult
                            </option>

                            <option value="Pediatric" @if($data->age_b == 'Pediatric') selected @endif>Pediatric
                            </option>

                            <option value="Both" @if($data->age_b == 'Both') selected @endif>Both
                            </option>
                        </select>

                    </div>


                </div>
                <div class="col-md-6">
                    <label class="col-md-4 form-control-label">Image</label>
                    <div class="col-sm-8">
                        <input type="file" name="image" id="image" class="form-control">
                        <input type="hidden" name="image_old" id="image_old" value="{{$data->img}}" class="form-control">
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="col-md-4 form-control-label"></label>
                    <div class="col-sm-8">
                    <img src="{{$data->img}}" style="height:50px;width:50px"/>
                    </div>
                </div>
               



            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.p_cat_list')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection