@extends('layout.admin_layout')

@section('title', 'Chief Complaint')

@section('body')

@section('header', 'Chief Complaint')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.p_cat_add') }}">Chief Complaint</a></li>

@endsection


<div class="card">
 
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.p_cat_create') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Problem <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="problem" id="cat" class="form-control" maxlength="50" required>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Age Limit <span class="text-danger">*</span></label>

                    <div class="col-md-8">


                        <select class="form-control" name="age_b" required>

                            <option value="">Select
                            </option>

                            <option value="Adult">Adult
                            </option>

                            <option value="Pediatric">Pediatric
                            </option>

                            <option value="Both">Both
                            </option>

                        </select>

                    </div>





                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label">Image</label>
                    <div class="col-sm-8">
                        <input type="file" name="image" id="image" class="form-control">

                    </div>
                </div>


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.p_cat_list')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection