@extends('layout.admin_layout')

@section('title', 'Medical history')

@section('body')
@section('header', '
Medical history')
@section('badge')
<li class="breadcrumb-item"><a href="">
Medical history</a></li>
@endsection



<div class="card card-primary card-outline">
   

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px;">


          
            <a href="{{ route('admin.medical.add') }}" data-toggle="tooltip" title="Add Medical History" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>
            <a href="{{ route('admin.medical.delete_all') }}" onclick="return confirm('Are you sure you want to delete all ?')" data-toggle="tooltip" title="Delete All Medical History" class="btn btn-danger btn-sm"><i class="fa fa-plus"></i> Delete All</a>
            <a href="{{ route('admin.export_medical') }}" data-toggle="tooltip" title="Import Medical History" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a>
        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Medical History</th>
                        <th>Status</th>
                      
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 0;
                    ?>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->medical}}</td>
                        @if($value->status == 1)
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/medical/status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;" >Active</a></td>
                        @else
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/medical/status') }}/{{$value->id}}/1">Inactive</a></td>
                        @endif
                       
                        <td>
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/medical/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                            <a class="btn btn-sm btn-outline-danger" onclick="return alert('Are you sure you want to delete this ?')" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/medical/delete') }}/{{$value->id}}"> <i class="fa fa-trash" aria-hidden="true"></i></a>
                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush