@extends('layout.admin_layout')

@section('title', 'Medical history')

@section('body')

@section('header', 'Medical history')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.medical') }}">Edit Medical history</a></li>

@endsection


<div class="card">

    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.editMedical') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Medical history <span class="text-danger">*</span></label>
                    <input type="hidden" name="id" id="id" class="form-control" value="{{$data->id}}"  required>
                    <div class="col-md-8">

                        <input type="text" name="medical" id="medical" class="form-control" maxlength="50" value="{{$data->medical}}"  required>
                       
                    </div>
                   
                    
                </div>
              
               
            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection