@extends('layout.admin_layout')

@section('title', 'Medication')

@section('body')
@section('header', '
Medication')
@section('badge')
<li class="breadcrumb-item"><a href="">
Medication</a></li>
@endsection



<div class="card card-primary card-outline">
    
    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px;">


          
            <a href="{{ route('admin.medication.add') }}" data-toggle="tooltip" title="Add Medication" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>
            <a href="{{ route('admin.medication.delete_all') }}" onclick="return confirm('Are you sure you want to delete all ?')" data-toggle="tooltip" title="Delete All Lab" class="btn btn-danger btn-sm"><i class="fa fa-plus"></i> Delete All</a>
            <a href="{{ route('admin.medication.import') }}" data-toggle="tooltip" title="Import Medication" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a>
        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Dose</th>
                        <th>Status</th>
                      
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->title}}</td>
                        <td>{{$value->type}}</td>
                        <td>{{$value->unit}}</td>
                        @if($value->status == 1)
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/medication/status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                        @else
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/medication/status') }}/{{$value->id}}/1">Inactive</a></td>
                        @endif
                       
                        <td>
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/medication/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                            <a class="btn btn-sm btn-outline-danger" onclick="return alert('Are you sure you want to delete this ?')" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/medication/delete') }}/{{$value->id}}"> <i class="fa fa-trash" aria-hidden="true"></i></a>
                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush