@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Add Featured Subscription')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.feature-subscription.index') }}">Featured Subscriptions</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.feature-subscription.create') }}">Add Featured Subscription</a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Featured Subscription</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.feature-subscription.store') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Title <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="name" id="inputName" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" maxlength="191" required>
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Validity (days) <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="valid_form" id="inputName" class="form-control @error('valid_form') is-invalid @enderror" value="{{ old('valid_form') }}" maxlength="191" required>
                        {{-- <select name="valid_form" id="valid_form" class="form-control @error('valid_form') is-invalid @enderror" required>
                            <option value="">Select subscription time</option>
                            <option value="1 M" {{ (old('valid_form') == '1 M') ? "selected" : "" }}>1 Month ( 30days )</option>
                            <option value="2 M" {{ (old('valid_form') == '2 M') ? "selected" : "" }}>2 Month ( 60 days )</option>
                            <option value="3 M" {{ (old('valid_form') == '3 M') ? "selected" : "" }}>3 Month ( 90 days )</option>
                            <option value="6 M" {{ (old('valid_form') == '6 M') ? "selected" : "" }}>6 Month (180 days)</option>
                            <option value="12 M" {{ (old('valid_form') == '12 M') ? "selected" : "" }}>1 years ( 360 days)</option>
                        </select> --}}
                        @error('valid_form')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">No of banner</label>

                    <div class="col-md-10">

                        <input type="text" name="no_of_banner" id="inputName" class="form-control @error('no_of_banner') is-invalid @enderror" value="{{ old('no_of_banner') }}" maxlength="191" >
                        @error('no_of_banner')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Space (MB) </label>

                    <div class="col-md-10">

                        <input type="text" name="space" id="inputName" class="form-control @error('space') is-invalid @enderror" value="{{ old('space') }}" maxlength="191" >
                        @error('space')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Price ($) <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="price" id="inputName" class="form-control @error('price') is-invalid @enderror" value="{{ old('price') }}" maxlength="191" required>
                        @error('price')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

{{--
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image </label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div> --}}


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
