{{-- @extends('admin.layouts.app')
@section('content')
<div class="content-wrapper">

    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Category Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{action('LoginController@getAdminDashboard')}}"><i class="fas fa-home"></i> Home</a></li>
                        <li class="breadcrumb-item active"><i class="fa fa-laptop"></i></i> Category Management</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-5">
                                    <h4 class="card-title mb-0">
                                        Sub-Category List
                                    </h4>
                                </div><!--col-->

                                <div class="col-sm-7">
                                    <div class="btn-toolbar float-right" role="toolbar" aria-label="@lang('labels.general.toolbar_btn_groups')">
                                        <a href="{{ action('BusinessCategoriesController@create').'/'.request()->segment(3) }}" class="btn btn-success ml-1" data-toggle="tooltip" title="@lang('labels.general.create_new')"><span>Add New</span> <i class="fas fa-plus-circle"></i></a>
                                    </div>
                                </div><!--col-->
                            </div><!--row-->


<div class="row mt-4">
<div class="col">
    <div class="table-responsive">
        <table class="table table-bordered table-striped data-table dt-select cms_table_width" id="business_categories">
            <thead>
            <tr>
                <!-- <th style="text-align:center;"><input type="checkbox" id="select-all"/></th> -->
                <th>Id</th>
                <th>Name</th>
                <th>Description</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
            </thead>
            <tbody>
                @foreach ($subCategory as $category)
                <tr>
                    <td>{{$category->id}}</td>
                    <td>{{$category->name}}</td>
                    <td>{{$category->description}}</td>
                    <td>{!!$category->active!!}</td>
                    <td>
<a href="{{action('BusinessCategoriesController@show', $category->id)}}" data-toggle="tooltip"
data-placement="top" title="View" class="btn btn-info">
<i class="fas fa-eye"></i></a>

<a href="{{action('BusinessCategoriesController@edit', $category->id)}}" data-toggle="tooltip" data-placement="top" title="Edit" class="btn btn-primary">
<i class="fas fa-edit"></i>
</a>

<form method="POST" action="{{action('BusinessCategoriesController@destroy', [$category->id])}}" accept-charset="UTF-8" style="display: inline-block;" onsubmit="return confirm(\'Are you sure want to delete this row?\');">
    {{method_field('DELETE')}}
     @csrf
<button class="btn btn-danger" type="submit" title="Delete" data-toggle="tooltip" data-placement="top"><i class="fas fa-trash"></i></button>
</form>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
</div>
                            <div class="row">

                            </div><!--row-->
                        </div><!--card-body-->
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>

@endsection --}}

@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Coupon Details')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.coupon.index') }}">Coupons</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.coupon.show', $coupon_dtl->id) }}">Coupon Details</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Coupon Details</h3>
    </div>
    <div class="card-body">

        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="name">Coupon Code </label>

            <div class="col-md-10">
                {{ $coupon_dtl->code }}
            </div>
            <!--col-->
        </div>

        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="name">Description </label>

            <div class="col-md-10">
                {{ $coupon_dtl->description }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="name">Discount Type </label>
            <div class="col-md-10">
                {{  $coupon_dtl->discount_type == 1 ? "Flat Discount":"Discount in %"  }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="name">Discount </label>

            <div class="col-md-10">
                {{ $coupon_dtl->discount }}
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="start_date">Start Date </label>
            <div class="col-md-10">
                {{ date("d-m-Y", strtotime($coupon_dtl->start_date)) }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-2 form-control-label" for="end_date">End Date </label>
            <div class="col-md-10">
                {{ date("d-m-Y", strtotime($coupon_dtl->end_date)) }}
            </div>
        </div>

        @if (!empty($coupon_dtl->image))

        <div class="form-group row">
            <div class="col-md-2">Image :</div>
            <div class="col-md-10">
                <img width="100px" height="100px" src="{{ asset('public/uploads/coupon/' . $coupon_dtl->image) }}">
            </div>
        </div>
        @endif



        {{-- <div class="row">
            <div class="col">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped data-table dt-select cms_table_width"
                        id="business_categories">
                        <thead>
                            <tr>
                                <!-- <th style="text-align:center;"><input type="checkbox" id="select-all"/></th> -->
                                <th>Id</th>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Status</th>

                            </tr>
                        </thead>
                        <tbody>
                                <tr>
                                    <td>{{ $coupon_dtl->id }}</td>
                                    <td>{{ $coupon_dtl->name }}</td>
                                    <td>{{ $coupon_dtl->description }}</td>
                                    <td>{!! $coupon_dtl->active !!}</td>

                                </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div> --}}
    </div>
    <!-- /.card-body -->

    <div class="card-footer">
        <div class="col text-right">
            <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                    class="far fa-arrow-alt-circle-left"></i> Back</a>
        </div>
    </div>

    <!-- /.card-footer-->
</div>

@endsection
