@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
          @section('header', 'Coupons')
          @section('badge')
           <li class="breadcrumb-item"><a href="{{ route('admin.coupon.index') }}">Coupons</a></li>
          @endsection

    <!-- /.col -->

          <div class="card card-primary card-outline">
            <div class="card-header">
              <h3 class="card-title">Coupons List</h3>

              <div class="card-tools">
                <form action="" method="GET">
                <div class="input-group input-group-sm">
                  <input type="text" name="search" class="form-control" placeholder="Search">
                  <div class="input-group-append">
                    <button class="btn btn-primary"><i class="fas fa-search"></i></button>

                  </div>
                </div>
                </form>

              </div>
              <!-- /.card-tools -->
            </div>
            <!-- /.card-header -->
            <div class="card-body p-0">
                <form action="" method="post">
                          @csrf

              <div class="mailbox-controls">
                <!-- Check all button -->
                {{-- <button type="button" data-toggle="tooltip" title="Select All" class="btn btn-default btn-sm checkbox-toggle"><i class="far fa-square"></i>
                </button> --}}
                <div class="btn-group">
                  {{-- <button type="submit" onclick="return confirm('Are you sure want to delete?');" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button> --}}
               {{--    <a href="" class="btn btn-default btn-sm"><i class="fas fa-eye"></i></a>
                  <a href="" class="btn btn-default btn-sm"><i class="fas fa-edit"></i></a> --}}
                  <a href="" data-toggle="tooltip" title="Refresh" class="btn btn-default btn-sm"><i class="fas fa-sync-alt"></i></a>
                </div>
                  <a href="{{ route('admin.coupon.create') }}" data-toggle="tooltip" title="Add New Coupons" class="btn btn-primary btn-sm"><i class="fas fa-plus-square"></i> New</a>
                <!-- /.btn-group -->


                <!-- /.float-right -->
              </div>
              <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                  <thead>
                  <tr>
                    <th># No</th>
                    <th>Code</th>
                    <th>Description</th>
                    <th>Start date</th>
                    <th>End date</th>
                    <th>Discount</th>
                    <th>Discount type</th>
                    <th>Action</th>
                  </tr>
                  </thead>

                  <tbody id="search_result">
                    @forelse ($coupons as $coupon)
                      <tr>
                         {{-- <tr onmouseover="showActionBtn('{{ $loop->iteration }}');" onmouseout="hideActionBtn('{{ $loop->iteration }}')"> --}}

                        <td>
                      <div class="icheck-primary">
                        {{-- <input type="checkbox" name="category_id[]" value="{{ $category->id }}" id="check{{ $loop->iteration }}"> --}}
                        <label for="check{{ $loop->iteration }}">#{{ $loop->iteration }}</label>
                      </div>
                    </td>
                        <td>{{ $coupon->code }}</td>
                        <td>{{ $coupon->description }}</td>
                        <td>{{ date("d-m-Y", strtotime($coupon->start_date)) }}</td>
                        <td>{{ date("d-m-Y", strtotime($coupon->end_date)) }}</td>
                        <td>{{ $coupon->discount }}</td>
                        <td>{{ $coupon->discount_type==1 ? 'flat discount' : 'discount in %' }}</td>

                        <td>
                        <a class="btn btn-sm btn-info" href="{{ route('admin.coupon.show', $coupon->id) }}"> <i class="fas fa-eye"></i> View</a>
                        {{-- <a class="btn btn-sm btn-outline-warning" href="{{ route('admin.news.edit', $news->id) }}"> <i class="fas fa-edit"></i> Edit</a>
                        <a class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure want to delete?');" href="{{ route('admin.news.delete', $news->id) }}"> <i class="fas fa-trash-alt"></i> Delete</a> --}}
                        <a href="{{ route('admin.coupon.edit', $coupon->id) }}" class="btn btn-sm btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>

                        @if ($coupon->status == 0)
                        <a href="{{route('admin.coupon.send',$coupon->id)}}" class="btn btn-sm btn-success">
                            <i class="fas fa-share-square"></i> Send
                        </a>
                        @endif
                        {{-- @else
                        <a href="{{route('admin.category.active',$category->id)}}" class="btn btn-sm btn-success">
                            <i class="fas fa-toggle-on"></i> Active
                        </a>
                        @endif --}}

                        </td>
                      </tr>
                    @empty
                      <tr>
                        <td colspan="7" class="text-center">No data found.</td>
                      </tr>
                    @endforelse

                  </tbody>


                </table>
                <!-- /.table -->
              </div>
              <!-- /.mail-box-messages -->
            </div>
            <!-- /.card-body -->
            <div class="card-footer p-0">
              <div class="mailbox-controls">

                <div class="float-right">

                  <div class="btn-group">
                    {{-- {{ $users->onEachSide(1)->links() }} --}}
                    {{ $coupons->links() }}
                  </div>
                  <!-- /.btn-group -->
                </div>
                <!-- /.float-right -->
              </div>
            </div>
          </form>
          </div>
          <!-- /.card -->

        <!-- /.col -->


@endsection
@push('scripts')

  @endpush
