@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Add Coupon')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.coupon.index') }}">Coupons</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.coupon.create') }}">Add Coupon</a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Coupon Add</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.coupon.store') }}" method="POST" enctype="multipart/form-data">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Coupon Code <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input type="text" name="code" id="inputName" class="form-control @error('code') is-invalid @enderror" value="{{ old('code') }}" maxlength="191" required>
                        @error('code')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Description </label>

                    <div class="col-md-10">
                        <textarea name="description" class="form-control" rows="5"></textarea>
                        @error('description')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Discount Type <span
                        class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <select name="discount_type" class="form-control" required>
                            <option value="">Select discount type</option>
                            <option value="1">Flat Amount</option>
                            <option value="2">%</option>
                        </select>
                        @error('discount_type')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Discount <span
                        class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input type="text" name="discount" id="inputName" class="form-control @error('discount') is-invalid @enderror" value="{{ old('discount') }}" required>

                        @error('discount')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="start_date">Start Date <span
                        class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" name="start_date" id="start_date" class="form-control datepicker @error('start_date') is-invalid @enderror" value="{{ old('start_date') }}" required>
                        @error('start_date')
                            <span class="error invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="end_date">End Date <span
                        class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" name="end_date" id="end_date" class="form-control datepicker @error('end_date') is-invalid @enderror" value="{{ old('end_date') }}" required>
                        @error('end_date')
                            <span class="error invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image </label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
