@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', '
Manage Contact')
@section('badge')
<li class="breadcrumb-item"><a href="">
        Contact Us</a></li>
@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">
        Contact Us</h3>
    </div>

    <div class="row">
        <div class="mailbox-controls col-md-9">

        <a href="{{ route('admin.cms') }}" data-toggle="tooltip" title="Back" class="btn btn-danger btn-sm" style="margin-left:10px;"><i class="fa fa-arrow-left"></i> Back</a>
            <!-- <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
            </div>
            <a href="{{ route('admin.reasons.add') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Reason"><i class="fas fa-plus-square"></i> New</a> -->

        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Massage</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->contact_name}} @if($value->seen == 0) <span class="btn btn-danger" style="padding: 0 3px; font-size: 10px">New</span>@endif</td>
                        <td>{{$value->contact_email}}</td>
                        <td>{{$value->contact_no}}</td>
                        <td>{{substr($value->contact_msg, 0, 30)}}</td>
                        <td>
                        <a class="btn btn-sm btn-outline-info" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/contact/view') }}/{{$value->id}}"> <i class="fa fa-eye"></i></a>
                        <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to reply" href="{{ URL::to('admin/contact/reply') }}/{{$value->id}}"> <i class="fa fa-share"></i></a>
                        <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete"  onclick="return confirm('Are you sure you want to delete?');" href="{{ URL::to('admin/contact/delete') }}/{{$value->id}}"> <i class="fa fa-trash"></i></a>
                    </td>
                       

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush