@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', '
Manage Contact Info')
@section('badge')
<li class="breadcrumb-item"><a href="">
        Manage Contact Info</a></li>
@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">
        Contact Info</h3>
    </div>

    <div class="row">
        <div class="mailbox-controls col-md-9">


            <!-- <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
            </div>
            <a href="{{ route('admin.reasons.add') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Reason"><i class="fas fa-plus-square"></i> New</a> -->
            <a href="{{ route('admin.cms') }}" data-toggle="tooltip" title="Back" class="btn btn-danger btn-sm"  style="margin-left:10px;"><i class="fa fa-arrow-left"></i> Back</a>
        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Address</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->email}}</td>
                        <td>{{$value->phone}}</td>
                        <td>{{$value->address}}</td>
                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/info/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>






                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush