@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Edit Contact Info')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.info') }}">Edit Contact Info</a></li>
 
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Edit Contact Info</h3>
    </div>
    <div class="card-body">
        <form role="form"  method="POST" action="{{ route('admin.contact_info.edit') }}" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Email<span
                            class="text-danger">*</span></label>

                    <div class="col-md-6">
                   
                        <input type="text" name="email"  class="form-control" value="{{$data->email}}" maxlength="150" required>
                       
                    </div>
                    <!--col-->
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Address<span
                            class="text-danger">*</span></label>

                    <div class="col-md-6">
                    <input type="hidden" name="id"  class="form-control" value="{{$data->id}}" maxlength="150" required>
                        <input type="text" name="address"  class="form-control" value="{{$data->address}}" maxlength="150" required>
                       
                    </div>
                    <!--col-->
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Phone<span
                            class="text-danger">*</span></label>

                    <div class="col-md-6">
                    
                        <input type="text" name="phone"  class="form-control" value="{{$data->phone}}" maxlength="10" oninput="this.value=this.value.replace(/[^0-9]/g,'')" required>
                       
                    </div>
                    <!--col-->
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.info') }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
