@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Contact Us CMS Page Edit')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.contact_us.cms') }}">Contact Us CMS</a></li>

@endsection
{{-- @extends('admin.layouts.app')
@section('content')
<link rel="stylesheet" href="{{ asset('public/plugins/summernote/summernote-bs4.css')}}">

    <div class="content"> --}}


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Contact Us CMS Page Edit</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.contact_us.cms') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}

            {{-- <input type="hidden" name="id" value="{{ $emp->id }}"> --}}
            <div class="card-body">

                <div class="form-group row">
                    @if (Session::has('Success'))
                        <div class="col-12 mt-2" style="margin-bottom: 15px;">

                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <strong>{{ Session::get('Success') }}</strong>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span class="fa fa-times"></span>
                                </button>
                            </div>
                        </div>
                    @endif

                    <label class="col-md-2 form-control-label" for="name">Phone No <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('phone') is-invalid @enderror" type="text" name="phone"
                            id="phone" placeholder="Please enter phone" value="{{ $page->phone }}" required>
                        @error('phone')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Email<span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('email') is-invalid @enderror" type="text" name="email"
                            id="email" placeholder="Please enter email" value="{{ $page->email }}" required>
                        @error('email')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="description">Address<span
                            class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <textarea class="form-control @error('address') is-invalid @enderror" type="text" name="address"
                            id="address" placeholder="address"
                            style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $page->address }}</textarea>

                        @error('address')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Latitude<span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('lat') is-invalid @enderror" type="text" name="lat" id="lat"
                            placeholder="Please enter lat" value="{{ $page->lat }}" required>
                        @error('lat')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Longitude<span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('long') is-invalid @enderror" type="text" name="long"
                            id="long" placeholder="Please enter long" value="{{ $page->long }}" required>
                        @error('long')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

{{-- </div> --}}

@endsection

@push('scripts')
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.9/summernote.min.js" defer></script> --}}

<script>
    // jQuery('#datetimepicker7').datetimepicker({
    //     timepicker:false,
    //     formatDate:'Y/m/d',
    //     minDate:'0',//yesterday is minimum date(for today use 0 or -1970/01/01)
    //     // maxDate:'+1970/01/02'//tomorrow is maximum date calendar
    // });

    jQuery('#timepicker').datetimepicker({
        datepicker: false,
        format: 'H:i',
        mask: true,
        step: 5
    });
    $(function() {
        $('.textarea').summernote();
    })
    // CKEDITOR.replace('content');
</script>

@endpush
