@extends('layout.admin_layout')

@section('title', 'Manage Commission')

@section('body')
@section('header', "
List of Doctor's Earnings")
@section('badge')
<li class="breadcrumb-item"><a href="">
        Earning</a></li>
@endsection



<div class="card card-primary card-outline">

    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }}
    </div>
    @endif




    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Doctor Name</th>
                        <th>Available Balance</th>
                        <th>Total Earning</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>Dr. {{$value->last_name}}</td>

                        @if($value->avl_bal == '')
                        <td>$ 0</td>
                        @else
                        <td>$ {{$value->avl_bal}}</td>
                        @endif
                        <td>$ {{total_earning($value->id)}}</td>


                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush