@extends('layout.admin_layout')

@section('title', 'Manage Commission')

@section('body')
@section('header', '
Manage Commission')
@section('badge')
<li class="breadcrumb-item"><a href="">
       Manage Commission</a></li>
@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">
        Commission List</h3>
    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif
    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:15px">


            <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
                <a style="margin-left:12px" href="{{ route('admin.global.commission') }}" data-toggle="tooltip" title="" class="btn btn-success btn-sm" data-original-title="Set Global Commission"><i class="fas fa-plus-square"></i> Global Commission</a>
            </div>
            <a href="{{ route('admin.doctor.commission') }}" data-toggle="tooltip" title="" class="btn btn-info btn-sm" data-original-title="Add Commission % to doctors"><i class="fas fa-plus-square"></i> Individual Commission </a>

        </div>
        <div class="card-tools col-md-4">
            <form method="GET">
                <div class="input-group input-group-sm">
                  
                  
                    <select class="form-control m-1" name="consultation_type" id="consultation_type">

                        <option value="">Search By Commission Type </option>
                        <option value="1" @if(isset($_GET['consultation_type']) && $_GET['consultation_type'] == 1) selected @endif>Global</option>
                        <option value="4" @if(isset($_GET['consultation_type']) && $_GET['consultation_type'] ==  2) selected @endif>Individual</option>

                    </select>



                    <div class="input-group-append">
                        <button class="btn btn-primary" id="search"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </div>
                </div>
            </form>

        </div>

        
    </div>
 


    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Doctor Name</th>
                        <th>Commission Type</th>
                        <th data-orderable="false" >Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($data as $key=>$value)
                    <tr>

              
                        <td>
                           
                                {{$key+1}}
                           
                        </td>
                        <td>Dr. {{$value->last_name}}</td>
                        @if($value->consultation_type != 4)

                        <td><span class="badge badge-pill badge-primary">Global</span></td>
                        @else
                        <td><span class="badge badge-pill badge-warning">Individual</span></td>
                        @endif
                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/commission/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>

   




                        </td>
                      
                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')
<script>
    $('#search').click(function(e) {
        e.preventDefault();
        var consultation_type = $('#consultation_type').val();

        $.ajax({
            url: "{{route('admin.commission')}}",
            type: 'GET',
            data: {
               
                consultation_type: consultation_type,
            },
            success: function(data) {
                location.replace('?consultation_type=' + consultation_type);

            }
        });


    });
</script>
@endpush