@extends('layout.admin_layout')

@section('title', 'Global Commission')

@section('body')

@section('header', 'Global Commission')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.global.commission') }}">Global Commission Percentage</a></li>
@endsection

@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }}
</div>
@endif
<div class="card">
   
    <div class="card-body">
   
        <form role="form" method="POST" action="{{ route('admin.global.store') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Percentage (%) <span class="text-danger">*</span></label>

                    <div class="col-md-3">

                        <input type="number" name="per" id="per" class="form-control" value=""   min="1" max="99" required/>
                    </div>
                    <!--col-->
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.commission') }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
     
       
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<div class="card">
    <div class="card-body p-0">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Commission</th>
                        <th>Start</th>
                        <th>End</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->percentage}}</td>

                        <td>
                        {{$value->created_at}}
                        </td>
                        <td>
                            @if($value->updated_at=='')
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/commission/global/edit/') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                            @else
                        {{$value->updated_at}}
                        @endif
                        </td>
                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>
</div>

@endsection