@extends('layout.admin_layout')

@section('title', 'Manage Commission')

@section('body')

@section('header', 'Manage Commission')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.global.commission') }}">Manage Commission</a></li>
@endsection

@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }}
</div>
@endif
@if ($errors->any())
@foreach ($errors->all() as $error)
<div class="alert alert-danger">{{$error}}</div>
@endforeach
@endif
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Commission</h3>
    </div>
    <div class="card-body">

        <form role="form" method="POST" action="{{ route('admin.commission.store') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Doctor<span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <select class="form-control" name="doctor_id" id="doctor_id" required>
                            <option value="">--Choose a Doctor--</option>
                            @foreach($data as $row)
                            <option value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach

                        </select>

                    </div>
                    <!--col-->
                </div>
               
                <div class="form-group row" id="per1">
                    <label class="col-md-2 form-control-label" for="name">Percentage (%) <span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <input type="number" name="per" id="per" class="form-control" min="1" max="99" required/>
                   
                    </div>
                    <!--col-->
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.commission') }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>

    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    function get_com() {

        var type = $("input[name=type]:checked").val();
        if (type == 1) {
            $.ajax({
                url: "{{route('admin.global_per')}}",
                type: 'GET',
                success: function(data) {
                    if (data != 0) {
                        $('#per').val(data);
                        $('#per1').hide();
                    } else {
                        $('#msg').show();
                        $(":submit").attr("disabled", true);
                    }



                }
            });
        } else {
            $('#per1').show();
            $('#msg').hide();
            $(":submit").attr("disabled", false);
            $('#per').val('');
        }

    }
</script>
@endsection