@extends('layout.admin_layout')

@section('title', 'Color Code')

@section('body')

@section('badge')

@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title" >List of Patients under <u style="color:{{$color_code->color}};padding:5px;">{{$color_code->color}}</u></h3>
    </div>
    <div class="row">


        <div class="card-tools col-md-10" style="padding-left:15px">




            <div class="input-group-append">
                <a class="btn btn-info" href="{{ route('admin.color_code') }}"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back to Color Code list</a>

            </div>
        </div>


    </div>




    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Gender</th>
                        <th data-orderable="false">Status</th>
                    
                    </tr>
                </thead>
                <tbody>
                    @foreach($color_code_patients as $key=>$u_d)
                    <tr>

                        <td>
                            <div class="icheck-primary">

                                <label for="check1">{{$key+1}}</label>
                            </div>
                        </td>
                        <td>{{$u_d->name}}</td>
                        <td>{{$u_d->email}}</td>
                        <td>{{$u_d->phone}}</td>

                        <td>
                            {{$u_d->sex}}


                        </td>
                        @if($u_d->status == 0)
                        <td><span class="badge badge-danger">Inactive</span></td>
                        @else
                        <td><span class="badge badge-success">Active</span></td>
                        @endif
               
                    </tr>
                    @endforeach






                </tbody>



            </table>

        </div>
    </div>



</div>


@endsection
@push('scripts')

@endpush