@extends('layout.admin_layout')

@section('title', 'Color Code')

@section('body')
@section('header', 'Manage Color Code')
@section('badge')
<li class="breadcrumb-item"><a href="">
        Manage Color Code</a></li>
@endsection



<div class="card card-primary card-outline">
   

    <div class="row">
        <div class="mailbox-controls col-md-9"  style="padding:20px;">


            <div class="btn-group">


                <a href="{{ route('admin.colorAdd') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Route"><i class="fas fa-plus-square"></i> New Color Code</a>
            </div>


        </div>


    </div>



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
        @if(Session::has('message'))
        <div class="alert alert-success">
            {{ Session::get('message') }}
        </div>
        @endif


            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Color Code</th>
                        <th>Health Condition</th>
                        <th>Status</th>
                        <th  data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td><button class="btn btn-basic"style="background-color:{{$value->color}};"></button> {{$value->color}}</td>
                        <td>{{$value->type}}</td>
                        @if($value->status == 1)
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/color_status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;" >Active</a></td>
                        @else
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/color_status') }}/{{$value->id}}/1">Inactive</a></td>
                        @endif

                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/color_code/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                          
                           
                            <a class="btn btn-sm btn-outline-info" data-toggle="tooltip" title="Click to view color code" href="{{ URL::to('admin/color_code/list') }}/{{$value->id}}"> <i class="fa fa-list" aria-hidden="true"></i></a>

                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete color code" href="{{ URL::to('admin/color_code/delete') }}/{{$value->id}}"> <i class="fa fa-trash" aria-hidden="true"></i></a>



                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush