@extends('layout.admin_layout')

@section('title', 'Color Code')

@section('body')

@section('header', 'Edit Color Code')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.color_code') }}">Color Code</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.colorAdd') }}">Edit Color Code</a></li>
@endsection
<style>
    .card1 {
        background-color: white;
        border-radius: 4px;
        padding: 5px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        box-shadow: 0 30px 30px -15px rgba(0, 0, 0, 0.3);

    }

    .code {
        list-style: none;
        padding: 0px;
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        grid-gap: 20px;

    }

    .color-item {
        width: 30px;
        height: 30px;
        background-color: red;
        border-radius: 50%;
        cursor: pointer;
        transition: transform 0.3s;

    }

    .color-item:hover {
        transform: scale(1.1);
    }
</style>

<div class="card">
  
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.colorCreate') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">

                <div class="col-md-6">
                    <label class="col-md-4 form-control-label" for="name">Color <span class="text-danger">*</span></label>
                    <input type="hidden" name="color" id="color" class="form-control" value="{{$data->color}}" required>
                    <input type="hidden" name="id" id="id" class="form-control" value="{{$data->id}}" required>
                    <div class="col-md-8">

                        <input type="text" name="color1" id="color1" class="form-control" value="{{$data->color}}"disabled required>
                        @error('color')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <label class="col-md-4 form-control-label" for="name">Health Condition <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="type" id="type" class="form-control" value="{{$data->type}}" required>
                        @error('type')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                </div>
                <div class="col-md-5">

                    <div class="card card1">
                        <label class="form-control-label" for="name">Pick a Color</label> 
                        <ul class="code">
                            @foreach(colors() as $cl)
                            <li class="color-item" style="background-color:{{$cl->color}};" id="{{$cl->color}}"></li>
                            @endforeach
                        </ul>

                    </div>
                </div>
                <div class="col-md-6">


                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i>Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    window.addEventListener('load', () => {
        const colorItem = document.querySelectorAll('.color-item');
        colorItem.forEach(item => {
            item.addEventListener('click', function() {
                const idSelected = this.id;
                console.log(idSelected);
                $('#color').val(idSelected);
                $('#color1').val(idSelected);
            });

        })
    });
</script>
@endsection