@extends('layout.admin_layout')

@section('title', 'Medicine Change')

@section('body')

@section('header', 'Medicine Change')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.med_ch_rq') }}"> Medicine Change</a></li>

@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title"> Medicine Change</h3>
    </div>
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.ch_rq_post') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <input type="hidden" name="id" id="id" value="{{$data->id}}" class="form-control" required>
            <input type="hidden" name="id_m" id="id_m" value="{{$id_m}}" class="form-control" required>
            <div class="card-body row">
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Medicine <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                    <select  name="med" id="med"  class="form-control">
                        @foreach($medicine as $row)
                            <option value="{{$row->title}}" @if($data->medicine == $row->title ) selected @endif>{{$row->title}}</option>
                            @endforeach
                        
                        </select>

                  
                    </div>


                </div>

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Course <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                      
                    <input type="text" name="course" id="course" value="{{$data->course}}" class="form-control" required>
                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Dose <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="dose" id="dose" value="{{$data->dose}}" class="form-control" required>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Frequency <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                    <input type="number" name="frq" id="frq" value="{{$data->frequency}}" class="form-control" min="0" max="99" required>
                    </div>
                </div>
           

            </div>
            <div class="card-footer">
                <div class="col text-right">
      
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>

</div>

@endsection