@extends('layout.admin_layout')

@section('title', 'Medicine Change Requests')

@section('body')
@section('header', 'Medicine Change Requests')
@section('badge')
<li class="breadcrumb-item"><a href="">
        Manage Medicine Change Requests</a></li>
@endsection



<div class="card card-primary card-outline">
   
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif




    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Date</th>
                        <th>Consultation Type</th>
                        <th>Doctor</th>
                        <th>Patient</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{date('m-d-Y',strtotime($value->date))}}</td>
                        <td>{{$value->consultation_type}}</td>
                        <td>{{user_name($value->doctor_id)}}</td>
                        <td>{{user_name($value->patient_id)}}</td>
                        <td>  <a href="med_ch_rq/{{$value->id}}" class="btn btn-sm btn-success">
                            <i class="fas fa-eye"></i> 
                        </a></td>
                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush