@extends('layout.admin_layout')

@section('title', 'List of Medicines to Change')

@section('body')
@section('header', 'List of Medicines to Change')
@section('badge')
<li class="breadcrumb-item"><a href="">
        List of Medicines to Change</a></li>
@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">
        List of Medicines to Change</h3>
    </div>





    <div class="card-body p-0">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                      
                        <th>Medicine</th>
                        <th>Course</th>
                        <th>Dose</th>
                    
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach(med($data->medicine_id) as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>
                            {{$value->medicine}}
                        </td>
                        <td>
                            {{$value->course}}
                        </td>
                        <td>
                            {{$value->dose}}
                        </td>
                        <td>
                        <a href="../ch_rq/{{$id_m}}/{{$value->id}}" class="btn btn-sm btn-warning">
                            <i class="fas fa-edit"></i> 
                        </a>


                        </td>
                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush