@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Food & drinks Category Details')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.category.index') }}">Food & drinks Category</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.category.show', $store->id) }}">Food & drinks Category Details</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Food & drinks Category Details</h3>
    </div>
    <div class="card-body">

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Food & drinks Category Name :</label>

            <div class="col-md-9">
                {{ $store->name }}
            </div>
            <!--col-->
        </div>

        @if (!empty($store->image))

        <div class="form-group row">
            <label class="col-md-3 form-control-label">Image :</label>
            <div class="col-md-9">
                <img width="100px" height="100px" src="{{ asset('public/uploads/category/' . $store->image) }}">

            </div>
        </div>
        @endif
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="col text-right">
            <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                    class="far fa-arrow-alt-circle-left"></i> Back</a>
        </div>
    </div>
    <!-- /.card-footer-->
</div>

@endsection
