@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Edit Food & Drinks Category')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.category.index') }}">Food & Drinks Category</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.category.edit', $storeDetailsById->id) }}">Edit Food & Drinks Category</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Food & Drinks Category Edit</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.category.update', $storeDetailsById->id) }}" method="POST"
            enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Name <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('name') is-invalid @enderror" type="text" name="name"
                            id="name" placeholder="Please Enter Food & Drinks Category Name" value="{{ $storeDetailsById->name }}">
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>
                @if (!empty($storeDetailsById->image))

                <div class="form-group row">
                    <div class="col-md-2"></div>
                    <div class="col-md-10">
                        <img width="100px" height="100px" src="{{ asset('public/uploads/category/' . $storeDetailsById->image) }}">
                        {{-- <br> --}}
                    </div>
                </div>
                @endif
                <div class="form-group row">


                    <label class="col-md-2 form-control-label" for="name">Image </label>


                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

            </div>

            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-outline-primary"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
