@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Add Food & Drinks Category')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.category.index') }}">Food & Drinks Category</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.category.create') }}">Add Food & Drinks Category</a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Food & Drinks Category Add</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.category.store') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Category Name <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        {{-- <input class="form-control @error('heading') is-invalid @enderror" type="text" name="heading"
                            id="heading" placeholder="Please enter news heading" maxlength="191"
                            value="{{ old('heading') }}"> --}}
                        <input type="text" name="name" id="inputName" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" maxlength="191">
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image </label>

                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
