@extends('layout.admin_layout')

@section('title', 'Import Symptoms with their problems')

@section('body')

@section('header', 'Import Symptoms with their problems')
@section('badge')
<li class="breadcrumb-item"><a href="#">Import Symptoms with their problems</a></li>

@endsection


<div class="card">
    <div class="card-header">
        <h5 class="card-title"> Please import Complain related question first. Don't rename sample CSV file name before import. Keep file name as it is.</h5>
    </div>
    <div class="card-body">
    @if(Session::has('message'))
        <div class="alert alert-success">
            {{ Session::get('message') }}
        </div>
        @endif
        @if(Session::has('error'))
        <div class="alert alert-danger">
            {{ Session::get('error') }}
        </div>
        @endif
        

        <form role="form" method="POST" action="{{ route('admin.body_cat_import_post') }}" enctype='multipart/form-data' id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">



                <div class="col-md-12">
                    <label class="col-md-4 form-control-label">Upload CSV File <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="file" name="csv_file" id="csv_file" class="form-control" required>

                    </div>


                </div>
                <div class="form-group">
                    <div class="row">
                        <div class="col-sm-10 col-md-12" style="text-align:right">
                        
                            <a href="{{url('Images/csv_file/symptoms_problems.csv')}}" download>Download Sample File</a>
                        </div>
                    </div>
                </div>


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.sub_cat_index') }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection