@extends('layout.admin_layout')

@section('title', 'Body Part Symptoms')

@section('body')

@section('header', 'Body Part Symptoms')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.body_cat.add') }}">Body Part Symptoms</a></li>

@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Create Symptoms</h3>
    </div>
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.editBodyCat') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <input type="hidden" name="id" id="id" class="form-control" value="{{$b->id}}"required>
            <div class="card-body row">
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Problems <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="pro_id" id="pro_id" required>

                            <option value="">Select
                            </option>
                            @foreach($data as $value)
                            <option value="{{$value->id}}" @if($value->id == $b->pro_id) selected @endif>{{$value->problem}}-{{$value->age_b}}
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Question <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="type" id="type" required>

                            <option value="">Select
                            </option>
                            @foreach(get_type($b->pro_id) as $value)
                            <option value="{{$value->id}}" @if($value->id == $b->type) selected @endif>{{$value->type}}
                            </option>
                            @endforeach
                        </select>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Symptom <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="symptoms" id="symptoms" value="{{$b->symptoms}}" class="form-control" required>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Priority <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" id="priority" name="priority" required>
                            <option value="">Select</option>
                            @for($i=0; $i<=8 ;$i++) <option value="{{$i}}+" @if($i.'+' == $b->priority) selected @endif>{{$i}}+
                                </option>
                                @endfor
                        </select>
                    </div>
                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Image <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                    <input type="hidden" value="{{$b->img}}" name="img_o" id="img_o" class="form-control" required>

                        <input type="file" name="img" id="img" class="form-control" >
                        <img src="{{$b->img}}" height="50" width="50"/>
                    </div>


                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.body_cat')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i>Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#pro_id').on('change', function(e) {
            var pro_id = e.target.value;
            $.ajax({
                url: "{{ route('admin.questions') }}",
                type: "GET",
                data: {
                    pro_id: pro_id
                },
                success: function(data) {


                    if (data) {
                        $('#type').empty();
                        $('#type').append('<option value="" hidden>Choose </option>');
                        $.each(data, function(key, value) {
                            $('select[name="type"]').append('<option value="' + value.id + '">' + value.type + '</option>');
                        });
                    } else {
                        $('#type').empty();
                    }
                }
            })
        });
    });
</script>
@endsection