@extends('layout.admin_layout')

@section('title', 'Body Part Symptoms')

@section('body')

@section('header', 'Body Part Symptoms')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.body_cat.add') }}">Body Part Symptoms</a></li>

@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Create Symptoms</h3>
    </div>
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.body_cat.create') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Problems <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="pro_id" id="pro_id" required>

                            <option value="">Select
                            </option>
                            @foreach($data as $value)
                            <option value="{{$value->id}}">{{$value->problem}}-{{$value->age_b}}
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Question <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="type" id="type" required>

                            <option value="">Select
                            </option>
                           
                        </select>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Symptom <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="symptoms" id="symptoms" class="form-control" required>

                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Priority <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" id="priority" name="priority" required>
                            <option value="">Select</option>
                            @for($i=1; $i<=8 ;$i++) <option value="{{$i}}+">{{$i}}+
                                </option>
                                @endfor
                        </select>
                    </div>
                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Image <span class="text-danger">*</span></label>

                    <div class="col-md-8">


                        <input type="file" name="img" id="img" class="form-control" required>
                    </div>


                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.body_cat')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#pro_id').on('change', function(e) {
            var pro_id = e.target.value;
            $.ajax({
                url: "{{ route('admin.questions') }}",
                type: "GET",
                data: {
                    pro_id: pro_id
                },
                success: function(data) {


                    if (data) {
                        $('#type').empty();
                        $('#type').append('<option value="" hidden>Choose </option>');
                        $.each(data, function(key, value) {
                            $('select[name="type"]').append('<option value="' + value.id + '">' + value.type + '</option>');
                        });
                    } else {
                        $('#type').empty();
                    }
                }
            })
        });
    });
</script>
@endsection