@extends('layout.admin_layout')

@section('title', 'Manage Profile')

@section('body')
@section('header', 'Manage Profile')
@section('badge')
{{-- <li class="breadcrumb-item"><a href="{{ route('admin.cms') }}">cms</a></li> --}}
<li class="breadcrumb-item"><a href="{{ route('admin.manageProfile') }}">Manage Profile</a></li><br>

@endsection
<div class="text-right">
    @if(request()->user()->profile_image != '')
    <img src="../{{ request()->user()->profile_image }}" height="128px" width="128px" alt="logo" style="padding-right:10px;" class="img-circle img-fluid">
    @else
    <img src="../images/noimage.png" height="80px" width="90px" alt="logo" style="padding-right:25px;">
    @endif

</div>
<section class="content">
    @if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif
    <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Manage Profile</h3>

                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>


                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form role="form" method="POST" action="{{ route('admin.manageProfile') }}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name <span style="color:red">*</span></label>


                                <input id="name" type="text" class="form-control" name="name" value="{{ request()->user()->name}}" required>

                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email</label>
                                <input id="email" type="email" class="form-control" name="email" value="{{ request()->user()->email}}" disabled>

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label class="col-md-12 form-control-label">Phone <span style="color:red">*</span></label>
                                <div class="col-md-2">

                                    <input type="hidden" name="country_code" class="form-control fil" id="country_code" value="{{request()->user()->country}}" placeholder="phone" autocomplete="off">
                                    <input type="hidden" name="dial_code" class="form-control fil" id="dial_code" value="{{request()->user()->code}}" placeholder="phone" autocomplete="off">
                                    <input type="tel" name="code" class="form-control fil" id="code" autocomplete="off">
                                </div>

                                <div class="col-md-10">


                                    <input id="phone" type="text" class="form-control" name="phone" maxlength="10" pattern="\d{10}" value="{{ request()->user()->phone}}" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Address <span style="color:red">*</span></label>


                                <input id="address" type="text" class="form-control" name="address" id="address" value="{{ request()->user()->address}}" required>

                            </div>
                        </div>
                        <div class="form-group row col-md-12">
                            <label class="col-md-2 form-control-label" for="name">Admin Profile Image</label>
                            <div class="col-md-9 custom-file">
                                <input type="file" class="custom-file-input" name="logo" id="inputGroupFile01">
                                @if(request()->user()->profile_image!='')
                                <label class="custom-file-label" for="inputGroupFile01"><?= request()->user()->profile_image ?></label>
                                @else
                                <label class="custom-file-label" for="inputGroupFile01">Choose Image</label>
                                @endif
                            </div>
                        </div>
                           
                            <div class="col-md-12">

                                @if(request()->user()->profile_image != '')
                                <img src="../{{ request()->user()->profile_image }}" height="128px" width="128px" alt="logo" style="margin-top:-20px;" class="img-circle img-fluid">
                                @else
                                <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                                @endif
                            </div>

                           <div class="form-group row col-md-12"  style="padding-top:5px;">
                            <label class="col-md-2 form-control-label" for="name">App Logo</label>
                            <div class="col-md-9 custom-file1">
                                <input type="file" class="custom-file-input1" name="logo_w" id="inputGroupFile02">
                                @if(getSetting('logo')!='')
                                <label class="custom-file-label" for="inputGroupFile02">Images/logo/<?= getSetting('logo') ?></label>
                                @else
                                <label class="custom-file-label" for="inputGroupFile02">Choose Image</label>
                                @endif
                            </div>
 



                               
                            </div>

                            <div class="col-md-12">




                                @if(getSetting('logo') != '')
                                <img src="{{ asset('Images/logo/' . getSetting('logo')) }}" height="128px" width="128px" style="margin-top:-20px;" class="img-circle img-fluid" alt="User Image">
                                @else
                                <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                                @endif
                            </div>
<br><br>
                            <button type="submit" class="btn btn-primary" style="padding-top:10px;">
                                Save
                            </button>
                            &nbsp;&nbsp;
                            <a class="btn btn-warning" style="padding-top:10px;" href="{{ route('admin.change.password') }}">
                                Change Password
                            </a>
                        </div>

                    </div>
                </form>
            </div>

        </div>

    </div>
</section>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>
<script>
$(document).ready(function(){
  $('#inputGroupFile01').on('change',function(){
      //get the file name
      var fileName = $(this).val();
      //replace the "Choose a file" label
      $(this).next('.custom-file-label').html(fileName);
  })
})

</script>
<script>
$(document).ready(function(){
  $('#inputGroupFile02').on('change',function(){
      //get the file name
      var fileName = $(this).val();
      //replace the "Choose a file" label
      $(this).next('.custom-file-label1').html(fileName);
  })
})

</script>
<script>
    var code = $('#country_code').val();

    var input = document.querySelector("#code");
    var iti = window.intlTelInput(input, {
        formatOnDisplay: true,
        initialCountry: code,
        autoPlaceholder: "off",
        separateDialCode: true,
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js",
    });
    input.addEventListener("countrychange", function() {
        console.log(iti.getSelectedCountryData());

        $('#country_code').val(iti.getSelectedCountryData().iso2);
        $('#dial_code').val(iti.getSelectedCountryData().dialCode);

    });
</script>
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyCyJ7Lirxe2ObjpsZbKTgeafLSA9bYSA0M&libraries=places"></script>
<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
    });
</script>

<script>
    google.maps.event.addDomListener(window, 'load', initialize);

    function initialize() {
        var input = document.getElementById('address');
        var autocomplete = new google.maps.places.Autocomplete(input);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            $('#latitude').val(place.geometry['location'].lat());
            $('#longitude').val(place.geometry['location'].lng());

            $("#latitudeArea").removeClass("d-none");
            $("#longtitudeArea").removeClass("d-none");
        });
    }
</script>




@endsection