@extends('layout.admin_layout')

@section('title', 'Change Password')

@section('body')
@section('header', 'Change Password')
@section('badge')
{{-- <li class="breadcrumb-item"><a href="{{ route('admin.cms') }}">cms</a></li> --}}
<li class="breadcrumb-item"><a href="{{ route('admin.changePassword') }}">Change Password</a></li>

@endsection
<a class="btn btn-info" href="{{ route('admin.manageProfile') }}">
  <i class="fa fa-arrow-left" aria-hidden="true"></i> Back to Profile
</a>
<section class="content">
  @if (session('error'))
  <div class="alert alert-danger">
    {{ session('error') }}
  </div>
  @endif
  @foreach ($errors->all() as $error)
  <div class="alert alert-danger">
    {{ $error }}
  </div>
  @endforeach
  @if (session('success'))
  <div class="alert alert-success">
    {{ session('success') }}
  </div>
  @endif
  <div class="container-fluid">

    <div class="card card-default">
      <div class="card-header">
        <h3 class="card-title">Password Change</h3>

        <div class="card-tools">
          <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
       
        </div>
      </div>

      <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.changePassword') }}">
          {{ csrf_field() }}
          <div class="row">
            <div class="col-md-6">

              <div class="input-group mb-3">

                <input type="password" name="current_password" class="@error('password') is-invalid @enderror form-control" placeholder="Current Password" id="current_password">
                <div class="input-group-append">
                  <div class="input-group-text" onclick="showPassword()">
                    <span class="fas fa-eye" id="eye"></span>
                  </div>
                </div>
              </div>
              <div class="input-group mb-3">

                <input type="password" name="new_password" class="@error('password') is-invalid @enderror form-control" placeholder="New Password" id="new_password">
                <div class="input-group-append">
                  <div class="input-group-text" onclick="showPasswordN()">
                    <span class="fas fa-eye" id="eye1"></span>
                  </div>
                </div>
              </div>
              <div class="input-group mb-3">

                <input type="password" name="new_password_confirmation" class="@error('password') is-invalid @enderror form-control" placeholder="New Password Confirmation" id="new_password_confirmation">
                <div class="input-group-append">
                  <div class="input-group-text" onclick="showPasswordC()">
                    <span class="fas fa-eye" id="eye2"></span>
                  </div>
                </div>
              </div>

              <button type="submit" class="btn btn-primary">
                Change Password 
              </button>
            </div>

          </div>
        </form>
      </div>

    </div>

  </div>
</section>

<script type="text/javascript">
  function showPassword() {
    var x = document.getElementById("current_password");
    if (x.type === "password") {
      x.type = "text";
      $("#eye").removeClass('fa fa-eye');
      $("#eye").addClass('fa fa-eye-slash');
    } else {
      x.type = "password";
      $("#eye").removeClass('fa fa-eye-slash');
      $("#eye").addClass('fa fa-eye');
    }
  }

  function showPasswordN() {
    var x = document.getElementById("new_password");
    if (x.type === "password") {
      x.type = "text";
      $("#eye1").removeClass('fa fa-eye');
      $("#eye1").addClass('fa fa-eye-slash');
    } else {
      x.type = "password";
      $("#eye1").removeClass('fa fa-eye-slash');
      $("#eye1").addClass('fa fa-eye');
    }
  }

  function showPasswordC() {
    var x = document.getElementById("new_password_confirmation");
    if (x.type === "password") {
      x.type = "text";
      $("#eye2").removeClass('fa fa-eye');
      $("#eye2").addClass('fa fa-eye-slash');
    } else {
      x.type = "password";
      $("#eye2").removeClass('fa fa-eye-slash');
      $("#eye2").addClass('fa fa-eye');
    }
  }
</script>

@endsection