@extends('layout.admin_layout')

@section('title', 'Appointment Details')

@section('body')

@section('header', 'Appointment Details')
@section('badge')

<li class="breadcrumb-item"><a href="{{ route('admin.appointment') }}">Appointment Details</a></li>
@endsection


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.route.store') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">




                <!--p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Specialization:</span>
                    {{$appointment->specialization->name}}

                 
                    </p-->
                <div class="form-group row">
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Appointment Date & Time:</span>
                        <?php
                        $start_time = date('h:i a', strtotime(get_change_utc_to_timezone($appointment->slot_start, 'America/New_York')));

                        $end_time = date('h:i a', strtotime(get_change_utc_to_timezone($appointment->slot_end, 'America/New_York')));
                        ?>



                        {{date("m-d-Y",strtotime($appointment->date))}} ({{$start_time}} to {{$end_time}})
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Doctor Name:</span>
                        Dr. {{$appointment->doctor->last_name}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Patient Name:</span>
                        {{$appointment->patient->name}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Consult:</span>
                        {{$appointment->consultation_type}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Appointment Fees:</span>
                        $ {{$appointment->fee}}

                    </p>






                </div>

                <div class="form-group row">

                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>


                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection