@extends('layout.admin_layout')

@section('title', 'Manage Appointments')

@section('body')
@section('header', 'Manage Appointments')
@section('badge')

@endsection



<div class="card card-primary card-outline">

    @if(Session::has('message'))
    <div class="alert alert-danger">
        {{ Session::get('message') }}
    </div>
    @endif
    <div class="row">


        <div class="card-tools col-md-8">
            <form method="GET">
                <div class="input-group input-group-sm">
                    <input type="text" name="from_date" id="from_date" class="form-control m-1"  max="2050-12-31" @if(isset($_GET['from_date'])) value="<?php echo date('m/d/Y',strtotime($_GET['from_date'])) ?>" @else value="<?php echo date('m/d/Y');?>" @endif required>
                    <span style="padding-top:5px;"> to </span>
                    <input type="text" name="to_date" id="to_date" class="form-control m-1" max="2050-12-31" @if(isset($_GET['to_date'])) value="<?php echo date('m/d/Y',strtotime($_GET['to_date'])) ?>" @else value="<?php echo date('m/d/Y');?>" @endif required>
                    <select class="form-control m-1" name="spl_id" id="spl_id">

                        <option value="">Select Specialization</option>
                        @foreach($services as $key=>$s)
                        <option value="{{$s->id}}" @if(isset($_GET['spl_id']) && $_GET['spl_id']==$s->id) selected @endif>{{$s->name}}</option>

                        @endforeach
                    </select>
                    <select class="form-control m-1" name="con_type" id="con_type">

                        <option value="">Select Consultation </option>
                        <option value="Video" @if(isset($_GET['con_type']) && $_GET['con_type']=='Video' ) selected @endif>Video</option>
                        <option value="Audio" @if(isset($_GET['con_type']) && $_GET['con_type']=='Audio' ) selected @endif>Audio</option>
                        <option value="Chat" @if(isset($_GET['con_type']) && $_GET['con_type']=='Chat' ) selected @endif>Chat</option>
                    </select>



                    <div class="input-group-append">
                        <button class="btn btn-primary" id="search"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </div>
                </div>
            </form>

        </div>

    </div>

    <br>

    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>DateTime</th>
                        <th>Doctor</th>
                        <th>Patient</th>


                        <th>Consult</th>
                        <th>Payment Status</th>
                        <th>Prescription Status</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;
                    ?>
                    @foreach($appointments as $key=>$u_d)
                    <tr>

                        <td>


                            {{$i++}}

                        </td>
                        <?php
                        $start_time = date('h:i a', strtotime(get_change_utc_to_timezone($u_d->slot_start, 'America/New_York')));

                        $end_time = date('h:i a', strtotime(get_change_utc_to_timezone($u_d->slot_end, 'America/New_York')));
                        ?>

                        <td>{{date("m-d-Y",strtotime($u_d->date))}} ({{$start_time}} to {{$end_time}})</td>
                        <td>Dr. {{$u_d->doctor->last_name}}</td>
                        <td>{{$u_d->patient->name}}</td>

                        <td>{{$u_d->consultation_type}}</td>

                        @if($u_d->payment_status == 1)
                        <td><span class="badge bg-success" style="padding:5px;color:white;">Success</span></td>
                        @elseif($u_d->payment_status == 2)
                        <td><span class="badge bg-danger" style="padding:5px;color:white;">Failed</span></td>
                        @elseif($u_d->payment_status == 3)
                        <td><span class="badge bg-info" style="padding:5px;color:white;">Free</span></td>

                        @else
                        <td><span class="badge bg-warning" style="padding:5px;color:white;">Pending</span></td>
                        @endif


                        @if($u_d->status == 1)
                        <td><span class="badge bg-warning" style="padding:5px;color:white;">Pending</span></td>
                        @elseif($u_d->status == 2)
                        <td><span class="badge bg-success" style="padding:5px;color:white;">Done</span></td>
                        @else
                        <td><span class="badge bg-danger" style="padding:5px;color:white;">Cancelled</span></td>
                        @endif
                        <td>
                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/appointment/view') }}/{{$u_d->id}}"> <i class="fas fa-eye"></i></a>


                        </td>
                    </tr>
                    @endforeach





                </tbody>



            </table>

        </div>
    </div>



</div>

<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  

  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

@endsection
@push('scripts')
<script>
  $( function() {
    $( "#from_date" ).datepicker();
  } );
  
  $( function() {
    $( "#to_date" ).datepicker();
  } );






  </script>
<script>
    $('#search').click(function(e) {
        e.preventDefault();
        var from_date = $('#from_date').val();
        const myArray = from_date.split("/");
        var to_date = $('#to_date').val();
        const myArray1 = to_date.split("/");
        var spl_id = $('#spl_id').val();
        var con_type = $('#con_type').val();

        $.ajax({
            url: "{{route('admin.appointment')}}",
            type: 'GET',
            data: {
                from_date:  myArray[2] +'-'+myArray[0] +'-'+myArray[1],
                to_date: myArray1[2] +'-'+myArray1[0] +'-'+myArray1[1],
                spl_id: spl_id,
                con_type: con_type
            },
            success: function(data) {
                location.replace('?from_date=' + myArray[2] +'-'+myArray[0] +'-'+myArray[1] +'&' + 'to_date=' + myArray1[2] +'-'+myArray1[0] +'-'+myArray1[1] + '&spl_id=' + spl_id + '&con_type=' + con_type);

            }
        });


    });
</script>

@endpush