<?php

use App\Members;
use App\Models\BookTimeSlot;
use App\Models\DoctorReview;
use App\Models\FavouritePub;
use App\Models\SiteSetting;
use App\Models\TimeSlot;
use App\Models\ThumbsUp;
use App\Models\Category;
use App\Models\BusinessCategory;
use App\Models\VendorSubscription;
use App\Models\ContactUsCms;
use App\Models\Cms;
use App\Models\User;
use App\Models\Gallery;
use App\Models\FoodMedia;
use App\Models\Appointment;
// use App\Models\FoodMedia;


function dateDifferent($date1, $date2)
{
  $date1 = $date1 ? $date1 : date('Y-m-d H:i:s');
  $date2 = $date2 ? $date2 : date('Y-m-d H:i:s');
  $date1 = strtotime($date1);
  $date2 = strtotime($date2);

  $diff = abs($date2 - $date1);

  $years = floor($diff / (365 * 60 * 60 * 24));

  $months = floor(($diff - $years * 365 * 60 * 60 * 24)
    / (30 * 60 * 60 * 24));

  $days = floor(($diff - $years * 365 * 60 * 60 * 24 -
    $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));

  $hours = floor(($diff - $years * 365 * 60 * 60 * 24
    - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24)
    / (60 * 60));

  $minutes = floor(($diff - $years * 365 * 60 * 60 * 24
    - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24
    - $hours * 60 * 60) / 60);

  $seconds = floor(($diff - $years * 365 * 60 * 60 * 24
    - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24
    - $hours * 60 * 60 - $minutes * 60));

  // return $time = ("%d years, %d months, %d days, %d hours, "
  //      . "%d minutes, %d seconds", $years, $months,
  //              $days, $hours, $minutes, $seconds);

  $time = '';
  if ($years > 0) {
    $time .= ($years > 1) ? $years . "years " : $years . "year ";
    return $time;
  }

  if ($months > 0) {
    $time .= ($months > 1) ? $months . "months " : $months . "month ";
    return $time;
  }

  if ($days > 0) {
    // $time .= ($days > 1) ? "$days days ": "$days day ";
    $time .= $days . "d ";
    return $time;
  }

  if ($hours > 0) {
    // $time .= ($hours > 1) ? "$hours hours ": "$hours hour ";
    $time .= $hours . "h ";
    return $time;
  }

  if ($minutes > 0) {
    // $time .= ($minutes > 1) ? "$minutes minutes ": "$minutes minute ";
    $time .=  $minutes . "m ";
  } else {
    $time .=  '0m';
    return $time;
  }

  return $time;
}




function getUserDetails($id)
{
  $member = User::find($id);
  return $member ? $member : false;
}

function getSetting($key)
{
  $setting = SiteSetting::where('key', $key)->first();
  return $setting ? $setting->value : '';
}



// function getLocaltime($){
//              $dt = new \DateTime();
//              $ts = strtotime($dt);
//              GMT+0530
//              $tz = new \DateTimeZone('Asia/Kolkata');
//              $dt->setTimezone($tz);
//              $ping->poll_time = $dt->format('Y-m-d H:i:s');
// }

function getFavDoc($pub_id)
{
  $fav_doc = FavouritePub::where('user_id', auth()->user()->id)->where('favourite_user_id', $pub_id)->where('status', 1)->first();
  // dd($fav_doc);
  return $fav_doc ? true : false;
}

function getChild()
{
  if (!empty(Session::get('parent_id'))) {
    $childs = User::find(Session::get('parent_id'));
    // print_r($childs); exit;
    // echo 'g'; exit;
    $childs = $childs->childs;
  } else {
    $childs = Auth::guard('sitePatient')->user()->childs;
  }
  // print_r($childs); exit;
  return $childs;
}

function getReview($doctor_id)
{
  $user = User::withCount('doctorReview')->find($doctor_id);
  $get_review = DoctorReview::where('doctor_id', $doctor_id)->sum('rating');
  $review = 0;
  if ($user->doctor_review_count > 0) {
    $review = round(($get_review / $user->doctor_review_count));
  }

  if ($review == 5) {
    return '<i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i>';
  } elseif ($review == 4) {
    return '<i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star"></i>';
  } elseif ($review == 3) {
    return '<i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>';
  }

  if ($review == 2) {
    return '<i class="fas fa-star reting"></i><i class="fas fa-star reting"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>';
  } elseif ($review == 1) {
    return '<i class="fas fa-star reting"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>';
  } else {
    return '<i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>';
  }
}


function getNearestSlot($doctor_id)
{
  $user = User::find($doctor_id);
  $booked_slot = BookTimeSlot::select('time_slot_id')->get()->toArray();
  $nearest_day = TimeSlot::select('*')->where('user_id', $doctor_id)->whereHas('availableDays', function ($query) {
    $query->where('date', '>=', date('Y-m-d'));
  })->whereDoesntHave('bookedSlot', function ($query) use ($booked_slot) {
    $query->whereIn('time_slot_id', $booked_slot);
  })->first();

  return $nearest_day;
}

function getThumbsUp($created_by)
{
  $thumbsup =  ThumbsUp::where('created_by', $created_by)->count();
  if ($thumbsup) {
    $axd = (int)$asd = $thumbsup / 12;
    if ($axd > 5) {
      return 5;
    }
    return $axd;
  }
  return $thumbsup;
}

function getDiffOfTwoDateInMinute($date1)
{
  // $time = new DateTime();
  // $diff = $time->diff(new DateTime($date1));
  // return $minutes = ($diff->days * 24 * 60) +
  //            ($diff->h * 60) + $diff->i;
  return (strtotime($date1) - time()) / 60;
}

function findOutBSTStartEndDate($year)
{
  // $year = Date('Y');
  $start_date = date('Y-m-d 01:00:00', strtotime('last sunday of March ' . $year));
  $end_date = date('Y-m-d 02:00:00', strtotime('last sunday of October ' . $year));
  return [$start_date, $end_date];
}

function timezoneAdjustmentFetch($timezone, $date, $time)
{
  $year = date('Y', strtotime($date));
  $dateTime = $date . ' ' . $time;
  // dd($dateTime);
  $start_date = date('Y-m-d 01:00:00', strtotime('last sunday of March ' . $year));
  $end_date = date('Y-m-d 01:00:00', strtotime('last sunday of October ' . $year));
  // dd($dateTime, $start_date, strtotime($dateTime) - strtotime($start_date));
  // $date1=date_create("2013-03-15");
  // $date2=date_create("2013-12-12");
  // $diff=date_diff($date1,$date2);
  // echo $diff->format("%R%a");&& $date > $end_date)
  if ((strtotime($start_date) <= strtotime($dateTime)) && (strtotime($dateTime) <  strtotime($end_date))) {
    $timestamp = strtotime($time) + 60 * 60;

    return date('H:i', $timestamp);
  } else {
    return $time;
  }
  // switch ($timezone) {
  //     case "GMT":
  //         return $dateTime;
  //       break;
  //     case "BST":
  //         return Carbon::parse($dateTime)->addHour();
  //       break;
  //     default:
  //     return $dateTime;
  // }
}

function timezoneAdjustmentStore($timezone, $dateTime)
{
  $year = date('Y', strtotime($dateTime));
  $start_date = date('Y-m-d 01:00:00', strtotime('last sunday of March ' . $year));
  $end_date = date('Y-m-d 02:00:00', strtotime('last sunday of October ' . $year));
  if ($start_date <= $dateTime && $dateTime > $end_date) {
    return Carbon::parse($dateTime)->subHour();
  } else {
    return $dateTime;
  }
  // switch ($timezone) {
  //     case "GMT":
  //         return $dateTime;
  //       break;
  //     case "BST":
  //         return Carbon::parse($dateTime)->subHour();
  //       break;
  //     default:
  //     return $dateTime;
  // }
}

function categoryList()
{
  return Category::select('name', 'id')->orderBy('name')->get();
}

function buisnessCategoryList()
{
  return BusinessCategory::select('name', 'id')->where('status', 1)->orderBy('name')->get();
}

function buisnessCategoryListArray()
{
  return BusinessCategory::select('name', 'id')->where('status', 1)->pluck('name', 'id');
}

function pubList()
{
  return User::select('name', 'id')->where('role', 2)->where('status', 1)->orderBy('name')->get();
}

function subscribtionDays($value)
{
  switch ($value) {
    case '1 M':
      return '1 Month ( 30 days )';
      break;

    case '2 M':
      return '2 Month ( 60 days )';

      break;
    case '3 M':
      return '3 Month ( 90 days )';

      break;
    case '6 M':
      return '6 Month ( 180 days )';

      break;
    case '12 M':
      return '1 Year ( 360 days )';

      break;
  }
}

function getContactUsdata()
{
  return ContactUsCms::find(1);
}

function getAboutUsdata()
{
  $about = Cms::find(6);
  $string = $about->banner_content;
  if (strlen($string) > 100) {

    // truncate string
    $stringCut = substr($string, 0, 100);
    $endPoint = strrpos($stringCut, ' ');

    //if the string doesn't contain any space then it will cut without word basis.
    $string = $endPoint ? substr($stringCut, 0, $endPoint) : substr($stringCut, 0);
    // $string .= '... <a href="/this/story">Read More</a>';
  }
  return $string;
}

function checkSize($pub_id)
{
  $date = date('Y-m-d');
  $data['vendor_space'] = $vendor_space = VendorSubscription::select(DB::raw('COUNT(*) AS count'), DB::raw('SUM(space) AS sum'), DB::raw('SUM(video_count) AS total_video'))->where('pub_id', $pub_id)->where('subscription_end', '>=', $date)->get();
  // dd($vendor_space);
  if ($vendor_space[0]->count == 0) {
    return $data;
  }
  $vender_used_space_gallery = FoodMedia::where('pub_id', $pub_id)->sum('media_size'); //image and video gallery space
  $vender_video_count_gallery = FoodMedia::where('pub_id', $pub_id)->where('file_status', 2)->count(); //image and video gallery space
  // $vender_used_space_food = FoodMedia::where('pub_id',$pub_id)->sum('media_size');//food media space
  $data['vender_used_space'] = $vender_used_space_gallery;
  $data['vender_video_count'] = $vender_video_count_gallery;
  return $data;
}

function convertPrice($price, $data, $currency)
{
  switch ($currency) {
    case 'usd':
      return $price;
      break;
    case 'gbp':
      return round(($price * $data->gbp), 2);
      break;
    case 'chf':
      return round(($price * $data->chf), 2);
      break;
    case 'eur':
      return round(($price * $data->eur), 2);
      break;
    default:
      return $price;
  }
}

function priceSymbol($currency)
{
  switch ($currency) {
    case 'usd':
      return '$';
      break;
    case 'gbp':
      return '<i class="bi bi-currency-pound"></i>';
      break;
    case 'chf':
      return 'CHF';
      break;
    case 'eur':
      return '<i class="bi bi-currency-euro"></i>';
      break;
    default:
      return '$';
  }
}
function doctors_speciality($id)
{
  $doc_spl = User::where('id', $id)->first();
  $spclity  = DB::table('services')->whereIn('id', explode(',', $doc_spl->specility_id))->get();
  $u = json_decode(json_encode($spclity), true);
  $_add_on = array_column($u, 'name');
  if (count($_add_on) == 3) {
    return $_add_on[0] . ', ' . $_add_on[1] . ', ' . $_add_on[2];
  } else if (count($_add_on) == 1) {
    return $_add_on[0];
  } else if (count($_add_on) == 2) {
    return $_add_on[0] . ', ' . $_add_on[1];
  } else if (count($_add_on) > 3) {
    return $_add_on[0] . ', ' . $_add_on[1] . ', ' . $_add_on[2];
  } else {
  }
}
function doctors_speciality_count($id)
{
  $doc_spl = User::where('id', $id)->first();
  $spclity  = DB::table('services')->whereIn('id', explode(',', $doc_spl->specility_id))->get();
  $u = json_decode(json_encode($spclity), true);
  $_add_on = array_column($u, 'name');

  return count($_add_on);
}



function doctors_speciality_m($id)
{
  $doc_spl = User::where('id', $id)->first();
  $spclity  = DB::table('services')->whereIn('id', explode(',', $doc_spl->specility_id))->get();
  $u = json_decode(json_encode($spclity), true);
  $_add_on = array_column($u, 'name');


  return implode(', ', $_add_on);
}
function doctors_speciality_n($id)
{
  $doc_spl = User::where('id', $id)->first();
  $spclity  = DB::table('services')->whereIn('id', explode(',', $doc_spl->specility_id))->get();


  return  $spclity;
}


function chk_permission($user_id, $menu_name)
{
  if ($user_id == 1) {
    return 1;
  } else {
    $data = DB::table('user_permission')->where('user_id', $user_id)->where('permissions', $menu_name)->first();
    if (empty($data)) {
      return 0;
    } else {
      return 1;
    }
  }
}
function doctors_speciality_ns($id)
{
  $doc_spl = User::where('id', $id)->first();
  $spl = DB::table('services')->whereNotIn('id', explode(',', $doc_spl->specility_id))->get();
  return  $spl;
}
function colors()
{
  $colors = DB::table('colors')->get();

  return  $colors;
}

function patient_allergy_ns($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('allergies')->whereNotIn('id', explode(',', $data->allergy_id))->get();
  return  $alr;
}
function patient_allergy($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('allergies')->whereIn('id', explode(',', $data->allergy_id))->get();
  return  $alr;
}
function patient_medical($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('medical_history')->whereIn('id', explode(',', $data->medical_id))->get();
  return  $alr;
}

function patient_surgery($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('surgeries')->whereIn('id', explode(',', $data->surgical_history_id))->get();
  return  $alr;
}
function patient_social_history($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('social_history')->whereIn('id', explode(',', $data->social_history_id))->get();
  return  $alr;
}
function patient_medication($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('medication')->whereIn('id', explode(',', $data->medication_id))->get();
  return  $alr;
}
function patient_lab($id)
{
  $data = User::where('id', $id)->first();
  $alr = DB::table('lab')->whereIn('id', explode(',', $data->lab_result))->get();
  return  $alr;
}
function avl_doc($id)
{
  $alr = DB::table('availability')->where('user_id', $id)->get();
  return  $alr;
}
function time_slot()
{

  $alr = DB::table('slot_time')->first();






  $qt = intval($alr->slot);

  $result_u = preg_replace("/[^a-zA-Z]+/", "", $alr->slot);
  if ($result_u == 'hr') {
    return   $qt * 60;
  } else {
    return   $qt;
  }
}







function getTimeSlot($interval, $start_time, $end_time)
{


  $start = new DateTime($start_time);
  $end = new DateTime($end_time);
  $startTime = $start->format('H:i');
  $endTime = $end->format('H:i');
  $y = date('H:i', strtotime('23:59'));
  $p = strtotime($y) - strtotime($endTime);
  if ($p < $interval * 60) {
    $time1 = strtotime($y) - ($interval * 60);
    $endTime = date("H:i", $time1);
  }

  $i = 0;
  $time = [];
  set_time_limit(0);
  while (strtotime($startTime) <= strtotime($endTime)) {
    $start = $startTime;
    $end = date('H:i', strtotime('+' . $interval . ' minutes', strtotime($startTime)));
    $startTime = date('H:i', strtotime('+' . $interval . ' minutes', strtotime($startTime)));
    $i++;

    if (strtotime($startTime) <= strtotime($endTime)) {

      $time[$i]['slot_start_time'] = $start;
      $time[$i]['slot_end_time'] = $end;
    }
  }


  return $time;
}
function getBookingDtl($doc_id, $start_time, $end_time, $date, $time_zone)
{

  // $start_time= date( 'h:i:s', strtotime($start_time));
  // $end_time =date( 'h:i:s', strtotime($end_time));

  $start_time = date('H:i:s', strtotime(get_change_timezone_to_utc($start_time, $time_zone)));




  $data = Appointment::with('patient')->where('status', '!=', 3)->where('payment_status', '!=', 2)->where('doctor_id', $doc_id)->where('slot_start', $start_time)->whereDate('date', $date)->first();

  if (!empty($data)) {
    return date('H:i', strtotime($data->slot_start)) . ' to ' . date('H:i', strtotime($data->slot_end));
  } else {
    return 0;
  }
}
function getBookingDtlP($doc_id, $start_time, $end_time, $date, $time_zone)
{
  // $start_time= date( 'h:i:s', strtotime($start_time));
  // $end_time =date( 'h:i:s', strtotime($end_time));
  $start_time = date('H:i:s', strtotime(get_change_timezone_to_utc($start_time, $time_zone)));
  $data = Appointment::with('patient')->where('doctor_id', $doc_id)->where('slot_start', $start_time)->whereDate('date', $date)->whereNotIn('patient_id', [0])->first();

  if (!empty($data)) {
    return $data->patient->name . '-' . $data->patient->id;
  } else {
    return 0;
  }
}
function getBookingDtlT($doc_id, $start_time, $end_time, $date)
{
  // $start_time= date( 'h:i:s', strtotime($start_time));
  // $end_time =date( 'h:i:s', strtotime($end_time));

  $data = Appointment::with('patient')->where('doctor_id', $doc_id)->where('slot_start', $start_time)->whereDate('date', $date)->first();

  if (!empty($data)) {
    return $data->consultation_type;
  } else {
    return 0;
  }
}
function getBookingDtlS($doc_id, $start_time, $end_time, $date)
{
  // $start_time= date( 'h:i:s', strtotime($start_time));
  // $end_time =date( 'h:i:s', strtotime($end_time));

  $data = Appointment::with('specialization')->where('doctor_id', $doc_id)->where('slot_start', $start_time)->whereDate('date', $date)->first();

  if (!empty($data)) {
    return $data->specialization->name;
  } else {
    return 0;
  }
}
function next_value($current)
{
  $letter = $current[0];
  $number = (int) substr($current, 1);

  if ($number == 9999) {
    $letter++;
    $number = 1;
  } else {
    $number++;
  }

  return $letter . str_pad($number, 4, '0', STR_PAD_LEFT);
}
function avg_rating($doctor_id)
{
  $data = DB::table('rating')->where('doctor_id', $doctor_id)->get();
  $i = 0;
  if (count($data) > 0) {
    $i = 0;
    foreach ($data as $row) {
      $i = $i + $row->rating;
    }
    return  round($i / count($data), 1);
  }
}
function rating_count($doctor_id)
{
  $data = DB::table('rating')->where('doctor_id', $doctor_id)->distinct('patient_id')->count();
  return $data;
}
function getName($n)
{
  $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  $randomString = '';

  for ($i = 0; $i < $n; $i++) {
    $index = rand(0, strlen($characters) - 1);
    $randomString .= $characters[$index];
  }

  return $randomString;
}
function patient_count($id)
{
  $data = DB::table('appointments')->where('doctor_id', $id)->distinct()->count('patient_id');
  return $data;
}
function review_count($id)
{
  $data = DB::table('rating')->where('doctor_id', $id)->where('complain', null)->count('doctor_id');
  return $data;
}
function getDatesFromRange($start, $end, $format = 'Y-m-d')
{
  $array = array();
  $interval = new DateInterval('P1D');

  $realEnd = new DateTime($end);
  $realEnd->add($interval);

  $period = new DatePeriod(new DateTime($start), $interval, $realEnd);

  foreach ($period as $date) {
    $array[] = $date->format($format);
  }

  return $array;
}
function getTimeSlot_c($interval, $start_time, $end_time, $time_zone)
{


  $start = new DateTime(get_change_utc_to_timezone(date('h:i a', strtotime($start_time)), $time_zone));
  $end = new DateTime(get_change_utc_to_timezone(date('h:i a', strtotime($end_time)), $time_zone));
  $startTime = $start->format('H:i');
  $endTime = $end->format('H:i');
  $y = date('H:i', strtotime('23:59'));
  $p = strtotime($y) - strtotime($endTime);
  if ($p < $interval * 60) {
    $time1 = strtotime($y) - ($interval * 60);
    $endTime = date("H:i", $time1);
  }
  $i = 0;
  $time = [];
  set_time_limit(0);
  while (strtotime($startTime) <= strtotime($endTime)) {
    $start = $startTime;
    $end = date('H:i', strtotime('+' . $interval . ' minutes', strtotime($startTime)));
    $startTime = date('H:i', strtotime('+' . $interval . ' minutes', strtotime($startTime)));
    $i++;
    if (strtotime($startTime) <= strtotime($endTime)) {
      $time[$i]['slot_start_time'] = $start;
      $time[$i]['slot_end_time'] = $end;
    }
  }
  return count($time);
}
function getAvailability($doctor_id, $time_zone)
{
  $data = DB::table('availability')->where('user_id', $doctor_id)->where('date', '>=', date('Y-m-d'))->get();
  $i = 0;
  foreach ($data as $row) {
    $duration = time_slot();

    $slots = getTimeSlot_c($duration, $row->start_time, $row->end_time, $time_zone);
    $i = $i + $slots;
  }
  $apt = DB::table('appointments')->where('doctor_id', $doctor_id)->whereDate('date', '>=', date('Y-m-d'))->get();

  $p = count($apt);

  return $i - $p;
}
function getAvailability_c($doctor_id, $timezone)
{
  date_default_timezone_set('UTC');



  $t = date('H:i:s', time());


  $data = DB::table('availability')->where('user_id', $doctor_id)->where('date', '=', date('Y-m-d'))->get();
  $i = 0;
  foreach ($data as $row) {
    $duration = time_slot();

    $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->start_time, $timezone)));

    $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->end_time, $timezone)));

    $slots = getTimeSlot($duration, $start_time, $end_time, $timezone);
    $i = $i + count($slots);
  }
  $apt = DB::table('appointments')->where('doctor_id', $doctor_id)->whereDate('date', '=', date('Y-m-d'))->get();

  $p = count($apt);

  return $i;
}


function getAvailability_o($doctor_id)
{
  $data = DB::table('availability')->where('user_id', $doctor_id)->where('date', '>', date('Y-m-d'))->get();
  $i = 0;
  foreach ($data as $row) {
    $duration = time_slot();

    $slots = getTimeSlot_c($duration, $row->start_time, $row->end_time, 'Asia/Kolkata');
    $i = $i + $slots;
  }
  $apt = DB::table('appointments')->where('doctor_id', $doctor_id)->whereDate('date', '=', date('Y-m-d'))->get();

  $p = count($apt);

  return  $p - $i;
}
function chkOrder($id)
{

  $o = DB::table('order')->where('booking_id', $id)->first();

  if (empty($o)) {
    return 0;
  } else {
    return $o->order_path;
  }
}
function get_treatments($id)
{

  $o = DB::table('services')->where('id', $id)->first();
  $data = DB::table('treatments')->whereIn('id', explode(',', $o->trt_id))->get();
  $d = json_decode(json_encode($data), true);
  $_add_on = array_column($d, 'treatments');
  $t = implode(',', $_add_on);
  return $t;
}
function slot_aval_for_doctor($date, $user_id, $timezone)
{


  $tip = DB::table('availability')->where('date', date('Y/m/d', strtotime($date)))->where('user_id', $user_id)->get();


  $data1 = [];
  foreach ($tip as $val) {

    $val->start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($val->start_time, $timezone)));

    $val->end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($val->end_time, $timezone)));
    array_push($data1, $val);
  }

  $names = array();

  foreach ($data1 as $key => $val) {

    $names[$key] = $val->start_time;
  }


  array_multisort($names, SORT_ASC, $data1);


  $u = [];

  foreach ($data1  as $row) {
    $duration = time_slot();

    $start_time = $row->start_time;

    $end_time = $row->end_time;


    $slots = getTimeSlot($duration, $start_time, $end_time, $timezone);


    $data1 = [];

    foreach ($slots  as $row1) {


      $t = getBookingDtl($user_id, date('h:i a', strtotime($row1['slot_start_time'])), date('h:i a', strtotime($row1['slot_end_time'])), date('Y-m-d'), $timezone);


      $row1['slot_end_time'] = date('H:i', strtotime($row1['slot_end_time']));



      $date = new DateTime('now', new DateTimeZone($timezone));
      $t1 = $date->format('Y-m-d h:i a');

      $date2 = date('Y-m-d');
      $start_time = date('h:i a', strtotime($row1['slot_start_time']));

      // $start_time = date('h:i a', strtotime($row1['slot_start_time']));
      $p1 = $date2 . ' ' . $start_time;
      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

      $result_in_seconds = $to->diffInSeconds($from, false);
      if ($result_in_seconds > 0) {
        if ($t !== 0) {

          $pt = explode('to', $t);
          $row1['slot_start_time'] = $pt[0];
          $row1['slot_end_time'] = $pt[1];

          $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));

          $row1['slot_end_time'] =  date('h:i a',  strtotime($row1['slot_end_time']));
          $row1['status'] = "Booked";
        } else {

          $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));

          $row1['slot_end_time'] =  date('h:i a',  strtotime($row1['slot_end_time']));
          $row1['status'] = "Available";
          $row1['patient_name'] = 'NA';
          $row1['type'] = str_replace(',', ', ', $row->type);
          array_push($data1, $row1);
        }
      } else {
      }
    }

    array_push($u, $data1);
  }

  $p = array_filter($u);
  $akf = array_key_first($p);

  if (is_null($akf)) {
    return empty($p) ? $p : $p[0][0];
  } else {
    return $p[$akf][0];
  }
  //return is_null($akf) == true ? $p[0][0] : $p[$akf][0];
  //return empty($p) ? $p : $p[0][0] ;
  // print_r(array_filter($u,"test_odd"));

  // if (empty($u[0])) {
  //   array_shift($u);

  //   return $u[0][0];
  // }
  // else{
  //  return $u[0][0];
  // }
}


function get_types()
{
  $data = DB::table('type')->orderBy('order', 'asc')->where('status', 1)->get();

  return $data;
}

function problems()
{

  $data = DB::table('problems')->where('status', 1)->get();

  return $data;
}
function get_type_question($id)
{
  $data = DB::table('type')->where('id', $id)->first();
  if($data)
  {
    return $data->type;
  }
  else{
    return " ";
  }

  
}
function get_type($id)
{
  $data = DB::table('type')->where('pro_id', $id)->get();

  return $data;
}

function list_of_non_registered_patient($color_code)
{
  $data = DB::table('quick_visit')->where('color_code', $color_code)->get();

  return $data;
}

function user_name($id)
{
  $data = User::where('id', $id)->first();

  return $data->name;
}
function med($med)
{

  $data = DB::table('doc_medicine')->whereIn('id', explode(',', $med))->get();

  return $data;
}

function med_e($med)
{

  $data = DB::table('medication')->whereNotIn('id', explode(',', $med))->get();

  return $data;
}
function rand_color()
{
  return sprintf('#%06X', mt_rand(0, 0xFFFFFF));
}

function  g_commission()
{
  $data = DB::table('global_commission')->orderBy('id','DESC')->first();
  if ($data) {
    return $data->percentage;
  } else {
    return 0;
  }
}



function get_change_utc_to_timezone($time, $time_zone)
{

  date_default_timezone_set('UTC');
  $new_date = new DateTime($time);
  $new_date->setTimeZone(new DateTimeZone($time_zone));
  return $new_date->format("h:i a");
}


function get_change_utc_to_timezone_c()
{
  $time = '01:00 pm';
  $time_zone = "Asia/Kolkata";
  date_default_timezone_set('UTC');
  $new_date = new DateTime($time);
  $new_date->setTimeZone(new DateTimeZone($time_zone));
  return $new_date->format("h:i a");
}



function get_change_timezone_to_utc($time, $time_zone)
{

  date_default_timezone_set($time_zone);
  $new_date = new DateTime($time);
  $new_date->setTimeZone(new DateTimeZone('UTC'));
  $time_u = $new_date->format("H:i");


  return $time_u;
}

function total_earning($id)
{
  $data = DB::table('appointments')->where('doctor_id',$id)->sum('doctor_fee');
  return $data;
}
