<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\User;
use Laravel\Sanctum\PersonalAccessToken;

class DoctorMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
            return response()->json([
                'error' => "Authentication token missing"
            ], 403);
        }
       
        $authToken = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        if (strpos($authToken, '|') === false) {
            $hashedToken = hash('sha256', $authToken);
        } else {
            [$id, $authToken] = explode('|', $authToken, 2);
            $hashedToken = hash('sha256', $authToken);
        }
        $token = PersonalAccessToken::where('token', $hashedToken)->first();
     

        if (!$token) {
            return response()->json([
                'error' => "Invalid authentication token",
            ], 403);
        }
        $user = User::where('id', $token->tokenable_id)->first();

        if (!$user) {
            return response()->json([
                'error' => "Invalid authentication token"
            ], 403);
        }
        // $roleTitle = $user->roles()->first()->title;
        // if ($roleTitle !== "Captain") {
        //     return response()->json([
        //         'error' => "You're not authorized"
        //     ], 403);
        // }

        // // Merging the captain with request
        // $request->merge([
        //     'captain' => $user
        // ]);

        return $next($request);
    }
}
