<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Hash;
use Illuminate\Validation\ValidationException;
use Laravel\Sanctum\PersonalAccessToken;
use Mail;
use App\Models\ColorCode;
use DB;

class UserController extends Controller
{
  //
  public function register(Request $request)
  {

    $r = User::where('email', $request->email)->where('status', 0)->first();
    if ($r) {
      User::where('id', $r->id)->delete();
    }



    if (preg_match('/[\'^£$%&*()}{@#~?><>,|=_.+¬-]/', $request->name)) {
      return response()->json([
        'success' => 0,
        'message' => "Name field should not contain any special character",

      ], 200);
    }

    $p = User::where('email', $request->email)->first();
    if ($p) {
      return response()->json([
        'success' => 0,
        'message' => "Email has already been taken",

      ], 200);
    }


    if ($request->role_id == 1 || $request->role_id == 2) {
      $user =  new User;
      if ($request->role_id == 1) {
        $user->name = ucfirst($request->name);
        $user->last_name = ucfirst($request->last_name);
      } else {
        $user->name = ucfirst($request->name) . ' ' . ucfirst($request->last_name);
      }

      $user->email = $request->email;
      $user->role = $request->role_id;
      $user->password = Hash::make($request->password);
      $user->otp = rand(1111, 9999);
      $user->profile_image = '';
      $user->consultation_type = 1;
      $user->status = 0;
      $user->code = '+91';
      $user->country = 'IN';

      $user->save();
      $data = [
        'date' => date('m/d/Y'),
        'name' => $user->name,
        'site_name' => 'DoctorApp',
        'contact_no' => 860 - 710 - 3378,
        'recovery_code' =>  $user->otp,
        'site_address' => " ",
        'logo' => 'https://doctorapp.mydevfactory.com/doctorAPP/public/Images/logo/1692775625logo.png'
      ];
      $mailTo = $request->email;
      Mail::send('signup', $data, function ($message) use ($data, $mailTo) {
        $message->to($mailTo)
          ->subject('Doctor App OTP for Registration')
          ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
          ->setBody($data, 'text/html');
      });

      if ($request->role_id == 1) {
        return response()->json([
          'success' => 1,
          'message' => "Doctor registered successfully",
          'user_id' => $user->id
        ], 200);
      } else {
        return response()->json([
          'success' => 1,
          'message' => "Patient registered successfully",
          'user_id' => $user->id
        ], 200);
      }
    } else {
      return response()->json([
        'success' => 0,
        'message' => "Incorrect role Id",
      ], 400);
    }
  }
  public function login(Request $request)
  {
    $validation = Validator::make(
      $request->all(),
      [

        'email' => 'required',
        'password' => 'required'
      ],
      [
        'email.required' => 'Email field is required',
        'password.required' => 'Password is required',
      ]

    );
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $email = $request->email;


    $user = User::where('email', $email)
      ->where(function ($query) {
        $query->where('status', '=', 1)
          ->orWhere('status', '=', 3)
          ->orWhere('status', '=', 2)
          ->orWhere('status', '=', 4);
      })->first();

    if ($user) {
      if ($user->role == 1) {
        $role = "Doctor";
      } elseif ($user->role == 2) {
        $role = "Patient";
      } else {
        return response()->json([
          'error' => 'Please register as a doctor or as a patient'
        ], 403);
      }
    }


    if (!$user || !Hash::check($request->password, $user->password)) {
      return response()->json([
        'error' => 'Please check your credentials or ask admin to activate your account'
      ], 403);
    }

    if ($user->role == 1 || $user->role == 2) {
      $authToken = $user->createToken('DoctorApp')->plainTextToken;
      if (isset($request->fcm_token)) {
        User::where('email', $email)->update([
          "fcm_token" => $request->fcm_token
        ]);
      }

      return response()->json([
        'success' => 1,
        'auth_token' => $authToken,
        'name' =>  $user->name,
        'email' => $user->email,
        'user_id' => $user->id,
        'role' => $role
      ], 200);
    } else {
      return response()->json([
        'error' => 'Choose proper user type'
      ], 403);
    }
  }
  public function logout(Request $request)
  {

    $authToken = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    if (strpos($authToken, '|') === false) {
      $hashedToken = hash('sha256', $authToken);
    } else {
      [$id, $authToken] = explode('|', $authToken, 2);
      $hashedToken = hash('sha256', $authToken);
    }
    $token = PersonalAccessToken::where('token', $hashedToken)->delete();

    return response()->json([
      'success' => 1,
      'message' => "Token Deleted Successfully",

    ], 200);
  }
  public function otp_chk(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
      'otp' => 'required'

    ], [
      'otp.required' => 'OTP field is required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::where('id', $request->user_id)
      ->where('otp', $request->otp)
      ->first();

    if ($user) {


      // User::where('id', $request->user_id)

      //   ->update([

      //     'updated_at' => now()
      //   ]);

      //  $dateTimeObject1 = date_create($user->updated_at);
      //  $dateTimeObject2 = date_create($user->created_at);

      // Calculating the difference between DateTime Objects
      // $interval = date_diff($dateTimeObject1, $dateTimeObject2);



      // $min = $interval->days * 24 * 60;
      // $min += $interval->h * 60;
      //  $min += $interval->i;

      // Printing the Result in Minutes format.
      //echo ("Difference in minutes is: ");
      //echo $min . ' minutes';
      // if ($min > 10) {
      //   return response()->json([
      //     'success' => 1,
      //     'message' => "OTP Expired",

      //   ], 200);
      // } else {
      User::where('id', $request->user_id)

        ->update([

          'status' => 1
        ]);
      $user_e = DB::table('quick_visit')->where('email', $user->email)->first();
      if ($user_e) {
        DB::table('appointments')->where('patient_email', $user->email)->update([
          'patient_id' => $user->id
        ]);
      }





      return response()->json([
        'success' => 1,
        'message' => "Your OTP has verified & Account has been registered successfully.",

      ], 200);
    }
    // } 
    else {

      return response()->json([
        'success' => 0,
        'message' => "Invalid OTP",

      ], 200);
    }
  }
  public function forgot_password(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::where('email', $request->email)->first();
    if (!$user) {
      return response()->json([
        'error' => 'Email is not registered'
      ], 403);
    }


    $user = User::find($user->id);

    $user->forgot_otp = rand(1111, 9999);

    $user->save();


    $data = [
      'date' => date('m/d/Y'),
      'name' => $user->name,
      'site_name' => 'DoctorApp',
      'contact_no' => 860 - 710 - 3378,
      'recovery_code' =>  $user->forgot_otp,
      'site_address' => " ",
      'logo' => 'https://doctorapp.mydevfactory.com/doctorAPP/public/Images/logo/1692775625logo.png'
    ];

    $mailTo = $request->email;
    Mail::send('reset', $data, function ($message) use ($data, $mailTo) {
      $message->to($mailTo)
        ->subject('Doctor App OTP for Reset Password')
        ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
        ->setBody($data, 'text/html');
    });
    return response()->json([
      'success' => 1,
      'message' => "Check email and get OTP for reset password",

    ], 200);
  }
  public function forgot_password_otp(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'otp' => 'required',

    ], [
      'otp.required' => "OTP is Required"
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::where('forgot_otp', $request->otp)->first();
    if (!$user) {
      return response()->json([
        'error' => 'Incorrect OTP'
      ], 403);
    }
    return response()->json([
      'success' => 1,
      'message' => "OTP verified Redirect to reset password page",
      'user_id' => $user->id

    ], 200);
  }
  public function reset_password(Request $request)
  {
    $validation = Validator::make($request->all(), [


      'password' => [
        'required',
        'string',
        'min:8',             // must be at least 10 characters in length
        'regex:/[a-z]/',      // must contain at least one lowercase letter
        'regex:/[A-Z]/',      // must contain at least one uppercase letter
        'regex:/[0-9]/',      // must contain at least one digit
        'regex:/[@$!%*#?&]/', // must contain a special character
      ],

      'confirm_password' => 'required:password|same:password',
      'user_id' => 'required',
    ]);

    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'success' => 0,
        'errors' => $errors
      ], 403);
    }

    $user = User::find($request->user_id);

    if ((Hash::check($request->get('password'), $user->password))) {

      return response()->json([
        'success' => 0,
        'message' => "Please Choose Another Password . This is Your Current Password",
      ], 200);
    } else {
      $user->password = Hash::make($request->password);

      $user->save();
    }



    return response()->json([
      'success' => 1,
      'message' => "Pasword Reset Successfully",
    ], 200);
  }
  public function resend_otp(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::find($request->user_id);

    $user->otp = rand(1111, 9999);
    $user->created_at = now();
    $user->save();

    // $content = "<html>";

    // $content .= "<head>";
    // $content .= "<title>Doctor App</title>";
    // $content .= "</head>";

    // $content .= "<body>";
    // $content .= "<h5>OTP For Reset Password :</h5>";
    // $content .= "<p>" . $user->otp . "</p>";


    // $content .= "</body>";

    // $content .= "</html>";

    // $mailTo = $user->email;
    // Mail::send(array(), array(), function ($message) use ($content, $mailTo) {
    //   $message->to($mailTo)
    //     ->subject('Doctor App OTP for Reset Password')
    //     ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
    //     ->setBody($content, 'text/html');
    // });


    $data = [
      'date' => date('m/d/Y'),
      'name' => $user->name,
      'site_name' => 'DoctorApp',
      'contact_no' => "860 - 710 - 3378",
      'recovery_code' =>  $user->otp,
      'site_address' => " ",
      'logo' => 'https://doctorapp.mydevfactory.com/doctorAPP/public/Images/logo/1692775625logo.png'
    ];
    $mailTo = $user->email;
    Mail::send('resend', $data, function ($message) use ($data, $mailTo) {
      $message->to($mailTo)
        ->subject('Doctor App Resend OTP for Registration')
        ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
        ->setBody($data, 'text/html');
    });


    return response()->json([
      'success' => 1,
      'message' => "Check your email for new OTP",
    ], 200);
  }
  public function chk_email(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',

    ], [
      'email.required' => "Email is required"
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::where('email', $request->email)->first();
    if (!$user) {
      $otp = rand(1111, 9999);
      $user = DB::table('otp')->insert([
        "otp" => $otp,
        "email" => $request->email,
        "status" => 0
      ]);
      $content = "<html>";

      $content .= "<head>";
      $content .= "<title>Doctor App</title>";
      $content .= "</head>";

      $content .= "<body>";
      $content .= "<h5>OTP For Chatbot :</h5>";
      $content .= "<p>" . $otp . "</p>";


      $content .= "</body>";

      $content .= "</html>";

      $mailTo = $request->email;
      Mail::send(array(), array(), function ($message) use ($content, $mailTo) {
        $message->to($mailTo)
          ->subject('Doctor App OTP for Chat Bot')
          ->from("info@doctorapp.com", "DoctorApp")
          ->setBody($content, 'text/html');
      });
      return response()->json([
        'success' => 0,
        'message' => 'Not registered go to OTP Verification',
        'user_id' => 0
      ], 200);
    } else {
      if ($user->role == 2) {
        return response()->json([
          'success' => 1,
          'message' => "Please Sign in and go for quick visit",
          'email' => $user->name,
          'user_id' => $user->id


        ], 200);
      } else {
        return response()->json([
          'success' => 2,
          'message' => "Doctors Can't go for quickchat bot"

        ], 200);
      }
    }
  }
  public function chk_otp_cbot(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'otp' => 'required',

    ], [
      'otp.required' => "OTP is required"
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $otp = DB::table('otp')->where('otp', $request->otp)->first();
    if (!$otp) {
      return response()->json([
        'success' => 0,
        'message' => 'Invalid OTP'
      ], 200);
    } else {
      DB::table('otp')->where('otp', $request->otp)->update([

        "status" => 1
      ]);
      return response()->json([
        'success' => 1,
        'message' => "OTP Verified",
        'email' => $otp->email


      ], 200);
    }
  }
  public function change_password(Request $request)
  {
    if ($request->con_password != ' ') {
      $validation = Validator::make($request->all(), [

        'user_id' => 'required',
        'new_password' => [
          'required',
          'string',
          'min:8',             // must be at least 10 characters in length
          'regex:/[a-z]/',      // must contain at least one lowercase letter
          'regex:/[A-Z]/',      // must contain at least one uppercase letter
          'regex:/[0-9]/',      // must contain at least one digit
          'regex:/[@$!%*#?&]/', // must contain a special character
        ],


        'con_password' => 'same:new_password'
      ]);
      if ($validation->fails()) {
        $errors = $validation->errors();

        return response()->json([
          'success' => 0,
          'errors' => $errors
        ], 403);
      }
    } else {
      $validation = Validator::make($request->all(), [

        'user_id' => 'required',
        'new_password' => [
          'required',
          'string',
          'min:8',             // must be at least 10 characters in length
          'regex:/[a-z]/',      // must contain at least one lowercase letter
          'regex:/[A-Z]/',      // must contain at least one uppercase letter
          'regex:/[0-9]/',      // must contain at least one digit
          'regex:/[@$!%*#?&]/', // must contain a special character
        ],


        'con_password' => 'required'
      ]);
      if ($validation->fails()) {
        $errors = $validation->errors();

        return response()->json([
          'success' => 0,
          'errors' => $errors
        ], 403);
      }
    }
    $user = User::find($request->user_id);

    if ((Hash::check($request->get('new_password'), $user->password))) {

      return response()->json([
        'success' => 0,
        'message' => "Please Choose Another Password . This is Your Current Password",
      ], 200);
    } else {
      User::where('id', $request->user_id)->update([
        'password' => Hash::make($request->new_password)
      ]);
    }

    return response()->json([
      'success' => 1,
      'response' => "Your Password Changed Successfully"
    ], 200);
  }

  public function page_content(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'page_title' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'success' => 0,
        'errors' => $errors
      ], 403);
    }
    $data =  DB::table('cms')->where('title', $request->page_title)->first();

    // $data->description = strip_tags($data->description);

    $data->description = str_replace('&nbsp;', ' ', $data->description);

    $data->description = str_replace('&quot;', ' ', $data->description);

    $data->description = str_replace('amp;', ' ', $data->description);

    return response()->json([
      'success' => 1,
      'message' => "Page content",
      'response' => $data

    ], 200);
  }
  public function delete_account(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'success' => 0,
        'errors' => $errors
      ], 403);
    }
    $r=DB::table('users')->where('id', $request->user_id)->first();

    DB::table('account_details')->where('user_id', $request->user_id)->delete();

    if($r->role == 1)
    {
      $a = DB::table('appointments')->where('doctor_id', $request->user_id)->get();
      foreach($a as $row)
      {

        DB::table('prescription')->where('booking_id', $row->id)->delete();
        DB::table('order')->where('booking_id', $row->id)->delete();
        DB::table('doc_medicine')->where('booking_id', $row->id)->delete();

        

      }
      DB::table('availability')->where('user_id', $request->user_id)->delete();
      DB::table('rating')->where('doctor_id', $request->user_id)->delete();
      DB::table('withdrawl')->where('user_id', $request->user_id)->delete();
     

     DB::table('appointments')->where('doctor_id', $request->user_id)->delete();
     DB::table('users')->where('id', $request->user_id)->delete();
     return response()->json([
      'success' => 1,
      'message' => "Data deleted successfully.",
    ], 200);
    }
    else if($r->role == 2){
      $a = DB::table('appointments')->where('patient_id', $request->user_id)->get();
      foreach($a as $row)
      {

        DB::table('prescription')->where('booking_id', $row->id)->delete();
        DB::table('order')->where('booking_id', $row->id)->delete();
        DB::table('doc_medicine')->where('booking_id', $row->id)->delete();

        

      }
    
      DB::table('rating')->where('patient_id', $request->user_id)->delete();

   

     DB::table('appointments')->where('patient_id', $request->user_id)->delete();

     DB::table('users')->where('id', $request->user_id)->delete();

     return response()->json([
      'success' => 1,
      'message' => "Data deleted successfully.",
    ], 200);



    }else{
      return response()->json([
        'success' => 0,
        'message' => "No data to delete",
      ], 200);
    }
  }

}
