<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\User;
use App\Models\Appointment;
use App\Models\AccountDetails;

use DB;
use Illuminate\Support\Facades\Validator;
use DateTime;
use PDF;
use Illuminate\Support\Facades\URL;
use DateTimeZone;
use \Carbon\Carbon;
use Twilio\Rest\Client;
use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VideoGrant;
use Symfony\Component\HttpKernel\Exception\TooManyRequestsHttpException;

class SkillController extends Controller
{
    public function skills()
    {
        $data = Service::select('id', 'name', 'image')->get();
        $p = [];
        foreach ($data as $key => $row) {
            $i = 0;
            $c = User::where('role', 1)->where('status', 2)->get();



            foreach ($c as $r) {
                $t = explode(',', $r->specility_id);
                if (in_array($row->id, $t)) {
                    $i = $i + 1;
                }
            }
            $row->count = $i;
            if ($key % 2 == 0) {
                $row->color = '#2173A8';
            } else {
                $row->color = 'grey';
            }
        }

        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Skills/Specialization list",
                "response" =>  $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No active  skills/specialization",
                "response" =>  $data
            ], 200);
        }
    }


    public function profile_details_doctor(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = User::select('id', 'name', 'last_name', 'fax', 'npi', 'license', 'dea', 'email', 'profile_image', 'phone', 'dob', 'address', 'sex as gender', 'about', 'certificate_practice', 'reg_no_p as certificate_practice_reg_no', 'experience', 'lat', 'lang', 'code', 'country')->where('id', $request->user_id)->where('role', 1)->first();


        if ($data->profile_image != '') {
            $data->profile_image = URL::to('/') . '/' . $data->profile_image;
        } else {
            $data->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        }

        if ($data->certificate_practice != '') {
            $data->certificate_practice =  $data->certificate_practice;
        }

        if ($data->about == null) {
            $data->about =  ' ';
        }

        if ($data->dob != '') {


            $data->dob = date('m-d-Y', strtotime($data->dob));
        }


        $data->exp = intval($data->experience);

        $data->years = preg_replace('#[0-9 ]*#', '', $data->experience);
        $data->f_name = $data->name;



        $data->name = 'Dr. ' . ucfirst($data->last_name);
        if (is_null($data->code) == true) {
            $data->code = '+1';
        }
        if (is_null($data->address) == true) {
            $data->address = '';
        }
        if (is_null($data->fax) == true) {
            $data->fax = 0;
        }

        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Doctor details",
                "response" =>  $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data found",
                "response" =>  $data
            ], 200);
        }
    }
    public function profile_update_doctor(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'f_name' => 'required',
            'l_name' => 'required',
            'phone' => 'required',
            'location' => 'required',
            'gender' => 'required',
            'npi' => 'required',
            'license' => 'required',
            'dea' => 'required',
            'exp' => 'required',
            'duration' => 'required',
            'code' => 'required',
            'country' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        if ($request->dob > date('Y-m-d')) {
            return response()->json([
                'success' => 0,
                'message' => "Date of birth cant be grater than current date",

            ], 200);
        }

        $d = explode('-', $request->dob);

        $user = User::find($request->user_id);
        if ($request->hasFile('profile_image')) {
            $file_type = $request->file('profile_image')->extension();
            $file_path = $request->file('profile_image')->storeAs('images/doctors', 'certificate' . time() . '.' . $file_type, 'public');
            $request->file('profile_image')->move(public_path('images/doctors'), 'certificate' . time() . '.' . $file_type);
            $user->profile_image =  $file_path;
        }

        $user->name = ucfirst($request->f_name);
        $user->last_name = ucfirst($request->l_name);
        $user->phone = $request->phone;
        $user->address = $request->location;
        $user->sex = $request->gender;
        $user->dob = $d[2] . '-' . $d[0] . '-' . $d[1];
        $user->about = $request->about;
        $user->lat = $request->latitude;
        $user->lang = $request->longitude;
        $user->dea = $request->dea;
        $user->license = $request->license;
        $user->npi = $request->npi;
        $user->specility_id = implode(',', $request->skills);
        $user->code = $request->code;
        $user->country = $request->country;
        $user->fax = $request->fax;
        //
        $images = $request->file('certificate_mbbs');
        $imageName = '';
        if ($images) {
            foreach ($images as $img) {
                $file_type = $img->extension();
                $new_name = URL::to('/') . '/' . $img->storeAs('images/doctors', rand() . '.' . $file_type, 'public');
                $img->move(public_path('/images/doctors'), $new_name);
                $imageName = $imageName . $new_name . ",";
            }
            $imgDb = $imageName;
            if ($request->new_certificate_mbbs == '') {
                $user->certificate_mbbs = substr($imgDb, 0, -1);
            } else {
                $user->certificate_mbbs = $request->new_certificate_mbbs . ',' . substr($imgDb, 0, -1);
            }
        } else {
            $user->certificate_mbbs = $request->new_certificate_mbbs;
        }

        $user->certificate_name = implode(',', $request->certificate_name);
        $user->registration_no = implode(',', $request->registration_no);

        $user->experience =  $request->exp . ' ' . $request->duration;




        if ($request->hasFile('certificate_practice')) {
            $file_type = $request->file('certificate_practice')->extension();
            $file_path = $request->file('certificate_practice')->storeAs('images/doctors', 'practise' . time() . '.' . $file_type, 'public');
            $request->file('certificate_practice')->move(public_path('images/doctors'), 'practise' . time() . '.' . $file_type);
            $user->certificate_practice = URL::to('/') . '/' . $file_path;
        }

        $user->reg_no_p = $request->reg_no_practice;


        if ($user->save()) {
            return response()->json([
                'success' => 1,
                'message' => "Doctor profile updated successfully",

            ], 200);
        } else {
            return response()->json([
                'success' => 0,
                'message' => "Error",

            ], 400);
        }
    }
    public function doctor_speciality(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = User::select('id', 'specility_id')->where('id', $request->user_id)->where('role', 1)->first();
        if (!$data) {
            return response()->json([
                'success' => '0',
                "message" => "no data found",

            ], 200);
        }
        $spl = Service::select('id', 'name')->whereIn('id', explode(',', $data->specility_id))->get();
        if ($spl) {
            return response()->json([
                'success' => '1',
                "message" => "Doctors specility",
                "response" =>   $spl
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data found",
                "response" =>   $spl
            ], 200);
        }
    }

    public function doctor_certificates(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = User::select('id', 'certificate_mbbs', 'certificate_name', 'registration_no')->where('id', $request->user_id)->where('role', 1)->first();
        if (!$data) {
            return response()->json([
                'success' => '0',
                "message" => "no data found",

            ], 200);
        }
        $data->certificate_mbbs = explode(',', $data->certificate_mbbs);


        $data->certificate_name = explode(',', $data->certificate_name);
        $data->registration_no = explode(',', $data->registration_no);


        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Doctors certificates",
                "response" =>   $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data found",
                "response" =>   $data
            ], 200);
        }
    }
    public function routes(Request $request)
    {
        $data = DB::table('routes')->select('id', 'route_name as name')->where('route_name', '!=', 'Oral')->get();
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Routes",
                "response" =>   $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data found",
                "response" =>   $data
            ], 200);
        }
    }
    public function medicine_add(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'medicine' => 'required',
            'course' => 'required',

            'frequency' => 'required',
            'dose' => 'required',
            'dose_type' => 'required',
            'sub' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        //  $m=DB::table('medication')->where('id',$request->medicine)->first();
        $book = DB::table('appointments')->where('id', $request->booking_id)->first();
        if ($request->id != '') {
            if ($request->route_id == 0) {
                $data = DB::table('routes')->where('route_name', 'Oral')->first();
                $route = $data->id;
            } else {
                $route = $request->route_id;
            }


            $data = DB::table('doc_medicine')->where('id', $request->id)->update([
                'user_id' => $book->doctor_id,
                'medicine' => $request->medicine,
                'course' => $request->course,
                'route_id' => $route,
                'dose' => $request->dose . $request->dose_type,
                //'brief' => $request->brief,
                'sub' => $request->sub,
                'refil' => $request->refil,
                'frequency' => $request->frequency,
                'booking_id' => $request->booking_id,
                'patient_id' => $book->patient_id,
                'status' => 2
            ]);
            $id = $request->id;
            $msg = 'Medicine updated successfully';
        } else {
            if ($request->route_id == 0) {
                $data = DB::table('routes')->where('route_name', 'Oral')->first();
                $route = $data->id;
            } else {
                $route = $request->route_id;
            }


            $id = DB::table('doc_medicine')->insertGetId([
                'user_id' => $book->doctor_id,
                'medicine' => $request->medicine,
                'course' => $request->course,
                'route_id' => $route,
                'dose' => $request->dose . $request->dose_type,
                //'brief' => $request->brief,
                'sub' => $request->sub,
                'refil' => $request->refil,
                'frequency' => $request->frequency,
                'booking_id' => $request->booking_id,
                'patient_id' => $book->patient_id,
                'status' => 2
            ]);
            $msg = 'Medicine added successfully';
        }




        return response()->json([
            'success' => '1',
            "message" => $msg,
            "med_id" => $id

        ], 200);
    }

    public function medicine_auto_save(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $book = DB::table('appointments')->where('id', $request->booking_id)->first();

        if ($request->medicine != '' || $request->course != '' || $request->route_id != '' || $request->dose != '' || $request->dose_type != '' || $request->brief != '' || $request->frequency != '') {
            $data = DB::table('doc_medicine')->insert([
                'user_id' => $book->doctor_id,
                'medicine' => $request->medicine,
                'course' => $request->course,
                'route_id' => $request->route_id,
                'dose' => $request->dose . $request->dose_type,
                'brief' => $request->brief,
                'frequency' => $request->frequency,
                'booking_id' => $request->booking_id,
                'patient_id' => $book->patient_id,
                'status' => 1
            ]);


            return response()->json([
                'success' => '1',
                "message" => "Medicine autosaved",

            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data to autosaved",

            ], 200);
        }
    }



    public function medicine_delete(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'med_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }


        $data = DB::table('doc_medicine')->where('id', $request->med_id)->delete();


        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Medicine deleted successfully",

            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "Medicine not deleted",

            ], 200);
        }
    }
    public function medicine_get(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'med_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('doc_medicine')->select('doc_medicine.*', 'routes.route_name')->where('doc_medicine.id', $request->med_id)->join('routes', 'routes.id', 'doc_medicine.route_id')->first();


        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Medicine deatails",
                "response" => $data

            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No data found",

            ], 200);
        }
    }
    public function medicine_update(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'id' => 'required',
            'medicine' => 'required',
            'course' => 'required',
            'route_id' => 'required',
            'frequency' => 'required',
            'dose' => 'required',
            'dose_type' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }




        $r = DB::table('routes')->where('route_name', $request->route_name)->first();


        // echo is_array($request->medicine);
        if (is_array($request->medicine) == 1) {
            $med = implode($request->medicine);
        } else {
            $med = $request->medicine;
        }





        //  die;


        $data = DB::table('doc_medicine')->where('id', $request->id)->update([

            'medicine' => $med,
            'course' => $request->course,
            'route_id' => $r->id,
            'dose' => $request->dose . $request->dose_type,
            'refil' => $request->refil,
            'frequency' => $request->frequency,
            'sub' => $request->sub

        ]);
        return response()->json([
            'success' => '1',
            "message" => "Medicine updated",


        ], 200);
    }
    public function medicine_get_by_id(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $b = DB::table('doc_medicine')->where('booking_id', $request->booking_id)->where('status', 1)->orderBy('id', 'DESC')->first();

        $data = DB::table('doc_medicine')->select('id', 'medicine', 'course', 'route_id', 'dose', 'brief', 'frequency', 'refil', 'sub')->where('status', 1)->where('id', $b->id)->first();
        // $data_r = DB::table('routes')->where('id', $data->route_id)->first();
        // $data->route_id = $data_r->route_name;
        $data->dose_type = substr($data->dose, -2);
        $data->dose = intval($data->dose);
        $data->dose = "" . $data->dose . "";
        if ($data->brief == null) {
            $data->brief = '';
        }


        return response()->json([
            'success' => '1',
            "message" => "Medicine details",
            "response" => $data

        ], 200);
    }


    public function medicine_details(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('doc_medicine')->select('doc_medicine.id', 'doc_medicine.medicine', 'doc_medicine.course', 'doc_medicine.route_id', 'doc_medicine.dose', 'doc_medicine.brief', 'doc_medicine.frequency', 'doc_medicine.sub', 'doc_medicine.refil', 'routes.route_name')->join('routes', 'routes.id', 'doc_medicine.route_id')->where('doc_medicine.status', 2)->where('doc_medicine.booking_id', $request->booking_id)->get();
        foreach ($data as $row) {
            $row->dose_type = substr($row->dose, -2);
            $row->dose = intval($row->dose);
        }


        return response()->json([
            'success' => '1',
            "message" => "Added medicine details",
            "response" => $data

        ], 200);
    }
    public function availability1(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'day' => 'required',
            'start_time' => 'required',
            'con_type' => 'required',
            'end_time' => 'required|after:start_time',
            'date' => 'required',
            'time_zone' => 'required'


        ], [
            'end_time.after' => 'End time must be after start time.',
            'con_type.required' => 'Consultation type required'
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $start_time = date('H:i', strtotime($request->start_time));

        $end_time = date('H:i', strtotime($request->end_time));



        $data_a = DB::table('users')->where('id', $request->user_id)->first();

        if ($data_a->fee_per_consultation == '') {
            return response()->json([
                'success' => '0',
                "message" => "Please enter consultation fees",
            ], 200);
        } else if ($data_a->status == 1) {
            return response()->json([
                'success' => '0',
                "message" => "You are not a appropved doctor",
            ], 200);
        } else {
        }


        $d = explode('-', $request->date);



        $date = $d[2] . '-' . $d[0] . '-' . $d[1];



        date_default_timezone_set($request->time_zone);
 



        if ($date <= date('Y-m-d') && date('h:i a', strtotime($start_time)) < date('h:i a')) {
            return response()->json([
                'success' => '0',
                "message" => "Booking Not Possible Because Time Already Over",
            ], 200);
        }
        $data_c = DB::table('availability')->where('user_id', $request->user_id)->where('date', $date)->orderBy('id', 'desc')->first();



        if ($data_c) {
            $s = get_change_utc_to_timezone(date('h:i a', strtotime($data_c->start_time)), $request->time_zone);
            $e = get_change_utc_to_timezone(date('h:i a', strtotime($data_c->end_time)), $request->time_zone);
            if ($s >= date('h:i a', strtotime($start_time))) {
                $data = DB::table('availability')->insert([
                    'user_id' => $request->user_id,
                    'day' => $request->day,
                    'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                    'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                    'date' =>  $date,
                    'type' => $request->con_type


                ]);
                return response()->json([
                    'success' => '1',
                    "message" => "Added Doctor Availability",
                ], 200);
            } else if ($s >= date('h:i a', strtotime($start_time))  || $e >= date('h:i a', strtotime($start_time))) {
                return response()->json([
                    'success' => '0',
                    "message" => "Availability cant be added when start time in between previous schedule time",
                ], 200);
            } else {

                $data = DB::table('availability')->insert([
                    'user_id' => $request->user_id,
                    'day' => $request->day,
                    'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                    'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                    'date' =>  $date,
                    'type' => $request->con_type


                ]);
                return response()->json([
                    'success' => '1',
                    "message" => "Added Doctor Availability",
                ], 200);
            }
        } else {
            $data = DB::table('availability')->insert([
                'user_id' => $request->user_id,
                'day' => $request->day,
                'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                'date' =>  $date,
                'type' => $request->con_type


            ]);
            return response()->json([
                'success' => '1',
                "message" => "Added Doctor Availability",
            ], 200);
        }



    }
    public function availability(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'day' => 'required',
            'start_time' => 'required',
            'con_type' => 'required',
            'end_time' => 'required|after:start_time',
            'date' => 'required',
            'time_zone' => 'required'


        ], [
            'end_time.after' => 'End Time must be greater than Start Time.',
            'con_type.required' => 'Consultation type required'
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $start_time = date('H:i', strtotime($request->start_time));

        $end_time = date('H:i', strtotime($request->end_time));



        $data_a = DB::table('users')->where('id', $request->user_id)->first();

        if ($data_a->fee_per_consultation == '') {
            return response()->json([
                'success' => '0',
                "message" => "Please enter consultation fees",
            ], 200);
        } else if ($data_a->status == 1) {
            return response()->json([
                'success' => '0',
                "message" => "You are not a appropved doctor",
            ], 200);
        } else {
        }


        $d = explode('-', $request->date);



        $date = $d[2] . '-' . $d[0] . '-' . $d[1];



        date_default_timezone_set($request->time_zone);

       
        if ($date <= date('Y-m-d') && date('H:i') >= date('H:i', strtotime($start_time))) {

            return response()->json([
                'success' => '0',
                "message" => "Adding schedule is not possible as the allotted time has already over",
            ], 200);
        }

        $data = DB::table('availability')->insert([
            'user_id' => $request->user_id,
            'day' => $request->day,
            'start_time' => get_change_timezone_to_utc($request->start_time, $request->time_zone),
            'end_time' => get_change_timezone_to_utc($request->end_time, $request->time_zone),
            'date' => $date,
            'type' => $request->con_type


        ]);
        return response()->json([
            'success' => '1',
            "message" => "Added doctor availability successfully",
        ], 200);

       
    }
    public function availability_get(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'time_zone' => 'required'
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('availability')->where('user_id', $request->user_id)->where('date', '>=', date('Y/m/d'))->get();
        $data_i = [];

        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));
            $t1 = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time =  get_change_utc_to_timezone(date('h:i a', strtotime($row->end_time)), $request->time_zone);
            $p1 = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

            $result_in_seconds = $to->diffInSeconds($from, false);




            if ($result_in_seconds > 0) {

                $start_time1 = date('H:i:s', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->start_time)), $request->time_zone)));
                $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->end_time)), $request->time_zone)));



                if ($start_time1 <= $end_time) {

                    $t = explode(',', $row->type);
                    asort($t);
                    $i = [];
                    foreach ($t as $key => $val) {
                        array_push($i, $val);
                    }



                    $row->type = implode(', ',$i);
                    $row->start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->start_time)), $request->time_zone);
                    $row->end_time =  get_change_utc_to_timezone(date('h:i a', strtotime($row->end_time)), $request->time_zone);
                    $row->date =  date('m/d/Y', strtotime($row->date));
                    $row->time_zone =  $request->time_zone;
                    array_push($data_i, $row);
                }
            }
        }

        $names = array();
        foreach ($data_i as $key => $val) {
            $names[$key]['date'] = $val->date;
            $names[$key]['start_time'] = $val->start_time;

        }


        array_multisort($names, SORT_ASC, $data_i);

        
        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability Details",
            "response" => $data_i
        ], 200);
    }
    public function availability_get_list(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'time_zone' => 'required'
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('availability')->select('date', 'day', 'type', 'start_time', 'end_time')->where('user_id', $request->user_id)->where('date', '>=', date('Y/m/d'))->distinct()->get();
        $data_i = [];

        foreach ($data as $row) {

            $start_time1 = date('H:i:s', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->start_time)), $request->time_zone)));
            $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->end_time)), $request->time_zone)));



            if ($start_time1 <= $end_time) {
                $row->type = str_replace(',', ', ', $row->type);
                //$row->start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->start_time)), $request->time_zone);
                // $row->end_time =  get_change_utc_to_timezone(date('h:i a', strtotime($row->end_time)), $request->time_zone);
                $row->date =  date('m/d/Y', strtotime($row->date));
                //  $row->time_zone =  $request->time_zone;
                array_push($data_i, $row);
            }
        }






        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability Details List",
            "response" =>   $data_i
        ], 200);
    }
    public function availability_update1(Request $request)
    {


        $validation = Validator::make($request->all(), [

            'day' => 'required',
            'start_time' => 'required',
            'end_time' => 'required|after:start_time',
            'date' => 'required',
            'id' => 'required',
            'user_id' => 'required',
            "time_zone" => 'required'


        ], [
            'day.required' => 'Day Field is required',
            'start_time.required' => 'Start time Field is required',
            'end_time.required' => 'End time Field is required',
            'date.required' => 'Day Field is required',
            'id.required' => 'Day Field is required',
            'user_id.required' => 'Day Field is required',
            'end_time.after' => 'End time Field must be after start time'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        // $d = date('Y/m/d', strtotime($request->date));
        date_default_timezone_set($request->time_zone);
        $start_time = date('H:i', strtotime($request->start_time));

        $end_time = date('H:i', strtotime($request->end_time));

        $dt = explode('/', $request->date);



        $d = $dt[2] . '-' . $dt[0] . '-' . $dt[1];



        //   echo $d;
        //  echo '<br>';
        //echo date('Y-m-d');




        if ($d == date('Y-m-d') && date('h:i a', strtotime($start_time)) < date('h:i a')) {

            return response()->json([
                'success' => '0',
                "message" => "Update not possible for previous time",
            ], 200);
        }

        //$data_a = DB::table('appointments')->whereDate('date', $d)->where('doctor_id', $request->user_id)->first();
        $data_c = DB::table('availability')->where('user_id', $request->user_id)->where('date', $d)->orderBy('id', 'desc')->first();

        if ($data_c) {
            $s = get_change_utc_to_timezone(date('h:i a', strtotime($data_c->start_time)), $request->time_zone);
            $e = get_change_utc_to_timezone(date('h:i a', strtotime($data_c->end_time)), $request->time_zone);
            if ($s > date('h:i a', strtotime($start_time))  || $e > date('h:i a', strtotime($end_time))) {



                if ($s <= date('h:i a', strtotime($start_time)) && $e <= date('h:i a', strtotime($end_time))) {
                    return response()->json([
                        'success' => '0',
                        "message" => "Availability cant be updated when start time in between previous schedule time",
                    ], 200);
                } else {
                    //echo "1";
                    $data = DB::table('availability')->where('id', $request->id)->update([

                        'day' => $request->day,
                        'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                        'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                        'date' => date('Y/m/d', strtotime($request->date)),
                        'type' => substr($request->type, 0, -1)

                    ]);
                    return response()->json([
                        'success' => '1',
                        "message" => "Doctor Availability Updated",
                    ], 200);
                }
            } else {
                $data = DB::table('availability')->where('id', $request->id)->update([

                    'day' => $request->day,
                    'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                    'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                    'date' => date('Y/m/d', strtotime($request->date)),
                    'type' => substr($request->type, 0, -1)


                ]);
                return response()->json([
                    'success' => '1',
                    "message" => "Doctor Availability Updated",
                ], 200);
            }
        } else {
            $data = DB::table('availability')->where('id', $request->id)->update([

                'day' => $request->day,
                'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
                'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
                'date' => date('Y/m/d', strtotime($request->date)),
                'type' => substr($request->type, 0, -1)


            ]);
            return response()->json([
                'success' => '1',
                "message" => "Doctor Availability Updated",
            ], 200);
        }
    }

    public function availability_update(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'day' => 'required',
            'start_time' => 'required',
            'end_time' => 'required|after:start_time',
            'date' => 'required',
            'id' => 'required',
            'user_id' => 'required',
            "time_zone" => 'required',
            "type" => 'required'


        ], [
            'day.required' => 'Day field is required',
            'start_time.required' => 'Start time field is required',
            'end_time.required' => 'End time field is required',
            'date.required' => 'Day field is required',
            'id.required' => 'Available id field is required',
            'user_id.required' => 'Day field is required',
            'end_time.after' => 'End time field must be after start time',
            'type.required' => "Consultation type field is required"

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        // $d = date('Y/m/d', strtotime($request->date));
        date_default_timezone_set($request->time_zone);
        $start_time = date('H:i', strtotime($request->start_time));

        $end_time = date('H:i', strtotime($request->end_time));

        $dt = explode('/', $request->date);



        $d = $dt[2] . '-' . $dt[0] . '-' . $dt[1];
        //echo date('h:i a', strtotime($start_time));
        //  echo date('h:i a');



        if ($d == date('Y-m-d') && date('H:i', strtotime($start_time)) <= date('H:i')) {

            return response()->json([
                'success' => '0',
                "message" => "Update is not possible for previous time",
            ], 200);
        }



        $data = DB::table('availability')->where('id', $request->id)->update([

            'day' => $request->day,
            'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
            'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
            'date' => date('Y/m/d', strtotime($request->date)),
            'type' => $request->type


        ]);


        return response()->json([
            'success' => '1',
            "message" => "Doctor availability updated successfully",
        ], 200);






        // $sh =  DB::table('availability')->where('id', $request->id)->where('date', $d)->first();
        // $sh1 =  DB::table('availability')->where('user_id', $request->user_id)->where('date', $d)->first();
        // $sh =  DB::table('availability')->where('id', $request->id)->first();

        // print_r($sh);

        //print_r($sh);
        // die;

        // if ($sh->date !== $d && empty($sh1)) {



        //     $data = DB::table('availability')->where('id', $request->id)->update([

        //         'day' => $request->day,
        //         'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //         'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //         'date' => date('Y/m/d', strtotime($request->date)),
        //         'type' => $request->type


        //     ]);
        //     return response()->json([
        //         'success' => '1',
        //         "message" => "Doctor Availability Updated",
        //     ], 200);
        // } else if ($sh->date === $d && !empty($sh1)) {


        //     if ($sh->start_time == get_change_timezone_to_utc($start_time, $request->time_zone) . ':00' && $sh->end_time == get_change_timezone_to_utc($end_time, $request->time_zone) . ':00') {



        //         $data = DB::table('availability')->where('id', $request->id)->update([

        //             'day' => $request->day,
        //             'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //             'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //             'date' => date('Y/m/d', strtotime($request->date)),
        //             'type' => $request->type


        //         ]);
        //         return response()->json([
        //             'success' => '1',
        //             "message" => "Doctor Availability Updated",
        //         ], 200);
        //     } else if ($sh->start_time !== get_change_timezone_to_utc($start_time, $request->time_zone) . ':00' && $sh->end_time !== get_change_timezone_to_utc($end_time, $request->time_zone) . ':00') {

        //         $pk = DB::table('availability')->where('user_id', $request->user_id)->max('end_time');

        //         $ps = DB::table('availability')->where('user_id', $request->user_id)->max('start_time');







        //         if (get_change_timezone_to_utc($end_time, $request->time_zone) . ':00' > $pk  && get_change_timezone_to_utc($start_time, $request->time_zone) . ':00' > $ps) {

        //             $data = DB::table('availability')->where('id', $request->id)->update([

        //                 'day' => $request->day,
        //                 'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                 'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                 'date' => date('Y/m/d', strtotime($request->date)),
        //                 'type' => $request->type


        //             ]);
        //             return response()->json([
        //                 'success' => '1',
        //                 "message" => "Doctor Availability Updated",
        //             ], 200);
        //         } else {
        //             $p = DB::table('availability')->whereNotIn('id', [$request->id])->where('user_id', $request->user_id)
        //                 ->where('start_time', '<', get_change_timezone_to_utc($start_time, $request->time_zone) . ':00')
        //                 ->where('end_time', '>', get_change_timezone_to_utc($start_time, $request->time_zone) . ':00')
        //                 ->count();
        //         //    echo $p;
        //             if ($p == 0) {

        //                 $data = DB::table('availability')->where('id', $request->id)->update([

        //                     'day' => $request->day,
        //                     'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                     'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                     'date' => date('Y/m/d', strtotime($request->date)),
        //                     'type' => $request->type


        //                 ]);
        //                 return response()->json([
        //                     'success' => '1',
        //                     "message" => "Doctor Availability Updated",
        //                 ], 200);
        //             } else {
        //                 return response()->json([
        //                     'success' => '0',
        //                     "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
        //                 ], 200);
        //             }
        //         }
        //     } elseif ($sh->start_time !== get_change_timezone_to_utc($start_time, $request->time_zone) . ':00') {


        //         if ($sh->start_time < get_change_timezone_to_utc($start_time, $request->time_zone) . ':00'  && $sh->end_time > get_change_timezone_to_utc($start_time, $request->time_zone) . ':00') {

        //             $data = DB::table('availability')->where('id', $request->id)->update([

        //                 'day' => $request->day,
        //                 'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                 'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                 'date' => date('Y/m/d', strtotime($request->date)),
        //                 'type' => $request->type


        //             ]);


        //             return response()->json([
        //                 'success' => '1',
        //                 "message" => "Doctor Availability Updated",
        //             ], 200);
        //         } else {

        //             $p = DB::table('availability')->whereNotIn('id', [$request->id])->where('user_id', $request->user_id)
        //                 ->where('start_time', '<', get_change_timezone_to_utc($start_time, $request->time_zone) . ':00')
        //                 ->where('end_time', '>', get_change_timezone_to_utc($start_time, $request->time_zone) . ':00')
        //                 ->count();

        //             if ($p > 0) {


        //                 return response()->json([
        //                     'success' => '0',
        //                     "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
        //                 ], 200);
        //             } else {


        //                 $data = DB::table('availability')->where('id', $request->id)->update([

        //                     'day' => $request->day,
        //                     'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                     'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                     'date' => date('Y/m/d', strtotime($request->date)),
        //                     'type' => $request->type


        //                 ]);
        //                 return response()->json([
        //                     'success' => '1',
        //                     "message" => "Doctor Availability Updated",
        //                 ], 200);
        //             }
        //         }
        //     } else {
        //         if ($sh->start_time < get_change_timezone_to_utc($end_time, $request->time_zone) . ':00'  && $sh->end_time > get_change_timezone_to_utc($end_time, $request->time_zone) . ':00') {




        //             $data = DB::table('availability')->where('id', $request->id)->update([

        //                 'day' => $request->day,
        //                 'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                 'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                 'date' => date('Y/m/d', strtotime($request->date)),
        //                 'type' => $request->type


        //             ]);


        //             return response()->json([
        //                 'success' => '1',
        //                 "message" => "Doctor Availability Updated",
        //             ], 200);
        //         } else {
        //             $pe = DB::table('availability')->whereNotIn('id', [$request->id])->where('user_id', $request->user_id)
        //                 ->where('start_time', '<=', get_change_timezone_to_utc($end_time, $request->time_zone) . ':00')
        //                 ->where('end_time', '>=', get_change_timezone_to_utc($end_time, $request->time_zone) . ':00')

        //                 ->count();


        //             if ($pe > 0) {

        //                 return response()->json([
        //                     'success' => '0',
        //                     "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
        //                 ], 200);
        //             } else {
        //                 $max = DB::table('availability')->max('end_time');




        //                 if ($max < get_change_timezone_to_utc($end_time, $request->time_zone) . ':00') {
        //                     $m = DB::table('availability')->where('end_time', $max)->first();


        //                     if ($m->id == $request->id) {
        //                         $data = DB::table('availability')->where('id', $request->id)->update([

        //                             'day' => $request->day,
        //                             'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                             'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                             'date' => date('Y/m/d', strtotime($request->date)),
        //                             'type' => $request->type


        //                         ]);
        //                         return response()->json([
        //                             'success' => '1',
        //                             "message" => "Doctor Availability Updated",
        //                         ], 200);
        //                     } else {
        //                         return response()->json([
        //                             'success' => '0',
        //                             "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
        //                         ], 200);
        //                     }
        //                 } else {


        //                     $data = DB::table('availability')->where('id', $request->id)->update([

        //                         'day' => $request->day,
        //                         'start_time' => get_change_timezone_to_utc($start_time, $request->time_zone),
        //                         'end_time' => get_change_timezone_to_utc($end_time, $request->time_zone),
        //                         'date' => date('Y/m/d', strtotime($request->date)),
        //                         'type' => $request->type


        //                     ]);
        //                     return response()->json([
        //                         'success' => '1',
        //                         "message" => "Doctor Availability Updated",
        //                     ], 200);
        //                 }
        //             }
        //         }
        //     }
        // } else {

        //     return response()->json([
        //         'success' => '0',
        //         "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
        //     ], 200);
        // }
    }


    public function availability_delete(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'id' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('availability')->where('id', $request->id)->delete();
        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability deleted sucessfully",
        ], 200);
    }
    public function availability_time_slot_pm(Request $request)
    {

        $validation = Validator::make($request->all(), [

            'avl_id' => 'required',
            'time_zone' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('availability')->where('id', $request->avl_id)->first();
        // $tip = DB::table('availability')->where('date', $data->date)->where('user_id', $data->user_id)->get();
        //  $u = [];


        // foreach ($tip  as $row) {
        $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($data->start_time, $request->time_zone)));

        $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($data->end_time, $request->time_zone)));


        $duration = time_slot($data->type);

        $slots = getTimeSlot($duration, $start_time, $end_time);



        $data1 = [];

        foreach ($slots  as $row1) {


            $t = getBookingDtl($data->user_id, $row1['slot_start_time'], $row1['slot_end_time'], $data->date, $request->time_zone);

            $p = getBookingDtlP($data->user_id, $row1['slot_start_time'], $row1['slot_end_time'], $data->date, $request->time_zone);

            $row1['slot_end_time'] = date('H:i', strtotime($row1['slot_end_time']));



            $date = new DateTime('now', new DateTimeZone($request->time_zone));
            $t1 = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($data->date));
            $start_time = date('h:i a', strtotime($row1['slot_start_time']));
            $p1 = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

            $result_in_seconds = $to->diffInSeconds($from, false);
            if ($result_in_seconds > 0) {
                if ($t !== 0) {

                    $pt = explode('to', $t);
                    //  $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_start_time'], $request->time_zone)));
                    //  $row1['slot_end_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_end_time'], $request->time_zone)));
                    $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));
                    $row1['slot_end_time'] = date('h:i a', strtotime($row1['slot_end_time']));

                    $contains = str_contains($row1['slot_start_time'], 'pm');
                    if ($contains) {

                        //  $row1['slot_start_time'] = date('h:i a', strtotime($pt[0]));

                        // $row1['slot_end_time'] = date('h:i a', strtotime($pt[1]));

                        $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($pt[0], $request->time_zone)));

                        $row1['slot_end_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($pt[1], $request->time_zone)));

                        //   $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_start_time'], $request->time_zone)));

                        //  $row1['slot_end_time'] =  date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_end_time'], $request->time_zone)));


                        $row1['status'] = "Booked";

                        array_push($data1, $row1);
                    }
                } else {

                    // echo $row1['slot_start_time'];
                    $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));



                    $row1['slot_end_time'] = date('h:i a', strtotime($row1['slot_end_time']));


                    $contains = str_contains($row1['slot_start_time'], 'pm');
                    if ($contains) {
                        $row1['status'] = "Available";
                        $row1['patient_name'] = 'NA';
                        array_push($data1, $row1);
                    }
                }
            }
        }
        // array_push($u, $data1);
        // }

        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability Time Slot PM",
            "response" =>  $data1
        ], 200);
    }
    public function availability_time_slot_am(Request $request)
    {

        $validation = Validator::make($request->all(), [

            'avl_id' => 'required',
            'time_zone' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('availability')->where('id', $request->avl_id)->first();
        // $tip = DB::table('availability')->where('date', $data->date)->where('user_id', $data->user_id)->get();
        //  $u = [];

        // foreach ($tip  as $row) {


        $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($data->start_time, $request->time_zone)));

        $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($data->end_time, $request->time_zone)));

        $duration = time_slot();

        $slots = getTimeSlot($duration, $start_time, $end_time);



        $data1 = [];

        foreach ($slots  as $row1) {


            $t = getBookingDtl($data->user_id, $row1['slot_start_time'], $row1['slot_end_time'], $data->date, $request->time_zone);



            $p = getBookingDtlP($data->user_id, $row1['slot_start_time'], $row1['slot_end_time'], $data->date, $request->time_zone);

            $row1['slot_end_time'] = date('H:i', strtotime($row1['slot_end_time']));



            $date = new DateTime('now', new DateTimeZone($request->time_zone));



            $t1 = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($data->date));


            $start_time = date('h:i a', strtotime($row1['slot_start_time']));
            $p1 = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

            $result_in_seconds = $to->diffInSeconds($from, false);
            if ($result_in_seconds > 0) {
                if ($t !== 0) {

                    $pt = explode('to', $t);

                    // echo  $row1['slot_start_time'];

                    $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));
                    $row1['slot_end_time'] = date('h:i a', strtotime($row1['slot_end_time']));

                    $contains = str_contains($row1['slot_start_time'], 'am');
                    if ($contains) {
                        $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($pt[0], $request->time_zone)));

                        $row1['slot_end_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($pt[1], $request->time_zone)));

                        //  $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_start_time'], $request->time_zone)));

                        //  $row1['slot_end_time'] =  date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_end_time'], $request->time_zone)));



                        $row1['status'] = "Booked";

                        array_push($data1, $row1);
                    }
                } else {


                    $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));

                    $row1['slot_end_time'] = date('h:i a', strtotime($row1['slot_end_time']));

                    $contains = str_contains($row1['slot_start_time'], 'am');
                    if ($contains) {
                        $row1['status'] = "Available";
                        $row1['patient_name'] = 'NA';
                        array_push($data1, $row1);
                    }
                }
            }
        }
        // array_push($u, $data1);
        // }

        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability Time Slot AM",
            "response" =>  $data1
        ], 200);
    }
    public function availability_time_slot_d(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'date' => 'required',
            'time_zone' => 'required',
            'user_id' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        // $data = DB::table('availability')->where('id', $request->avl_id)->first();
        $tip = DB::table('availability')->where('date', date('Y/m/d', strtotime($request->date)))->where('user_id', $request->user_id)->get();


        $u = [];

        foreach ($tip  as $row) {
            $duration = time_slot();

            $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->start_time, $request->time_zone)));

            $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->end_time, $request->time_zone)));



            //echo $end_time;

            $slots = getTimeSlot($duration, $start_time, $end_time);



            //print_r($slots);





            $data1 = [];

            foreach ($slots  as $row1) {


                $t = getBookingDtl($request->user_id, $row1['slot_start_time'], $row1['slot_end_time'], date('Y-m-d', strtotime($request->date)), $request->time_zone);

                $p = getBookingDtlP($request->user_id, $row1['slot_start_time'], $row1['slot_end_time'], date('Y-m-d', strtotime($request->date)), $request->time_zone);

                $row1['slot_end_time'] = date('H:i', strtotime($row1['slot_end_time']));




                $date = new DateTime('now', new DateTimeZone($request->time_zone));
                $t1 = $date->format('Y-m-d h:i a');

                $date2 = date('Y-m-d', strtotime($request->date));
                $start_time = date('h:i a', strtotime($row1['slot_start_time']));

                $p1 = $date2 . ' ' . $start_time;

                //echo $p1;
                $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
                $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

                $result_in_seconds = $to->diffInSeconds($from, false);
                if ($result_in_seconds > 0) {
                    if ($t !== 0) {

                        $pt = explode('to', $t);
                        $row1['slot_start_time'] = $pt[0];

                        $row1['slot_end_time'] = $pt[1];
                        $row1['slot_start_time'] = date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_start_time'], $request->time_zone)));

                        $row1['slot_end_time'] =  date('h:i a', strtotime(get_change_utc_to_timezone($row1['slot_end_time'], $request->time_zone)));
                        $row1['status'] = "Booked";
                        $k = explode('-', $p);
                        $row1['patient_name'] = $k[0];
                        $row1['patient_id'] = $k[1];
                    } else {
                        $row1['slot_start_time'] = date('h:i a', strtotime($row1['slot_start_time']));

                        $row1['slot_end_time'] = date('h:i a', strtotime($row1['slot_end_time']));
                        $row1['status'] = "Available";
                        $row1['patient_name'] = 'NA';
                    }
                    array_push($data1, $row1);
                } else {
                }
            }
            array_push($u, $data1);
        }

        return response()->json([
            'success' => '1',
            "message" => "Doctor Availability Time Slot",
            'date' => date('m/d/Y', strtotime($request->date)),
            'day' => date('l', strtotime($request->date)),
            "response" => $u
        ], 200);
    }
    public function fees_update(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        if ($request->fee_video == '' && $request->fee_audio == '' && $request->fee_chat == '') {
            return response()->json([
                'success' => '0',
                "message" => "Please Give any of the fee mentioned",

            ], 200);
        }


        if ($request->fee_video == '') {
            $v = 0;
        } else {
            $v = $request->fee_video;
        }

        if ($request->fee_audio == '') {
            $a = 0;
        } else {
            $a = $request->fee_audio;
        }
        if ($request->fee_chat == '') {
            $c = 0;
        } else {
            $c = $request->fee_chat;
        }

        $data = DB::table('users')->where('id', $request->user_id)->update([
            'fee_per_consultation' => $v . ',' . $a . ',' . $c,

        ]);
        return response()->json([
            'success' => '1',
            "message" => "Doctor Fees Updated Sucesfuly",

        ], 200);
    }
    public function fees_get(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('users')->select('id', 'fee_per_consultation')->where('id', $request->user_id)->first();

        if ($data->fee_per_consultation) {
            $fee = explode(',', $data->fee_per_consultation);
            $data->fee_video = $fee[0];
            $data->fee_audio = $fee[1];
            $data->fee_chat = $fee[2];
            return response()->json([
                'success' => '1',
                "message" => "Doctor Fees",
                "response" => $data

            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No Doctor Fees Updated yet",
            ], 200);
        }
    }
    public function booking_list(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.date', 'appointments.app_type', 'appointments.reason', 'appointments.consultation_type', 'appointments.status', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.app_type', 'B')
            ->where('appointments.payment_status', '!=', null)
            ->join('users', 'users.id', 'appointments.patient_id')
            ->whereDate('appointments.date', '>=', date('Y/m/d'))
            ->orderBy('appointments.date', 'ASC')
            ->orderBy('appointments.slot_start', 'ASC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $p = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);
            if ($result_in_seconds > 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }
                if ($row->status == 3) {
                    $row->status = "Cancelled";
                }

                array_push($u, $row);
            }
        }
        if ($u) {
            return response()->json([
                'success' => '1',
                "message" => "List of Appointments",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No List of Appointments",

            ], 200);
        }
    }

    public function booking_list_home_page(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.date', 'appointments.app_type', 'appointments.reason', 'appointments.consultation_type', 'appointments.status', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.app_type', 'B')
            ->where('appointments.status', 1)
            ->whereIn('appointments.payment_status', [1, 3])
            ->join('users', 'users.id', 'appointments.patient_id')
            ->whereDate('appointments.date', '>=', date('Y/m/d'))
            ->orderBy('appointments.date', 'ASC')
            ->orderBy('appointments.slot_start', 'ASC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $p = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);
            if ($result_in_seconds > 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];

                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }


                // $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                if ($row->status == 3) {
                    $row->status = "Cancelled";
                }

                array_push($u, $row);
            }
        }
        if ($u) {
            return response()->json([
                'success' => '1',
                "message" => "List of Appointments",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No List of Appointments",

            ], 200);
        }
    }




    public function booking_details(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $d = DB::table('appointments')->where('appointments.id', $request->booking_id)->first();
        if ($d->patient_id != 0) {
            $row = DB::table('appointments')->select('appointments.id as booking_id', 'appointments.doctor_id', 'appointments.patient_id', 'appointments.date', 'appointments.fee', 'appointments.problem', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image', 'users.email', 'users.phone', 'users.age', 'users.blood_gr',  'users.blood_suger_level', 'users.sex', 'users.height', 'users.weight', 'users.blood_gr', 'users.blood_suger_level', 'users.allergy_id as allergy', 'users.medication_id as medication', 'users.medication_id as medication', 'users.lab_result', 'users.lab_result_images', 'users.surgical_history_id', 'users.surgical_images', 'users.medical_id', 'users.social_history_id')->where('appointments.id', $request->booking_id)->join('users', 'users.id', 'appointments.patient_id')->first();

            $dpl = DB::table('allergies')->select('allergy')->whereIn('id', explode(',', $row->allergy))->get();


            $users = json_decode(json_encode($dpl), true);
            $_add_on = array_column($users, 'allergy');
            $row->allergy = implode(',', $_add_on);

            $dpl1 = DB::table('medication')->select('title')->whereIn('id', explode(',', $row->medication))->get();

            $dpl2 = DB::table('lab')->select('lab')->whereIn('id', explode(',', $row->lab_result))->get();

            $dpl3 = DB::table('surgeries')->select('surgery')->whereIn('id', explode(',', $row->surgical_history_id))->get();

            $dpl4 = DB::table('medical_history')->select('medical')->whereIn('id', explode(',', $row->medical_id))->get();

            $dpl5 = DB::table('social_history')->select('social_history')->whereIn('id', explode(',', $row->social_history_id))->get();

            $users1 = json_decode(json_encode($dpl1), true);
            $_add_on1 = array_column($users1, 'title');
            $row->medication = implode(',', $_add_on1);

            $users2 = json_decode(json_encode($dpl2), true);
            $_add_on2 = array_column($users2, 'lab');
            $row->lab_result = implode(',', $_add_on2);

            $users3 = json_decode(json_encode($dpl3), true);
            $_add_on3 = array_column($users3, 'surgery');
            $row->surgical_history = implode(',', $_add_on3);

            $users4 = json_decode(json_encode($dpl4), true);
            $_add_on4 = array_column($users4, 'medical');
            $row->medical_history = implode(',', $_add_on4);


            $users5 = json_decode(json_encode($dpl5), true);
            $_add_on5 = array_column($users5, 'social_history');
            $row->social_history = implode(',', $_add_on5);



            $row->surgical_images = explode(',', $row->surgical_images);
            $row->lab_result_images = explode(',', $row->lab_result_images);


            $row->date = date('m/d/Y', strtotime($row->date));
            //  $row->slot_start = date('g:i a', strtotime($row->slot_start));
            //  $row->slot_end = date('g:i a', strtotime($row->slot_end));


            $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
            $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);





            $row->slot_start_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone)));
            $row->slot_end_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone)));

            if ($row->profile_image == '') {
                $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
            } else {

                $row->profile_image = URL::to('/') . '/' . $row->profile_image;
            }
            if ($row->height == ' ' || $row->height === null) {
                $row->height = 'NA';
            } else {
                $row->height = $row->height . '"';
            }
            if ($row->weight == ' ' || $row->weight === null) {
                $row->weight = 'NA';
            } else {
                $row->weight = $row->weight . ' lbs';
            }

            if ($row->age == ' ' || $row->age === null) {
                $row->age = 'NA';
            } else {
                $row->age = $row->age;
            }

            if ($row->blood_gr == ' ' || $row->blood_gr === null) {
                $row->blood_gr = 'NA';
            }

            if ($row->blood_suger_level == ' ' || $row->blood_suger_level === null) {
                $row->blood_suger_level = 'NA';
            }
            // $row->age = $row->age;


            // $row->age = $row->age;
            $row->day = date('l', strtotime($row->date));




            return response()->json([
                'success' => '1',
                "message" => "Booking details",
                "patient_id" => $row->patient_id,
                "data" => $row
            ], 200);
        } else {

            $d = DB::table('appointments')->where('id', $request->booking_id)->first();
            $row = DB::table('quick_visit')->select('quick_visit.allergy', 'quick_visit.email', 'quick_visit.gender', 'quick_visit.height', 'quick_visit.weight', 'quick_visit.year', 'quick_visit.allergy as allergy', 'quick_visit.med_id as medication', 'quick_visit.lab as lab', 'quick_visit.lab_result', 'quick_visit.surgical_history', 'quick_visit.surgical_result', 'quick_visit.medical_id')->where('quick_visit.email', $d->patient_email)->first();

            $dpl = DB::table('allergies')->select('allergy')->whereIn('id', explode(',', $row->allergy))->get();


            $users = json_decode(json_encode($dpl), true);
            $_add_on = array_column($users, 'allergy');
            $row->allergy = implode(',', $_add_on);

            $dpl1 = DB::table('medication')->select('title')->whereIn('id', explode(',', $row->medication))->get();

            $dpl2 = DB::table('lab')->select('lab')->whereIn('id', explode(',', $row->lab))->get();

            $dpl3 = DB::table('surgeries')->select('surgery')->whereIn('id', explode(',', $row->surgical_history))->get();

            $dpl4 = DB::table('medical_history')->select('medical')->whereIn('id', explode(',', $row->medical_id))->get();

            $users1 = json_decode(json_encode($dpl1), true);
            $_add_on1 = array_column($users1, 'title');
            $row->medication = implode(',', $_add_on1);

            $users2 = json_decode(json_encode($dpl2), true);
            $_add_on2 = array_column($users2, 'lab');
            $row->lab_result = implode(',', $_add_on2);

            $users3 = json_decode(json_encode($dpl3), true);
            $_add_on3 = array_column($users3, 'surgery');
            $row->surgical_history = implode(',', $_add_on3);

            $users4 = json_decode(json_encode($dpl4), true);
            $_add_on4 = array_column($users4, 'medical');
            $row->medical_history = implode(',', $_add_on4);

            $row->surgical_result = explode(',', $row->surgical_result);
            $row->lab_result_images = explode(',', $row->lab_result);


            $row->date = date('m/d/Y', strtotime($d->date));

            $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
            $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

            $row->slot_start_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone)));
            $row->slot_end_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($row->end)), $request->time_zone)));

            $row->day = date('l', strtotime($d->date));

            $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";


            return response()->json([
                'success' => '1',
                "message" => "Booking details",

                "data" => $row
            ], 200);
        }
    }
    public function booking_accepted(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = Appointment::find($request->booking_id);


        $data->status = 2;
        $data->save();


        return response()->json([
            'success' => '1',
            "message" => "Booking Accepted",

        ], 200);
    }

    public function booking_rejected(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = Appointment::find($request->booking_id);
        $data->status = 3;
        $data->save();

        $user = User::find($data->doctor_id);
        $user->consultation = $user->consultation - 1;
        $user->save();

        return response()->json([
            'success' => '1',
            "message" => "Booking Rejected",

        ], 200);
    }
    public function booking_list_completed_doctor(Request $request)
    {


        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.joined_d', 'appointments.joined_p', 'appointments.app_type', 'appointments.status', 'appointments.payment_status', 'appointments.date', 'appointments.reason', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'appointments.reason', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.app_type', 'B')
            ->where('appointments.payment_status', '!=', null)
            ->whereDate('appointments.date', '<=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->orderBy('appointments.slot_start', 'DESC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));


            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds < 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }

                $o = chkOrder($row->booking_id);

                if ($row->status == 1) {
                    if ($row->joined_p == 1 && $row->joined_d == 1) {
                        $row->status = "Pending Prescription";
                    } else {
                        $row->status = "Prescription: NA";
                    }
                } else if ($row->status == 2) {
                    $row->status = "Prescription Generated";
                } else {
                    $row->status = "Cancelled";
                }
                if ($o != '') {
                    $row->order_path = $o;
                    $row->order = 'Order  Generated';
                } else if ($row->status == 'Cancelled') {
                    $row->order = "Cancelled";
                } else {
                    if ($row->joined_p == 1 && $row->joined_d == 1) {
                        $row->order = "Order Not Generated";
                    } else {
                        $row->order = "Order: NA";
                    }
                }
                array_push($u, $row);
            }
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of Completed Appointments",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No List of Appointments",

            ], 200);
        }
    }
    public function booking_list_rejected(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.date', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.status', 3)
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->get();

        foreach ($data as $row) {
            $row->date = date('m/d/Y', strtotime($row->date));
            $row->slot_start = date('g:i a', strtotime($row->slot_start));
            $row->slot_end = date('g:i a', strtotime($row->slot_end));
            $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of Rejected Appointments",
                "data" => $data
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No List of Appointments",

            ], 200);
        }
    }
    public function generate_prescription(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'time_zone' => 'required',




        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }


        //echo '1';
        $book = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.note', 'appointments.date', 'appointments.slot_end', 'users.name as patient_name', 'users.age', 'users.sex', 'users.height', 'users.weight', 'users.email', 'users.address', 'users.dob', 'doctor.name as doctor_name', 'doctor.last_name as doctor_last_name', 'doctor.license', 'doctor.id as doc_id', 'doctor.specility_id', 'doctor.code', 'doctor.fax', 'doctor.phone', 'doctor.code', 'doctor.npi', 'doctor.dea')
            ->where('appointments.id', $request->booking_id)
            ->join('users', 'users.id', 'appointments.patient_id')
            ->join('users as doctor', 'doctor.id', 'appointments.doctor_id')
            ->first();




        $date = new DateTime('now', new DateTimeZone($request->time_zone));
        $t = $date->format('Y-m-d H:i:s');
        //$start_time = get_change_utc_to_timezone(date('h:i a', strtotime($book->slot_start)), $request->time_zone);

        $start_time = date('h:i:s', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($book->slot_end)), $request->time_zone)));
        $date = date('Y-m-d', strtotime($book->date));

        $start_datetime = new DateTime($date . ' ' . $start_time);

        $end_datetime = new DateTime($t);
        $r = $start_datetime->diff($end_datetime);
        // echo $r->h;
        // echo $r->d;
        // print_r($start_datetime->diff($end_datetime));
        // die;
        if ($r->d >= 1) {
            return response()->json([
                'success' => 0,
                "message" => "24 hours expired to generate prescription",


            ], 200);
        } else {

            // echo '2';
            $med =  DB::table('doc_medicine')
                ->select('doc_medicine.*', 'routes.route_name')
                ->where('doc_medicine.booking_id', $request->booking_id)
                ->join('routes', 'routes.id', 'doc_medicine.route_id')
                ->get();

            if (count($med) == 0) {
                return response()->json([
                    'success' => 0,
                    "message" => "Prescribe some medicine to generate prescription",


                ], 200);
            }
            $f = [];
            foreach ($med as $m) {
                if ($m->sub == 1) {
                    array_push($f, $m);
                }
            }
            if (count($f) > 0) {
                $md = 1;
            } else {
                $md = 0;
            }
            DB::table('appointments')->where('id', $request->booking_id)->update([
                'status' => 2
            ]);
            // echo '3';
            $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $book->specility_id))->get();


            $users = json_decode(json_encode($dpl), true);
            $_add_on = array_column($users, 'spli');
            $book->specility_id = implode(',', $_add_on);
            $unique_id = DB::table('prescription')->orderBy('id', 'desc')->first();

            // echo '4';
            if (!$unique_id) {
                $number = 'A000';
            } else {
                $number = $unique_id->unique_id;
            }
            //  echo '5';

            $number =  next_value($number);

            ini_set('memory_limit', '256M');

            // echo '6';
            $data = [
                'date' => date('m/d/Y'),
                'patient' => $book->patient_name,
                'age' => $book->age,
                'height' => $book->height,
                'weight' => $book->weight,
                'dob' => $book->dob,
                'address' => $book->address,
                'email' => $book->email,
                'phone' => $book->code . ' ' . $book->phone,
                'med' => $med,
                'doctor' => $book->doctor_name . ' ' . $book->doctor_last_name,
                'license' => $book->license,
                'dea' => $book->dea,
                'npi' => $book->npi,
                'specility' => $book->specility_id,
                'doc_id' => $book->doc_id,
                'number' => $number,
                'sex' => $book->sex,
                'remarks' => $request->remarks,
                'sub' => $md,
                'note' => $book->note,
                'fax' => $book->code . ' ' . $book->fax,
                'code' => $book->code
            ];

            $pdf = PDF::loadView('prescription', $data);
            // echo '7';
            $path = public_path('pdf/');
            //  echo '8';
            $fileName =  'prescription' . time() . '.' . 'pdf';
            //echo '9';
            $pdf->save($path . '/' . $fileName);

            // echo '10';
            $c = DB::table('prescription')->where('booking_id', $request->booking_id)->get();
            //echo '11';
            if (count($c) == 0) {
                DB::table('prescription')->insert([

                    "unique_id" => $number,
                    "booking_id" => $request->booking_id,
                    "prescription_path" => URL::to('pdf/' . $fileName)
                ]);

                return response()->json([
                    'success' => 1,
                    "message" => "prescription generated",
                    "prescription" => URL::to('pdf/' . $fileName)

                ], 200);
            } else {
                return response()->json([
                    'success' => 1,
                    "message" => "Prescription already generated",


                ], 200);
            }
        }
    }

    public function generate_prescription_non(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'time_zone' => 'required',




        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }


        //echo '1';
        $book = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.patient_email', 'appointments.note', 'appointments.date', 'appointments.slot_end', 'doctor.name as doctor_name', 'doctor.license', 'doctor.id as doc_id', 'doctor.specility_id', 'doctor.npi', 'doctor.dea')
            ->where('appointments.id', $request->booking_id)

            ->join('users as doctor', 'doctor.id', 'appointments.doctor_id')
            ->first();
        $patient = DB::table('quick_visit')
            ->select('name as patient_name', 'gender', 'height', 'weight', 'email', 'dob')
            ->where('email', $book->patient_email)


            ->first();



        $date = new DateTime('now', new DateTimeZone($request->time_zone));
        $t = $date->format('Y-m-d H:i:s');


        $start_time = date('h:i:s', strtotime($book->slot_end));
        $date = date('Y-m-d', strtotime($book->date));

        $start_datetime = new DateTime($date . ' ' . $start_time);

        $end_datetime = new DateTime($t);
        $r = $start_datetime->diff($end_datetime);
        // echo $r->h;
        // echo $r->d;
        // print_r($start_datetime->diff($end_datetime));
        // die;
        if ($r->d >= 1) {
            return response()->json([
                'success' => 0,
                "message" => "24 hours expired to generate prescription",


            ], 200);
        } else {
            DB::table('appointments')->where('id', $request->booking_id)->update([
                'status' => 2
            ]);
            // echo '2';
            $med =  DB::table('doc_medicine')
                ->select('doc_medicine.*', 'routes.route_name')
                ->where('doc_medicine.booking_id', $request->booking_id)
                ->join('routes', 'routes.id', 'doc_medicine.route_id')
                ->get();


            // echo '3';
            $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $book->specility_id))->get();


            $users = json_decode(json_encode($dpl), true);
            $_add_on = array_column($users, 'spli');
            $book->specility_id = implode(',', $_add_on);
            $unique_id = DB::table('prescription')->orderBy('id', 'desc')->first();

            // echo '4';
            if (!$unique_id) {
                $number = 'A000';
            } else {
                $number = $unique_id->unique_id;
            }
            //  echo '5';

            $number =  next_value($number);

            ini_set('memory_limit', '256M');

            // echo '6';
            $data = [
                'date' => date('m/d/Y'),
                'patient' => $patient->patient_name,
                'age' => '',
                'height' => $patient->height,
                'weight' => $patient->weight,
                'dob' => $patient->dob,
                'address' => '',
                'email' => $patient->email,
                'med' => $med,
                'doctor' => $book->doctor_name,
                'license' => $book->license,
                'dea' => $book->dea,
                'npi' => $book->npi,
                'specility' => $book->specility_id,
                'doc_id' => $book->doc_id,
                'number' => $number,
                'sex' => $patient->gender,
                'note' => $book->note
            ];

            $pdf = PDF::loadView('prescription', $data);
            // echo '7';
            $path = public_path('pdf/');
            //  echo '8';
            $fileName =  'prescription' . time() . '.' . 'pdf';
            //echo '9';
            $pdf->save($path . '/' . $fileName);

            // echo '10';
            $c = DB::table('prescription')->where('booking_id', $request->booking_id)->get();
            //echo '11';
            if (count($c) == 0) {
                DB::table('prescription')->insert([

                    "unique_id" => $number,
                    "booking_id" => $request->booking_id,
                    "prescription_path" => URL::to('pdf/' . $fileName)
                ]);

                return response()->json([
                    'success' => 1,
                    "message" => "prescription generated",
                    "prescription" => URL::to('pdf/' . $fileName)

                ], 200);
            } else {
                return response()->json([
                    'success' => 1,
                    "message" => "prescription already generated",


                ], 200);
            }
        }
    }



    public function  prescription_view(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $p = DB::table('prescription')
            ->where('booking_id', $request->booking_id)

            ->first();
        if (!$p) {
            return response()->json([
                'success' => 1,
                "message" => "No Prescription",

            ], 200);
        }
        return response()->json([
            'success' => 1,
            "message" => "prescription already generated",
            "prescription" => $p->prescription_path

        ], 200);
    }
    public function generate_token(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $book = Appointment::with('doctor')->where('id', $request->booking_id)->first();

        //$sid = 'AC1755380d57655fc9f24e9df05ede73e2';
        //$token = '7bc11440fe370956303cc05b89c91de4';
        $twilioAccountSid = 'AC1755380d57655fc9f24e9df05ede73e2';
        $twilioApiKey = 'SK742b2bf1c3070063ca9f69a75d2c1a70';
        $twilioApiSecret = 'L2fxUnhHgq4HLlkkm6duGZs4q5bnJnSo';

        // Required for Video grant
        $roomName = $book->room;
        // An identifier for your app - can be anything you'd like
        $identity =  getName(10);

        // Create access token, which we will serialize and send to the client
        $token = new AccessToken(
            $twilioAccountSid,
            $twilioApiKey,
            $twilioApiSecret,
            3600,
            $identity
        );

        /// Create Video grant
        $videoGrant = new VideoGrant();
        $videoGrant->setRoom($roomName);

        // Add grant to token
        $token->addGrant($videoGrant);

        // render token to string
        //echo $token->toJWT();

        return response()->json([
            'success' => 1,
            "message" => "Acess token for video call for doctor",
            "token" => $token->toJWT()

        ], 200);
    }
    public function message_history(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id', 'appointments.app_type', 'appointments.status','appointments.patient_id','appointments.payment_status', 'appointments.date', 'appointments.reason', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'appointments.reason', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.consultation_type', 'Chat')
            ->where('appointments.payment_status', '!=', null)
            ->whereDate('appointments.date', '<=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->orderBy('appointments.slot_start', 'DESC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));


            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds < 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->patient_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->patient_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }



                array_push($u, $row);
            }
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of  Appointments",
                "response" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No List of Appointments",

            ], 200);
        }
    }
    public function video_history(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id', 'appointments.app_type', 'appointments.status','appointments.patient_id','appointments.payment_status', 'appointments.date', 'appointments.reason', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'appointments.reason', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.consultation_type', 'Video')
            ->where('appointments.payment_status', '!=', null)
            ->whereDate('appointments.date', '<=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->orderBy('appointments.slot_start', 'DESC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));


            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds < 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->patient_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->patient_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }



                array_push($u, $row);
            }
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of  Appointments",
                "response" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No List of Appointments",

            ], 200);
        }
    }
    public function audio_history(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id', 'appointments.app_type', 'appointments.status','appointments.patient_id','appointments.payment_status', 'appointments.date', 'appointments.reason', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'appointments.reason', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.consultation_type', 'Audio')
            ->where('appointments.payment_status', '!=', null)
            ->whereDate('appointments.date', '<=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->orderBy('appointments.slot_start', 'DESC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));


            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds < 0) {
                $p = explode(' ', $row->patient_name);
                $row->patient_name = $p[0];
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image != '') {
                    $row->patient_image = URL::to('/') . '/' . $row->profile_image;
                } else {
                    $row->patient_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
                }



                array_push($u, $row);
            }
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of  Appointments",
                "response" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No List of Appointments",

            ], 200);
        }
    }
    public function video_upcoming_booking_list(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required',
            'type' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.consultation_type', 'appointments.app_type', 'appointments.date', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.status', 1)
            ->where('appointments.app_type', 'B')
            ->where('appointments.consultation_type', $request->type)
            ->join('users', 'users.id', 'appointments.patient_id')
            ->whereDate('appointments.date', '>=', date('Y/m/d'))

            ->orderBy('appointments.date', 'ASC')
            ->orderBy('appointments.slot_start', 'ASC')
            ->get();

        $u = [];
        foreach ($data as $row) {



            $date = new DateTime('now', new DateTimeZone($request->time_zone));



            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds > 0) {
                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image == '') {
                    $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
                } else {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                }


                array_push($u, $row);
            }
        }
        if ($u) {
            return response()->json([
                'success' => '1',
                "message" => "List of Appointments " . $request->type,
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No List of Appointments" . $request->type,

            ], 200);
        }
    }
    public function add_multiple_avl(Request $request)
    {



        $validation = Validator::make($request->all(), [
            'user_id' => 'required',
            'days' => 'required',
            'time_slots' => 'required',

            'time_slots.*.start_time'  => 'required',
            'time_slots.*.end_time'  => 'required|after:time_slots.*.start_time',



            'from_date' => 'required',
            'to_date' => 'required',

            'con_type' => 'required',
            'time_zone' => 'required'

        ], [
            'time_slots.*.end_time.after' => 'End Time must be greater than Start time'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $date_f = explode('-', $request->from_date);
        $date_t = explode('-', $request->to_date);

        $date_from = $date_f[2] . '-' . $date_f[0] . '-' . $date_f[1];
        $date_to = $date_t[2] . '-' . $date_t[0] . '-' . $date_t[1];




        if ($date_from < date('Y-m-d')) {
            return response()->json([
                'success' => '0',
                "message" => "Previous date booking not possible",
            ], 200);
        }





        if ($date_from == false) {
            return response()->json([
                'success' => '0',
                "message" => "From time is required",

            ], 200);
        }

        if ($date_to == false) {
            return response()->json([
                'success' => '0',
                "message" => "To time is required",

            ], 200);
        }





        $data_a = DB::table('users')->where('id', $request->user_id)->first();

        if ($data_a->fee_per_consultation == '') {
            return response()->json([
                'success' => '0',
                "message" => "Please enter consultation fees",
            ], 200);
        } else if ($data_a->status == 1) {
            return response()->json([
                'success' => '0',
                "message" => "You are not a appropved doctor",
            ], 200);
        } else {
        }





        $dates = getDatesFromRange($date_from, $date_to);



        $days = explode(',', $request->days);


        $u = [];
        foreach ($dates as $row) {
            foreach ($days as $d) {
                if (date('l', strtotime($row)) == $d) {
                    array_push($u, $row);
                }
            }
        }
        if (count($u) == 0) {
            return response()->json([
                'success' => '0',
                "message" => "Please choose proper days",

            ], 200);
        }
        if ($date_from ===  date('Y-m-d',)) {
            foreach ($request->time_slots as $i => $r) {
                date_default_timezone_set($request->time_zone);
                if (date('H:i') >= date('H:i', strtotime($r['start_time']))) {
                    return response()->json([
                        'success' => '0',
                        "message" => "Previous time schedule is not possible",

                    ], 200);
                }
            }
        }
        $array = $request->time_slots;
        $t = count($array);
        $a = [];
        $ord = array();
        foreach ($array as $key => $value) {
            $ord[] = strtotime($value['start_time']);
        }
        array_multisort($ord, SORT_ASC, $array);
        if ($t == 2) {
            if (date('H:i:s', strtotime($array[1]['start_time'])) <= date('H:i:s', strtotime($array[0]['end_time']))) {
                return response()->json([
                    'success' => '0',
                    "message" => "Schedule timing are overlaping with each other",

                ], 200);
            } else if (date('H:i:s', strtotime($array[1]['start_time'])) <= date('H:i:s', strtotime($array[0]['start_time'])) && date('H:i:s', strtotime($array[1]['end_time'])) >= date('H:i:s', strtotime($array[0]['end_time']))) {
                return response()->json([
                    'success' => '0',
                    "message" => "Schedule timing are overlaping with each other",

                ], 200);
            }
        } else {
            foreach ($array as $i => $r) {

                if ($i != $t - 1) {
                    for ($k = $i + 1; $k < $t; $k++) {
                        if (date('H:i:s', strtotime($array[$k]['start_time'])) >= date('H:i:s', strtotime($r['end_time']))) {
                            array_push($a, 1);
                        } else {
                            array_push($a, 2);
                        }
                    }
                }
            }

            $p = implode($a);

            if (str_contains($p, 2)) {
                return response()->json([
                    'success' => '0',
                    "message" => "Schedule timing are overlaping with each other",

                ], 200);
            }
        }







        foreach ($u as $r) {
            foreach ($array as $t) {
                if ($t['start_time'] != '') {
                    // echo $r;
                    $start_time =  date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone)));


                    $end_time =  date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone)));

                    if ($start_time <= $end_time) {
                        $data = DB::table('availability')->insert([
                            'user_id' => $request->user_id,
                            'day' => date('l', strtotime($r)),
                            'start_time' =>  date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))),
                            'end_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))),
                            'date' => $r,
                            'type' => $request->con_type


                        ]);
                    } else {
                        $da_c = DB::table('availability')->where('user_id', $request->user_id)->where('date', $r)->get();

                        if (count($da_c) == 0) {
                            // echo 5;
                            $data = DB::table('availability')->insert([
                                'user_id' => $request->user_id,
                                'day' => date('l', strtotime($r)),
                                'start_time' =>  date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))),
                                'end_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))),
                                'date' => $r,
                                'type' => $request->con_type


                            ]);
                        } else {

                            $da = DB::table('availability')->where('date', $r)->where('start_time', '>=', date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))))->get();


                            if (count($da) > 0) {
                                foreach ($da as $ta) {





                                    $dat = DB::table('availability')
                                        ->where('date', $r)
                                        ->where('start_time', '<=', date("H:i", strtotime($ta->start_time)))
                                        ->where('end_time', '>=', date("H:i", strtotime($ta->end_time)))
                                        ->get();


                                    if (count($dat) == 0) {
                                        //echo 1;
                                        $data = DB::table('availability')->insert([
                                            'user_id' => $request->user_id,
                                            'day' => date('l', strtotime($r)),
                                            'start_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))),
                                            'end_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))),
                                            'date' => $r,
                                            'type' => $request->con_type


                                        ]);
                                    } else {


                                        $sh =  DB::table('availability')->where('user_id', $request->user_id)->where('date', $r)
                                            ->where(function ($query) use ($t, $request) {

                                                $query->where('start_time', '<=',  date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))))
                                                    ->where('end_time', '>=',  date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))));
                                            })
                                            ->orWhere(function ($query) use ($t, $request) {

                                                $query->where('start_time', '<=',  date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))))
                                                    ->where('end_time', '>=',  date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))));
                                            })
                                            ->count();




                                        if ($sh == 0) {
                                            // echo 2;
                                            $data = DB::table('availability')->insert([
                                                'user_id' => $request->user_id,
                                                'day' => date('l', strtotime($r)),
                                                'start_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))),
                                                'end_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))),
                                                'date' => $r,
                                                'type' => $request->con_type


                                            ]);
                                        } else {
                                            // echo 3;
                                            return response()->json([
                                                'success' => '0',
                                                "message" => "You have already added a time schedule within the time range " . $t['start_time'] . " to " . $t['end_time'] . " you entered.",

                                            ], 200);
                                        }
                                    }
                                }
                            } else {
                                //echo 3;

                                //echo 1;
                                $data = DB::table('availability')->insert([
                                    'user_id' => $request->user_id,
                                    'day' => date('l', strtotime($r)),
                                    'start_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['start_time'], $request->time_zone))),
                                    'end_time' => date("H:i", strtotime(get_change_timezone_to_utc($t['end_time'], $request->time_zone))),
                                    'date' => $r,
                                    'type' => $request->con_type


                                ]);
                            }
                        }
                    }
                } else {
                    // echo 4;
                    return response()->json([
                        'success' => '0',
                        "message" => "You have already added a time schedule within the time range you entered. Please add other times that have not been entered.",
                    ], 200);
                }
            }
        }
        return response()->json([
            'success' => '1',
            "message" => "Doctor availability added successfully",

        ], 200);
    }
    public function save_note(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'note' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')->where('id', $request->booking_id)->update([
            'note' => $request->note,



        ]);
        return response()->json([
            'success' => '1',
            "message" => "Note saved successfully",

        ], 200);
    }
    public function get_note(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',



        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')->where('id', $request->booking_id)->first();
        return response()->json([
            'success' => '1',
            "message" => "Note saved successfully",
            "response" => $data

        ], 200);
    }
    public function order(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'order_id' => 'required',




        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }


        $co = DB::table('order')->where('booking_id', $request->booking_id)->first();


        if (!empty($co)) {
            return response()->json([
                'success' => 0,
                "message" => "Order already generated"
            ], 200);
        }





        $book = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.note', 'appointments.date', 'appointments.slot_end', 'users.name as patient_name', 'users.age', 'users.height', 'users.weight', 'users.email', 'users.address', 'users.dob', 'doctor.last_name as doctor_name', 'doctor.license', 'doctor.id as doc_id', 'doctor.certificate_name', 'doctor.npi', 'doctor.dea')
            ->where('appointments.id', $request->booking_id)
            ->join('users', 'users.id', 'appointments.patient_id')
            ->join('users as doctor', 'doctor.id', 'appointments.doctor_id')
            ->first();
        $order = DB::table('lab')->whereIn('id', explode(',', $request->order_id))->get();
        $users = json_decode(json_encode($order), true);
        $_add_on = array_column($users, 'lab');
        $order = implode(', ', $_add_on);

        if (str_contains($order, 'Others')) {

            if ($request->other_order == '') {
                return response()->json([
                    'success' => 0,
                    "message" => "Other order field is required"


                ], 200);
            }

            $order = str_replace('Others', $request->other_order,  $order);
            DB::table('lab')->insert([
                "lab" => $request->other_order,
                "status" => 1
            ]);
        }

        ini_set('memory_limit', '256M');

        $data = [
            'date' => date('m/d/Y'),
            'patient' => $book->patient_name,
            'age' => $book->age,
            'height' => $book->height,
            'weight' => $book->weight,
            'dob' => $book->dob,
            'address' => $book->address,
            'email' => $book->email,

            'doctor' => 'Dr.' . ' ' . ucfirst($book->doctor_name),
            'license' => $book->license,
            'dea' => $book->dea,
            'npi' => $book->npi,
            'specility' => str_replace(',', ', ', $book->certificate_name),
            'doc_id' => $book->doc_id,

            'order' => $order,
            'comment' => $request->comment,
            'note' => $book->note
        ];

        $pdf = PDF::loadView('order', $data);
        // echo '7';
        $path = public_path('pdf/');
        //  echo '8';
        $fileName =  'order' . time() . '.' . 'pdf';
        //echo '9';
        $pdf->save($path . '/' . $fileName);

        // echo '10';
        $c = DB::table('order')->where('booking_id', $request->booking_id)->where('status', 1)->first();
        //echo '11';
        if (empty($c)) {

            DB::table('order')->insert([

                "unique_id" => '',
                "booking_id" => $request->booking_id,
                "order" => $order,
                "comment" => $request->comment,
                "order_path" => URL::to('pdf/' . $fileName),
                "status" => 2,

            ]);

            return response()->json([
                'success' => 1,
                "message" => "Order generated",
                "order" => URL::to('pdf/' . $fileName)

            ], 200);
        } else {


            DB::table('order')->where('booking_id', $request->booking_id)->update([

                "unique_id" => '',
                "booking_id" => $request->booking_id,
                "order" => $order,
                "comment" => $request->comment,
                "order_path" => URL::to('pdf/' . $fileName),
                "status" => 2,

            ]);

            return response()->json([
                'success' => 1,
                "message" => "Order generated",
                "order" => URL::to('pdf/' . $fileName)

            ], 200);
        }
    }
    public function order_auto_save(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $order = DB::table('lab')->whereIn('id', explode(',', $request->order_id))->get();
        $users = json_decode(json_encode($order), true);
        $_add_on = array_column($users, 'lab');
        $order = implode(',', $_add_on);

        if (str_contains($order, 'Others')) {
            $order = str_replace('Others', $request->other_order,  $order);
            DB::table('lab')->insert([
                "lab" => $request->other_order,
                "status" => 1
            ]);
        }
        if ($request->comment == '') {
            $request->comment = '';
        }
        $c = DB::table('order')->where('booking_id', $request->booking_id)->where('status', 2)->get();
        if (count($c) == 0) {
            DB::table('order')->insert([
                "booking_id" => $request->booking_id,
                "order_path" => '',
                "order_id" => $request->order_id,
                "order" => $order,
                "comment" => $request->comment,
                "status" => 1
            ]);
        }


        return response()->json([
            'success' => 1,
            "message" => "Order auto saved"
        ], 200);
    }
    public function chk_order_details_by_id(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('order')->where('booking_id', $request->booking_id)->where('status', 1)->first();

        return response()->json([
            'success' => 1,
            "message" => "Order details",
            "response" => $data

        ], 200);
    }
    public function note_auto_save(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')->where('id', $request->booking_id)->update([
            'note' => $request->note,
        ]);
        return response()->json([
            'success' => '1',
            "message" => "Note auto saved successfully",

        ], 200);
    }
    public function treatments(Request $request)
    {

        $data = DB::table('treatments')->select('id', 'treatments')->get();
        return response()->json([
            'success' => '1',
            "message" => "All treatments",
            "response" => $data

        ], 200);
    }
    public function urgent_booking_list(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.patient_id', 'appointments.payment_status', 'appointments.date', 'appointments.app_type', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')

            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.status', 1)
            ->whereIn('appointments.payment_status', [1,3])
            ->where('appointments.app_type', 'Q')
            ->whereDate('appointments.date', '>=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'ASC')
            ->orderBy('appointments.slot_start', 'ASC')

            ->get();
        $u = [];
        foreach ($data as $row) {



            $date = new DateTime('now', new DateTimeZone($request->time_zone));
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));

            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;
            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);
            if ($result_in_seconds > 0) {



                //  $p = DB::table('users')->where('id', $row->patient_id)->first();

                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
                if ($row->profile_image == '') {
                    $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
                } else {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                }
                $k = explode(' ', $row->patient_name);
                $row->patient_name = $k[0];

                //  $row->patient_name = $p->name;

                array_push($u, $row);
            }
        }
        if ($u) {
            return response()->json([
                'success' => '1',
                "message" => "List of urgent appointments",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No list of urgent appointments",

            ], 200);
        }
    }

    public function  patient_search(Request $request)
    {
        $search = $request->keyword;
        $data = User::select('id', 'name', 'phone', 'profile_image', 'height', 'weight', 'age', 'status')->where('role', 2)->where('status', 1)->where('name', 'LIKE', "$search%")->orderBy('name', 'ASC')->get();


        $data1 = [];
        foreach ($data as $row) {

            if ($row->height == ' ' || $row->height === null) {
                $row->height = 'NA';
            } else {
                $row->height = $row->height . '"';
            }
            if ($row->weight == ' ' || $row->weight === null) {
                $row->weight = 'NA';
            }
            if ($row->age == ' ' || $row->age === null) {
                $row->age = 'NA';
            }

            if ($row->profile_image == '') {
                $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
            } else {
                $row->profile_image = URL::to('/') . '/' . $row->profile_image;
            }




            $row->about = substr($row->about, 0, 30);



            array_push($data1, $row);
        }




        if ($data1) {
            return response()->json([
                'success' => '1',
                "message" => "Patient lists",

                "response" =>  $data1
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No doctor found",
                "response" => $data1
            ], 200);
        }
    }

    public function patient_by_id(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'patient_id' => 'required'
        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = User::select('id', 'name', 'email', 'phone', 'profile_image', 'height', 'weight', 'age', 'status', 'allergy_id', 'address', 'sex as gender', 'dob', 'medication_id', 'lab_result', 'surgical_history_id', 'medical_id', 'surgical_images', 'lab_result_images', 'social_history_id', 'code', 'country', 'blood_gr', 'blood_suger_level')->where('role', 2)->where('status', 1)->where('id', $request->patient_id)->first();
        // 


        $data->dob = date('m-d-Y', strtotime($data->dob));




        $dpl = DB::table('allergies')->select('allergy')->whereIn('id', explode(',', $data->allergy_id))->get();


        $users = json_decode(json_encode($dpl), true);
        $_add_on = array_column($users, 'allergy');
        $data->allergy = implode(',', $_add_on);

        $dpl1 = DB::table('medication')->select('title')->whereIn('id', explode(',', $data->medication_id))->get();

        $dpl2 = DB::table('lab')->select('lab')->whereIn('id', explode(',', $data->lab_result))->get();

        $dpl3 = DB::table('surgeries')->select('surgery')->whereIn('id', explode(',', $data->surgical_history_id))->get();

        $dpl4 = DB::table('medical_history')->select('medical')->whereIn('id', explode(',', $data->medical_id))->get();

        $dpl5 = DB::table('social_history')->select('social_history')->whereIn('id', explode(',', $data->social_history_id))->get();




        $users1 = json_decode(json_encode($dpl1), true);
        $_add_on1 = array_column($users1, 'title');
        $data->medication = implode(',', $_add_on1);

        $users2 = json_decode(json_encode($dpl2), true);
        $_add_on2 = array_column($users2, 'lab');
        $data->lab_result = implode(',', $_add_on2);

        $users3 = json_decode(json_encode($dpl3), true);
        $_add_on3 = array_column($users3, 'surgery');
        $data->surgical_history = implode(',', $_add_on3);

        $users4 = json_decode(json_encode($dpl4), true);
        $_add_on4 = array_column($users4, 'medical');
        $data->medical_history = implode(',', $_add_on4);


        $users5 = json_decode(json_encode($dpl5), true);
        $_add_on5 = array_column($users5, 'social_history');
        $data->social_history = implode(',', $_add_on5);

        $data->surgical_images = explode(',', $data->surgical_images);
        $data->lab_result_images = explode(',', $data->lab_result_images);


        $data->date = date('m/d/Y', strtotime($data->date));


        if ($data->blood_gr == ' ' || $data->blood_gr === null) {
            $data->blood_gr = 'NA';
        }

        if ($data->blood_suger_level == ' ' || $data->blood_suger_level === null) {
            $data->blood_suger_level = 'NA';
        }



        if ($data->address == ' ' || $data->address === null) {
            $data->address = ' ';
        }

        if ($data->height == ' ' || $data->height === null) {
            $data->height = 'NA';
        } else {
            $data->height =  $data->height . '"';
        }
        if ($data->weight == ' ' || $data->weight === null) {
            $data->weight = 'NA';
        }
        if ($data->age == ' ' || $data->age === null) {
            $data->age = 'NA';
        }
        if ($data->gender == ' ' || $data->gender === null) {
            $data->gender = 'NA';
        }
        if ($data->phone == ' ' || $data->phone === null) {
            $data->phone = 'NA';
        }

        if ($data->profile_image == '') {
            $data->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
        } else {
            $data->profile_image = URL::to('/') . '/' . $data->profile_image;
        }



        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "Patient data",
                "test" => $data->code,

                "response" =>  $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No doctor found",

            ], 200);
        }
    }
    public function add_to_fav_d(Request $request)
    {
        $validation = Validator::make($request->all(), [


            'doctor_id' => 'required',
            'patient_id' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('favourites_d')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->first();

        if (!$data) {
            $d = DB::table('favourites_d')->insert([
                'doctor_id' => $request->doctor_id,
                'patient_id' => $request->patient_id
            ]);
            return response()->json([
                'success' => '1',
                "message" => "Patient added to favorite"

            ], 200);
        } else {
            DB::table('favourites_d')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->delete();
            return response()->json([
                'success' => '0',
                "message" => "Patient removed from favorite"

            ], 200);
        }
    }


    public function list_of_fav_patients(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'doctor_id' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $data = DB::table('favourites_d')->select('users.id', 'users.dob', 'users.name', 'users.phone', 'users.email', 'users.profile_image', 'users.status')->where('favourites_d.doctor_id', $request->doctor_id)->join('users', 'users.id', 'favourites_d.patient_id')->orderBy('favourites_d.id', 'DESC')->get();
        $data1 = [];
        foreach ($data as $row) {


            if ($row->profile_image == '') {
                $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
            } else {
                $row->profile_image = URL::to('/') . '/' . $row->profile_image;
            }

            // $row->profile_image = URL::to('/') . '/' . $row->profile_image;

            $row->dob = date('m-d-Y', strtotime($row->dob));

            array_push($data1, $row);
        }


        if ($data1) {
            return response()->json([
                'success' => '1',
                "message" => "Patient Favorite List",

                "response" =>  $data1
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No patient found",
                "response" => $data1
            ], 200);
        }
    }
    public function chk_fav_d(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'doctor_id' => 'required',
            'patient_id' => 'required'

        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $data = DB::table('favourites_d')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->first();

        if (!$data) {
            return response()->json([
                'success' => '0',
                "message" => "Favorite or not",
                "response" => false
            ], 200);
        } else {
            return response()->json([
                'success' => '1',
                "message" => "Favorite or not",
                "response" => true
            ], 200);
        }
    }

    public function quick_chat_list_upcoming(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }




        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.date', 'appointments.app_type', 'appointments.payment_status', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.app_type', 'Q')
            ->whereIn('appointments.payment_status', [1,3])


            ->whereDate('appointments.date', '>=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'ASC')
            ->orderBy('appointments.slot_start', 'ASC')

            ->get();
        $u = [];
        foreach ($data as $row) {



            $date = new DateTime('now', new DateTimeZone($request->time_zone));



            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            // $t = $date->format('Y-m-d h:i a');
            //$date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));

            //  $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds > 0) {
                //  $user = DB::table('users')->where('email', $row->patient_email)->first();

                if ($row->profile_image == '') {
                    $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
                } else {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                }

                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

                $k = explode(' ', $row->patient_name);
                $row->patient_name = $k[0];
                array_push($u, $row);
            }
        }
        if ($u) {
            return response()->json([
                'success' => '1',
                "message" => "List of appointments upcoming",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No list of appointments upcoming",

            ], 200);
        }
    }

    public function quick_chat_completed_list(Request $request)
    {


        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }



        $data = DB::table('appointments')
            ->select('appointments.id as booking_id', 'appointments.joined_d', 'appointments.joined_p', 'appointments.status', 'appointments.app_type', 'appointments.payment_status', 'appointments.date', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.name as patient_name', 'users.profile_image')
            ->where('appointments.doctor_id', $request->doctor_id)
            ->where('appointments.app_type', 'Q')
            ->whereIn('appointments.payment_status', [1,3])

            ->whereDate('appointments.date', '<=', date('Y/m/d'))
            ->join('users', 'users.id', 'appointments.patient_id')
            ->orderBy('appointments.date', 'DESC')
            ->orderBy('appointments.slot_start', 'DESC')
            ->get();
        $u = [];
        foreach ($data as $row) {
            $date = new DateTime('now', new DateTimeZone($request->time_zone));


            $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
            $t = $date->format('Y-m-d h:i a');

            $date2 = date('Y-m-d', strtotime($row->date));
            $start_time = date('h:i a', strtotime($oldDate));
            $p = $date2 . ' ' . $start_time;




            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

            $result_in_seconds = $to->diffInSeconds($from, false);





            if ($result_in_seconds < 0) {

                //   $user = DB::table('users')->where('email', $row->patient_email)->first();

                if ($row->profile_image == '') {
                    $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
                } else {
                    $row->profile_image = URL::to('/') . '/' . $row->profile_image;
                }

                $row->date = date('m/d/Y', strtotime($row->date));
                $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
                $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

                $o = chkOrder($row->booking_id);

                if ($row->status == 1) {
                    if ($row->joined_p == 1 && $row->joined_d == 1) {
                        $row->status = "Pending Prescription";
                    } else {
                        $row->status = "Prescription: NA";
                    }
                } else if ($row->status == 2) {
                    $row->status = "Prescription Generated";
                } else {
                    $row->status = "Cancelled";
                }
                if ($o != '') {
                    $row->order_path = $o;
                    $row->order = 'Order  Generated';
                } else if ($row->status == 'Cancelled') {
                    $row->order = "Cancelled";
                } else {
                    if ($row->joined_p == 1 && $row->joined_d == 1) {
                        $row->order = "Order Not Generated";
                    } else {
                        $row->order = "Order: NA";
                    }
                }
                $k = explode(' ', $row->patient_name);
                $row->patient_name = $k[0];




                array_push($u, $row);
            }
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of completed appointments",
                "data" => $u
            ], 200);
        } else {
            return response()->json([
                'success' => '',
                "message" => "No list of appointments",

            ], 200);
        }
    }


    public function booking_details_qc(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'booking_id' => 'required',
            'time_zone' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $a = DB::table('appointments')->select('appointments.*', 'patient.name as patient_name', 'patient.profile_image as patient_image', 'patient.height', 'patient.weight as weight', 'patient.sex as patient_gender', 'patient.medical_id', 'patient.surgical_images', 'patient.lab_result_images', 'patient.allergy_id', 'patient.medication_id', 'patient.surgical_history_id', 'patient.social_history_id', 'patient.lab_result', 'patient.blood_suger_level', 'patient.blood_gr', 'doctor.profile_image as doctor_image', 'doctor.last_name as doctor_name', 'doctor.id as doctor_id')->join('users as doctor', 'doctor.id', 'appointments.doctor_id')->join('users as patient', 'patient.id', 'appointments.patient_id')->where('appointments.id', $request->booking_id)->first();

        // $row = DB::table('quick_visit')->where('email', $a->patient_email)->first();

        $dpl = DB::table('allergies')->select('allergy')->whereIn('id', explode(',', $a->allergy_id))->get();


        $users = json_decode(json_encode($dpl), true);
        $_add_on = array_column($users, 'allergy');
        $a->allergy = implode(',', $_add_on);

        $dpl1 = DB::table('medication')->select('title')->whereIn('id', explode(',', $a->medication_id))->get();

        $dpl2 = DB::table('lab')->select('lab')->whereIn('id', explode(',', $a->lab_result))->get();

        $dpl3 = DB::table('surgeries')->select('surgery')->whereIn('id', explode(',', $a->surgical_history_id))->get();

        $dpl4 = DB::table('medical_history')->select('medical')->whereIn('id', explode(',', $a->medical_id))->get();

        $dpl5 = DB::table('social_history')->select('social_history')->whereIn('id', explode(',', $a->social_history_id))->get();

        $users1 = json_decode(json_encode($dpl1), true);
        $_add_on1 = array_column($users1, 'title');
        $a->medication = implode(',', $_add_on1);

        $users2 = json_decode(json_encode($dpl2), true);
        $_add_on2 = array_column($users2, 'lab');
        $a->lab_result = implode(',', $_add_on2);

        $users3 = json_decode(json_encode($dpl3), true);
        $_add_on3 = array_column($users3, 'surgery');
        $a->surgical_history = implode(',', $_add_on3);

        $users4 = json_decode(json_encode($dpl4), true);
        $_add_on4 = array_column($users4, 'medical');
        $a->medical_history = implode(',', $_add_on4);

        $users5 = json_decode(json_encode($dpl5), true);
        $_add_on5 = array_column($users5, 'social_history');
        $a->social_history = implode(',', $_add_on5);

        $a->surgical_images = explode(',', $a->surgical_images);
        $a->lab_result_images = explode(',', $a->lab_result_images);


        $a->date = date('m/d/Y', strtotime($a->created_at));
        $a->slot_start = date('g:i a', strtotime($a->slot_start));
        $a->slot_end = date('g:i a', strtotime($a->slot_end));



        $a->slot_start = date('g:i a', strtotime($a->slot_start));
        $a->slot_end = date('g:i a', strtotime($a->slot_end));


        $a->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($a->slot_start)), $request->time_zone);
        $a->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($a->slot_end)), $request->time_zone);




        $a->slot_start_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($a->slot_start)), $request->time_zone)));
        $a->slot_end_p = date('a', strtotime(get_change_utc_to_timezone(date('h:i a', strtotime($a->slot_end)), $request->time_zone)));


        $a->day = date('l', strtotime($a->date));
        $a->consultation_type = $a->consultation_type;
        $a->doctor_name = 'Dr. ' . ucfirst($a->doctor_name);

        if ($a->doctor_image == '') {
            $a->doctor_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
            $a->doctor_image = URL::to('/') . '/' . $a->doctor_image;
        }

        if ($a->patient_image == '') {
            $a->patient_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
            $a->patient_image = URL::to('/') . '/' . $a->patient_image;
        }
        if ($a->height == ' ' || $a->height === null) {
            $a->height = 'NA';
        } else {
            $a->height = $a->height . '"';
        }
        if ($a->weight == ' ' || $a->weight === null) {
            $a->weight = 'NA';
        }
        if ($a->blood_gr == ' ' || $a->blood_gr === null) {
            $a->blood_gr = 'NA';
        }
        if ($a->blood_suger_level == ' ' || $a->blood_suger_level === null) {
            $a->blood_suger_level = 'NA';
        }

        if ($a) {
            return response()->json([
                'success' => '1',
                "message" => "Booking details",
                "booking_id" => $request->booking_id,
                "data" => $a
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No booking details",

            ], 200);
        }
    }
    public function list_of_rating_reviews(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required'


        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $data = DB::table('rating')->select('rating.*', 'doctor.name as doctorName', 'patient.name as patientName', 'patient.profile_image as patientImage')->join('users as doctor', 'doctor.id', 'rating.doctor_id')->join('users as patient', 'patient.id', 'rating.patient_id')->where('doctor_id', $request->doctor_id)->where('complain', null)->orderBy('id', 'desc')->get();

        foreach ($data as $row) {

            if ($row->patientImage === '') {
                $row->patientImage = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
            } else {
                $row->patientImage = URL::to('/') . '/' . $row->patientImage;
            }





            //    $row->patientImage = URL::to('/') . '/' . $row->patientImage;

            $fdate = $row->created_at;
            $tdate = date('Y-m-d');
            $datetime1 = new DateTime($fdate);
            $datetime2 = new DateTime($tdate);
            $interval = $datetime1->diff($datetime2);
            $days = $interval->format('%a');
            $row->created_at =  $days;


            $result = array($days);

            $sub_struct_month = ($result[0] / 30);
            $sub_struct_month = floor($sub_struct_month);
            $sub_struct_days = ($result[0] % 30); // the rest of days


            if ($sub_struct_month != 0) {
                if ($sub_struct_month > 12) {
                    $p = $sub_struct_month - 12;
                    $y = $sub_struct_month / 12;
                    $y = intval($y);


                    $sub_struct = $y . "y " . $p . "m ago";
                } else {
                    $sub_struct = $sub_struct_month . "m " . $sub_struct_days . "d ago";
                }
            } else if ($sub_struct_days != 0) {
                $sub_struct = $sub_struct_days . "d ago";
            } else {


                $sub_struct =  'today';
            }


            $row->created_at = $sub_struct;
        }
        if ($data) {
            return response()->json([
                'success' => '1',
                "message" => "List of reviews",
                "data" => $data
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No list of reviews",
                "data" => $data
            ], 200);
        }
    }

    public function list_of_notes(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'booking_id' => 'required'



        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

        $a = DB::table('appointments')->where('id', $request->booking_id)->first();


        $n = DB::table('appointments')->where('doctor_id', $a->doctor_id)->where('patient_id', $a->patient_id)->where('note', '!=', null)->orderBy('id', 'DESC')->get();
        foreach ($n as $row) {
            $row->day = date('l', strtotime($row->date));
            $row->date = date('m-d-Y', strtotime($row->date));
        }

        if ($n) {
            return response()->json([
                'success' => '1',
                "message" => "List of notes",
                "data" => $n
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No list of notes",
                "data" => $n
            ], 200);
        }
    }
    public function list_of_notes_doctor(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'doctor_id' => 'required',
            'patient_id'=>'required'



        ]);
        if ($validation->fails()) {
            $errors = $validation->errors();

            return response()->json([
                'errors' => $errors
            ], 403);
        }

      


        $n = DB::table('appointments')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->where('note', '!=', null)->orderBy('id', 'DESC')->get();
        foreach ($n as $row) {
            $row->day = date('l', strtotime($row->date));
            $row->date = date('m-d-Y', strtotime($row->date));
        }

        if ($n) {
            return response()->json([
                'success' => '1',
                "message" => "List of notes",
                "data" => $n
            ], 200);
        } else {
            return response()->json([
                'success' => '0',
                "message" => "No list of notes",
                "data" => $n
            ], 200);
        }
    }
    public function addBankInStripeForDoctor(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'account_holder_name' => 'required',
            'account_number' => 'required',
            'routing_number' => 'required',
            'country' => 'required',
            'currency' => 'required',
            'ssn' => 'required',
            'phone' => 'required',
            'user_id' => 'required'
        ]);


        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 401);
        }
        $stripe = new \Stripe\StripeClient(
            'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
        );

        $u = User::find($request->user_id);
        if (!$u->id_stripe_account) {
            $customer = $stripe->customers->create([

                'description' => 'My First Test Customer (created for API docs at https://www.stripe.com/docs/api)',
            ]);
            $u->id_stripe_account = $customer->id;
            $u->save();
        }

        $acc = DB::table('account_details')->where('user_id', $request->user_id)->first();
        if (!empty($acc)) {
            if ($acc->account_number == $request->account_number || $acc->routing_number == $request->routing_number) {
                return response()->json([
                    'success' => '0',
                    "message" => "Account already created",

                ], 200);
            }
        }



        try {
            $account = $stripe->accounts->create(
                [
                    'country' => $request->country,
                    'type' => 'custom',
                    'capabilities' => [
                        'card_payments' => ['requested' => true],
                        'transfers' => ['requested' => true],
                    ],
                    'business_type' => 'individual',
                    'business_profile' => [
                        'mcc' => '5734',
                        'url' => 'https://success.com'
                    ],
                    'tos_acceptance' => [
                        'date' => time(),
                        'ip' => '127.0.0.1'
                    ],
                    'email' => $u->email,
                    'individual' => [
                        'first_name' => 'DoctorApp',
                        'last_name' => $u->name,
                        'address' => [
                            'city' => 'Fresno',
                            'country' => $request->country,
                            'state' => 'California',
                            'postal_code' => '93711',
                            'line1' => '695 Center Avenue',
                        ],
                        'phone' => $request->phone,
                        'dob' => [
                            'day' => 22,
                            'month' => 1,
                            'year' => 1993
                        ],
                        'ssn_last_4' => $request->ssn,
                        'email' => $u->email,
                    ],
                    'external_account' => array(
                        'object' => 'bank_account',
                        'country' => $request->country,
                        'currency' => $request->currency,
                        'account_holder_name' => $request->account_holder_name,
                        'account_holder_type' => "individual",
                        'routing_number' => $request->routing_number,
                        'account_number' => $request->account_number

                    )
                ]
            );

            $check_data_presence = DB::table('account_details')->where('user_id', $u->id)->get();
            if (count($check_data_presence) > 0) {




                $accountDetail =  DB::table('account_details')->where('user_id', $u->id)
                    ->update([
                        'account_holder_name' => $request->account_holder_name,
                        'account_number' => $request->account_number,
                        'routing_number' => $request->routing_number,
                        'country' => $request->country,
                        'currency' => $request->currency,
                        'ssn' => $request->ssn,
                        'phone' => $request->phone
                    ]);

                $account->status = 'old';
            } else {
                $accountDetail = new AccountDetails;
                $accountDetail->account_holder_name = $request->account_holder_name;
                $accountDetail->account_number = $request->account_number;
                $accountDetail->routing_number = $request->routing_number;
                $accountDetail->country = $request->country;
                $accountDetail->currency = $request->currency;
                $accountDetail->user_id = $request->user_id;
                $accountDetail->ssn = $request->ssn;
                $accountDetail->phone = $request->phone;
                $accountDetail->save();
                $account->status = 'new';
            }

            $u = User::find($request->user_id);
            $u->id_stripe_account = $account->id;
            $u->update();
            // return $account;
            return response()->json([
                'success' => '1',
                "message" => "Account created successfully",

            ], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }

    public function doctor_payment_details(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required'
        ]);

        $a = DB::table('appointments')->where('doctor_id', $request->user_id)->where('payment_status', 1)->count();


        $a_b = DB::table('users')->where('id', $request->user_id)->first();

        return response()->json([
            'success' => '1',
            "message" => "No list of notes",
            "total_no_of_booking" => $a,
            "available_balance" => $a_b->avl_bal
        ], 200);
    }


    public function withdrawl(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required',
            'amount' => 'required'
        ]);
        $a_b = DB::table('users')->where('id', $request->user_id)->first();

        if ($a_b->avl_bal < $request->amount) {
            return response()->json([
                'success' => '0',
                "message" => "Withdrawal amount can't be greater than available balance"

            ], 403);
        }
        $a = DB::table('withdrawl')->insert([
            'user_id' => $request->user_id,
            'withdrawl_amount' => $request->amount,
            'status' => 2,
            'created_at' => date('Y-m-d')
        ]);
        return response()->json([
            'success' => '1',
            "message" => "Withdrawal request send to admin"

        ], 200);
    }
    public function withdrawl_history(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required',

        ]);

        $a = DB::table('withdrawl')->where('user_id', $request->user_id)->orderBy('id', 'desc')->get();

        foreach ($a as $row) {
            if ($row->status == 2) {
                $row->status = 'Pending';
            } else if ($row->status == 3) {
                $row->status = 'Failed';
            } else {
                $row->status = 'Paid';
            }
            $row->created_at = date('m-d-Y', strtotime($row->created_at));
        }
        return response()->json([
            'success' => '1',
            "message" => "Withdrawal history list.",
            "data" => $a

        ], 200);
    }
    public function withdrawl_money(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required',
            'amount' => 'required'

        ]);
        $u = User::where('id', $request->user_id)->first();
        if ($u->avl_bal < $request->amount) {
            return response()->json([
                'success' => '0',
                "error" => "Withdrawal amount can't be greater than available balance"

            ], 403);
        }
        $check_data_presence = DB::table('account_details')->where('user_id', $u->id)->count();
        if ($check_data_presence == 0) {
            return response()->json([
                'success' => '0',
                "error" => "Please add your account details to transfer amount"

            ], 403);
        }

        $stripe = new \Stripe\StripeClient(
            'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
        );
        try {

            $stripe->transfers->create([
                'amount' => $request->amount * 100,
                'currency' => 'usd',
                'destination' => $u->id_stripe_account,
                "description" => 'test',
            ]);
            $u = User::find($request->user_id);
            $u->avl_bal = $u->avl_bal - $request->amount;
            $u->save();
            $a = DB::table('withdrawl')->insert([
                'user_id' => $request->user_id,
                'withdrawl_amount' => $request->amount,
                'status' => 1,
                'created_at' => date('Y-m-d')
            ]);
            return response()->json([
                'success' => '1',
                "message" => "Withdrawal successful"

            ], 200);
        } catch (\Exception $e) {

            $a = DB::table('withdrawl')->insert([
                'user_id' => $request->user_id,
                'withdrawl_amount' => $request->amount,
                'status' => 3,
                'created_at' => date('Y-m-d')
            ]);
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }

    public function account_details(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required'
        ]);




        $data = DB::table('account_details')->where('user_id', $request->user_id)->first();

        return response()->json([
            'success' => '1',
            "message" => "Account details",
            "response" => $data
        ], 200);
    }
    public function leave_doctor(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'booking_id' => 'required'
        ]);




        $data = DB::table('appointments')->where('id', $request->booking_id)->update([
            'joined_d' => 0,

        ]);

        return response()->json([
            'success' => '2',
            "message" => "Doctor Left",

        ], 200);
    }
    public function join_doctor(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'booking_id' => 'required'
        ]);




        $data = DB::table('appointments')->where('id', $request->booking_id)->update([
            'joined_d' => 1,

        ]);

        return response()->json([
            'success' => '1',
            "message" => "Doctor joined",

        ], 200);
    }
    public function request_for_multi_spl(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required'
        ]);




        $data = DB::table('users')->where('id', $request->user_id)->update([
            'multi' => 2,

        ]);

        return response()->json([
            'success' => '1',
            "message" => "Multi specialiity add request send",

        ], 200);
    }

    public function request_aprv(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'user_id' => 'required'
        ]);




        $data = DB::table('users')->where('id', $request->user_id)->first();
        if($data->multi == 1)
        {

            return response()->json([
                'success' => '1',
                "message" => "Multi specialiity add request appropved",
    
            ], 200);
        }
        else{
            return response()->json([
                'success' => '0',
                "message" => "Multi specialiity add request not-appropved",
    
            ], 200);
        }

    }
}
