<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\ColorCode;
use App\Models\Allergy;
use App\Models\Surgery;
use App\Models\Socialhistory;
use App\Models\Medication;
use App\Models\Lab;
use App\Models\Appointment;
use Illuminate\Support\Facades\URL;
use App\Models\MedicalHistory;
use DB;
use DateTime;
use \Carbon\Carbon;
use DateTimeZone;
use Twilio\Rest\Client;
use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VideoGrant;
use App\Models\ParentCat;
use App\Models\BodyPartCat;
use App\Models\BodyPartSubCat;
use App\Models\QuickVisit;
use Twilio\TwiML\VoiceResponse;
use Stripe;



class PatientController extends Controller
{
  public function profile_update(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
      'name' => 'required',
      'age' => 'required',
      'phone' => 'required',
      'location' => 'required',
      'gender' => 'required',
      'code' => 'required',
      'country' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    if ($request->dob > date('Y-m-d')) {
      return response()->json([
        'success' => 0,
        'message' => "Date of birth cant be grater than current date",

      ], 200);
    }
    $d = explode('-', $request->dob);

    $user = User::find($request->user_id);

    if ($request->hasFile('profile_image')) {
      $file_type = $request->file('profile_image')->extension();
      $file_path = $request->file('profile_image')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
      $request->file('profile_image')->move(public_path('images/doctors'), time() . '.' . $file_type);
      $user->profile_image =  $file_path;
    }

    $user->name = ucfirst($request->name);

    $user->phone = $request->phone;
    $user->address = $request->location;
    $user->sex = $request->gender;
    $user->dob = $d[2] . '-' . $d[0] . '-' . $d[1];
    $user->age = $request->age;
    $user->code = $request->code;
    $user->country = $request->country;
    $user->save();
    return response()->json([
      'success' => 1,
      'message' => "Patient profile updated successfully",

    ], 200);
  }
  public function color_code()
  {
    $data = ColorCode::select('id', 'color', 'type')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Color code List",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No active  color codes",
        "response" =>  $data
      ], 200);
    }
  }
  public function profile_details_patient(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'name', 'email', 'phone', 'address', 'sex as gender', 'dob', 'profile_image', 'age', 'height', 'weight', 'color_code', 'code', 'country')->where('id', $request->user_id)->where('role', 2)->first();



    if ($data->profile_image != '') {
      $data->profile_image = URL::to('/') . '/' . $data->profile_image;
    } else {

      $data->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
    }
    if ($data->dob != '') {
      $data->date_of_year = date('Y', strtotime($data->dob));

      $data->dob = date('m-d-Y', strtotime($data->dob));
    }


    if ($data->color_code == '') {
      $data->color_code = '';
    } else if ($data->color_code == 1) {
      $data->color_code = 'Red';
    } else if ($data->color_code == 2) {
      $data->color_code = 'Yellow';
    } else {
      $data->color_code = 'Green';
    }
    $f = explode(' ', $data->name);
    if (count($f) > 1) {
      $data->name = $f[0];
      $data->full_name = $f[0] . ' ' . $f[1];
    } else {

      $data->full_name = $data->name;
    }

    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Patient details",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function allergy()
  {
    $data = Allergy::select('id', 'allergy as name')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of allergy",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function surgical_history()
  {
    $data = Surgery::select('id', 'surgery as name')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of surgical history",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function social_history()
  {
    $data = Socialhistory::select('id', 'social_history as name')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of social history",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function medication()
  {
    $data = Medication::select('id', 'title as name', 'type', 'unit')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of medication",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function lab_history()
  {
    $data = Lab::select('id', 'lab as name')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of lab history",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }
  public function  medical_history()
  {
    $data = MedicalHistory::select('id', 'medical as name')->where('status', 1)->orderBy('id')->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of medical history",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>  $data
      ], 200);
    }
  }

  public function profile_details(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
      'feet' => 'required|numeric',
      'inch' => 'required|numeric',
      'weight' => 'required|numeric'



    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $user = User::find($request->user_id);
    //
    if (implode(',', $request->medical_history) != '') {
      if (implode(',', $request->medical_history) == 4) {
        $id = MedicalHistory::insertGetId([
          'medical' => $request->other_medical,
          'status' => 1
        ]);
        $user->medical_id = $id;
      } else {
        $user->medical_id = implode(',', $request->medical_history);
      }
    }
    //
    if (implode(',', $request->allergy) != '') {

      if (implode(',', $request->allergy) == 6) {
        $id = Allergy::insertGetId([
          'allergy' => $request->other_allergy,
          'status' => 1
        ]);
        $user->allergy_id = $id;
      } else {
        $user->allergy_id = implode(',', $request->allergy);
      }
    } else {
      $user->allergy_id = null;
    }

    //
    if (implode(',', $request->surgical_history) != '') {

      if (implode(',', $request->surgical_history) == 6) {
        $id = Surgery::insertGetId([
          'surgery' => $request->other_surgical_history,
          'status' => 1
        ]);
        $user->surgical_history_id = $id;
      } else {
        $user->surgical_history_id = implode(',', $request->surgical_history);
      }
    } else {
      $user->surgical_history_id = null;
    }

    //
    if (implode(',', $request->social_history) != '') {
      if (implode(',', $request->social_history) == 4) {
        $id = Socialhistory::insertGetId([
          'social_history' => $request->other_social_history,
          'status' => 1
        ]);
        $user->social_history_id = $id;
      } else {
        $user->social_history_id = implode(',', $request->social_history);
        $user->social_history_type = implode(',', $request->social_history_type);
        $user->frequency = implode(',', $request->frequency);
      }
    } else {
      $user->social_history_id  = null;
    }

    //
    if (implode(',', $request->lab_result) != '') {
      if (implode(',', $request->lab_result) == 4) {
        $id = Lab::insertGetId([
          'lab' => $request->other_lab,
          'status' => 1
        ]);
        $user->lab_result = $id;
      } else {
        $user->lab_result = implode(',', $request->lab_result);
      }
    } else {
      $user->lab_result  = null;
    }


    //
    if (implode(',', $request->medications) != '') {
      if (implode(',', $request->medications) == 4) {
        $id = Medication::insertGetId([
          'title' => $request->other_med,
          'status' => 1
        ]);
        $user->medication_id = $id;
      } else {
        $user->medication_id = implode(',', $request->medications);
      }
    } else {
      $user->medication_id  = null;
    }


    $images = $request->file('surgery_images');
    $imageName = '';
    if ($images) {
      foreach ($images as $img) {
        $file_type = $img->extension();
        // $new_name = rand() . '.' . $img->getClientOriginalExtension();
        $new_name = URL::to('/') . '/' . $img->storeAs('images/patients', rand() . '.' . $file_type, 'public');
        $img->move(public_path('/images/patients'), $new_name);
        $imageName = $imageName . $new_name . ",";
      }
      $imgDb = $imageName;
      if ($request->new_surgical_images == '') {
        $user->surgical_images = substr($imgDb, 0, -1);
      } else {
        $user->surgical_images = $request->new_surgical_images . ',' . substr($imgDb, 0, -1);
      }
    } else {
      $user->surgical_images = $request->new_surgical_images;
    }


    $images_lab = $request->file('lab_result_images');
    $imageNameLab = '';
    if ($images_lab) {
      foreach ($images_lab as $img) {
        $file_type = $img->extension();
        $new_name = URL::to('/') . '/' . $img->storeAs('images/patients', rand() . '.' . $file_type, 'public');
        $img->move(public_path('/images/patients'), $new_name);
        $imageNameLab = $imageNameLab . $new_name . ",";
      }
      $imgDbLab =  $imageNameLab;
      if ($request->new_lab_result_images == '') {
        $user->lab_result_images = substr($imgDbLab, 0, -1);
      } else {
        $user->lab_result_images = $request->new_lab_result_images . ',' . substr($imgDbLab, 0, -1);
      }
    } else {
      $user->lab_result_images = $request->new_lab_result_images;
    }


    $user->weight = $request->weight;
    $user->height = $request->feet . "'" . $request->inch;
    $user->blood_gr = $request->blood_gr;
    $user->blood_suger_level = $request->blood_suger_level;

    $user->save();
    return response()->json([
      'success' => '1',
      "message" => "Patient other details updated successfully",

    ], 200);
  }
  public function patient_allergy(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'allergy_id')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Allergy::select('id', 'allergy as name')->whereIn('id', explode(',', $data->allergy_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Allergy",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function patient_surgical_history(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'surgical_history_id')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Surgery::select('id', 'surgery as name')->whereIn('id', explode(',', $data->surgical_history_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Surgical History",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function patient_medical_history(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'medical_id')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = MedicalHistory::select('id', 'medical as name')->whereIn('id', explode(',', $data->medical_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Medical History",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function patient_medication(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'medication_id')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Medication::select('id', 'title as name', 'unit')->whereIn('id', explode(',', $data->medication_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Medication",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function patient_lab_history(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'lab_result')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Lab::select('id', 'lab as name')->whereIn('id', explode(',', $data->lab_result))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Lab Results",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function patient_surgical_images(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'surgical_images')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $data->surgical_images = explode(',', $data->surgical_images);





    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Surgical images",
        "response" =>   $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $data
      ], 200);
    }
  }
  public function patient_lab_result_images(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'lab_result_images')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }

    $data->lab_result_images = explode(',', $data->lab_result_images);

    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Patient lab result images",
        "response" =>   $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $data
      ], 200);
    }
  }
  public function patient_social_history(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'social_history_id', 'frequency', 'social_history_type')->where('id', $request->user_id)->where('role', 2)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $data->frequency = explode(',', $data->frequency);
    $data->social_history_type = explode(',', $data->social_history_type);

    $data['social_history'] = Socialhistory::select('id', 'social_history as name')->whereIn('id', explode(',', $data->social_history_id))->get();



    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Patients Social History",
        "response" =>   $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $data
      ], 200);
    }
  }
  public function patient_height_details(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'user_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'height', 'weight', 'blood_gr', 'blood_suger_level')->where('id', $request->user_id)->where('role', 2)->first();
    $hig = explode("'", $data->height);
    $data->feet = $hig[0];
    $data->inch =  $hig[1];

    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Patients Height,weight,blood group,blood sugar level",
        "response" =>   $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $data
      ], 200);
    }
  }
  public function doctor_search(Request $request)
  {
    $search = $request->keyword;
    $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->where('fee_per_consultation', '!=', '')->where('name', 'LIKE', "%$search%")->orderBy('name', 'ASC')->get();

    if (count($data) == 0) {
      $ser = DB::table('services')->where('name', 'LIKE', "$search%")->first();
      if (!$ser) {
        return response()->json([
          'success' => '0',
          "message" => "No doctor found",

        ], 200);
      }
      $search = $ser->id;
      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->where('fee_per_consultation', '!=', '')->orderBy('name', 'ASC')->get();
      $p = [];
      foreach ($data as $r) {
        $t = explode(',', $r->speciality);
        if (in_array($search, $t)) {
          array_push($p, $r);
        }
      }
      $data = $p;
    }

    $data1 = [];
    foreach ($data as $row) {

      $row->profile_image = URL::to('/') . '/' . $row->profile_image;

      $f = explode(',', $row->fee_per_consultation);
      $row->video_fee = $f[0];
      $row->audio_fee = $f[1];
      $row->chat_fee = $f[2];
      $row->rating = avg_rating($row->id);
      $row->avl_slots = getAvailability($row->id, $request->time_zone);
      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();

      $row->name = 'Dr. ' . ucfirst($row->name);
      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(',', $_add_on);
      $row->about = substr($row->about, 0, 30);


      array_push($data1, $row);
    }
    $names = array();

    foreach ($data1 as $key => $val) {

      $names[$key] = $val['avl_slots'];
    }

    array_multisort($names, SORT_DESC, $data1);


    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor List",
        "search_id" => $search,
        "response" =>  $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No doctor found",
        "response" => $data1
      ], 200);
    }
  }
  public function doctor_profile(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = User::select('id', 'last_name', 'email', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'consultation', 'experience')->where('role', 1)->where('id', $request->doctor_id)->first();
    if ($data->speciality != '') {
      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $data->speciality))->get();
      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $data->speciality = implode(', ', $_add_on);
    } else {
      $data->speciality = '';
    }

    $data->name = 'Dr. ' . ucfirst($data->last_name);


    if ($data->profile_image != '') {
      $data->profile_image = URL::to('/') . '/' . $data->profile_image;
    } else {
      $data->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
    }


    // $data->profile_image = URL::to('/') . '/' . $data->profile_image;

    $data->patient_count = patient_count($data->id);
    $data->review_count = review_count($data->id);
    $data->rating = avg_rating($data->id);
    $data->rating_count = review_count($data->id);
    if ($data->experience == '1 Years') {
      $data->experience = "1 Year";
    }
    return response()->json([
      'success' => '1',
      "message" => "Doctor Profile",
      "response" => $data
    ], 200);
  }
  public function location_search(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'keyword' => 'required',
    ], [
      'keyword.required' => "Keyword field is required"
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $search = $request->keyword;
    $lon1 = $request->long1;
    $lat1 = $request->lat1;

    $data = User::select('id', 'last_name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'specility_id as speciality', 'lat', 'lang', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->where('name', 'LIKE', "%$search%")->orderBy('consultation', 'DESC')->get();

    if (count($data) == 0) {
      $ser = DB::table('services')->where('name', 'LIKE', "%$search%")->first();
      if (!$ser) {
        return response()->json([
          'success' => '0',
          "errors" => "No data found",

        ], 200);
      }
      $search = $ser->id;
      $data = User::select('id', 'name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'lat', 'lang', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)
        ->orderBy('consultation', 'DESC')->get();

      $p = [];
      foreach ($data as $r) {
        $t = explode(',', $r->speciality);
        if (in_array($search, $t)) {
          array_push($p, $r);
        }
      }
      $data = $p;
    }

    // $data = DB::table('users')->select('id', 'name', 'email', 'phone', 'profile_image', 'about', 'specility_id as speciality', 'lat', 'lang')->where('role', 1)->where('status', 2)->get();
    $data1 = [];

    foreach ($data as $row) {

      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();
      $f = explode(',', $row->fee_per_consultation);
      //  echo 1;
      $row->rating = avg_rating($row->id);
      $row->avl_slots = getAvailability($row->id, $request->time_zone);

      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(',', $_add_on);
      // echo 2;

      $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      $row->about = substr($row->about, 0, 30);
      if ($row->lang != '') {
        $lon2 = $row->lang;
      }
      if ($row->lat != '') {
        $lat2 = $row->lat;
      }

      $unit =  intval($request->distance);

      //  echo 3;
      $theta = $lon1 - $lon2;
      $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));

      //   echo 4;
      $dist = acos($dist);
      $dist = rad2deg($dist);
      $miles = $dist * 60 * 1.1515;
      $unit = strtoupper($unit);


      $distance = round($miles * 1.609344);

      if ($distance <= $unit && count($f) == 3) {
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];

        $row->distance = $distance . 'KM';
        array_push($data1, $row);
      }
    }
    $names = array();

    foreach ($data1 as $key => $val) {

      $names[$key] = $val['avl_slots'];
    }

    array_multisort($names, SORT_DESC, $data1);


    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Nearest Doctors",
        "search_id" => $search,
        "response" => $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "errors" => "No Doctors Found",

      ], 200);
    }
  }
  public function  price_search(Request $request)
  {
    $search = $request->keyword;
    $validation = Validator::make($request->all(), [
      'type' => 'required',
      'price_range' => 'required',
      'keyword' => 'required'
    ], [

      'keyword.required' => 'Keyword field is required',
      'price_range.required' => 'Price field is required',
      'type.required' => 'Type field is required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    // $data = DB::table('users')->select('id', 'name', 'email', 'phone', 'profile_image', 'about', 'specility_id as speciality', 'fee_per_consultation')->where('role', 1)->where('status', 2)->orderBy('name','DESC')->get();
    $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'fee_per_consultation', 'consultation', 'status')->where('role', 1)->where('status', 2)->where('name', 'LIKE', "%$search%")->orderBy('consultation', 'DESC')->get();

    if (count($data) == 0) {
      $ser = DB::table('services')->where('name', 'LIKE', "%$search%")->first();
      if (!$ser) {
        return response()->json([
          'success' => '0',
          "message" => "No data found",

        ], 200);
      }
      $search = $ser->id;
      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->orderBy('consultation', 'DESC')->get();

      $p = [];
      foreach ($data as $r) {
        $t = explode(',', $r->speciality);
        if (in_array($search, $t)) {
          array_push($p, $r);
        }
      }
      $data = $p;
    }

    $data1 = [];
    foreach ($data as $row) {
      $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      $f = explode(',', $row->fee_per_consultation);

      if (count($f) != 3) {
        $row->video_fee = '';
        $row->audio_fee = '';
        $row->chat_fee = '';
      } else {
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
      }
      $row->name = 'Dr. ' . ucfirst($row->name);
      $row->rating = avg_rating($row->id);
      $row->avl_slots = getAvailability($row->id, $request->time_zone);
      $row->about = substr($row->about, 0, 30);

      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(',', $_add_on);


      if ($row->fee_per_consultation != '') {
        $fee = explode(',', $row->fee_per_consultation);
        if ($request->type == 'V') {
          if ($fee[0] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'A') {
          if ($fee[1] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'C') {
          if ($fee[2] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'V,A' || $request->type == 'A,V') {
          if ($fee[0] <= $request->price_range || $fee[1] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'A,C' || $request->type == 'C,A') {
          if ($fee[1] <= $request->price_range || $fee[2] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'C,V' || $request->type == 'V,C') {
          if ($fee[2] <= $request->price_range || $fee[0] <= $request->price_range) {

            array_push($data1, $row);
          }
        } elseif ($request->type == 'A,V,C') {
          if ($fee[2] <= $request->price_range || $fee[0] <= $request->price_range || $fee[1] <= $request->price_range) {

            array_push($data1, $row);
          }
        } else {
          if (count($fee) == 3) {
            array_push($data1, $row);
          }
        }
      }
    }
    $names = array();

    foreach ($data1 as $key => $val) {

      $names[$key] = $val['avl_slots'];
    }

    array_multisort($names, SORT_DESC, $data1);

    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Price Search Doctor List",
        "search_id" => $search,
        "response" => $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "errors" => "No Doctors Found",

      ], 200);
    }
  }
  public function booking(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'patient_id' => 'required',
      'spl_id' => 'required',
      'date' => 'required',
      'slot_start' => 'required',
      'slot_end' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $start_time = date('H:i', strtotime($request->slot_start));

    $end_time = date('H:i', strtotime($request->slot_end));


    $chk_b = Appointment::where('doctor_id', $request->doctor_id)
      ->where('patient_id', $request->patient_id)
      ->where('slot_start', get_change_timezone_to_utc($start_time, $request->time_zone))
      ->where('date', date('Y/m/d', strtotime($request->date)))
      ->first();
    if (empty($chk_b)) {
      $data = DB::table('payment_mode')->first();



      $doc = User::find($request->doctor_id);

      $apt = new Appointment;

      if ($doc->fee_per_consultation != '') {

        $fee = explode(',', $doc->fee_per_consultation);

        if ($request->consultation_type == 'Video') {

          $apt->room = getName(5);
          $feen = $fee[0];
        } elseif ($request->consultation_type == 'Audio') {
          $apt->room = getName(5);
          $feen = $fee[1];
        } else {

          $feen = $fee[2];
        }
      } else {
        $feen = null;
      }



      $apt->doctor_id = $request->doctor_id;
      $apt->patient_id = $request->patient_id;
      $apt->spl_id = 1;
      $apt->status = 1;
      $apt->consultation_type  = $request->consultation_type;
      $apt->slot_start = get_change_timezone_to_utc($start_time, $request->time_zone);
      $apt->slot_end = get_change_timezone_to_utc($end_time, $request->time_zone);
      $apt->fee = $feen;
      if ($doc->per_con == '') {
        $apt->admin_fee = ($feen * g_commission()) / 100;
      } else {
        $apt->admin_fee = ($feen * $doc->per_con) / 100;
      }

      $apt->doctor_fee = $feen - $apt->admin_fee;
      $apt->date = date('Y/m/d', strtotime($request->date));
      $apt->patient_email = $request->patient_email;
      if ($request->patient_email != '') {
        $apt->app_type = "Q";
      } else {
        $apt->app_type = "B";
      }



      if ($data->status == 0) {
        $apt->payment_status = 3;
        $user = User::find($request->doctor_id);
        $user->consultation = $user->consultation + 1;

        $user->save();
      }



      $apt->save();

      $doctor = User::where('id', $request->doctor_id)->first();


      return response()->json([
        'success' => '1',
        "message" => "Appointment Booked",
        "booking_date" => date('d', strtotime($request->date)) . ' ' . date('M', strtotime($request->date)) . ' ' . date('Y', strtotime($request->date)),
        "booking_time" => date('l', strtotime($request->date)) . ', ' . date('h:i a', strtotime($request->slot_start)),
        "doctor_name" => 'Dr.' . ' ' . ucfirst($doctor->name) . ' ' . ucfirst($doctor->last_name),
        "doctor_image" => URL::to('/') . '/' . $doctor->profile_image,
        "consultation" => $apt->consultation_type,
        "fee" => $apt->fee,
        "booking_id" => $apt->id

      ], 200);
    } else {
      if ($chk_b->payment_status != 1) {

        $doc = User::find($request->doctor_id);

        // $apt = new Appointment;

        if ($doc->fee_per_consultation != '') {

          $fee = explode(',', $doc->fee_per_consultation);

          if ($request->consultation_type == 'Video') {


            $feen = $fee[0];
          } elseif ($request->consultation_type == 'Audio') {

            $feen = $fee[1];
          } else {

            $feen = $fee[2];
          }
        } else {
          $feen = null;
        }

        $apt = Appointment::find($chk_b->id);
        $apt->consultation_type = $request->consultation_type;
        $apt->fee = $feen;
        if ($doc->per_con == '') {
          $apt->admin_fee = ($feen * g_commission()) / 100;
        } else {
          $apt->admin_fee = ($feen * $doc->per_con) / 100;
        }

        $apt->doctor_fee = $feen - $apt->admin_fee;

        $apt->save();




        $doctor = User::where('id', $request->doctor_id)->first();

        return response()->json([
          'success' => '0',
          "message" => "Booked but Payment Pending",
          "booking_date" => date('d', strtotime($request->date)) . ' ' . date('M', strtotime($request->date)) . ' ' . date('Y', strtotime($request->date)),
          "booking_time" => date('l', strtotime($request->date)) . ', ' . date('H:i', strtotime($request->slot_start)),
          "doctor_name" => 'Dr. ' . ucfirst($doctor->name) . ' ' . ucfirst($doctor->last_name),
          "doctor_image" => URL::to('/') . '/' . $doctor->profile_image,
          "consultation" => $request->consultation_type,

          "fee" => $feen,
          "booking_id" => $chk_b->id

        ], 200);
      } else {
        return response()->json([
          'success' => '0',
          "message" => "Already Booked",
        ], 200);
      }
    }
  }
  public function per_doc_spl(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'doc_id' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('users')->select('id', 'name',  'specility_id as speciality')->where('id', $request->doc_id)->where('role', 1)->first();
    if ($data) {
      $dpl = DB::table('services')->select('id', 'name')->whereIn('id', explode(',', $data->speciality))->get();
      return response()->json([
        'success' => '1',
        "message" => "Per Doctor Speciality",
        "response" => $dpl
      ], 200);
    } else {
      return response()->json([
        'success' => '1',
        "message" => "No data found",

      ], 200);
    }
  }
  public function booking_patient_details_update(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'booking_id' => 'required',
      'feet' => 'required',
      'inch' => 'required',
      'weight' => 'required',
      'age' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data = Appointment::find($request->booking_id);
    $data->problem = $request->problem;
    $data->save();


    $user = User::find($data->patient_id);
    $user->name = $request->name;

    $user->phone = $request->phone;

    $user->sex = $request->gender;
    $user->age = $request->age;
    $user->weight = $request->weight;
    $user->height = $request->feet . "'" . $request->inch;
    $user->blood_gr = $request->blood_gr;
    $user->blood_suger_level = $request->blood_suger_level;
    if ($request->allergy != '') {

      if ($request->allergy == 6) {
        $id = Allergy::insertGetId([
          'allergy' => $request->other_allergy,
          'status' => 1
        ]);
        $user->allergy_id = $id;
      } else {
        $user->allergy_id = $request->allergy;
      }
    }
    if ($request->medications != '') {
      if ($request->medications == 4) {
        $id = Medication::insertGetId([
          'title' => $request->other_med,
          'status' => 1
        ]);
        $user->medication_id = $id;
      } else {
        $user->medication_id =  $request->medications;
      }
    }
    $user->save();

    return response()->json([
      'success' => '1',
      "message" => "Booking Updated with patient details",

    ], 200);
  }


  public function accepted_booking_list(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }



    $data = DB::table('appointments')
      ->select('appointments.id as booking_id', 'appointments.app_type', 'appointments.date', 'appointments.status', 'appointments.consultation_type', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.last_name as doctor_name', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->whereIn('appointments.payment_status', [1, 3])
      ->where('appointments.status', 1)

      ->whereDate('appointments.date', '>=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')

      ->orderBy('appointments.date', 'ASC')
      ->orderBy('appointments.slot_start', 'ASC')

      ->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));



      $t = $date->format('Y-m-d h:i a');

      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds > 0) {

        $row->date = date('m/d/Y', strtotime($row->date));
        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

        if ($row->profile_image == '') {
          $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        }

        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);

        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Accepted Appointments of Patients",
        "data" => $u
      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }




  public function upcoming_booking_list_qc(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_email' => 'required',
      'time_zone' => 'required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }



    $data = DB::table('appointments')
      ->select('appointments.id as booking_id', 'appointments.app_type', 'patient.profile_image as patient_image', 'patient.name as patient_name', 'appointments.payment_status', 'appointments.app_type', 'appointments.date', 'appointments.status', 'appointments.consultation_type', 'appointments.slot_start', 'appointments.slot_end', 'users.last_name as doctor_name', 'users.profile_image', 'users.id as doctor_id')
      ->where('appointments.patient_email', $request->patient_email)
      ->where('appointments.app_type', 'Q')
      ->whereIn('appointments.payment_status', [1, 3])
      ->where('appointments.status', '!=', 3)
      ->whereDate('appointments.date', '>=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->join('users as patient', 'patient.id', 'appointments.patient_id')
      ->orderBy('appointments.date', 'ASC')
      ->orderBy('appointments.slot_start', 'ASC')
      ->get();



    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));



      $t = $date->format('Y-m-d h:i a');

      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds > 0) {
        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);
        $row->date = date('m/d/Y', strtotime($row->date));

        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
        // $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        if ($row->profile_image == '') {
          $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        }


        $row->patient_image = URL::to('/') . '/' . $row->patient_image;
        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Upcoming Appointments of Patients for quick chat bot",
        "data" => $u
      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }


  public function completed_booking_list(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('appointments')
      ->select('appointments.id as booking_id', 'appointments.joined_d', 'appointments.joined_p', 'appointments.app_type', 'appointments.status', 'appointments.date', 'appointments.consultation_type', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.last_name as doctor_name', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->whereIn('appointments.payment_status', [1, 3])

      ->whereDate('appointments.date', '<=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('appointments.date', 'DESC')
      ->orderBy('appointments.slot_start', 'DESC')
      ->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));

      //date('h:i a', strtotime($row->slot_end))
      //date_default_timezone_set($request->time_zone);


      // echo date("H:i:s", strtotime($row->slot_end));
      $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $t = $date->format('Y-m-d h:i a');



      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = date('h:i a', strtotime($oldDate));
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds < 0) {


        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);

        $row->date = date('m/d/Y', strtotime($row->date));
        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

        if ($row->profile_image == '') {
          $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        }
        if ($row->status == 1) {


          if ($row->joined_p == 1 && $row->joined_d == 1) {
            $row->status = "Pending Prescription";
          } else {
            $row->status = "Prescription: NA";
          }
        } elseif ($row->status == 2) {
          $row->status = "Prescription Generated";
        } else {
          $row->status = "Cancelled";
        }


        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Completed Appointments",
        "data" => $u
      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }
  public function consultation_search(Request $request)
  {
    $validation = Validator::make(
      $request->all(),
      [
        'keyword' => 'required',
      ],
      [
        'keyword.required' => 'Keyword field is required'

      ]
    );
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $search = $request->keyword;
    $counsultation = $request->counsultation;

    if ($counsultation == 'low') {

      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'specility_id as speciality', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->where('name', 'LIKE', "%$search%")->orderBy('consultation', 'ASC')->get();
    } else {

      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'specility_id as speciality', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->where('name', 'LIKE', "%$search%")->orderBy('consultation', 'DESC')->get();
    }
    if (count($data) == 0) {
      $ser = DB::table('services')->where('name', 'LIKE', "%$search%")->first();
      if (!$ser) {
        return response()->json([
          'success' => '0',
          "errors" => "No data found",

        ], 200);
      }
      $search = $ser->id;

      if ($counsultation == 'low') {
        $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->orderBy('consultation', 'ASC')->get();
        $p = [];
        foreach ($data as $r) {
          $t = explode(',', $r->speciality);
          if (in_array($search, $t)) {
            array_push($p, $r);
          }
        }
        $data = $p;
      } else {

        $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->orderBy('consultation', 'DESC')->get();

        $p = [];
        foreach ($data as $r) {
          $t = explode(',', $r->speciality);
          if (in_array($search, $t)) {
            array_push($p, $r);
          }
        }
        $data = $p;
      }
    }

    // $data = DB::table('users')->select('id', 'name', 'email', 'phone', 'profile_image', 'about', 'specility_id as speciality', 'lat', 'lang')->where('role', 1)->where('status', 2)->get();
    $data1 = [];

    foreach ($data as $row) {

      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(',', $_add_on);


      $row->profile_image = URL::to('/') . '/' . $row->profile_image;

      $f = explode(',', $row->fee_per_consultation);
      if (count($f) == 3) {
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
        $row->rating = avg_rating($row->id);
        $row->avl_slots = getAvailability($row->id, $request->time_zone);
        $row->about = substr($row->about, 0, 30);
        $row->name = 'Dr. ' . ucfirst($row->name);
        array_push($data1, $row);
      }
    }

    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor List According to consultation",
        "search_id" => $search,
        "response" => $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "errors" => "No Doctors Found",

      ], 200);
    }
  }
  public function prescription_list(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $book = DB::table('appointments')
      ->select('appointments.*', 'prescription.id as prescription_id', 'prescription.booking_id', 'prescription.prescription_path', 'users.name as doctor', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->join('prescription', 'prescription.booking_id', 'appointments.id')
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('prescription.id', 'desc')
      ->get();
    $data1 = [];

    foreach ($book as $row) {

      if ($row->profile_image == '') {
        $row->profile_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
      } else {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      }


      //$row->profile_image = URL::to('/') . '/' . $row->profile_image;
      $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
      $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $row->day = date('l', strtotime($row->date));
      $row->date = date('m/d/Y', strtotime($row->date));
    }
    return response()->json([
      'success' => '1',
      "message" => "Prescription List",
      "response" =>   $book,

    ], 200);
  }
  public function order_list(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $book = DB::table('appointments')
      ->select('appointments.*', 'order.id as order_id', 'order.booking_id', 'order.order_path', 'users.name as doctor', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->join('order', 'order.booking_id', 'appointments.id')
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('order.id', 'desc')
      ->get();
    $data1 = [];

    foreach ($book as $row) {
      //  $row->profile_image = URL::to('/') . '/' . $row->profile_image;

      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }

      $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
      $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $row->day = date('l', strtotime($row->date));
      $row->date = date('m/d/Y', strtotime($row->date));
    }
    return response()->json([
      'success' => '1',
      "message" => "Order List",
      "response" =>   $book,

    ], 200);
  }
  public function booking_details_patient(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'booking_id' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $book = DB::table('appointments')
      ->select('appointments.*', 'doctor.last_name as doctor', 'doctor.profile_image as doctor_image', 'doctor.experience as doctor_exp', 'patient.profile_image as patient_img', 'patient.name as patient_name', 'patient.age as patient_age', 'patient.phone as patient_phone', 'patient.code as patient_code', 'patient.country as patient_country')
      ->where('appointments.id', $request->booking_id)
      ->join('users as patient', 'patient.id', 'appointments.patient_id')
      ->join('users as doctor', 'doctor.id', 'appointments.doctor_id')
      ->first();


    $book->doctor = 'Dr. ' . ucfirst($book->doctor);
    if ($book->doctor_image == '') {
      $book->doctor_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
    } else {
      $book->doctor_image = URL::to('/') . '/' . $book->doctor_image;
    }

    $book->date = date('m/d/Y', strtotime($book->date));
    // $book->slot_start = date('h:i a', strtotime($book->slot_start));
    // $book->slot_end = date('h:i a', strtotime($book->slot_end));

    $book->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($book->slot_start)), $request->time_zone);
    $book->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($book->slot_end)), $request->time_zone);

    if ($book->patient_img == '') {
      $book->patient_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
    } else {
      $book->patient_image = URL::to('/') . '/' . $book->patient_img;
    }


    //  $book->patient_image = URL::to('/') . '/' . $book->patient_img;
    $book->slot_end_p = date('a', strtotime($book->slot_end));
    $book->slot_start_p = date('a', strtotime($book->slot_start));
    $book->day = date('l', strtotime($book->date));
    $book->review_count = review_count($book->doctor_id);
    $book->rating = avg_rating($book->doctor_id);

    $book->patient_count = patient_count($book->doctor_id);

    return response()->json([
      'success' => '1',
      "message" => "Booking details for patient",
      "response" =>   $book,

    ], 200);
  }
  public function doctor_details_for_rating_page(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'booking_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $book = DB::table('appointments')
      ->select('doctor.last_name as doctor', 'doctor.profile_image as doctor_image')
      ->where('appointments.id', $request->booking_id)
      ->join('users as doctor', 'doctor.id', 'appointments.doctor_id')
      ->first();


    $book->doctor = 'Dr. ' . ' ' . ucfirst($book->doctor);
    $book->doctor_image = URL::to('/') . '/' . $book->doctor_image;
    return response()->json([
      'success' => '1',
      "message" => "Doctor Details For Rating Review Page",
      "response" => $book,

    ], 200);
  }
  public function rating_review_post(Request $request)
  {
    if ($request->type == 'R') {
      $validation = Validator::make($request->all(), [
        'doctor_id' => 'required',
        'patient_id' => 'required',
        'rating' => 'required',
        'review' => 'required'

      ], [
        'review.required' => 'Review field is required'
      ]);
      $rating =  $request->rating;
    } else {
      $validation = Validator::make($request->all(), [
        'doctor_id' => 'required',
        'patient_id' => 'required',

        'complain' => 'required'

      ], [
        'complain.required' => 'Complain field is required'
      ]);
      $rating =  0;
    }


    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    DB::table('rating')->insert([
      'doctor_id' => $request->doctor_id,
      'patient_id' => $request->patient_id,
      'rating' => $rating,
      'review' => $request->review,
      'complain' => $request->complain,
      "created_at" => date('Y-m-d H:i:s')
    ]);
    if ($request->type == 'R') {
      $msg = "Rating review given sucessfully";
    } else {
      $msg = "Complain given sucessfully";
    }
    return response()->json([
      'success' => '1',
      "message" => $msg,


    ], 200);
  }
  public function rating_search(Request $request)
  {
    $search = $request->keyword;
    $validation = Validator::make($request->all(), [


      'keyword' => 'required',
      'rating' => 'required',
    ], [
      'keyword.required' => 'Keyword field is required',
      'rating.required' => 'Rating field is required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'fee_per_consultation', 'consultation', 'status')->where('role', 1)->where('status', 2)->where('name', 'LIKE', "%$search%")->orderBy('consultation', 'DESC')->get();

    if (count($data) == 0) {
      $ser = DB::table('services')->where('name', 'LIKE', "%$search%")->first();
      if (!$ser) {
        return response()->json([
          'success' => '0',
          "message" => "No data found",

        ], 200);
      }
      $search = $ser->id;
      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'fee_per_consultation', 'consultation')->where('role', 1)->where('status', 2)->where('specility_id', 'LIKE', "%$search%")->orderBy('consultation', 'DESC')->get();
      $p = [];
      foreach ($data as $r) {
        $t = explode(',', $r->speciality);
        if (in_array($search, $t)) {
          array_push($p, $r);
        }
      }
      $data = $p;
    }

    $data1 = [];
    foreach ($data as $row) {
      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(',', $_add_on);


      $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      $f = explode(',', $row->fee_per_consultation);



      if (count($f) == 3 && avg_rating($row->id) >= $request->rating) {
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
        $row->rating = avg_rating($row->id);
        $row->avl_slots = getAvailability($row->id, $request->time_zone);
        $row->about = substr($row->about, 0, 30);
        $row->name = 'Dr. ' . ucfirst($row->name);
        array_push($data1, $row);
      }
    }
    return response()->json([
      'success' => '1',
      "message" => "List of Doctors",
      "response" => $data1


    ], 200);
  }

  public function generate_token_p(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'booking_id' => 'required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $book = Appointment::with('patient')->where('id', $request->booking_id)->first();

    if ($book->patient_id == 0) {
      $status = 'non registered';
    } else {
      $status = 'registered';
    }

    //$sid = 'AC1755380d57655fc9f24e9df05ede73e2';
    //$token = '7bc11440fe370956303cc05b89c91de4';
    $twilioAccountSid = 'AC1755380d57655fc9f24e9df05ede73e2';
    $twilioApiKey = 'SK742b2bf1c3070063ca9f69a75d2c1a70';
    $twilioApiSecret = 'L2fxUnhHgq4HLlkkm6duGZs4q5bnJnSo';

    // Required for Video grant
    $roomName = $book->room;
    // An identifier for your app - can be anything you'd like
    $identity =  getName(10);

    // Create access token, which we will serialize and send to the client
    $token = new AccessToken(
      $twilioAccountSid,
      $twilioApiKey,
      $twilioApiSecret,
      3600 * 24,
      $identity
    );

    // Create Video grant
    $videoGrant = new VideoGrant();
    $videoGrant->setRoom($roomName);

    // Add grant to token
    $token->addGrant($videoGrant);

    // render token to string
    //echo $token->toJWT();

    return response()->json([
      'success' => 1,
      "message" => "Acess token for video call for patient",
      "patient_status" => $status,
      "token" => $token->toJWT()

    ], 200);
  }
  public function prescription_medicines(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'prs_id' => 'required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $p = DB::table('prescription')->where('id', $request->prs_id)->first();
    $med = DB::table('doc_medicine')->select('doc_medicine.id', 'doc_medicine.medicine', 'doc_medicine.course', 'doc_medicine.dose', 'doc_medicine.course', 'doc_medicine.brief', 'doc_medicine.frequency', 'routes.route_name')
      ->join('routes', 'routes.id', 'doc_medicine.route_id')
      ->where('doc_medicine.booking_id', $p->booking_id)
      ->get();
    foreach ($med as $row) {
      $row->course = $row->course . ' Days';
    }

    return response()->json([
      'success' => 1,
      "message" => "Medicines List",
      "medicines" => $med

    ], 200);
  }
  public function medicine_change(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'med_id' => 'required',
      'booking_id' => 'required'

    ], [
      'med_id.required' => 'Medicine field is required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $t = DB::table('change_medicine')->where('booking_id', $request->booking_id)->first();
    if ($t) {
      $p = DB::table('change_medicine')->where('booking_id', $request->booking_id)->update([
        "medicine_id" => $request->med_id,
        "booking_id" => $request->booking_id
      ]);
    } else {
      $p = DB::table('change_medicine')->insert([
        "medicine_id" => $request->med_id,
        "booking_id" => $request->booking_id
      ]);
    }

    return response()->json([
      'success' => 1,
      "message" => "Medicines Change Request Send",
    ], 200);
  }
  public function chat_end(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'booking_id' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $p = Appointment::select('appointments.id', 'appointments.patient_id', 'appointments.consultation_type', 'appointments.doctor_id', 'users.last_name as doctor_name', 'users.profile_image as doctor_image')->where('appointments.id', $request->booking_id)->join('users', 'users.id', 'appointments.doctor_id')->first();
    $p->call_time = time_slot();
    $p->call_time = $p->call_time;


    $p->call_time = $p->call_time . ' ' . 'minute';

    $p->doctor_name = 'Dr. ' . ' ' . ucfirst($p->doctor_name);

    $p->doctor_image =  URL::to('/') . '/' . $p->doctor_image;


    return response()->json([
      'success' => 1,
      "message" => "Call end give review",
      "response" => $p
    ], 200);
  }
  public function doctor_search_with_spl()
  {

    $book = DB::table('services')->select('id', 'name')->get();
    return response()->json([
      'success' => 1,
      "message" => "Speciality List",
      "response" => $book
    ], 200);
  }
  public function message_history(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('appointments')
      ->select('appointments.id', 'appointments.app_type', 'appointments.status', 'appointments.date', 'appointments.consultation_type', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.id as doctor_id', 'users.last_name as doctor_name', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->where('appointments.consultation_type', 'Chat')
      ->whereIn('appointments.payment_status', [1, 3])

      ->whereDate('appointments.date', '<=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('appointments.date', 'DESC')
      ->orderBy('appointments.slot_start', 'DESC')
      ->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));


      $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $t = $date->format('Y-m-d h:i a');



      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = date('h:i a', strtotime($oldDate));
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds < 0) {


        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);

        $row->date = date('m/d/Y', strtotime($row->date));
        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

        if ($row->profile_image == '') {
          $row->doctor_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->doctor_image = URL::to('/') . '/' . $row->profile_image;
        }



        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Completed Appointments",
        "response" => $u

      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }
  public function video_history(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('appointments')
      ->select('appointments.id', 'appointments.app_type', 'appointments.status', 'appointments.date', 'appointments.consultation_type', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.id as doctor_id', 'users.last_name as doctor_name', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->where('appointments.consultation_type', 'Video')
      ->whereIn('appointments.payment_status', [1, 3])

      ->whereDate('appointments.date', '<=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('appointments.date', 'DESC')
      ->orderBy('appointments.slot_start', 'DESC')
      ->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));


      $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $t = $date->format('Y-m-d h:i a');



      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = date('h:i a', strtotime($oldDate));
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds < 0) {


        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);

        $row->date = date('m/d/Y', strtotime($row->date));
        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

        if ($row->profile_image == '') {
          $row->doctor_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->doctor_image = URL::to('/') . '/' . $row->profile_image;
        }



        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Completed Appointments",
        "response" => $u
      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }

  public function audio_history(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('appointments')
      ->select('appointments.id', 'appointments.app_type', 'appointments.status', 'appointments.date', 'appointments.consultation_type', 'appointments.payment_status', 'appointments.slot_start', 'appointments.slot_end', 'users.id as doctor_id', 'users.last_name as doctor_name', 'users.profile_image')
      ->where('appointments.patient_id', $request->patient_id)
      ->where('appointments.consultation_type', 'Audio')
      ->whereIn('appointments.payment_status', [1, 3])

      ->whereDate('appointments.date', '<=', date('Y/m/d'))
      ->join('users', 'users.id', 'appointments.doctor_id')
      ->orderBy('appointments.date', 'DESC')
      ->orderBy('appointments.slot_start', 'DESC')
      ->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));


      $oldDate = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);
      $t = $date->format('Y-m-d h:i a');



      $date2 = date('Y-m-d', strtotime($row->date));
      $start_time = date('h:i a', strtotime($oldDate));
      $p = $date2 . ' ' . $start_time;




      $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t);
      $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p);

      $result_in_seconds = $to->diffInSeconds($from, false);





      if ($result_in_seconds < 0) {


        $row->doctor_name = 'Dr. ' . ucfirst($row->doctor_name);

        $row->date = date('m/d/Y', strtotime($row->date));
        $row->slot_start = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_start)), $request->time_zone);
        $row->slot_end = get_change_utc_to_timezone(date('h:i a', strtotime($row->slot_end)), $request->time_zone);

        if ($row->profile_image == '') {
          $row->doctor_image = "https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png";
        } else {
          $row->doctor_image = URL::to('/') . '/' . $row->profile_image;
        }



        array_push($u, $row);
      }
    }
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "List of Completed Appointments",
        "response" => $u
      ], 200);
    } else {
      return response()->json([
        'success' => '',
        "message" => "No List of Appointments",

      ], 200);
    }
  }


  public function parent_category()
  {
    $data = DB::table('parent_category')->select('id', 'cat')->where('status', 1)->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Here is the parent categories",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No active parent category",
        "response" =>  $data
      ], 200);
    }
  }
  public function category()
  {

    $data = BodyPartCat::select('id', 'category')->where('status', 1)->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Here is the  categories",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No active  category",
        "response" =>  $data
      ], 200);
    }
  }
  public function sub_category(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'cat_id' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = BodyPartSubCat::select('id', 'sub_cat', 'position')->where('cat_id', $request->cat_id)->where('status', 1)->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Here is the  sub categories",
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No active sub-category",
        "response" =>  $data
      ], 200);
    }
  }
  public function symptoms(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'ques_id' => 'required',
      'gender' => 'required',

      'problem_id' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    //echo $j;

    if ($request->gender == 'Male') {
      $s = DB::table('symptoms')->where('pro_id', $request->problem_id)->where('type', $request->ques_id)->whereIn('id', explode(',', $request->selected_id))->whereNotIn('symptoms', ['Menstrual cycle (WOMEN ONLY)'])->where('status', 1)->get();
    } else {
      $s = DB::table('symptoms')->where('pro_id', $request->problem_id)->where('type', $request->ques_id)->whereIn('id', explode(',', $request->selected_id))->where('status', 1)->get();
    }

    $u = [];
    foreach ($s as $row) {
      $row->condition = true;
      array_push($u, $row);
    }
    //print_r($u);
    if ($request->gender == 'Male') {
      $ns = DB::table('symptoms')->where('pro_id', $request->problem_id)->where('type', $request->ques_id)->whereNotIn('id', explode(',', $request->selected_id))->whereNotIn('symptoms', ['Menstrual cycle (WOMEN ONLY)'])->where('status', 1)->get();
    } else {
      $ns = DB::table('symptoms')->where('pro_id', $request->problem_id)->where('type', $request->ques_id)->whereNotIn('id', explode(',', $request->selected_id))->where('status', 1)->get();
    }


    $p = [];
    foreach ($ns as $row) {
      $row->condition = false;
      array_push($p, $row);
    }
    //print_r($ns);
    $data = array_merge($u, $p);


    $names = array();

    foreach ($data as $key => $val) {

      $names[$key] = $val->id;
    }

    array_multisort($names, SORT_ASC, $data);

    $data_t = DB::table('symptoms')->where('symptoms', 'None')->where('type', $request->ques_id)->first();

    if ($request->select === true && !empty($data_t)) {

      // echo "hi1";

      $r = explode(',', $request->selected_id);

      if (in_array($data_t->id, $r)) {
        // echo "hi2";

        $u = [];

        foreach ($data as $t) {
          if ($t->id == $data_t->id) {

            $t->con = true;
          } else {
            $t->con = false;
          }
          array_push($u, $t);
        }
        return response()->json([
          'success' => '1',
          'message' => 'Here all the  symtoms',
          "response" => $u,

        ], 200);
      } else {

        // echo "hi3";
        $u = [];

        foreach ($data as $t) {
          if ($t->id == $data_t->id) {

            $t->con = false;
          } else {
            $t->con = true;
          }
          array_push($u, $t);
        }
        return response()->json([
          'success' => '1',
          'message' => 'Here all the  symtoms',
          "response" => $u,

        ], 200);
      }
    } else {
      return response()->json([
        'success' => '1',
        "message" => "Here all the  symtoms",
        "response" =>  $data
      ], 200);
    }
  }






  public function next_button_restrict(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'ques_id' => 'required',


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $r = DB::table('symptoms')->where('type', $request->ques_id)->get();

    $e = json_decode(json_encode($r), true);
    $j = array_column($e, 'id');


    $c = explode(',', $request->selected_id);

    $result = array_intersect($j, $c);

    $p =  count($result);
    //echo $j;
    if ($p == 0) {

      return response()->json([
        'success' => '0',
        "message" => "Please select any symptom"

      ], 200);
    } else {
      return response()->json([
        'success' => '1',
        "message" => "Move Further"

      ], 200);
    }
  }



  public function diagnosis(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'symp_id' => 'required',
      'user_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $r = implode(',', $request->symp_id);


    $g = explode(',', $r);


    if (count($g) <= 17) {
      $data = DB::table('diagnosis')->select('diagnosis.diagnosis', 'color_code.color')->whereIn('diagnosis.symp_id',  $request->symp_id)->join('color_code', 'color_code.id', 'diagnosis.color_code')->get();

      $pc = count($data);

      //print_r($data);

      foreach ($data as $row) {
        $d = json_decode(json_encode($data), true);
        $_add_on = array_column($d, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }
      $t = $data[0];

      $di = explode(',', $t->diagnosis);
      $n = array_count_values($di);
      // print_r(array_count_values($di));
      $u = [];

      foreach ($n as $key => $value) {
        if ($value >= $pc) {
          array_push($u, $key);
        }
      }

      // print_r($u);




      // if ($pc > 1) {
      //   $p = array_unique(array_diff_assoc($di, array_unique($di)));
      // } else {
      //   $p = array_unique($di);
      // }



      if (implode(',', $u) == '') {
        $t->diagnosis = "Please select more symptoms to get an accurate diagnosis.";
        $t->color = "No Color";
      } else {

        $t->diagnosis = implode(',', $u);


        $trt = DB::table('treatments')->whereIn('treatments', explode(',', $t->diagnosis))->get();


        $d = json_decode(json_encode($trt), true);
        $_add_on = array_column($d, 'color_code');
        $color_code = array_unique($_add_on);
        $t->color = implode(',', $color_code);


        if (str_contains($t->color, '1')) {
          $t->color = 'Red';
        } else if (str_contains($t->color, '2')) {
          $t->color = 'Yellow';
        } else {
          $t->color = 'Green';
        }



        // $color = explode(',', $t->color);
        // $t->color = array_unique($color);
        // $t->color = implode(',', $t->color);

        // if (str_contains($t->color, 'Red')) {
        //   $t->color = 'Red';
        // } else if (str_contains($t->color, 'Yellow')) {
        //   $t->color = 'Yellow';
        // } else {
        //   $t->color = 'Green';
        // }

        if ($request->user_id != 0) {

          if ($t->color == 'Red') {
            $color = 1;
          } else if ($t->color == 'Yellow') {
            $color = 2;
          } else {
            $color = 3;
          }

          DB::table('users')->where('id', $request->user_id)->update([
            'color_code' => $color
          ]);
        }
      }

      $m = DB::table('symptoms')->whereIn('id', $request->symp_id)->get();


      $e = json_decode(json_encode($m), true);
      $_add_on2 = array_column($e, 'symptoms');
      $t->symp = implode(',', $_add_on2);


      if ($data) {

        return response()->json([
          'success' => '1',
          "message" => "Possible Solutions",

          "response" =>  $t
        ], 200);
      } else {
        return response()->json([
          'success' => '0',
          "message" => "No Solutions",
          "response" =>  $data
        ], 200);
      }
    } else {
      $m = DB::table('symptoms')->whereIn('id', $request->symp_id)->get();


      $e = json_decode(json_encode($m), true);
      $_add_on2 = array_column($e, 'symptoms');
      $symp = implode(',', $_add_on2);
      $data = ['diagnosis' => 'Please select more symptoms to get an accurate diagnosis.', 'color' => 'No Color', 'symp' => $symp];


      return response()->json([
        'success' => '1',
        "message" => "Possible Solutions",
        "response" => $data
      ], 200);
    }
  }
  public function suggest_doctors(Request $request)
  {

    $validation = Validator::make($request->all(), [
      "timezone" => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data_doc = User::select('users.id', 'users.last_name as name', 'users.phone', 'users.profile_image', 'users.specility_id as speciality', 'users.about', 'users.status', 'users.consultation', 'users.fee_per_consultation')
      ->join('availability', 'availability.user_id', 'users.id')
      ->where('users.role', 1)->where('users.status', 2)->distinct('users.id')->get();



    $doctors = [];
    foreach ($data_doc as $row) {

      $row->avl_slots = getAvailability_c($row->id, $request->timezone);
      if ($row->avl_slots > 0) {


        if ($row->profile_image != '') {
          $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        } else {
          $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
        }


        // $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        if ($row->fee_per_consultation != '') {

          $f = explode(',', $row->fee_per_consultation);
          $row->video_fee = $f[0];
          $row->audio_fee = $f[1];
          $row->chat_fee = $f[2];
        }
        $row->rating = avg_rating($row->id);

        $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


        $users = json_decode(json_encode($dpl), true);


        $_add_on = array_column($users, 'spli');
        $row->rating_count = rating_count($row->id);

        $row->speciality = implode(', ', $_add_on);

        $row->name = 'Dr. ' . ucfirst($row->name);


        $row->rating_count = review_count($row->id);
        $row->slot = slot_aval_for_doctor(date('Y-m-d'), $row->id, $request->timezone);
        if (!empty($row->slot)) {
          array_push($doctors, $row);
        }
      }
    }




    $d = json_decode(json_encode($doctors), true);
    $_add_on = array_column($d, 'id');
    $doc_id = implode(',', $_add_on);

    date_default_timezone_set($request->timezone);



    $t = date('H:i:s', time());


    return response()->json([
      'success' => '1',
      "message" => "Suggected Doctors",
      "test" => $t,


      "date" => date('m/d/Y'),
      "response" =>  $doctors
    ], 200);
  }
  public function other_doctors(Request $request)
  {
    // $validation = Validator::make($request->all(), [

    //   'spl_id' => 'required',
    //   'doc_id' => 'required'

    // ]);
    // if ($validation->fails()) {
    //   $errors = $validation->errors();

    //   return response()->json([
    //     'errors' => $errors
    //   ], 403);
    // }
    // $l = $request->spl_id;
    $data_doc = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation')->where('role', 1)->where('status', 2)->orderBy('consultation', 'ASC')->get();
    $doctors = [];
    foreach ($data_doc as $row) {
      $row->avl_slots = getAvailability_o($row->id);
      if ($row->avl_slots <= 0) {

        if ($row->profile_image != '') {
          $row->profile_image = URL::to('/') . '/' . $row->profile_image;
        } else {
          $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
        }



        //$row->profile_image = URL::to('/') . '/' . $row->profile_image;
        if ($row->fee_per_consultation != '') {
          $f = explode(',', $row->fee_per_consultation);
          $row->video_fee = $f[0];
          $row->audio_fee = $f[1];
          $row->chat_fee = $f[2];
        }


        $row->rating = avg_rating($row->id);

        $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


        $users = json_decode(json_encode($dpl), true);
        $_add_on = array_column($users, 'spli');
        $row->speciality = implode(',', $_add_on);
        $row->about = substr($row->about, 0, 30);
        $row->name = 'Dr. ' . ucfirst($row->name);
        $row->rating_count = review_count($row->id);
        array_push($doctors, $row);
      }
    }
    $names = array();

    foreach ($doctors as $key => $val) {

      $names[$key] = $val['avl_slots'];
    }
    array_multisort($names, SORT_DESC, $doctors);




    return response()->json([
      'success' => '1',
      "message" => "Other Doctors",
      "response" =>   $doctors
    ], 200);
  }

  public function slot_aval_for_doctor(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'date' => 'required',
      'time_zone' => 'required',
      'user_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    // $data = DB::table('availability')->where('id', $request->avl_id)->first();
    $tip = DB::table('availability')->where('date', date('Y/m/d', strtotime($request->date)))->where('user_id', $request->user_id)->get();
    $u = [];

    foreach ($tip  as $row) {
      $duration = time_slot();


      $slots = getTimeSlot($duration, $row->start_time, $row->end_time);



      $data1 = [];

      foreach ($slots  as $row1) {


        $t = getBookingDtl($request->user_id, $row1['slot_start_time'], $row1['slot_end_time'], date('Y-m-d', strtotime($request->date)), $request->timezone);


        $row1['slot_end_time'] = date('H:i', strtotime($row1['slot_end_time']) - (3 * 60));



        $date = new DateTime('now', new DateTimeZone($request->time_zone));
        $t1 = $date->format('Y-m-d h:i a');

        $date2 = date('Y-m-d', strtotime($request->date));
        $start_time = date('h:i a', strtotime($row1['slot_start_time']));
        $p1 = $date2 . ' ' . $start_time;
        $to = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $t1);
        $from = \Carbon\Carbon::createFromFormat('Y-m-d H:i a', $p1);

        $result_in_seconds = $to->diffInSeconds($from, false);
        if ($result_in_seconds > 0) {
          if ($t !== 0) {

            $pt = explode('to', $t);
            $row1['slot_start_time'] = $pt[0];
            $row1['slot_end_time'] = $pt[1];
            $row1['status'] = "Booked";
          } else {

            $row1['status'] = "Available";
            $row1['patient_name'] = 'NA';
          }
          array_push($data1, $row1);
        } else {
        }
      }
      array_push($u, $data1);
    }
    if (count($tip) == 1) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor Available Time Slot",
        "date" => date('m/d/Y'),
        "response" => $u[0][0]
      ], 200);
    } else {
      return response()->json([
        'success' => '1',
        "message" => "Doctor Available Time Slot",
        "date" => date('m/d/Y'),
        "response" => $u[1][1]
      ], 200);
    }
  }

  public function quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [


      'feet' => 'required',
      'inch' => 'required',
      'weight' => 'required',
      'dob' => 'required',
      'name' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $d = QuickVisit::where('email', $request->email)->first();
    if (!$d) {
      $user = new QuickVisit();
    } else {
      $user = QuickVisit::find($d->id);
    }




    if (implode(',', $request->allergy) != '') {

      if (implode(',', $request->allergy) == 6) {
        $id = Allergy::insertGetId([
          'allergy' => $request->other_allergy,
          'status' => 1
        ]);
        $user->allergy = $id;
      } else {
        $user->allergy = implode(',', $request->allergy);
      }
    } else {
      $user->allergy = null;
    }




    //
    if (implode(',', $request->medical_history) != '') {
      if (implode(',', $request->medical_history) == 4) {
        $id = MedicalHistory::insertGetId([
          'medical' => $request->other_medical,
          'status' => 1
        ]);
        $user->medical_id = $id;
      } else {
        $user->medical_id = implode(',', $request->medical_history);
      }
    } else {
      $user->medical_id = null;
    }
    //
    if (implode(',', $request->surgical_history) != '') {

      if (implode(',', $request->surgical_history) == 6) {
        $id = Surgery::insertGetId([
          'surgery' => $request->other_surgical_history,
          'status' => 1
        ]);
        $user->surgical_history = $id;
      } else {
        $user->surgical_history = implode(',', $request->surgical_history);
      }
    } else {
      $user->surgical_history = null;
    }

    //
    if (implode(',', $request->lab_result) != '') {
      if (implode(',', $request->lab_result) == 4) {
        $id = Lab::insertGetId([
          'lab' => $request->other_lab,
          'status' => 1
        ]);
        $user->lab = $id;
      } else {
        $user->lab = implode(',', $request->lab_result);
      }
    } else {
      $user->lab = null;
    }

    //
    if (implode(',', $request->med_id) != '') {
      if (implode(',', $request->med_id) == 51) {
        $id = Medication::insertGetId([
          'lab' => $request->other_med,
          'status' => 1
        ]);
        $user->med_id = $id;
      } else {
        $user->med_id = implode(',', $request->med_id);
      }
    } else {
      $user->med_id = null;
    }


    $images = $request->file('surgical_result');
    $imageName = '';
    if ($images) {
      foreach ($images as $img) {
        $file_type = $img->extension();
        // $new_name = rand() . '.' . $img->getClientOriginalExtension();
        $new_name = URL::to('/') . '/' . $img->storeAs('images/patients', rand() . '.' . $file_type, 'public');
        $img->move(public_path('/images/patients'), $new_name);
        $imageName = $imageName . $new_name . ",";
      }
      $imgDb = $imageName;
      $user->surgical_result = substr($imgDb, 0, -1);
    }


    $images_lab = $request->file('lab_result_images');
    $imageNameLab = '';
    if ($images_lab) {
      foreach ($images_lab as $img) {
        $file_type = $img->extension();
        $new_name = URL::to('/') . '/' . $img->storeAs('images/patients', rand() . '.' . $file_type, 'public');
        $img->move(public_path('/images/patients'), $new_name);
        $imageNameLab = $imageNameLab . $new_name . ",";
      }
      $imgDbLab =  $imageNameLab;
      if ($request->new_lab_result_images == '') {
        $user->lab_result = substr($imgDbLab, 0, -1);
      } else {
        $user->llab_result = $request->new_lab_result_images . ',' . substr($imgDbLab, 0, -1);
      }
    } else {
      $user->lab_result = $request->new_lab_result_images;
    }
    $user->dob =  date('Y-m-d', strtotime($request->dob));
    $user->name = $request->name;
    $user->weight = $request->weight;
    $user->height = $request->feet . "'" . $request->inch;
    $user->email = $request->email;
    $user->gender = $request->gender;
    $user->year = date('Y', strtotime($request->dob));
    $user->save();
    return response()->json([
      'success' => '1',
      "message" => "Quick visit details saved",
      "visit_id" => $user->id
    ], 200);
  }
  public function consultation_avl(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'doctor_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $fee = DB::table('users')->select('fee_per_consultation')->where('id', $request->doctor_id)->first();
    $fee1 = explode(',', $fee->fee_per_consultation);
    $fee->fee_video = $fee1[0];
    $fee->fee_audio = $fee1[1];
    $fee->fee_chat = $fee1[2];

    return response()->json([
      'success' => '1',
      "message" => "Doctor Fee Per Consultation",
      "response" => $fee
    ], 200);
  }
  public function quick_chat_details(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'visit_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $b = DB::table('quick_visit')->where('id', $request->visit_id)->first();

    $dpl = DB::table('surgeries')->select('id', 'surgery')->whereIn('id', explode(',', $b->surgical_history))->get();


    $users = json_decode(json_encode($dpl), true);
    $_add_on = array_column($users, 'surgery');
    $b->surgical_history = implode(',', $_add_on);


    $a = DB::table('allergies')->select('id', 'allergy')->whereIn('id', explode(',', $b->allergy))->get();


    $u = json_decode(json_encode($a), true);
    $_add_on = array_column($u, 'allergy');
    $b->allergy = implode(',', $_add_on);


    $l = DB::table('lab')->select('id', 'lab')->whereIn('id', explode(',', $b->lab))->get();


    $u = json_decode(json_encode($l), true);
    $_add_on = array_column($u, 'lab');
    $b->lab = implode(',', $_add_on);

    $b->lab_result = explode(',', $b->lab_result);
    $b->surgical_result = explode(',', $b->surgical_result);


    return response()->json([
      'success' => '1',
      "message" => "Quick Visit Details",
      "response" => $b
    ], 200);
  }
  public function select_dio(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'diogonosis' => 'required',
      'part' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $m = DB::table('symptoms')->where('symptoms', 'like', $request->diogonosis)->first();

    $data = DB::table('diagnosis')->select('diagnosis.id', 'diagnosis.diagnosis', 'color_code.color')->where('symp_id',  $m->id)->join('color_code', 'color_code.id', 'diagnosis.color_code')->first();
    $part = explode(' ', $request->part);

    if ($part[0] == 'Left') {
      $side = 'L Side';
    } else if ($part[0] == 'Right') {
      $side = 'R Side';
    } else {
      $side = 'middle';
    }
    return response()->json([
      'success' => '1',
      "message" => "Quick Visit Details",
      "side" => $side,

      "response" => $data
    ], 200);
  }
  public function problems(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'year' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $y =  date("Y") - $request->year;
    if ($y >= 18) {
      $a = "Adult";
    } else {
      $a = "Pediatric";
    }
    $search = $request->keyword;
    if ($search == '') {
      $m = DB::table('problems')->select('id', 'problem', 'img')->where('status', 1)->where('top', 1)->where('problem', 'LIKE', "$search%")->whereIn('age_b', [$a, 'Both'])->orderBy('problem', 'ASC')->limit(10)->get();
    } else {
      $m = DB::table('problems')->select('id', 'problem', 'img')->where('status', 1)->where('problem', 'LIKE', "$search%")->whereIn('age_b', [$a, 'Both'])->orderBy('problem', 'ASC')->limit(10)->get();
    }

    foreach ($m as $row) {
      $row->problem = ucfirst($row->problem);
    }
    return response()->json([
      'success' => '1',
      "message" => "List of Problems",
      "response" => $m
    ], 200);
  }
  public function symptoms_part(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'type' => 'required',
      'pro_id' => 'required',
      'selected_id' => 'required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data = DB::table('symptoms')->select('id', 'symptoms', 'img')->where('pro_id', $request->pro_id)->where('type', $request->type)->where('status', 1)->get();
    if ($data) {
      return response()->json([
        'success' => '1',
        "message" => "Here all the  symtoms of" . $request->type,
        "response" =>  $data
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No symptoms of" . $request->type,
        "response" =>  $data
      ], 200);
    }
  }
  public function diagnosis_2(Request $request)
  {

    $validation = Validator::make($request->all(), [


      'user_id' => 'required',
      'symp_id' => 'required',
      'gender' => 'required',
      'email' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $m = $request->symp_id;


    $ms = DB::table('symptoms')->whereIn('id', $m)->get();


    $e = json_decode(json_encode($ms), true);
    $_add_on2 = array_column($e, 'symptoms');
    $symp = implode(', ', $_add_on2);


    $d4 = DB::table('diagnosis')->join('symptoms', 'symptoms.id', 'diagnosis.symp_id')->whereIn('symp_id', $m)->where('priority', '4+')->get();

    $d3 = DB::table('diagnosis')->join('symptoms', 'symptoms.id', 'diagnosis.symp_id')->whereIn('symp_id', $m)->where('priority', '3+')->get();



    $d2 = DB::table('diagnosis')->join('symptoms', 'symptoms.id', 'diagnosis.symp_id')->whereIn('symp_id', $m)->where('priority', '2+')->get();


    $d1 = DB::table('diagnosis')->join('symptoms', 'symptoms.id', 'diagnosis.symp_id')->whereIn('symp_id', $m)->where('priority', '1+')->get();


    if (count($d4) != 0) {


      $d = $d4;




      if (count($d) == 1) {

        foreach ($d as $row) {
          if (count($d3) != 0) {

            $d_o = $d3;
          } else if (count($d2) != 0) {

            $d_o = $d2;
          } else {

            $d_o = $d1;
          }

          if (count($d_o) == 1) {
            foreach ($d_o as $row_o) {
              $t2 = $row_o;
            }
          } else if (count($d_o) != 0) {
            foreach ($d_o as $row_o) {
              $dp = json_decode(json_encode($d_o), true);
              $_add_on = array_column($dp, 'diagnosis');
              $row_o->diagnosis = implode(',', $_add_on);
            }

            $t2 = $d_o[0];



            $l = str_replace(',', ",", $t2->diagnosis);

            $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;
          

            $counts = array_count_values($di);


            $y = [];
            foreach ($counts as $r => $value) {

              if ($value > count($d_o)) {
                array_push($y, $r);
              }
            }

            $t2->diagnosis = implode(',', $y);

            if (count($y) == 0) {


              $p = array_unique(array_diff_assoc($di, array_unique($di)));
              $k = implode(',', $p);

              if ($k != '') {

                $t2->diagnosis = $k;
              } else {
                $t2->diagnosis = $l;
              }
            } else {
              $t2->diagnosis = implode(',', $y);
            }


            //
            if ($request->gender == 'Male') {

              $t2->diagnosis = str_replace('(W)', '(M)',  $t2->diagnosis);
            } else {
              $t2->diagnosis = str_replace('(M)', '(W)',  $t2->diagnosis);
            }
          }


          if (count($d_o) != 0) {
            $a1 = explode(',', str_replace(", ", ",", $row->diagnosis));
            $a2 = explode(',', $t2->diagnosis);
            $a1 = array_map('ucfirst', $a1);
            $a2 = array_map('ucfirst', $a2);

            $intersect = array_intersect($a1, $a2);

            $result = array_diff($a2, $intersect);

            if (count($result) == 0) {
              $other_dia = 'NA';
            } else {
              $other_dia = implode(',', $result);
            }
          } else {
            $other_dia = 'NA';
          }



          $trt = DB::table('treatments')->whereIn('treatments', explode(',', $row->diagnosis))->get();

          $d = json_decode(json_encode($trt), true);
          $_add_on = array_column($d, 'color_code');
          $color_code = array_unique($_add_on);
          $row->color = implode(',', $color_code);


          if (str_contains($row->color, '1')) {
            $row->color = 'Red';
            $c = 1;
          } else if (str_contains($row->color, '2')) {
            $row->color = 'Yellow';
            $c = 2;
          } else {
            $row->color = 'Green';
            $c = 3;
          }
          return response()->json([
            'success' => '1',
            "message" => "Here all the possible solutions",
            "symp" => str_replace(",None", "", $symp),
            "zone" => $row->color,
            "diagonosis" => ucfirst(str_replace(',', ", ", $row->diagnosis)),
            "diagonosis_2" => str_replace(',', ", ", $other_dia)

          ], 200);
        }
      }

      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t = $d[0];
      $l = str_replace(',', ",", $t->diagnosis);

   
      $di = array_map('ucfirst', explode(',', $t->diagnosis)) ;

      $counts = array_count_values($di);

      $y = [];
      foreach ($counts as $r => $value) {
        if ($value >= count($d)) {
          array_push($y, $r);
        }
      }


      if (count($y) == 0) {


        $p = array_unique(array_diff_assoc($di, array_unique($di)));
        $k = implode(',', $p);
        if ($k != '') {

          $t->diagnosis = $k;
        } else {
          $t->diagnosis = $l;
        }


      } else {
        $t->diagnosis = implode(',', $y);
      }
      $di = str_replace(', ', ",", $di);

      $str1 = implode(',', $di);
      $str2 = str_replace(', ', ",", $t->diagnosis);

      $array1 = explode(',', $str1);
      $array2 = explode(',', $str2);


      $array1 = array_diff($array1, $array2);

      $trt = DB::table('treatments')->whereIn('treatments', explode(',', $str2))->get();

      $d = json_decode(json_encode($trt), true);
      $_add_on = array_column($d, 'color_code');
      $color_code = array_unique($_add_on);
      $t->color = implode(',', $color_code);


      if (str_contains($t->color, '1')) {
        $t->color = 'Red';
        $c = 1;
      } else if (str_contains($t->color, '2')) {
        $t->color = 'Yellow';
        $c = 2;
      } else {
        $t->color = 'Green';
        $c = 3;
      }
      //
      if ($request->user_id != 0) {

        User::where('id', $request->user_id)->update([
          'color_code' => $c
        ]);
      } else {
        DB::table('quick_visit')->where('email', $request->email)->update([
          'color_code' => $c
        ]);
      }


      if ($request->gender == 'Male') {

        $t->diagnosis = str_replace('(W)', '(M)',  $t->diagnosis);
      } else {
        $t->diagnosis = str_replace('(M)', '(W)',  $t->diagnosis);
      }



      if (count($d3) != 0) {

        $d = $d3;
      } else if (count($d2) != 0) {

        $d = $d2;
      } else {

        $d = $d1;
      }
      if (count($d) == 0) {
        return response()->json([
          'success' => '1',
          "message" => "Here all the possible solutions",
          "symp" => str_replace(",None", "", $symp),
          "zone" => $t->color,
          "diagonosis" =>  ucfirst(str_replace(',', ", ", $str2)),
          "diagonosis_2" => str_replace(',', ", ", implode(',',$array1))
          
        ], 200);
      }

 
      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t2 = $d[0];



      $l = str_replace(',', ",", $t2->diagnosis);
  

      $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;
      $di = array_merge($array1, $di);
      $counts = array_count_values($di);


      $y = [];
      foreach ($counts as $r => $value) {


        if ($value > 1) {
          array_push($y, $r);
        }
      }




      $t2->diagnosis = implode(',', $y);



      if (count($y) == 0) {

        $t2->diagnosis = implode(',',$array1);
        // $p = array_unique(array_diff_assoc($di, array_unique($di)));
        // $k = implode(',', $p);

        // if ($k != '') {

        //   $t2->diagnosis = $k;
        // } else {
        //   $t2->diagnosis = $l;
        // }
      } else {
        $m = array_diff($array1,$y);
        $common_hp = array_merge($y,$m);

        $t2->diagnosis = implode(',', $common_hp);
      }


      //
      if ($request->gender == 'Male') {

        $t2->diagnosis = str_replace('(W)', '(M)',  $t2->diagnosis);
      } else {
        $t2->diagnosis = str_replace('(M)', '(W)',  $t2->diagnosis);
      }
      $a1 = explode(',', $t->diagnosis);
      $a2 = explode(',', $t2->diagnosis);
      $a1 = array_map('ucfirst', $a1);
      $a2 = array_map('ucfirst', $a2);

      $intersect = array_intersect($a1, $a2);


      $result = array_diff($a2, $intersect);

      if (count($result) == 0) {
        $other_dia = 'NA';
      } else {
        $other_dia = implode(', ', $result);
      }

      return response()->json([
        'success' => '1',
        "message" => "Here all the possible solutions",
        "symp" => str_replace(",None", "", $symp),
        "zone" => $t->color,
        "diagonosis" => ucfirst(str_replace(',', ", ", $str2)),
        "diagonosis_2" => str_replace(',', ", ", $other_dia) 
      ], 200);
    } else if (count($d3) != 0) {



      $d = $d3;

      if (count($d) == 1) {

        foreach ($d as $row) {


          if (count($d2) != 0) {

            $d_o = $d2;
          } else {

            $d_o = $d1;
          }
          if (count($d_o) == 1) {
            foreach ($d_o as $row_o) {
              $t2 = $row_o;
            }
          } else if (count($d_o) != 0) {

            foreach ($d_o as $row_o) {
              $dp = json_decode(json_encode($d_o), true);
              $_add_on = array_column($dp, 'diagnosis');
              $row_o->diagnosis = implode(',', $_add_on);
            }

            $t2 = $d_o[0];


            $l = str_replace(',', ",", $t2->diagnosis);

            $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;
          

            $counts = array_count_values($di);


            $y = [];
            foreach ($counts as $r => $value) {
              if ($value >= count($d_o)) {
                array_push($y, $r);
              }
            }

            $t2->diagnosis = implode(',', $y);

            if (count($y) == 0) {


              $p = array_unique(array_diff_assoc($di, array_unique($di)));
              $k = implode(',', $p);

              if ($k != '') {

                $t2->diagnosis = $k;
              } else {
                $t2->diagnosis = $l;
              }
            } else {
              $t2->diagnosis = implode(',', $y);
            }
          }
          if (count($d_o) != 0) {
            $a1 = explode(',', str_replace(", ", ",", $row->diagnosis));
            $a2 = explode(',', $t2->diagnosis);

            $intersect = array_intersect($a1, $a2);

            $result = array_diff($a2, $intersect);

            if (count($result) == 0) {
              $other_dia = 'NA';
            } else {
              $other_dia = implode(',', $result);
            }
          } else {
            $other_dia = 'NA';
          }

          $trt = DB::table('treatments')->whereIn('treatments', explode(',', $row->diagnosis))->get();

          $d = json_decode(json_encode($trt), true);
          $_add_on = array_column($d, 'color_code');
          $color_code = array_unique($_add_on);
          $row->color = implode(',', $color_code);


          if (str_contains($row->color, '1')) {
            $row->color = 'Red';
            $c = 1;
          } else if (str_contains($row->color, '2')) {
            $row->color = 'Yellow';
            $c = 2;
          } else {
            $row->color = 'Green';
            $c = 3;
          }
          return response()->json([
            'success' => '1',
            "message" => "Here all the possible solutions",
            "symp" => str_replace(",None", "", $symp),
            "zone" => $row->color,
            "diagonosis" => ucfirst(str_replace(',', ", ", $row->diagnosis)),
            "diagonosis_2" =>str_replace(',', ", ", $other_dia) 

          ], 200);
        }
      }

      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t = $d[0];




      $l = str_replace(',', ",", $t->diagnosis);


      $di = array_map('ucfirst', explode(',', $t->diagnosis)) ;

      $counts = array_count_values($di);


      $y = [];
      foreach ($counts as $r => $value) {

        if ($value >= count($d)) {
          array_push($y, $r);
        }
      }

      if (count($y) == 0) {


        $p = array_unique(array_diff_assoc($di, array_unique($di)));
        $k = implode(', ', $p);
        // echo $k;
        if ($k != '') {

          $t->diagnosis = $k;
        } else {
          $t->diagnosis = $l;
        }
      } else {
        $t->diagnosis = implode(',', $y);
      }
      $di = str_replace(', ', ",", $di);

      $str1 = implode(',', $di);
      $str2 = str_replace(', ', ",", $t->diagnosis);

      $array1 = explode(',', $str1);
      $array2 = explode(',', $str2);
    


      $array1 = array_diff($array1, $array2);






      $trt = DB::table('treatments')->whereIn('treatments', explode(',', $str2))->get();

      $d = json_decode(json_encode($trt), true);
      $_add_on = array_column($d, 'color_code');
      $color_code = array_unique($_add_on);
      $t->color = implode(',', $color_code);


      if (str_contains($t->color, '1')) {
        $t->color = 'Red';
        $c = 1;
      } else if (str_contains($t->color, '2')) {
        $t->color = 'Yellow';
        $c = 2;
      } else {
        $t->color = 'Green';
        $c = 3;
      }
      //
      if ($request->user_id != 0) {

        User::where('id', $request->user_id)->update([
          'color_code' => $c
        ]);
      } else {
        DB::table('quick_visit')->where('email', $request->email)->update([
          'color_code' => $c
        ]);
      }

      //
      if ($request->gender == 'Male') {

        $t->diagnosis = str_replace('(W)', '(M)',  $t->diagnosis);
      } else {
        $t->diagnosis = str_replace('(M)', '(W)',  $t->diagnosis);
      }

      $msg = "Your most likely diagnosis";

      if (count($d2) != 0) {

        $d = $d2;
      } else {

        $d = $d1;
      }
      if (count($d) == 0) {
        return response()->json([
          'success' => '1',
          "message" => "Here all the possible solutions",
          "symp" => str_replace(",None", "", $symp),
          "zone" => $t->color,
          "diagonosis" => ucfirst(str_replace(',', ", ", $str2) ),
          "diagonosis_2" => str_replace(',', ", ", implode(',',$array1)) 
        ], 200);
      }

      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t2 = $d[0];



      $l = str_replace(',', ",", $t2->diagnosis);

      $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;
   
      $di = array_merge($array1, $di);



      $counts = array_count_values($di);


      $y = [];
      foreach ($counts as $r => $value) {
        if ($value > 1) {
          array_push($y, $r);
        }
      }

      $t2->diagnosis = implode(',', $y);



      if (count($y) == 0) {


        $t2->diagnosis = implode(',', $array1);
        // $p = array_unique(array_diff_assoc($di, array_unique($di)));
        // $k = implode(',', $p);

        // if ($k != '') {

        //   $t2->diagnosis = $k;
        // } else {
        //   $t2->diagnosis = $l;
        // }
      } else {
        $m = array_diff($array1,$y);
        $common_hp = array_merge($y,$m);

        $t2->diagnosis = implode(',', $common_hp);
      //  $t2->diagnosis = implode(',', $y);
      }



      if ($request->gender == 'Male') {

        $t2->diagnosis = str_replace('(W)', '(M)',  $t2->diagnosis);
      } else {
        $t2->diagnosis = str_replace('(M)', '(W)',  $t2->diagnosis);
      }

      $a1 = explode(',', str_replace(", ", ",", $t->diagnosis));
      $a2 = explode(',', $t2->diagnosis);
      $a1 = array_map('ucfirst', $a1);
      $a2 = array_map('ucfirst', $a2);

      $intersect = array_intersect($a1, $a2);


      $result = array_diff($a2, $intersect);

      if (count($result) == 0) {
        $other_dia = 'NA';
      } else {
        $other_dia = implode(',', $result);
      }

      return response()->json([
        'success' => '1',
        "message" => "Here all the possible solutions",
        "symp" => str_replace(",None", "", $symp),
        "zone" => $t->color,
        "diagonosis" => ucfirst($str2),
        "diagonosis_2" =>  $other_dia
      ], 200);
    } else if (count($d2) != 0) {

      $d = $d2;
      if (count($d) == 1) {
        foreach ($d as $row) {



          $d_o = $d1;

          if (count($d_o) == 1) {
            foreach ($d_o as $row_o) {
              $t2 = $row_o;
            }
          } else if (count($d_o) != 0) {
            foreach ($d_o as $row_o) {
              $dp = json_decode(json_encode($d_o), true);
              $_add_on = array_column($dp, 'diagnosis');
              $row_o->diagnosis = implode(',', $_add_on);
            }

            $t2 = $d_o[0];


            $l = str_replace(',', ",", $t2->diagnosis);


           

            $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;

            $counts = array_count_values($di);

            $y = [];
            foreach ($counts as $r => $value) {
              if ($value >= count($d_o)) {
                array_push($y, $r);
              }
            }

            $t2->diagnosis = implode(',', $y);
          }
          if (count($d_o) != 0) {
            $a1 = explode(',', str_replace(", ", ",", $row->diagnosis));
            $a2 = explode(',', $t2->diagnosis);

            $intersect = array_intersect($a1, $a2);

            $result = array_diff($a2, $intersect);

            if (count($result) == 0) {
              $other_dia = 'NA';
            } else {
              $other_dia = implode(',', $result);
            }
          } else {
            $other_dia = 'NA';
          }
          $trt = DB::table('treatments')->whereIn('treatments', explode(',', $row->diagnosis))->get();

          $d = json_decode(json_encode($trt), true);
          $_add_on = array_column($d, 'color_code');
          $color_code = array_unique($_add_on);
          $row->color = implode(',', $color_code);


          if (str_contains($row->color, '1')) {
            $row->color = 'Red';
            $c = 1;
          } else if (str_contains($row->color, '2')) {
            $row->color = 'Yellow';
            $c = 2;
          } else {
            $row->color = 'Green';
            $c = 3;
          }
          return response()->json([
            'success' => '1',
            "message" => "Here all the possible solutions",
            "symp" => str_replace(",None", "", $symp),
            "zone" => $row->color,
            "diagonosis" => ucfirst(str_replace(',', ", ", $row->diagnosis)),
            "diagonosis_2" => str_replace(',', ", ", $other_dia) 

          ], 200);
        }
      }
      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t = $d[0];
      //print_r($t);
      $l = str_replace(',', ",", $t->diagnosis);
      $di = array_map('ucfirst', explode(',', $t->diagnosis)) ;

    

      $counts = array_count_values($di);

      $y = [];
      foreach ($counts as $r => $value) {
        if ($value >= count($d)) {
          array_push($y, $r);
        }
      }





      $t->diagnosis = implode(',', $y);
      if (count($y) == 0) {


        $p = array_unique(array_diff_assoc($di, array_unique($di)));
        $k = implode(', ', $p);
        if ($k != '') {

          $t->diagnosis = $k;
        } else {
          $t->diagnosis = $l;
        }
      } else {
        $t->diagnosis = implode(',', $y);
      }
      $di = str_replace(', ', ",", $di);

      $str1 = implode(',', $di);
      $str2 = str_replace(', ', ",", $t->diagnosis);

      $array1 = explode(',', $str1);
      $array2 = explode(',', $str2);


      $array1 = array_diff($array1, $array2);



      $trt = DB::table('treatments')->whereIn('treatments', explode(',', $str2))->get();

      $d = json_decode(json_encode($trt), true);
      $_add_on = array_column($d, 'color_code');
      $color_code = array_unique($_add_on);
      $t->color = implode(',', $color_code);


      if (str_contains($t->color, '1')) {
        $t->color = 'Red';
        $c = 1;
      } else if (str_contains($t->color, '2')) {
        $t->color = 'Yellow';
        $c = 2;
      } else {
        $t->color = 'Green';
        $c = 3;
      }
      //
      if ($request->user_id != 0) {

        User::where('id', $request->user_id)->update([
          'color_code' => $c
        ]);
      } else {
        DB::table('quick_visit')->where('email', $request->email)->update([
          'color_code' => $c
        ]);
      }

      //
      if ($request->gender == 'Male') {
        $t->diagnosis = str_replace('(W)', '(M)',  $t->diagnosis);
      } else {
        $t->diagnosis = str_replace('(M)', '(W)',  $t->diagnosis);
      }



      $d = $d1;

      if (count($d) == 0) {
        return response()->json([
          'success' => '1',
          "message" => "Here all the possible solutions",
          "symp" => str_replace(",None", "", $symp),
          "zone" => $t->color,
          "diagonosis" => ucfirst(str_replace(',', ", ", $str2)),
          "diagonosis_2" => str_replace(',', ", ", implode(',',$array1))  
        ], 200);
      }

      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t2 = $d[0];


      $l = str_replace(',', ",", $t2->diagnosis);
      $di = array_map('ucfirst', explode(',', $t2->diagnosis)) ;

    

      $di=array_merge($array1,$di);

      $counts = array_count_values($di);

      $y = [];
      foreach ($counts as $r => $value) {
        if ($value > 1) {
          array_push($y, $r);
        }
      }




      $t2->diagnosis = implode(',', $y);



      if (count($y) == 0) {

       $t2->diagnosis = implode(',',$array1);
        // $p = array_unique(array_diff_assoc($di, array_unique($di)));
        // $k = implode(',', $p);

        // if ($k != '') {

        //   $t2->diagnosis = $k;
        // } else {
        //   $t2->diagnosis = $l;
        // }
      } else {
        $m = array_diff($array1,$y);
        $common_hp = array_merge($y,$m);

        $t2->diagnosis = implode(',', $common_hp);
       // $t2->diagnosis = implode(',', $y);
      }


      //
      if ($request->gender == 'Male') {

        $t2->diagnosis = str_replace('(W)', '(M)',  $t2->diagnosis);
      } else {
        $t2->diagnosis = str_replace('(M)', '(W)',  $t2->diagnosis);
      }
      $a1 = explode(',', str_replace(", ", ",", $t->diagnosis));
      $a2 = explode(',', $t2->diagnosis);

      $intersect = array_intersect($a1, $a2);


      $result = array_diff($a2, $intersect);

      if (count($result) == 0) {
        $other_dia = 'NA';
      } else {
        $other_dia = implode(', ', $result);
      }
      return response()->json([
        'success' => '1',
        "message" => "Here all the possible solutions",
        "symp" => str_replace(",None", "", $symp),
        "zone" => $t->color,
        "diagonosis" => ucfirst(str_replace(',', ", ", $t->diagnosis)),
        "diagonosis_2" => str_replace(',', ", ", $other_dia) 
      ], 200);
    } else if (count($d1) != 0) {


      $d = $d1;
      if (count($d) == 1) {
        foreach ($d as $row) {

          $trt = DB::table('treatments')->whereIn('treatments', explode(',', $row->diagnosis))->get();

          $d = json_decode(json_encode($trt), true);
          $_add_on = array_column($d, 'color_code');
          $color_code = array_unique($_add_on);
          $row->color = implode(',', $color_code);


          if (str_contains($row->color, '1')) {
            $row->color = 'Red';
            $c = 1;
          } else if (str_contains($row->color, '2')) {
            $row->color = 'Yellow';
            $c = 2;
          } else {
            $row->color = 'Green';
            $c = 3;
          }
          return response()->json([
            'success' => '1',
            "message" => "Here all the possible solutions",
            "symp" => str_replace(",None", "", $symp),
            "zone" => $row->color,
            "diagonosis" => ucfirst(str_replace(',', ", ", $row->diagnosis)),
            "diagonosis_2" =>  'NA'

          ], 200);
        }
      }
      foreach ($d as $row) {
        $dp = json_decode(json_encode($d), true);
        $_add_on = array_column($dp, 'diagnosis');
        $row->diagnosis = implode(',', $_add_on);
      }

      $t = $d[0];

      $l = str_replace(',', ",", $t->diagnosis);



    
      $di = array_map('ucfirst', explode(',', $t->diagnosis)) ;

      $counts = array_count_values($di);

      $y = [];
      foreach ($counts as $r => $value) {
        if ($value >= count($d)) {
          array_push($y, $r);
        }
      }

      if (count($y) == 0) {


        $p = array_unique(array_diff_assoc($di, array_unique($di)));
        $k = implode(',', $p);
        if ($k != '') {

          $t->diagnosis = $k;
        } else {
          $t->diagnosis = $l;
        }
      } else {
        $t->diagnosis = implode(',', $y);
      }
      $di = str_replace(', ', ",", $di);

      $str1 = implode(',', $di);
      $str2 = str_replace(', ', ",", $t->diagnosis);

      $array1 = explode(',', $str1);
      $array2 = explode(',', $str2);


      $array1 = array_diff($array1, $array2);
      
      $trt = DB::table('treatments')->whereIn('treatments', explode(',', $str2))->get();

      $d = json_decode(json_encode($trt), true);
      $_add_on = array_column($d, 'color_code');
      $color_code = array_unique($_add_on);
      $t->color = implode(',', $color_code);


      if (str_contains($t->color, '1')) {
        $t->color = 'Red';
        $c = 1;
      } else if (str_contains($t->color, '2')) {
        $t->color = 'Yellow';
        $c = 2;
      } else {
        $t->color = 'Green';
        $c = 3;
      }
      //
      if ($request->user_id != 0) {

        User::where('id', $request->user_id)->update([
          'color_code' => $c
        ]);
      } else {
        DB::table('quick_visit')->where('email', $request->email)->update([
          'color_code' => $c
        ]);
      }


      if ($request->gender == 'Male') {

        $t->diagnosis = str_replace('(W)', '(M)',  $t->diagnosis);
      } else {
        $t->diagnosis = str_replace('(M)', '(W)',  $t->diagnosis);
      }
      $t->diagnosis = str_replace(',,', ",", $t->diagnosis);
      if(count($array1)==0)
      {
        $other_dia = 'NA';
      }
      else{
        $other_dia = implode(',',$array1);
      }

      return response()->json([
        'success' => '1',
        "message" => "Here all the possible solutions",
        "symp" => str_replace(",None", "", $symp),
        "zone" => $t->color,
        "diagonosis" => ucfirst($str2),
        "diagonosis_2" => $other_dia
      ], 200);
    } else {


      return response()->json([
        'success' => '1',
        "message" => "Here all the possible solutions",
        "symp" => str_replace(",None", "", $symp),
        "zone" => "",
        "diagonosis" => "",
        "diagonosis_2" => ""
      ], 200);
    }
  }

  public function show_data_quick_visit(Request $request)
  {
    $validation = Validator::make($request->all(), [


      'email' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('quick_visit')->select('quick_visit.height', 'quick_visit.weight', 'quick_visit.gender', 'quick_visit.year', 'quick_visit.name', 'quick_visit.dob', 'quick_visit.color_code')->where('quick_visit.email', $request->email)->first();



    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "Here Quick Visit user no data found",

      ], 200);
    }
    $h = explode("'", $data->height);
    if ($data->color_code == 1) {
      $data->color_code = 'Red';
    } else if ($data->color_code == 2) {
      $data->color_code = 'Yellow';
    } else {
      $data->color_code = 'Green';
    }
    $data->feet = $h[0];
    $data->inch = $h[1];
    return response()->json([
      'success' => '1',
      "message" => "Here Quick Visit user data",
      "response" =>  $data
    ], 200);
  }
  public function doctors_list(Request $request)
  {
    $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation', 'qualification')->where('role', 1)->where('status', 2)->orderBy('name', 'ASC')->get();
    $data1 = [];
    foreach ($data as $row) {
      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }
      // $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      if ($row->fee_per_consultation != '') {
        $f = explode(',', $row->fee_per_consultation);
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
      }
      $row->name = 'Dr. ' . ucfirst($row->name);
      $row->rating = avg_rating($row->id);
      $row->avl_slots = getAvailability($row->id, $request->time_zone);
      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(', ', $_add_on);
      $row->about = substr($row->about, 0, 30);

      $row->rating_count = review_count($row->id);

      array_push($data1, $row);
    }
    $names = array();

    foreach ($data1 as $key => $val) {

      $names[$key] = $val['rating'];
    }

    array_multisort($names, SORT_DESC, $data1);



    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor List",

        "response" =>  $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No doctor found",
        "response" => $data1
      ], 200);
    }
  }
  public function add_to_fav(Request $request)
  {
    $validation = Validator::make($request->all(), [


      'doctor_id' => 'required',
      'patient_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('favourites')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->first();

    if (!$data) {
      $d = DB::table('favourites')->insert([
        'doctor_id' => $request->doctor_id,
        'patient_id' => $request->patient_id
      ]);
      return response()->json([
        'success' => '1',
        "message" => "Doctor added to favorite"

      ], 200);
    } else {
      DB::table('favourites')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->delete();
      return response()->json([
        'success' => '0',
        "message" => "Doctor removed from favorite"

      ], 200);
    }
  }

  public function list_of_fav_doctors(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'patient_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('favourites')->select('users.id', 'users.last_name as name', 'users.phone', 'users.profile_image', 'users.specility_id as speciality', 'users.about', 'users.status', 'users.consultation', 'users.fee_per_consultation', 'users.qualification')->where('favourites.patient_id', $request->patient_id)->join('users', 'users.id', 'favourites.doctor_id')->orderBy('favourites.id', 'DESC')->get();
    $data1 = [];
    foreach ($data as $row) {

      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }

      //  $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      if ($row->fee_per_consultation != '') {
        $f = explode(',', $row->fee_per_consultation);
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
      }

      $row->rating = avg_rating($row->id);

      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();

      $row->name = 'Dr. ' . ucfirst($row->name);
      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(', ', $_add_on);
      $row->about = substr($row->about, 0, 30);


      array_push($data1, $row);
    }


    if ($data1) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor Favorite List",

        "response" =>  $data1
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No doctor found",
        "response" => $data1
      ], 200);
    }
  }
  public function chk_fav(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'doctor_id' => 'required',
      'patient_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('favourites')->where('doctor_id', $request->doctor_id)->where('patient_id', $request->patient_id)->first();

    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "Favorite or not",
        "response" => false
      ], 200);
    } else {
      return response()->json([
        'success' => '1',
        "message" => "Favorite or not",
        "response" => true
      ], 200);
    }
  }
  public function patient_allergy_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('quick_visit')->select('id', 'allergy')->where('email', $request->email)->first();
    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Allergy::select('id', 'allergy as name')->whereIn('id', explode(',', $data->allergy))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Allergy for quick chat bot",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function medical_history_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('id', 'medical_id')->where('email', $request->email)->first();


    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = MedicalHistory::select('id', 'medical as name')->whereIn('id', explode(',', $data->medical_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Medical History for quick chat bot",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function lab_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('id', 'lab')->where('email', $request->email)->first();


    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Lab::select('id', 'lab as name')->whereIn('id', explode(',', $data->lab))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient Lab data for quick chatbot",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }

  public function lab_doc_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('lab_result')->where('email', $request->email)->first();
    if ($data) {
      $data->lab_result = explode(',', $data->lab_result);
    }


    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }


    return response()->json([
      'success' => '1',
      "message" => "Patient Lab doc for quick chatbot",
      "response" =>   $data
    ], 200);
  }

  public function surgical_doc_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('surgical_result')->where('email', $request->email)->first();

    if ($data) {
      $data->surgical_result = explode(',', $data->surgical_result);
    }



    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }


    return response()->json([
      'success' => '1',
      "message" => "Patient surgical doc for quick chatbot",
      "response" =>   $data
    ], 200);
  }
  public function surgical_history_quick_chat(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('surgical_history')->where('email', $request->email)->first();


    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Surgery::select('id', 'surgery as name')->whereIn('id', explode(',', $data->surgical_history))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient surgical history for quick chat",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }
  public function medication_for_quick_chat_bot(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'email' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('quick_visit')->select('id', 'med_id')->where('email', $request->email)->first();


    if (!$data) {
      return response()->json([
        'success' => '0',
        "message" => "no data found",

      ], 200);
    }
    $spl = Medication::select('id', 'title as name')->whereIn('id', explode(',', $data->med_id))->get();
    if ($spl) {
      return response()->json([
        'success' => '1',
        "message" => "Patient medicine data for quick chatbot",
        "response" =>   $spl
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No data found",
        "response" =>   $spl
      ], 200);
    }
  }

  public function sendNotificationToDoctor(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'patient_id' => 'required',
      'booking_id' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $d = User::where('id', $request->doctor_id)->first();
    $p = User::where('id', $request->patient_id)->first();

    $book = DB::table('appointments')->where('id', $request->booking_id)->first();


    $pt = explode(' ', $p->name);

    $msg = "Hello Dr. " . ucfirst($d->last_name) . ", you have an appointment with Patient " . $pt[0] . " on " . date("m/d/Y", strtotime($book->date)) . " at " . get_change_utc_to_timezone(date("h:i a", strtotime($book->slot_start)), $request->time_zone) . ". We will send you a reminder prior to your upcoming appointment.";


    DB::table('notifications')->insert([
      'doctor_id' => $request->doctor_id,
      'msg' => $msg,
      'start_time' => $book->slot_start,
      'created_at' => $book->date

    ]);



    $firebaseToken = $request->fcm_token;

    //print_r($firebaseToken);
    $SERVER_API_KEY = "AAAA_NY2eGQ:APA91bH1XVJNVy_JsnmY8j4KqQgCVCVlV6lzLRkHsP9QjrW4s-p83-myv_yQGEW5N11U9WIZuYGHxnWioxipOE10lxdTjzR_-l09COou8Nf81X9CGqdsKT7N7j0ys7GkayFHf5U6eIzG";

    $data = [
      "registration_ids" => array($d->fcm_token),
      "notification" => [
        "title" => "DoctorApp",
        "body" => $msg,
      ]
    ];
    $dataString = json_encode($data);

    $headers = [
      'Authorization: key=' . $SERVER_API_KEY,
      'Content-Type: application/json',
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

    $response = curl_exec($ch);
    return response()->json([
      'success' => '1',
      "message" => "Notification send successfully to doctor.",
      "response" =>   $response
    ], 200);
  }

  public function sendNotificationToPatient(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'patient_id' => 'required',
      'booking_id' => 'required',
      'time_zone' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $d = User::where('id', $request->doctor_id)->first();
    $p = User::where('id', $request->patient_id)->first();

    $book = DB::table('appointments')->where('id', $request->booking_id)->first();
    $pt = explode(' ', $p->name);

    $msg = "Hello " . $pt[0] . ", you have booked an appointment with Dr. " . ucfirst($d->last_name) . " on " . date("m/d/Y", strtotime($book->date)) . " at " . get_change_utc_to_timezone(date("h:i a", strtotime($book->slot_start)), $request->time_zone) . ". We will send you a reminder prior to your upcoming appointment.";


    DB::table('notifications')->insert([
      'patient_id' => $request->patient_id,
      'msg' => $msg,
      'start_time' => $book->slot_start,
      'created_at' => $book->date


    ]);


    $firebaseToken = $request->fcm_token;

    //print_r($firebaseToken);
    $SERVER_API_KEY = "AAAA_NY2eGQ:APA91bH1XVJNVy_JsnmY8j4KqQgCVCVlV6lzLRkHsP9QjrW4s-p83-myv_yQGEW5N11U9WIZuYGHxnWioxipOE10lxdTjzR_-l09COou8Nf81X9CGqdsKT7N7j0ys7GkayFHf5U6eIzG";

    $data = [
      "registration_ids" => array($p->fcm_token),
      "notification" => [
        "title" => "DoctorApp",
        "body" => $msg,
      ]
    ];
    $dataString = json_encode($data);

    $headers = [
      'Authorization: key=' . $SERVER_API_KEY,
      'Content-Type: application/json',
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

    $response = curl_exec($ch);
    return response()->json([
      'success' => '1',
      "message" => "Notification send successfully to patient.",
      "response" =>   $response
    ], 200);
  }
  public function listOfNotificationForDoctor(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'time_zone' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data = DB::table('notifications')->where('doctor_id', $request->doctor_id)->orderBy('created_at', 'DESC')->get();
    $u = [];
    foreach ($data as $row) {

      $date = new DateTime('now', new DateTimeZone($request->time_zone));
      $t = $date->format('Y-m-d H:i:s');


      $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date("h:i a", strtotime($row->start_time)), $request->time_zone)));
      $date = date('Y-m-d', strtotime($row->created_at));

      $start_datetime = new DateTime($date . ' ' . $start_time);

      $end_datetime = new DateTime($t);
      $r = $start_datetime->diff($end_datetime);


      date_default_timezone_set($request->time_zone);
      if ($r->d == 0) {

        array_push($u, $row);
      } else if ($row->created_at > date('Y-m-d')) {
        array_push($u, $row);
      }
    }





    return response()->json([
      'success' => '1',
      "message" => "Notifications of doctors",
      "response" =>  $u
    ], 200);
  }
  public function unseenForDoctor(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'time_zone' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $data = DB::table('notifications')->where('doctor_id', $request->doctor_id)->where('seen', 0)->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));
      $t = $date->format('Y-m-d H:i:s');


      $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date("h:i a", strtotime($row->start_time)), $request->time_zone)));
      $date = date('Y-m-d', strtotime($row->created_at));

      $start_datetime = new DateTime($date . ' ' . $start_time);

      $end_datetime = new DateTime($t);
      $r = $start_datetime->diff($end_datetime);


      date_default_timezone_set($request->time_zone);
      if ($r->d == 0) {

        array_push($u, $row);
      } else if ($row->created_at > date('Y-m-d')) {
        array_push($u, $row);
      }
    }

    return response()->json([
      'success' => '1',
      "message" => "Notifications of doctors",
      "response" =>  count($u)
    ], 200);
  }
  public function seenForDoctor(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data = DB::table('notifications')->where('doctor_id', $request->doctor_id)->update([
      'seen' => 1
    ]);

    return response()->json([
      'success' => '1',
      "message" => "updated all the unseen notifications of doctors",

    ], 200);
  }
  public function listOfNotificationForPatient(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    //$data = DB::table('notifications')->where('patient_id', $request->patient_id)->where('created_at', date('Y-m-d'))->where('start_time', '>', date('H:i:s'))->get();
    //$data = $data->toArray();

    $data = DB::table('notifications')->where('patient_id', $request->patient_id)->orderBy('created_at', 'DESC')->get();

    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));
      $t = $date->format('Y-m-d H:i:s');


      $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date("h:i a", strtotime($row->start_time)), $request->time_zone)));
      $date = date('Y-m-d', strtotime($row->created_at));

      $start_datetime = new DateTime($date . ' ' . $start_time);

      $end_datetime = new DateTime($t);
      $r = $start_datetime->diff($end_datetime);


      date_default_timezone_set($request->time_zone);
      if ($r->d == 0) {

        array_push($u, $row);
      } else if ($row->created_at > date('Y-m-d')) {
        array_push($u, $row);
      }
    }


    return response()->json([
      'success' => '1',
      "message" => "Notifications of patients",
      "response" =>  $u
    ], 200);
  }
  public function unseenForPatient(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
      'time_zone' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    // date_default_timezone_set('UTC');


    $data = DB::table('notifications')->where('patient_id', $request->patient_id)->where('seen', 0)->get();
    $u = [];
    foreach ($data as $row) {
      $date = new DateTime('now', new DateTimeZone($request->time_zone));
      $t = $date->format('Y-m-d H:i:s');


      $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone(date("h:i a", strtotime($row->start_time)), $request->time_zone)));
      $date = date('Y-m-d', strtotime($row->created_at));

      $start_datetime = new DateTime($date . ' ' . $start_time);

      $end_datetime = new DateTime($t);
      $r = $start_datetime->diff($end_datetime);


      date_default_timezone_set($request->time_zone);
      if ($r->d == 0) {
        if ($start_time > date('H:i:s'))
          array_push($u, $row);
      } else if ($row->created_at > date('Y-m-d')) {
        array_push($u, $row);
      }
    }

    return response()->json([
      'success' => '1',
      "message" => "Notifications of patient",
      "response" =>  count($u)
    ], 200);
  }

  public function seenForPatient(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $data = DB::table('notifications')->where('patient_id', $request->patient_id)->update([
      'seen' => 1
    ]);

    return response()->json([
      'success' => '1',
      "message" => "updated all the unseen notifications of patients",

    ], 200);
  }


  public function questions(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'pro_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = DB::table('type')->where('pro_id', $request->pro_id)->where('status', 1)->orderBy('order', 'asc')->get();


    return response()->json([
      'success' => '1',
      "message" => "List Of questions",
      "response" =>   $data
    ], 200);
  }
  public function sendNotificationToDoctorFromQc(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',

      'booking_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $d = User::where('id', $request->doctor_id)->first();


    $book = DB::table('appointments')->where('id', $request->booking_id)->first();

    $msg = "Hello Dr.  " . ucfirst($d->last_name) . " you have an appointment on " . $book->date .  " at " . date("h:i a", strtotime($book->slot_start));

    DB::table('notifications')->insert([
      'doctor_id' => $request->doctor_id,
      'msg' => $msg,
      'created_at' => $book->date
    ]);



    $firebaseToken = $request->fcm_token;

    //print_r($firebaseToken);
    $SERVER_API_KEY = "AAAA_NY2eGQ:APA91bH1XVJNVy_JsnmY8j4KqQgCVCVlV6lzLRkHsP9QjrW4s-p83-myv_yQGEW5N11U9WIZuYGHxnWioxipOE10lxdTjzR_-l09COou8Nf81X9CGqdsKT7N7j0ys7GkayFHf5U6eIzG";

    $data = [
      "registration_ids" => array($d->fcm_token),
      "notification" => [
        "title" => "DoctorApp",
        "body" => $msg,
      ]
    ];
    $dataString = json_encode($data);

    $headers = [
      'Authorization: key=' . $SERVER_API_KEY,
      'Content-Type: application/json',
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

    $response = curl_exec($ch);
    return response()->json([
      'success' => '1',
      "message" => "Notification send successfully to doctor.",
      "response" =>   $response
    ], 200);
  }



  public function audioCallApi(Request $request)
  {

    $sid = "AC1755380d57655fc9f24e9df05ede73e2";
    $token = "7bc11440fe370956303cc05b89c91de4";
    $twilio = new Client($sid, $token);

    $call = $twilio->calls
      ->create(
        "+917718684972",
        "+13203731620",
        ["url" => "http://demo.twilio.com/docs/voice.xml"]
      );
    return response()->json([
      'success' => '1',
      "message" => "Call generated",
      "response" => $call->sid
    ], 200);
  }
  public function twlioML()
  {
    $response = new VoiceResponse();
    $response->say('Hello World');

    echo $response;
  }

  public function doctor_with_skill(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'specility_id' => 'required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $data = User::select('id', 'last_name as name', 'profile_image', 'email', 'phone', 'specility_id', 'about')->where('role', 1)->where('status', 2)->get();

    $p = [];
    foreach ($data as $r) {
      $t = explode(',', $r->specility_id);
      if (in_array($request->specility_id, $t)) {
        array_push($p, $r);
      }
    }
    $data = $p;

    $d = [];
    foreach ($data as $row) {

      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }



      // $row->profile_image = URL::to('/') . '/' . $row->profile_image;

      $row->rating = avg_rating($row->id);
      $row->rating_count = review_count($row->id);
      $row->avl_slots = getAvailability($row->id, $request->time_zone);
      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->specility_id))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(', ', $_add_on);
      $row->about = substr($row->about, 0, 30);
      $row->name = 'Dr. ' . ucfirst($row->name);
      array_push($d, $row);
    }

    $names = array();

    foreach ($d as $key => $val) {

      $names[$key] = $val['rating'];
    }

    array_multisort($names, SORT_DESC, $d);


    if ($d) {
      return response()->json([
        'success' => '1',
        "message" => "Doctor List with their skills",
        "response" =>  $d
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No Doctors",
        "response" =>  $d
      ], 200);
    }
  }
  public function cancel_booking(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'booking_id' => 'required',
      'reason' => 'required'
    ], [
      'booking_id.required' => 'Booking Id Required',
      'reason.required' => 'Reason field is required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    DB::table('appointments')->where('id', $request->booking_id)->update([

      'reason' => $request->reason,
      'status' => 3
    ]);

    return response()->json([
      'success' => '1',
      "message" => "Booking cancelled successfully",

    ], 200);
  }

  public function create_stripe_payment(Request $request)
  {
    $validation = Validator::make($request->all(), [
      //'stripeToken' => 'required',

      'booking_id' => 'required'
      // 'card_no' => 'required',
      // 'month' => 'required',
      // 'year' => 'required',
      // 'brand' => 'required'

    ], [
      // 'stripeToken.required' => 'Stripe Token Required',

      'booking_id.required' => 'Booking Id Required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    //  Stripe\Stripe::setApiKey("sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv");
    try {
      $stripe = new \Stripe\StripeClient(
        'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
      );
      $a = DB::table('appointments')->where('id', $request->booking_id)->first();

      $card_chk = DB::table('card')->where('card_no', $request->card_no)->where('user_id', $a->patient_id)->first();
      if (empty($card_chk)) {
        $customer = $stripe->customers->create([

          'description' => 'My First Test Customer (created for API docs at https://www.stripe.com/docs/api)',
        ]);



        $card = $stripe->customers->createSource(
          $customer->id,
          ['source' => $request->stripeToken]
        );


        //$stripe->charges->create([
        // "amount" => $request->amount * 100,
        // "currency" => "usd",
        // "source" => $card->id,
        // "customer" => $customer->id,
        // "description" => "Test payment from tutsmake.com."
        // ]);
        // DB::table('appointments')->where('id', $request->booking_id)->update([

        //   'payment_status' => 1

        // ]);



        DB::table('card')->insert([

          'user_id' => $a->patient_id,
          'card_no' => $request->card_no,
          'cvv' => $request->cvv,
          'month' => $request->month,
          'year' => $request->year,
          'token' => $request->stripeToken,
          'brand' => $request->brand,
          'customer_id' => $customer->id,
          'card_id' => $card->id
        ]);

        return response()->json([
          'success' => '1',
          "doctor_id" => $a->doctor_id,
          "message" => "Card added successfully",

        ], 200);
      } else {


        return response()->json([
          'success' => '1',
          "doctor_id" => $a->doctor_id,
          "message" => "Card already added",

        ], 200);
      }
    } catch (\Stripe\Exception\ApiErrorException $e) {



      return response()->json([
        'success' => '0',
        "message" =>  $e->getError()->message


      ], 200);
    }
  }

  public function create_stripe_payment_add(Request $request)
  {
    $validation = Validator::make($request->all(), [
      //'stripeToken' => 'required',

      'user_id' => 'required'
      // 'card_no' => 'required',
      // 'month' => 'required',
      // 'year' => 'required',
      // 'brand' => 'required'

    ], [
      // 'stripeToken.required' => 'Stripe Token Required',

      'user_id.required' => 'Booking Id Required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    //  Stripe\Stripe::setApiKey("sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv");
    try {
      $stripe = new \Stripe\StripeClient(
        'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
      );
      // $a = DB::table('appointments')->where('id', $request->booking_id)->first();

      $card_chk = DB::table('card')->where('card_no', $request->card_no)->where('user_id', $request->user_id)->first();
      if (empty($card_chk)) {
        $customer = $stripe->customers->create([

          'description' => 'My First Test Customer (created for API docs at https://www.stripe.com/docs/api)',
        ]);



        $card = $stripe->customers->createSource(
          $customer->id,
          ['source' => $request->stripeToken]
        );


        //$stripe->charges->create([
        // "amount" => $request->amount * 100,
        // "currency" => "usd",
        // "source" => $card->id,
        // "customer" => $customer->id,
        // "description" => "Test payment from tutsmake.com."
        // ]);
        // DB::table('appointments')->where('id', $request->booking_id)->update([

        //   'payment_status' => 1

        // ]);



        DB::table('card')->insert([

          'user_id' => $request->user_id,
          'card_no' => $request->card_no,
          'cvv' => $request->cvv,
          'month' => $request->month,
          'year' => $request->year,
          'token' => $request->stripeToken,
          'brand' => $request->brand,
          'customer_id' => $customer->id,
          'card_id' => $card->id
        ]);

        return response()->json([
          'success' => '1',

          "message" => "Card added successfully",

        ], 200);
      } else {


        return response()->json([
          'success' => '1',

          "message" => "Card Already Added",

        ], 200);
      }
    } catch (\Stripe\Exception\ApiErrorException $e) {



      return response()->json([
        'success' => '0',
        "message" =>  $e->getError()->message


      ], 200);
    }
  }


  public function list_of_account_details(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'patient_id' => 'required',
    ], [
      'patient_id.required' => 'Patient id Required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $r = DB::table('card')->select('card.*', 'users.name')->join('users', 'users.id', 'card.user_id')->where('card.user_id', $request->patient_id)->orderBy('id', 'ASC')->get();

    foreach ($r as $row) {
      if (strlen($row->card_no) == 16) {
        $row->card_no = substr($row->card_no, -4);
      }
    }

    return response()->json([
      'success' => 1,
      "message" => "List of card details",
      "data" => $r
    ], 200);
  }
  public function save_account_details(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'user_id' => 'required',
      'cvv' => 'required',
      'card_no' => 'required',
      'month' => 'required',
      'year' => 'required'

    ], [
      'user_id.required' => 'user id Required',
      'cvv.required' => 'cvv Required',
      'card_no.required' => 'card no Required',
      'month.required' => 'month Required',
      'year.required' => 'year required'


    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    if ($request->year < date("Y")) {
      return response()->json([
        'success' => 0,
        "message" => "Expiry year must be grater or equal to current year",

      ], 200);
    }

    if ($request->month > 12) {
      return response()->json([
        'success' => 0,
        "message" => "Invalid expiry month",

      ], 200);
    }

    if ($request->year == date("Y") && $request->month <= date("m")) {
      return response()->json([
        'success' => 0,
        "message" => "Invalid expiry month",

      ], 200);
    }





    DB::table('card')->insert([

      'user_id' => $request->user_id,
      'card_no' => $request->card_no,
      'cvv' => $request->cvv,
      'month' => $request->month,
      'year' => $request->year


    ]);

    return response()->json([
      'success' => 1,
      "message" => "Save account details",

    ], 200);
  }
  public function set_account_default(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'card_id' => 'required'


    ], [
      'card_id.required' => 'card id Required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $c = DB::table('card')->where('id', $request->card_id)->first();
    DB::table('card')->where('id', $request->card_id)->update([
      'default' => 1
    ]);
    DB::table('card')->where('user_id', $c->user_id)->whereNotIn('id', [$request->card_id])->update([
      'default' => 0
    ]);
    return response()->json([
      'success' => 1,
      "message" => "Default account set",

    ], 200);
  }

  public function get_account_default(Request $request)
  {
    $validation = Validator::make($request->all(), [

      'user_id' => 'required'


    ], [
      'user_id.required' => 'user id Required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $c = DB::table('card')->where('user_id', $request->user_id)->where('default', 1)->first();

    return response()->json([
      'success' => 1,
      "message" => "Default account details",
      "response" => $c

    ], 200);
  }


  public function pay_now(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'booking_id' => 'required',
      'amount' => 'required'


    ], [
      'booking_id.required' => 'booking id Required',
      'amount.required' => 'amount Required',
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $a = DB::table('appointments')->where('id', $request->booking_id)->first();
    $stripe = new \Stripe\StripeClient(
      'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
    );
    $card_chk_d = DB::table('card')->where('default', 1)->where('user_id', $a->patient_id)->first();
    if (!empty($card_chk_d)) {
      $stripe->charges->create([
        "amount" => $request->amount * 100,
        "currency" => "usd",
        "source" => $card_chk_d->card_id,
        "customer" => $card_chk_d->customer_id,
        "description" => "Test payment from tutsmake.com."
      ]);
      DB::table('appointments')->where('id', $request->booking_id)->update([

        'payment_status' => 1

      ]);

      $a_b = DB::table('users')->where('id', $a->doctor_id)->first();
      $book = DB::table('appointments')->where('id', $request->booking_id)->first();
      $user = User::find($a->doctor_id);
      $user->consultation = $user->consultation + 1;
      $user->avl_bal = $a_b->avl_bal + $book->doctor_fee;
      $user->save();
      return response()->json([
        'success' => '1',
        "doctor_id" => $a->doctor_id,

        "app_type" => $a->app_type,
        "message" => "Payment successfull!",

      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "Please select a card",

      ], 200);
    }
  }

  public function delete_card(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'card_id' => 'required'


    ], [
      'card_id.required' => 'card id Required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }

    $c = DB::table('card')->where('id', $request->card_id)->first();

    $stripe = new \Stripe\StripeClient(
      'sk_test_51MmHexI0cD0FsbEB5nhfgGysGGBuFOjAUYUehvLYdJEmeGLDy8wDi5aHLnxGapfNStKFrwNHlz9nloOV5zEAK4sZ00BxDCXrTv'
    );
    $stripe->customers->deleteSource(
      $c->customer_id,
      $c->card_id,
      []
    );

    $stripe->customers->delete(
      $c->customer_id,
      []
    );


    DB::table('card')->where('id', $request->card_id)->delete();

    return response()->json([
      'success' => '1',
      "message" => "Card deleted successfully",

    ], 200);
  }

  public function payment_status_chk()
  {


    $data = DB::table('payment_mode')->first();

    if ($data->status == 1) {
      $data->status = 'enable';
    } else {
      $data->status = 'disable';
    }

    return response()->json([
      'success' => '1',
      "message" => "Payment status",
      'response' => $data

    ], 200);
  }

  public function profile_update_or_not_status_chk(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'user_id' => 'required'

    ], [
      'user_id.required' => 'user id required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $r = DB::table('users')->where('id', $request->user_id)->first();

    if ($r->address != '' && $r->sex != '' && $r->dob != '' &&  $r->age != '') {
      return response()->json([
        'success' => '1',
        "message" => "Go for quick chat bot",

      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "Can't go for quick chat bot",

      ], 200);
    }
  }



  public function back_problems(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'selected_id' => 'required',
      'problem_id' => 'required'

    ], [
      'selected_id.required' => 'selected id required',
      'problem_id.required' => 'problem id required',

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $s = DB::table('symptoms')->where('pro_id', $request->problem_id)->whereIn('id', explode(',', $request->selected_id))->get();
    $u = [];
    foreach ($s as $row) {
      $row->condition = true;
      array_push($u, $row);
    }
    //print_r($u);

    $ns = DB::table('symptoms')->where('pro_id', $request->problem_id)->whereNotIn('id', explode(',', $request->selected_id))->get();
    $p = [];
    foreach ($ns as $row) {
      $row->condition = false;
      array_push($p, $row);
    }
    //print_r($ns);
    $data = array_merge($u, $p);


    $names = array();

    foreach ($data as $key => $val) {

      $names[$key] = $val->id;
    }

    array_multisort($names, SORT_ASC, $data);




    return response()->json([
      'success' => '1',
      "message" => "Selected Problems Chk",
      'response' => $data

    ], 200);
  }
  public function next_button_selection(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'ques_id' => 'required',
      'selected_id' => 'required'

    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $r = explode(',', $request->selected_id);
    $data = DB::table('symptoms')->where('symptoms', 'None')->where('type', $request->ques_id)->first();
    if ($data) {
      if (str_contains($data->id, $request->selected_id)) {

        $data_2 = DB::table('symptoms')->where('type', $request->ques_id)->get();


        $u = [];

        foreach ($data_2 as $t) {
          if ($t->id == $data->id) {

            $t->con = true;
          } else {
            $t->con = false;
          }
          array_push($u, $t);
        }
        return response()->json([
          'success' => '1',
          'message' => 'None Button Selection Process',
          "response" => $u,

        ], 200);
      } else {
        $data_2 = DB::table('symptoms')->where('type', $request->ques_id)->get();


        $u = [];

        foreach ($data_2 as $t) {
          if ($t->id == $data->id) {

            $t->con = false;
          } else {
            $t->con = true;
          }
          array_push($u, $t);
        }
        return response()->json([
          'success' => '1',
          'message' => 'None Button Selection Process',
          "response" => $u,

        ], 200);
      }
    }
  }
  public function sendNotificationToDoctorBooking(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'patient_id' => 'required',
      'booking_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $d = User::where('id', $request->doctor_id)->first();


    $book = DB::table('appointments')->where('id', $request->booking_id)->first();

    if ($book->note_a != 1) {

      $msg = "Hello " . $d->name . ", your consultation started";

      $firebaseToken = $request->fcm_token;

      //print_r($firebaseToken);
      $SERVER_API_KEY = "AAAA_NY2eGQ:APA91bH1XVJNVy_JsnmY8j4KqQgCVCVlV6lzLRkHsP9QjrW4s-p83-myv_yQGEW5N11U9WIZuYGHxnWioxipOE10lxdTjzR_-l09COou8Nf81X9CGqdsKT7N7j0ys7GkayFHf5U6eIzG";

      $data = [
        "registration_ids" => array($d->fcm_token),
        "notification" => [
          "title" => "DoctorApp",
          "body" => $msg,
        ]
      ];
      $dataString = json_encode($data);

      $headers = [
        'Authorization: key=' . $SERVER_API_KEY,
        'Content-Type: application/json',
      ];

      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

      $response = curl_exec($ch);

      DB::table('appointments')->where('id', $request->booking_id)->update([
        'note_a' => 1,
        'joined_d' => 1
      ]);



      return response()->json([
        'success' => '1',
        "message" => "Notification send successfully to doctor.",
        "response" => $response
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "Notification already send",

      ], 200);
    }
  }

  public function sendNotificationToPatientBooking(Request $request)
  {

    $validation = Validator::make($request->all(), [
      'doctor_id' => 'required',
      'patient_id' => 'required',
      'booking_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }
    $p = User::where('id', $request->patient_id)->first();


    $book = DB::table('appointments')->where('id', $request->booking_id)->first();



    if ($book->note_p != 1) {

      $msg = "Hello " . $p->name . ", your consultation started";

      $firebaseToken = $request->fcm_token;

      //print_r($firebaseToken);
      $SERVER_API_KEY = "AAAA_NY2eGQ:APA91bH1XVJNVy_JsnmY8j4KqQgCVCVlV6lzLRkHsP9QjrW4s-p83-myv_yQGEW5N11U9WIZuYGHxnWioxipOE10lxdTjzR_-l09COou8Nf81X9CGqdsKT7N7j0ys7GkayFHf5U6eIzG";

      $data = [
        "registration_ids" => array($p->fcm_token),
        "notification" => [
          "title" => "DoctorApp",
          "body" => $msg,
        ]
      ];
      $dataString = json_encode($data);

      $headers = [
        'Authorization: key=' . $SERVER_API_KEY,
        'Content-Type: application/json',
      ];

      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

      $response = curl_exec($ch);

      DB::table('appointments')->where('id', $request->booking_id)->update([
        'note_p' => 1,
        'joined_p' => 1
      ]);


      return response()->json([
        'success' => '1',
        "message" => "Notification send successfully to patient.",
        "response" => $response
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "Notification already send",

      ], 200);
    }
  }

  public function show_msg_to_doctor(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'booking_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $book = DB::table('appointments')->where('id', $request->booking_id)->first();

    if ($book->note_p != 1) {
      return response()->json([
        'success' => '1',
        "message" => "Show Message",
        "response" => "Awaiting for other party to join"
      ], 200);
    } else if ($book->note_p == 1 && $book->joined_p == 0) {
      return response()->json([
        'success' => '2',
        "message" => "Show Message",
        "response" => "left"
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No message to show"

      ], 200);
    }
  }

  public function show_msg_to_patient(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'booking_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $book = DB::table('appointments')->where('id', $request->booking_id)->first();

    if ($book->note_a != 1) {
      return response()->json([
        'success' => '1',
        "message" => "Show Message",
        "response" => "Awaiting for other party to join"
      ], 200);
    } else if ($book->note_a == 1 && $book->joined_d == 0) {
      return response()->json([
        'success' => '2',
        "message" => "Show Message",
        "response" => "left"
      ], 200);
    } else {
      return response()->json([
        'success' => '0',
        "message" => "No message to show"

      ], 200);
    }
  }
  public function consultation_type(Request $request)
  {

    $validation = Validator::make($request->all(), [

      'avl_id' => 'required'
    ]);
    if ($validation->fails()) {
      $errors = $validation->errors();

      return response()->json([
        'errors' => $errors
      ], 403);
    }


    $book = DB::table('availability')->where('id', $request->avl_id)->first();
    $t = explode(',', $book->type);
    return response()->json([
      'success' => '1',
      "message" => "Show Message",
      "response" => $book->type



    ], 200);
  }
  public function sorting(Request $request)
  {
    // $validation = Validator::make($request->all(), [
    //   'keyword' => 'required',

    // ], ['keyword.required' => 'Please select any skill/specialization']);
    // if ($validation->fails()) {
    //   $errors = $validation->errors();

    //   return response()->json([
    //     'errors' => $errors
    //   ], 403);
    // }
    $search = $request->keyword;
    $ser = DB::table('services')->where('name', 'LIKE', "$search%")->first();
    if ($search == '') {
      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation', 'lat', 'lang')->where('role', 1)->where('status', 2)->where('fee_per_consultation', '!=', '')->get();
    } else {
      $search = $ser->id;
      $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'specility_id as speciality', 'about', 'status', 'consultation', 'fee_per_consultation', 'lat', 'lang')->where('role', 1)->where('status', 2)->where('fee_per_consultation', '!=', '')->get();
      $p = [];
      foreach ($data as $r) {
        $t = explode(',', $r->speciality);
        if (in_array($search, $t)) {
          array_push($p, $r);
        }
      }
      $data = $p;
    }





    foreach ($data as $row) {

      $row->name = 'Dr. ' . ucfirst($row->name);

      // $row->avl_slots = getAvailability($row->id, $request->time_zone);
      $row->avl_slots = getAvailability_c($row->id, $request->time_zone);


      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }


      $row->rating_count = review_count($row->id);

      // $row->profile_image = URL::to('/') . '/' . $row->profile_image;

      if ($row->fee_per_consultation != '') {

        $f = explode(',', $row->fee_per_consultation);
        $row->video_fee = $f[0];
        $row->audio_fee = $f[1];
        $row->chat_fee = $f[2];
      }
      $row->rating = avg_rating($row->id);

      $dpl = DB::table('services')->select('name as spli')->whereIn('id', explode(',', $row->speciality))->get();


      $users = json_decode(json_encode($dpl), true);
      $_add_on = array_column($users, 'spli');
      $row->speciality = implode(', ', $_add_on);
      $row->about = substr($row->about, 0, 30);
    }

    if (isset($request->long1) && isset($request->lat1)) {
      $data1 = [];
      $lon1 = $request->long1;
      $lat1 = $request->lat1;
      foreach ($data as $row) {

        if ($row->lang !== '') {
          $lon2 = $row->lang;
        }

        if ($row->lat !== '') {
          $lat2 = $row->lat;
        }


        $unit =  intval($request->distance);

        //echo 3;
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));

        // echo 4;
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);


        $distance = round($miles * 1.609344);
        $f = explode(',', $row->fee_per_consultation);

        if ($distance <= $unit) {
          $row->video_fee = $f[0];
          $row->audio_fee = $f[1];
          $row->chat_fee = $f[2];

          $row->distance = $distance . 'KM';
          array_push($data1, $row);
        }
      }
      $data = $data1;
    }

    if (isset($request->type) && isset($request->price_range)) {
      $data1 = [];
      foreach ($data as $row) {
        if ($row->fee_per_consultation != '') {
          $fee = explode(',', $row->fee_per_consultation);
          if ($request->type == 'All') {
            array_push($data1, $row);
          } else if ($request->type == 'V') {
            if ($fee[0] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'A') {
            if ($fee[1] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'C') {
            if ($fee[2] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'V,A' || $request->type == 'A,V') {
            if ($fee[0] <= $request->price_range || $fee[1] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'A,C' || $request->type == 'C,A') {
            if ($fee[1] <= $request->price_range || $fee[2] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'C,V' || $request->type == 'V,C') {
            if ($fee[2] <= $request->price_range || $fee[0] <= $request->price_range) {

              array_push($data1, $row);
            }
          } elseif ($request->type == 'A,V,C') {
            if ($fee[2] <= $request->price_range || $fee[0] <= $request->price_range || $fee[1] <= $request->price_range) {

              array_push($data1, $row);
            }
          } else {
            if (count($fee) == 3) {
              array_push($data1, $row);
            }
          }
        }
      }
      $data = $data1;
    }




    if (isset($request->rating)) {

      $u = [];
      foreach ($data as $row) {
        if (avg_rating($row->id) >= $request->rating) {
          array_push($u, $row);
        }
      }
      $data = $u;
    }




    if (isset($request->consultation)) {

      if (!isset($request->keyword) && !isset($request->rating) && !isset($request->lat1) && !isset($request->long1) && $request->type == 'All') {
        $data = $data->toArray();
      } elseif (!isset($request->keyword) && !isset($request->rating) && !isset($request->lat1) && !isset($request->long1) && !isset($request->type)) {
        $data = $data->toArray();
      }


      $names = array();

      foreach ($data as $key => $val) {

        $names[$key] = $val['consultation'];
      }

      if ($request->consultation == 'low') {


        array_multisort($names, SORT_ASC, $data);
      } else {
        array_multisort($names, SORT_DESC, $data);
      }
    }



    return response()->json([
      'success' => '1',
      "message" => "Doctor list",
      "response" => $data



    ], 200);
  }

  public function top_doctors()
  {
    $data = User::select('id', 'last_name as name', 'phone', 'profile_image', 'about', 'status', 'consultation')->where('role', 1)->where('status', 2)->where('fee_per_consultation', '!=', '')->get();
    $data1 = [];

    foreach ($data as $row) {

      $row->name = 'Dr. ' . ucfirst($row->name);
      if ($row->profile_image != '') {
        $row->profile_image = URL::to('/') . '/' . $row->profile_image;
      } else {
        $row->profile_image = 'https://www.seekpng.com/png/detail/46-462959_unknown-person-icon-png-download-single-people-logo.png';
      }
      $row->rating = avg_rating($row->id);
      // if ($row->rating > 0) {
      array_push($data1, $row);
      // }
    }

    $names = array();

    foreach ($data1 as $key => $val) {

      $names[$key] = $val['rating'];
    }

    array_multisort($names, SORT_DESC, $data1);

    return response()->json([
      'success' => '1',
      "message" => "Top doctor list",
      "response" => $data1
    ], 200);
  }

  public function leave_patient(Request $request)
  {
    $validator = Validator::make($request->all(), [

      'booking_id' => 'required'
    ]);




    $data = DB::table('appointments')->where('id', $request->booking_id)->update([
      'joined_p' => 0,

    ]);

    return response()->json([
      'success' => '2',
      "message" => "Patient Left",

    ], 200);
  }
  public function join_patient(Request $request)
  {
    $validator = Validator::make($request->all(), [

      'booking_id' => 'required'
    ]);




    $data = DB::table('appointments')->where('id', $request->booking_id)->update([
      'joined_p' => 1,

    ]);

    return response()->json([
      'success' => '1',
      "message" => "Patient joined",

    ], 200);
  }
}
