<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Mail\AdminVerification;
use App\Mail\Registration;
use App\Models\Role;
use App\Models\UserProfile;
use App\Models\VendorSubscription;
use App\Models\BusinessCategory;
use App\Models\Appointment;
use App\Models\User;
use App\Models\ColorCode;
use App\Models\Reason;
use App\Models\ContactInfo;
use App\Models\Allergy;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Config;
use Session;


class UserController extends Controller
{
  public $per_page = 2;
  public function userList(Request $request, $type)
  {
    //   $users = User::whereRole($type);
    if ($request->search) {
      if ($type == 2) {
        $b_cs = BusinessCategory::select('name', 'id')->where('name', 'LIKE', "%{$request->search}%")->get();
        $users = User::where('role', $type)
          ->where(function ($query) use ($request, $b_cs) {
            $query->where('name', 'LIKE', "%{$request->search}%")
              ->orWhere('business_name', 'LIKE', "%{$request->search}%")
              ->orWhereHas('profile', function ($query) use ($b_cs) {
                $j = count($b_cs);
                $i = 0;
                foreach ($b_cs as $bc) {
                  $i++;
                  if ($j == 1) {

                    $query->where('business_type', 'LIKE', "%{$bc->id}%");
                  } elseif ($j > $i && $i == 1) {
                    $query->where('business_type', 'LIKE', "%{$bc->id}%");
                  } elseif ($j > $i && $i > 1) {
                    $query->orWhere('business_type', 'LIKE', "%{$bc->id}%");
                  }
                }
              });
          });
      } else {
        $users = User::where('role', $type)
          ->where(function ($query) use ($request) {
            $query->where('name', 'LIKE', "%{$request->search}%")
              ->orWhere('email', 'LIKE', "%{$request->search}%");
          });
      }
    } else {
      $users = User::where('role', $type);
    }

    $users = $users->latest()->paginate(10);
    $users = $users->appends(request()->query());
    $total_users = User::whereStatus(1)->where('role', $type)->count();
    //   user::select('asd')->get();
    return view('admin.user.list', compact('users', 'total_users', 'type'));
  }

  public function addUser(Request $request)
  {
    if ($request->isMethod('post')) {

      $validator = $request->validate(
        [
          "name" => "required",
          "email" => "required|email|unique:users,email",
          "password" => "required|min:6",
          "confirm_password" => "required|same:password",
        ]
      );

      DB::beginTransaction();
      try {
        $user = new User;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->save();

        $role = Role::where('role', 'user')->first();
        $user->role = $role->id;
        $user->save();

        Mail::to($request->email)->send(new Registration($user->id));
        DB::commit();
        if (!empty($user->id)) {
          Session::flash('Success-toastr', 'Registration successfully.');
        } else {
          Session::flash('Error-toastr', 'Something want wrong. Please try again.');
        }
        return redirect()->back();
      } catch (\Exception $e) {
        Session::flash('Error', $e->getMessage());
        DB::rollback();
        return redirect()->back();
      }
    }
    return view('admin.user.add');
  }

  public function userView($role, $id)
  {
    $user = User::find($id);
    return view('admin.user.view', compact('user', 'role'));
  }

  public function userEdit($role, $id)
  {
    $user = User::find($id);
    return view('admin.user.edit', compact('user', 'role'));
  }

  public function userUpdate(Request $request)
  {
    $data = $request->validate([
      "name" => "sometimes|required|min:3|max:100",
      "mobile" => "sometimes|nullable|digits:10",
      //   "dob"=>"sometimes|nullable|date|before_or_equal:".now()->subYears(13)->format('Y-m-d'),
      "profile_photo" => "sometimes|nullable|image|mimes:jpeg,png,jpg|max:2048",
      //   "old_password"=>"sometimes|nullable|required",
      //   "new_password"=>"sometimes|nullable|required|min:6",
      //   "confirm_password"=>"sometimes|nullable|required|same:new_password",
    ], [
      //   'dob.before_or_equal'=>'You must be 13 years old or above.'
    ]);


    try {
      $user = User::find($request->user_id);
      if (!empty($request->email) && ($user->email != $request->email)) {
        $request->validate([
          'email' => 'sometimes|nullable|required|unique:users,email',
        ]);
      }
      if (!empty($request->name)) $user->name = $request->name;
      if (!empty($request->email) && ($user->email != $request->email)) $user->email = $request->email;
      // if (isset($request->old_password) && !empty($request->old_password)) {
      //   if (!(Hash::check($request->old_password, Auth::guard('siteUser')->user()->password))) {
      //       Session::flash('Error-toastr', 'Your old password does not matches');
      //      return redirect()->back();
      //   } elseif (!empty($request->new_password)){
      //   $user->password = Hash::make($request->new_password);
      //   }
      // }
      if (!empty($request->mobile)) $user->mobile = $request->mobile;
      if (!empty($request->business_name)) $user->business_name = $request->business_name;

      $user->save();
      $profile = UserProfile::where('user_id', $user->id)->first();
      $profile = $profile ?? new UserProfile;
      $profile->user_id = $user->id;

      if (!empty($request->dob)) $profile->dob = $request->dob;
      if (!empty($request->mobile)) $profile->mobile = $request->mobile;
      if (!empty($request->gender)) $profile->gender = $request->gender;
      if (!empty($request->address)) $profile->address = $request->address;
      if (!empty($request->about)) $profile->about = $request->about;

      if ($request->hasFile('profile_photo')) {
        $rand_val           = date('YMDHIS') . rand(11111, 99999);
        $image_file_name    = md5($rand_val);
        $file               = $request->file('profile_photo');
        $extension          = $request->file('profile_photo')->extension();
        $fileName           = $image_file_name . '.' . $extension;
        $destinationPath    = public_path() . '/uploads/users/';
        $file->move($destinationPath, $fileName);
        $profile->profile_photo = $fileName;
      }

      if ($request->hasFile('document')) {
        $rand_val           = date('YMDHIS') . rand(11111, 99999);
        $image_file_name    = md5($rand_val);
        $file               = $request->file('document');
        $extension          = $request->file('document')->extension();
        $fileName           = $image_file_name . '.' . $extension;
        $destinationPath    = public_path() . '/uploads/users/document';
        $file->move($destinationPath, $fileName);
        $profile->document = $fileName;
      }
      $profile->save();
      Session::flash('Success-toastr', 'Profile Successfully updated');
    } catch (\Exception $e) {
      Session::flash('Error-toastr', $e->getMessage());
    }
    // return redirect()->back();

    return redirect()->route('admin.users', $user->role);
  }

  public function userDelete($uid = '', Request $request)
  {
    // dd($request->all());
    if ($request->isMethod('post')) {
      foreach ($request->users_id as $id) {
        $user = User::find($id);
        $user->profile->delete();
        $user->delete();
      }
    } elseif ($request->isMethod('get')) {
      $user = User::find($uid);
      $user->profile->delete();
      $user->delete();
    }
    Session::flash('Success-toastr', 'Successfully deleted.');
    return redirect()->back();
  }

  public function blockUser(User $user)
  {
    $user->status = 2;
    $user->save();
    return redirect()->back()->with('Success-toastr', 'Successfully blocked.');
  }

  public function activeUser(User $user)
  {
    $user->status = 1;
    $user->save();
    return redirect()->back()->with('Success-toastr', 'Successfully activeted.');
  }

  public function approvedUser($id)
  {
    $message = '';
    $user = User::find($id);
    if ($user->role == 2) {
      if ($user->admin_verified_at == null) {
        // $start_date = "2015/03/02";
        $date = strtotime(date('Y-m-d'));
        $date = strtotime("+7 day", $date);

        $user->admin_verified_at = now();
        $message = 'Successfully Approved.';

        $vendor_subs = new VendorSubscription;
        $vendor_subs->pub_id = $user->id;
        $vendor_subs->valid_form = '7 days';
        $vendor_subs->orginal_price = 0;
        $vendor_subs->price_taken = 0;
        $vendor_subs->subscription_start = date('Y-m-d');
        $vendor_subs->subscription_end = date('Y-m-d', $date);
        $vendor_subs->status = 3;
        $vendor_subs->save();
        //  Mail::to($user->email)->send(new AdminVerification($user->id));
        $user->save();
      } else {
        $user->admin_verified_at = null;
        $message = 'Already Approved by admin';
      }
    }


    return redirect()->back()->with('Success-toastr', $message);
  }
  public function doctors()
  {
    $title =  'Doctors';
    $heading =  'Doctors';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User MAnagement') == 0) {
      return back();
    }
    return view('admin.user.doctors', compact('title', 'heading'));
  }
  public function patient()
  {
    $title =  'Patient';
    $heading =  'Patient';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User MAnagement') == 0) {
      return back();
    }
    $data['patients'] = User::where('role', 2)->orderBy('id', 'DESC')->get();
    return view('admin.user.patient', compact('title', 'heading'), $data);
  }
  public function unappropved_doctors()
  {
    $title =  'Unappropved Doctors';
    $heading =  'Unapproved Doctors';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User MAnagement') == 0) {
      return back();
    }
    $data['unappropved_doctors'] = User::where('status', '!=', 2)->where('role', 1)->orderBy('id', 'DESC')->get();
    return view('admin.user.unapproved', compact('title', 'heading'), $data);
  }
  public function  route()
  {
    $title =  'Route';
    $heading =  'Route';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }
    $data = DB::table('routes')->orderBy('id', 'DESC')->get();
    return view('admin.user.route', compact('title', 'heading', 'data'));
  }
  public function  route_add()
  {
    $title =  'Route';
    $heading =  'Route';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }
    return view('admin.user.route_add', compact('title', 'heading'));
  }
  public function route_store(Request $request)
  {
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }
    $validator = $request->validate([
      'route' => 'required|unique:routes,route_name',

    ]);

    DB::table('routes')->insert([
      'route_name' => $request->route,

    ]);
    return redirect()->route('admin.route');
  }
  public function  route_edit($id)
  {
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }
    $title =  'Route Edit';
    $heading =  'Route Edit';
    $data = DB::table('routes')->where('id', $id)->first();
    return view('admin.user.route_edit', compact('title', 'heading', 'data'));
  }
  public function route_update(Request $request)
  {
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }
    $validator = $request->validate([
      'route' => 'required|unique:routes,route_name,' . $request->id,

    ]);

    DB::table('routes')->where('id', $request->id)->update([
      'route_name' => $request->route,

    ]);
    return redirect()->route('admin.route');
  }
  public function route_delete($id)
  {
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
      return back();
    }

    DB::table('routes')->where('id', $id)->delete();
    return redirect()->route('admin.route');
  }
  public function doctor_view_pending($id)
  {

    $title =  'Pending doctor Details';
    $heading =  'Pending doctor Details';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }


    $data['doctor'] = User::where('id', $id)->first();
    return view('admin.user.doctor_view_pending', compact('title', 'heading'), $data);
  }
  public function doctor_validate($id)
  {
    $data = User::where('id', $id)->first();
    if ($data->profile_image == '' || $data->certificate_mbbs == '' || $data->certificate_practice == '') {
      return redirect()->route('admin.unappropved_doctors')->with('error', 'Need profile image, certificate details and practitional license to validate');
    } else {
      User::where('id', $id)->update([
        'status' => 2
      ]);
      $content = "<html>";

      $content .= "<head>";
      $content .= "<title>Doctor App</title>";
      $content .= "</head>";

      $content .= "<body>";
      $content .= "<p>Doctor App</p>";
      $content .= "<p>Your registration as a doctor is approved</p>";

      $content .= "</body>";

      $content .= "</html>";

      $mailTo = $data->email;
      Mail::send(array(), array(), function ($message) use ($content, $mailTo) {
        $message->to($mailTo)
          ->subject('Doctor App Doctor App')
          ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
          ->setBody($content, 'text/html');
      });
      return redirect()->route('admin.appropved_doctors')->with('message', 'Doctor approved successfully');;
    }
  }
  public function appropved_doctors()
  {
    $title =  'Appropved Doctors';
    $heading =  'Approved Doctors';

    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['appropved_doctors'] = User::where('status', 2)->where('role', 1)->orderBy('id', 'DESC')->get();
    return view('admin.user.approved', compact('title', 'heading'), $data);
  }
  public function approved_doctor_view($id)
  {
    $title =  'Pending doctor Details';
    $heading =  'Pending doctor Details';

    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['doctor'] = User::where('id', $id)->first();
    return view('admin.user.doctor_view_approved', compact('title', 'heading'), $data);
  }
  public function unapproved($id)
  {
    User::where('id', $id)->update([
      'status' => 4
    ]);
    return redirect()->route('admin.appropved_doctors');
  }
  public function doctor_edit($id)
  {
    $title =  'Doctor Edit';
    $heading =  'Doctor Edit';

    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['doctor'] = User::where('id', $id)->first();

    if ($data['doctor']['status'] == 0) {
      $type = 'Unapproved';
    } else {
      $type = 'Approved';
    }
    return view('admin.user.doctor_edit', compact('title', 'heading', 'type'), $data);
  }
  public function  doctor_update(Request $request)
  {

    $validator = $request->validate([
      'name' => 'required',

    ]);
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    if ($request->hasFile('profile_image')) {
      $file_type = $request->file('profile_image')->extension();
      $file_path = $request->file('profile_image')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
      $request->file('profile_image')->move(public_path('images/doctors'), time() . '.' . $file_type);
    } else {
      $file_path = $request->profile_image_old;
    }

    // if ($request->hasFile('certificate_mbbs')) {


    //   $file_type = $request->file('certificate_mbbs')->extension();
    //   $file_path_mbbs = $request->file('certificate_mbbs')->storeAs('images/doctors', 'certificate_mbbs' . time() . '.' . $file_type, 'public');
    //   $request->file('certificate_mbbs')->move(public_path('images/doctors'), 'certificate_mbbs' . time() . '.' . $file_type);
    // } else {
    //   $file_path_mbbs = $request->certificate_mbbs_old;
    // }


    if ($request->hasFile('certificate_practice')) {
      $file_type = $request->file('certificate_practice')->extension();
      $file_path_practice = $request->file('certificate_practice')->storeAs('images/doctors', 'certificate_practice' . time() . '.' . $file_type, 'public');
      $request->file('certificate_practice')->move(public_path('images/doctors'), 'certificate_practice' . time() . '.' . $file_type);
    } else {

      $file_path_practice = $request->certificate_practice_old;
    }



    User::where('id', $request->id)->update([
      'name' => $request->name,
      'specility_id' => implode(',', $request->skill),
      'phone' => $request->phone,
      'sex' => $request->sex,
      'address' => $request->address,
      'qualification' => $request->qualification,

      'fee_per_consultation' => $request->fee_per_consultation_1 . ',' . $request->fee_per_consultation_2 . ',' . $request->fee_per_consultation_3,
      'profile_image' => $file_path,
      'reg_no_p' => $request->reg_no_p,
      'certificate_practice' => $file_path_practice,
      'country' => $request->country_code,

      'code' => '+' . $request->dial_code,
      'last_name' => $request->last_name

    ]);
    return back()->with('message', 'Doctor Updated Successfully');
  }


  public function doctor_delete($id)
  {
    User::where('id', $id)->update([
      'status' => 4
    ]);
    return back();
  }

  public function doctor_discard($id)
  {
    $title =  'Pending doctor Details';
    $heading =  'Pending doctor Details';

    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['doctor'] = User::where('id', $id)->first();
    $data['reasons'] = Reason::where('status', 1)->get();

    return view('admin.user.doctor_discard', compact('title', 'heading'), $data);
  }

  public function doctor_disappropved(Request $request)
  {
    $reason = implode(',', $request->reason);


    User::where('id', $request->id)->update([
      'status' => 3,

    ]);
    $content = "<html>";

    $content .= "<head>";
    $content .= "<title>Doctor App</title>";
    $content .= "</head>";

    $content .= "<body>";
    $content .= "<p>Doctor App</p>";
    $content .= "<p>Your registration as a doctor is discarded due to:" . $reason . "</p>";
    $content .= "<p>" . $request->note . "</p>";
    $content .= "</body>";

    $content .= "</html>";

    $mailTo = $request->email;
    Mail::send(array(), array(), function ($message) use ($content, $mailTo) {
      $message->to($mailTo)
        ->subject('Doctor App Registration Error')
        ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
        ->setBody($content, 'text/html');
    });
    return Redirect()->route('admin.unappropved_doctors');
  }

  public function admins()
  {
    $title =  'Sub Admins';
    $heading =  'Sub Admins';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }


    $id = Auth::guard('siteAdmin')->user()->id;
    $data['sub_admins'] = User::where('role', 0)->whereNotIn('id', [$id])->orderBy('id', 'DESC')->get();
    return view('admin.user.admin', compact('title', 'heading'), $data);
  }
  public function admin_create()
  {
    $title =  'Admin Create';
    $heading =  'Admin Create';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    return view('admin.user.admin_create', compact('title', 'heading'));
  }

  public function admin_store(Request $request)
  {
    $request->validate([
      "name" => "required",
      "email" => "required|email|unique:users,email",
      "password" => "required_with:confirm_password|same:confirm_password"

    ]);

    $user = new User;
    $user->name = $request->name;
    $user->email = $request->email;
    $user->password = Hash::make($request->password);
    $user->status = 1;
    $user->role = 0;
    $user->save();

    return Redirect()->route('admin.sub_admin')->with('message', 'Sub Admin created successfully');
  }

  public function admin_edit($id)
  {
    $title =  'Admin Edit';
    $heading =  'Admin Edit';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['data'] = User::where('id', $id)->first();
    return view('admin.user.admin_edit', compact('title', 'heading'), $data);
  }
  public function admin_update(Request $request)
  {
    $user = User::find($request->id);
    $user->name = $request->name;
    // $user->email = $request->email;

    $user->save();

    return Redirect()->route('admin.sub_admin')->with('message', 'Sub Admin edited successfully');
  }

  public function give_permission($id)
  {
    $title =  'Permission';
    $heading =  'Permission';


    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }


    $data['data'] = User::where('id', $id)->first();
    $data['permission'] =  DB::table('user_permission')->get();
    return view('admin.user.give_permission', compact('title', 'heading'), $data);
  }
  public function give_permission_post(Request $request)
  {






    $data = DB::table('user_permission')->where('id', $request->id)->get();

    if ($data) {



      DB::table('user_permission')->where('user_id', $request->id)->delete();

      if (empty($request->permission)) {
        return back();
      }



      foreach ($request->permission as $per) {
        DB::table('user_permission')->insert([
          'user_id' => $request->id,
          'permissions' => $per
        ]);
      }
    } else {

      $request->validate([
        'permission' => 'required'

      ]);

      foreach ($request->permission as $per) {
        DB::table('user_permission')->insert([
          'user_id' => $request->id,
          'permissions' => $per
        ]);
      }
    }

    return back();
  }

  public function admin_status($id, $status)
  {
    User::where('id', $id)->update([
      'status' => $status,
    ]);
    return back();
  }
  public function patient_view($id)
  {
    $title =  'Patient Details';
    $heading =  'Pending doctor Details';
    $test = User::where('id', $id)->first();
    if ($test->color_code == '') {
      $data['patient'] = User::where('id', $id)->first();
    } else {
      $data['patient'] = User::select('users.*', 'color_code.color', 'color_code.type')->where('users.id', $id)->join('color_code', 'color_code.id', 'users.color_code')->first();
    }

    return view('admin.user.patient_view', compact('title', 'heading'), $data);
  }
  public function patient_edit($id)
  {
    $title =  'Patient Edit';
    $heading =  'Patient Edit';
    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'User Management') == 0) {
      return back();
    }

    $data['patient'] = User::where('id', $id)->first();
    $data['colorCode'] = ColorCode::where('status', 1)->get();
    $data['allergy'] = Allergy::where('status', 1)->get();
    return view('admin.user.patient_edit', compact('title', 'heading'), $data);
  }

  public function patient_update(Request $request)
  {



    if ($request->hasFile('profile_image')) {
      $file_type = $request->file('profile_image')->extension();
      $file_path = $request->file('profile_image')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
      $request->file('profile_image')->move(public_path('images/doctors'), time() . '.' . $file_type);
    } else {

      if ($request->profile_image_old == '') {
        $file_path = '';
      } else {
        $file_path = $request->profile_image_old;
      }
    }


    if ($request->id == '') {
      $request->validate([
        'name' => 'required'


      ]);

      DB::table('users')->insert([
        'name' => $request->name,
        'email' => $request->email,
        'password' => Hash::make($request->password),
        'role' => 2,
        'phone' => $request->phone,
        'sex' => $request->sex,
        'address' => $request->address,
        'dob' => date('Y-m-d',strtotime($request->dob)),
        'profile_image' => $file_path,
        'color_code' => $request->color_code,
        'country' => $request->country_code,
        'code' => $request->dial_code,
        'status' => 1

      ]);
      $msg = "Patient Inserted Successfully";
    } else {

      $request->validate([
        'name' => 'required'
      ]);
      $u = DB::table('users')->where('id', $request->id)->first();
      //  if($u->code != $request->dial_code){
      //   $dial_code = '+'.$request->dial_code;
      //  }else{
      //   $dial_code = $request->dial_code;
      //  }

      DB::table('users')->where('id', $request->id)->update([
        'name' => $request->name,

        'phone' => $request->phone,
        'sex' => $request->sex,
        'address' => $request->address,
        'dob' => date('Y-m-d',strtotime($request->dob)),
        'profile_image' => $file_path,
        'color_code' => $request->color_code,
        // 'country' => $request->country_code,
        //   'code' => $dial_code


      ]);
      $msg = "Patient Updated Successfully";
    }

    return redirect()->route('admin.patient')->with('message', $msg);
  }
  public function patient_status($id, $status)
  {
    User::where('id', $id)->update([
      'status' => $status,
    ]);
    return back();
  }
  public function  appointment_list($id)
  {
    $title =  'Appointments list';
    $heading =  'Appointments list';
    $data['appointments'] = Appointment::with('doctor', 'patient', 'specialization')->where('patient_id', $id)->whereDate('date', '<=', date('Y-m-d'))->get();
    $data['user'] = User::where('id', $id)->first();
    return view('admin.user.appoinment_list', compact('title', 'heading'), $data);
  }

  public function patient_create()
  {
    $title =  'Patient Create';
    $heading =  'Patient Create';
    $data['color'] = ColorCode::where('status', 1)->get();
    $data['allergy'] = Allergy::where('status', 1)->get();
    return view('admin.user.patient_create', compact('title', 'heading'), $data);
  }
  public function reasons()
  {
    $title =  'Reasons';
    $heading =  'Resons';
    $data['reasons'] = Reason::orderBy('id', 'DESC')->get();
    return view('admin.reason.index', compact('title', 'heading'), $data);
  }

  public function reasons_add()
  {
    $title =  'Reasons Create';
    $heading =  'Reasons Create';
    return view('admin.reason.add', compact('title', 'heading'));
  }
  public function reasons_create(Request $request)
  {
    if ($request->id == '') {
      $reason = new Reason;
      $msg = "Reason inserted successfully";
    } else {
      $reason = Reason::find($request->id);
      $msg = "Reason updated successfully";
    }

    $reason->reason = $request->reason;
    $reason->status = 1;
    $reason->save();
    return redirect()->route('admin.reasons')->with('message', $msg);
  }
  public function reasons_edit($id)
  {
    $title =  'Reasons Edit';
    $heading =  'Reasons Edit';
    $data['data'] = Reason::find($id);
    return view('admin.reason.edit', compact('title', 'heading'), $data);
  }
  public function reason_status($id, $status)
  {
    Reason::where('id', $id)->update([
      'status' => $status,
    ]);
    return back();
  }
  public function contact_info()
  {
    $title =  'Contact Info';
    $heading =  'Contact Info';
    $data['data'] = ContactInfo::get();
    return view('admin.contact.index', compact('title', 'heading'), $data);
  }
  public function  contact_info_edit($id)
  {
    $title =  'Contact Info';
    $heading =  'Contact Info';
    $data['data'] = ContactInfo::where('id', $id)->first();
    return view('admin.contact.edit', compact('title', 'heading'), $data);
  }
  public function contact_info_update(Request $request)
  {
    $c = ContactInfo::find($request->id);
    $c->email = $request->email;
    $c->phone = $request->phone;
    $c->address = $request->address;
    $c->save();
    return redirect()->route('admin.info')->with('message', 'Contact Info updated successfully');
  }
  public function contact()
  {
    $title =  'Contact Us';
    $heading =  'Contact Us';
    $data['data'] = DB::table('contact_us')->get();
    return view('admin.contact.us', compact('title', 'heading'), $data);
  }
  public function contact_view($id)
  {
    $title =  'Contact Us';
    $heading =  'Contact Us';
    DB::table('contact_us')->where('id', $id)->update([
      'seen' => '1',
    ]);
    $data['data'] = DB::table('contact_us')->where('id', $id)->first();
    return view('admin.contact.view', compact('title', 'heading'), $data);
  }
  public function contact_delete($id)
  {
    DB::table('contact_us')->where('id', $id)->delete();
    return redirect()->route('admin.contact')->with('message', 'Contact deleted successfully');
  }
  public function contact_reply($id)
  {
    $title =  'Contact Reply';
    $heading =  'Contact Reply';
    $data['data'] = DB::table('contact_us')->where('id', $id)->first();
    return view('admin.contact.reply', compact('title', 'heading'), $data);
  }
  public function contact_reply_send(Request $request)
  {

    $data = DB::table('contact_us')->where('id', $request->id)->first();

    DB::table('contact_us')->where('id', $request->id)->update([
      'status' => 'replied',
    ]);
    $content = "<html>";

    $content .= "<head>";
    $content .= "<title>Doctor App</title>";
    $content .= "</head>";

    $content .= "<body>";
    $content .= "<h5>Reply to your message from Doctor App-</h5>";
    $content .= "<p>" . $request->reply . "</p>";

    $content .= "<p>Thank you for Contacting Us</p>";
    $content .= "</body>";

    $content .= "</html>";

    $mailTo = $data->contact_email;
    Mail::send(array(), array(), function ($message) use ($content, $mailTo) {
      $message->to($mailTo)
        ->subject('Doctor App Reply')
        ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
        ->setBody($content, 'text/html');
    });
    return Redirect()->route('admin.contact')->with('message', 'Replied Successfully');
  }
  public function complain_list()
  {
    $title =  'Complain List';
    $heading =  'Complain List';

    // if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Complain List') == 0) {
    //   return back();
    // }


    $data['data'] = DB::table('rating')
      ->select('rating.*', 'doctor.name as doctor_name', 'patient.name as patient_name')
      ->where('rating.rating', 0)
      ->join('users as doctor', 'doctor.id', 'rating.doctor_id')
      ->join('users as patient', 'patient.id', 'rating.patient_id')
      ->orderBy('rating.id', 'desc')
      ->get();


    return view('admin.rating.index', compact('title', 'heading'), $data);
  }

  public function complain_view($id)
  {
    $title =  'Complain View';
    $heading =  'Complain View';

    if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Complain List') == 0) {
      return back();
    }

    $data['store'] = DB::table('rating')
      ->select('rating.*', 'doctor.name as doctor_name', 'patient.name as patient_name')
      ->where('rating.id', $id)
      ->join('users as doctor', 'doctor.id', 'rating.doctor_id')
      ->join('users as patient', 'patient.id', 'rating.patient_id')
      ->first();
    return view('admin.rating.view', compact('title', 'heading'), $data);
  }

  public function reasons_delete($id)
  {
    $data = Reason::find($id);
    $data->delete();
    return redirect()->route('admin.reasons')->with('message', 'Reason Deleted');
  }

  public function multi_spl_aprv($id, $status)
  {
    $data = DB::table('users')->where('id', $id)->update([
      'multi' => $status,

    ]);
    return redirect()->back()->with('Success-toastr', 'Multi speciality request updated');
    
  }
  public function admin_delete($id)
  {
    $data = DB::table('users')->where('id', $id)->delete();
      
    return redirect()->back()->with('Success-toastr', 'Sub admin deleted successfully');
  }

  
}
